
{$T+}  {$R-}  {$D+}  {$S-}  {$V-}

program Cobl2API;
{-[ 10-02-89/ns ]--------------------------------------------------------------}
{                 test environment for COBL2BTX.ASM                            }
{                 (this is the minimal terminal of the btx-api booklet         }
{                 realized by calls to COBL2BTX.ASM)                           }
{-[ janussoft ]--------------------------------------------------------------}

 type
    apibuffer= record
 { 0}  ax: word;                        { register..                           }
 { 2}  bx: word;                        {..                                    }
 { 4}  cx: word;                        {..                                    }
 { 6}  dx: word;                        {..                                    }
 { 8}  es: word;                        {..                                    }
 {10}  si: word;                        {..                                    }
 {12}  di: word;                        {..                                    }
 {14}  bp: word;                        {..set                                 }
 {16}  datalen: byte;                   { length of data buffer                }
 {17}  databuf: array[1..255] of byte;  { data buffer                          }
    end;

 var
    ab: apibuffer;                      {                                      }

 {$F+}
procedure Cobl2btx(var buffer: apibuffer);
{-[ 10-02-89/ns ]--------------------------------------------------------------}
{                 call to COBL2BTX.ASM                                         }
{$L cobl2btx ------------------------------------------------------------------}
 external;

 begin

    ab.ax:=$0101;                       { set to 'Initialize'                  }
    ab.datalen:=0;                      { no parameter block available         }
   Cobl2Btx(ab);                        { make btx-api to initialize           }

    ab.ax:=$0102;                       { set to 'Connect'                     }
    ab.datalen:=0;                      { no parameter block available         }
   Cobl2Btx(ab);                        { make btx-api to connect              }


    { at this point we should examine AB.AX for 'connection established'       }


    ab.ax:=$0201;                       { set to 'BtxTerminal'                 }
    ab.datalen:=0;                      { no parameter block available         }
   Cobl2Btx(ab);                        { make btx-api to be btx terminal      }
                                        {                                      }
    ab.ax:=$0104;                       { set to 'Terminate'                   }
   Cobl2Btx(ab);                        { make btx-api to terminate            }

 end.
                                        {                                      }
