TITLE Hercules-Graphik-Hardcopy ber PrtScn -Interrupt

NAME HgrCopy

; 20. Dez. 1988 Bernd Trls

;
CODE           SEGMENT PARA 'CODE'
	       ASSUME CS:CODE, DS:CODE
	       ORG 100H

start:         JMP init                ; neue Interruptroutine installieren

newirq         PROC NEAR

	       JMP irqcode             ; Datenblock berspringen

				       ; Endmarkierung 0FFH
abstand1 DB 27, 'A', 8, 27, '2', 0FFH  ; Zeilenabstand 8/72 Zoll
abstand2 DB 27, '3', 2, 0FFH ;         ; Zeilenabstand 2/216 Zoll
abstand3 DB 27, '3', 22, 0FFH          ; Zeilenabstand 22/216 Zoll
graphik1 DB 27, '*', 6, 208, 2, 0FFH   ; Graphikmodus 1 aktiv
graphik2 DB 27, '*', 3, 208, 2, 0FFH   ; Graphikmodus 2 aktiv
normal   DB 27, 'A', 12, 27, '2', 0FFH ; Zeilenabstand 1/6 Zoll
return   DB 13, 10, 0FFH               ; Wagenrcklauf, Zeilenvorschub
							    ; Graphikoffset
add1   DW 24666, 16474, 8282, 90, 24576, 16384, 8192, 0      ; Zeile 7 - 0
add2   DW 16654, 270, 16564, 180, 16474, 90, 16384, 0        ; Zeile 14, 12, 10, 8, 6, 4, 2 und 0
add3   DW 24846, 8462, 24756, 8372, 24666, 8282, 24576, 8192 ; Zeile 15, 13, 11, 9, 7, 5, 3 und 1
addOff DW 0                            ; Zeiger auf Bildschirmzeilen - Offset
aktiv  DB 0                            ; Routine schon aufgerufen ?
wert   DB 0      		       ; errechnetes Byte
zeile  DW 0			       ; aktuelle Bildschirmzeile
seite  DW 0			       ; Bildschirmseite ( 0B000H oder 0B800 )
flag   DB 0			       ; fr Doppeldruck
invert DB 0			       ; zeigt Inversdruck an

irqcode:       CLI                     ; Interrupt zulassen
	       PUSH DS                 ; Register retten
	       PUSH ES
	       PUSH AX
	       PUSH BX
	       PUSH CX
	       PUSH DX
	       PUSH SI
	       PUSH DI
	       MOV AX,CS               ; Datensegment einrichten
	       MOV DS,AX
	       CMP aktiv,1
	       JNZ noend               ; Routine noch nicht abgeschlossen
	       JMP ende		       ; ja dann raus hier
noend:         MOV aktiv,1             ; Flag fr Routine in Betrieb
	       MOV zeile,0             ; Start bei Bildschirmzeile 0
	       MOV AH,2                ; Shift- bzw LOCK Taste ermitteln
	       INT 16H                 ; Tastatur abfragen
	       MOV BH,0
	       PUSH AX
	       AND AL,3                ; AL = gedrckte Shift bzw. LOCK Taste
	       JZ norm1                ; wenn kein Shift dann weiter
	       CMP AL,3                ; sind beide Shift gedrckt
	       JNE norm1               ; nein, dann weiter
	       MOV flag,1              ; doppelte Dichte ?
	       POP AX                  ; AX wurde durch AND verndert
	       JMP norm2               ; keine Abfrage auf Shift mehr
norm1:         POP AX		       ; AX wieder herstellen
	       MOV flag,BH             ; falls nicht beide Shift, dann FLAG = 0
				       ; normale Graphikhardcopy
	       TEST AL,2               ; linke Shift gedrckt ?
	       JZ norm2	               ; nein, dann weiter
               TEST AL,1               ; rechte Shift gedrckt ?
               JNZ norm2               ; ja, dann weiter
	       PUSHF                   ; Status auf Stack, da die Rckkehr
				       ; aus CALL mittels IRET geschieht
	       DB   9AH                ; Code fr Intersegment CALL
OFF05          DW   ?                  ; Offset- und Segment- Adresse
SEG05	       DW   ?                  ; des alten PtrScr Interrupt
	       JMP ende                ; zu Textbildschirmhardcopy zurckkehren
norm2:         MOV BX,0B000H           ; Graphikbildschirmseite 1
	       TEST AL,32              ; Num Lock ?
	       JZ setPage              ; nein, dann weiter
	       MOV BX,0B800H	       ; ja, dann Graphikseite 2
setPage:       MOV seite,BX            ; Seite festlegen
	       MOV BL,0                ; Ausdruck inverse
	       TEST AL,64	       ; Caps Lock ?
	       JZ setInvers            ; nein, dann weiter
	       MOV BL,255              ; ja, dann Ausdruck inverse
setInvers:     MOV invert,BL	       ; Modus festlegen
nextrow:       MOV BX,OFFSET abstand1  ; Vorbereitung fr normale
	       MOV DI,OFFSET add1      ; Graphikhardcopy
	       MOV CX,OFFSET graphik1
	       CMP flag,0
	       JE norm3
	       MOV BX,OFFSET abstand2
	       MOV DI,OFFSET add2      ; Vorbereitung fr den ersten
	       MOV CX,OFFSET graphik2  ; Durchgang der Graphikhardcopy
	       CMP flag,1              ; in doppelter Dichte
	       JE norm3
	       MOV BX,OFFSET abstand3
	       MOV DI,OFFSET add3      ; Vorbereitungen fr den zweiten
	       MOV CX,OFFSET graphik2  ; Durchgang
norm3:	       MOV addOff,DI           ; Offset der Graphikzeilen- Offsets
	       CALL sendOut            ; Code fr Abstand an den Drucker
	       MOV BX,CX
	       CALL sendOut            ; Code zum Einschalten des Graphikmodus
	       MOV AX,[seite]
	       MOV ES,AX               ; ES zeigt nun auf die Graphikseite
	       MOV SI,[zeile]          ; aktuelle Bildschirmzeile in SI
	       MOV AL,0	  	       ; AL = Spalte
nextcol:       MOV AH,7		       ; AH = Bitspalte
nextbcol:      MOV wert,0	       ; errechneter  Wert = 0
	       MOV DL,0                ; DL = Bit
nextbit:       MOV BX,addoff           ; Offset der Graphikzeilen- Offsets
	       MOV CL,DL               ; in das BX - Register
	       SHL CL,1
	       MOV CH,0
	       ADD BX,CX               ; BX = Adresse des Graphikoffsets
	       MOV CX,[BX]
	       MOV BX,CX               ; BX = Graphikzeilenoffset
	       MOV CL,AL
	       MOV CH,0
	       ADD BX,CX               ; BX = Adresse des Bytes
	       MOV CL,AH
	       MOV DH,1
	       SHL DH,CL               ; DH = zu testendes Bit
	       TEST ES:[BX+SI],DH      ; teste Bit
	       JZ notSet               ; springe, wenn Bit nicht gesetzt
	       MOV CL,DL
	       MOV DH,1
	       SHL DH,CL               ; wenn Graphikbit gesetzt, dann
				       ; berechne Druckerbit
	       OR wert,DH              ; Wert = Druckerbyte
notSet:	       INC DL		       ; nchstes Bit
	       CMP DL,8		       ; schon alle acht ?
	       JNZ nextBit             ; nein, dann wiederhole
	       PUSH AX                 ; AX, DX zwischenspeichern
	       PUSH DX
	       XOR AH,AH	       ; AH, DX lschen
	       XOR DX,DX
	       MOV AL,wert
	       XOR AL,invert	       ; invertiere Druckerbyte, wenn ntig
	       STI
	       INT 17H		       ; sende Byte
	       CLI
	       MOV DX,3BDH
	       IN AL,DX		       ; Drucker nicht eingeschaltet ?
	       TEST AL,8
	       JZ ioError	       ; ja, beende Hardcopy
	       POP DX		       ; Register wiederherstellen
	       POP AX
	       DEC AH		       ; nchste Bitspalte rckwrts
	       CMP AH,255	       ; schon alle acht
	       JNZ nextbCol	       ; nein, dann wiederhole
	       INC AL		       ; nchste Spalte = Byte
	       CMP AL,90	       ; schon alle 720 Punkte
	       JNZ nextCol	       ; nein, dann wiederhole
	       MOV AX,180	       ; Wert fr Addition
	       CMP flag,0	       ; komprimierte Hardcopy
	       JZ norm4		       ; nein, dann weiter
	       MOV BX,OFFSET return
	       CALL sendOut	       ; sende LF und CR
	       INC flag
	       CMP flag,3	       ; wenn flag = 2, dann 2.Durchgang
	       JNZ helpJump            ; wenn 2.Durchgang noch nicht beendet,
				       ; dann wiederhole
	       MOV flag,1              ; setzt Durchlaufzahl auf 1
	       MOV AX,360	       ; Wert fr Addition
norm4:         ADD [zeile],AX	       ; erhhe Zeiger auf Graphikzeile,
				       ; wobei Graphikzeile = Zeile/9
	       CMP [zeile],7920        ; unterer Bildschirmrand ?
	       JNZ helpJump	       ; nein, dann wiederhole
ende:          MOV BX,OFFSET normal    ; Druckcode fr normalen Zeilenabstand
	       CALL sendOut	       ; senden
	       MOV aktiv,0             ; Routine beenden
	       POP DI		       ; Register wiederherstellen
	       POP SI
	       POP DX
	       POP CX
	       POP BX
	       POP AX
	       POP ES
	       POP DS
	       IRET		       ; Rckkehr vom Interrupt
ioError:       POP DX		       ; wird angesprungen, wenn Drucker nicht
	       POP AX		       ; eingeshaltet
	       JMP ende
helpJump:      JMP nextRow             ; Ende wie oben

newIRQ         ENDP

sendOut	       PROC NEAR  	       ; Sendet Codes an den Drucker, wobei
	       XOR AH,AH	       ; BX = Offset des Druckcodes
	       XOR DX,DX               ; letztes Byte des Codes = 0FFH
	       MOV AL,[BX]
	       STI
	       INT 17H
	       CLI
	       INC BX
	       CMP BYTE PTR [BX],0FFH  ; schon Ende ?
	       JNZ sendOut	       ; nein, dann wiederhole
	       RET

sendOut        ENDP

init:          MOV AX,3505H            ; hole das Segment von Interrupt 5
	       INT 21H                 ; nach ES und Offset nach BX
	       MOV OFF05,BX
	       MOV SEG05,ES
	       MOV AX,2505H	       ; biege Interruptvektor auf neue
	       MOV DX,OFFSET newIRQ    ; Interruptroutine
	       INT 21H
	       MOV DX,OFFSET init      ; mache neue Routine speicherresident
	       INT 27H                 ; kehre zum DOS zurck

CODE           ENDS

               END start

