title schlangenspiel
cseg segment para public 'code'
assume cs:cseg,ds:cseg

public start,schlange,loopy,schleife,ausgabe,eingabe,posit

up       equ 48h
down     equ 50h
left     equ 4bh
right    equ 4dh
prgend   equ 01h
space    equ 20h
star     equ 2ah

         org 100h

start:   jmp schlange

zeile    DB    0             ;Cursoranfangsposition
spalte   DB    0             ;Cursoranfangsposition
verzzeit  DW   0             ;Verzoegerungszeit

schlange:
         push cs
         pop ds
         mov ax,3h           ;einstellen Bildschirmmodus
         int 10h
         call posit          ;Corsor in linkes oberes Eck
         mov al,0c9h         ;linkes Eckzeichen
         call ausgabe

         inc spalte
         call posit
         mov al,0cdh         ;Querzeichen
         mov ah,0ah          ;Zeichen an Corsorposition festlegen
         mov bh,0            ;Bildschirmseite
         mov cx,78           ;Zeichenanzahl Querzeichen
         int 10h


         mov spalte,79       ;rechtes oberes Eck
         call posit
         mov al,0bbh ;
         call ausgabe

         mov spalte,0
         mov zeile,1
rahmen:  call posit
         mov al,0bah         ;senkrechtes Zeichen
         call ausgabe
         inc zeile
         cmp zeile,24
         jnz rahmen

         call posit
         mov al,0c8h         ;linkes unteres Eck
         call ausgabe



         mov spalte,1        ;untere Querlinie
         mov zeile,24
         call posit
         mov al,0cdh         ;Querzeichen
         mov ah,0ah          ;Zeichen an Corsorposition festlegen
         mov bh,0            ;Bildschirmseite
         mov cx,78           ;Zeichenanzahl Querzeichen
         int 10h

         mov spalte,79       ;rechtes unteres Eck
         call posit
         mov al,0bch
         call ausgabe


         dec zeile           ;rechte Rahmenlinie
rahmen1: call posit
         mov al,0bah         ;senkrechtes Zeichen
         call ausgabe
         dec zeile
         cmp zeile,0
         jnz rahmen1

         mov spalte,40
         mov zeile,12
         call posit          ;Curser auf spalte, zeile
         mov al,star         ;auszugebendes Zeichen

loopy:   call ausgabe
schleife:call eingabe
         jmp schleife

ausgabe: mov ah,0ah          ;Zeichen an Cursorposition festlegen
         mov dh,zeile
         mov dl,spalte
         mov bh,0            ;Bildschirmseite
         mov cx,1h           ;Zeichenanzahl ab Cursorposition
         int 10h
         ret

eingabe:
         ;ueber BIOS
         mov ah,0            ;Zeichen lesen
         int 16h             ;Keyboard-Interrupt
                             ;scan code in ah

         cmp ah,prgend       ;Abfrage ob Programmende
         jz gameend0
         cmp ah,up           ;Vergleich ob Cursor rauf
         jz cursorup
         cmp ah,down         ;Vergleich ob Cursor runter
         jz cursordown
         cmp ah,left         ;Vergleich ob Cursor links
         jz cursorleft1
         cmp ah,right        ;Vergleich ob Cursor rechts
         jz cursorright1
         ret

posit:   mov ah,2h           ;positionieren Cursor
         mov dh,zeile        ;Zeile
         mov dl,spalte       ;Spalte
         mov bh,0            ;Bildschirmseite
         int 10h
         ret


poscheck: cmp zeile,0        ;Spielfeldabgrenzungskontrolle
          jz gameend1
          cmp zeile,24
          jz gameend1
          cmp spalte,0
          jz gameend1
          cmp spalte,79
          jz gameend1
          ret

cursorleft1: jmp cursorleft

gameend0: jmp gameend1

cursorup:
          ;  mov al,space    ;Ende der Schlange loeschen
          ;  call ausgabe
            dec zeile        ;Schlangenkopf
            call poscheck    ;Randkontrolle
            call posit
            mov al,star      ;Kopf als Stern ausgeben
            call ausgabe
            call kbabfrage   ;schauen ob Taste gedrueckt
            cmp al,0
            jz cursorup
            jmp schleife

gameend1:  jmp gameend

cursorright1: jmp cursorright

kbabfrage:
            mov verzzeit,2000;Verzoegerungszeit
vzeit:      dec verzzeit
            cmp verzzeit,0
            jnz vzeit
            mov ah,0bh       ;Abfrage ob Zeichen in Tastaturbuffer
            int 21h
            ret



cursordown:
          ;  mov al,space    ;Ende der Schlange loeschen
          ;  call ausgabe
            inc zeile        ;Schlangenkopf
            call poscheck    ;Randkontrolle
            call posit
            mov al,star      ;Kopf als Stern ausgeben
            call ausgabe
            call kbabfrage   ;schauen ob Taste gedrueckt
            cmp al,0
            jz cursordown
            jmp schleife

cursorleft:
          ;  mov al,space    ;Ende der Schlange loeschen
          ;  call ausgabe
            dec spalte       ;Schlangenkopf
            call poscheck    ;Randkontrolle
            call posit
            mov al,star      ;Kopf als Stern ausgeben
            call ausgabe
            call kbabfrage   ;schauen ob Taste gedrueckt
            cmp al,0
            jz cursorleft
            jmp schleife

cursorright:
         ;   mov al,space    ;Ende der Schlange loeschen
         ;   call ausgabe
            inc spalte       ;Schlangenkopf
            call poscheck    ;Randkontrolle
            call posit
            mov al,star      ;Kopf als Stern ausgeben
            call ausgabe
            call kbabfrage   ;schauen ob Taste gedrueckt
            cmp al,0
            jz cursorright
            jmp schleife

gameend:
            mov ax,4c00h     ;zurueck ins Betriebssystem
            int 21h
            cseg ends
            end  schlange
