;---------------------------------------------------------------------------
; COM-Programm, von BAT2EXEC erzeugt
;---------------------------------------------------------------------------

                org     100h

init_code       proc    near
                assume  cs:code,ds:code,es:code,ss:code
                mov     bp,Data_ptr
                mov     sp,com_stack_ptr        ; setze Stapelzeiger
                mov     bx,com_prog_size        ; Speicherbedarf festlegen
                mov     ah,4ah                  ; Speicherblock verkleinern
                int     21h
                mov     ax,ds:[2ch]             ; hole Umgebungs-Segment
                mov     environment_seg,ax      ; und merken
                mov     bx,code_start_ptr
                jmp     bx                      ; und auf den Programmstart
init_code       endp                            ; springen
;---------------------------------------------------------------------------
; gemeinsame Daten fr alle COM-Programme
;---------------------------------------------------------------------------
code_start_ptr  dw      offset code_start
com_stack_ptr   dw      offset end_of_code + 512
com_prog_size   dw      (offset end_of_code + 1031) SHR 4
com_label_start dw      offset label1
string1_buf     dw      offset end_of_code + 514
string2_buf     dw      offset end_of_code + 760
string3_buf     dw      offset end_of_code + 1016
forloop_ptr     dw      0
stdout_hdl      dw      ?
outfile_hdl     dw      ?
stdin_hdl       dw      ?
infile_hdl      dw      ?
environment_seg dw      ?
dos_version     dw      ?
process_rc      db      ?
shift_count     db      0
;---------------------------------------------------------------------------
; programmspezifische Daten
;---------------------------------------------------------------------------
echo_string1    db      "Die Datei %1.asm wird auf Laufwerk A kopiert",0

exist_string    db      "%1.asm",0      ; fr EXIST-Test

skip1_addr      dw      offset skip1    ; offset der Anweisung nach GOTO

label1_struc    dw      offset end_struc - offset label1_struc
                dw      offset label1
                db      6
                db      "LABEL1"

echo_string2    db      "Die Datei %1.asm existiert nicht",0

end_struc       dw      -1                      ; -1 = letzte Sprungmarke
                dw      offset end              ; fr den Sprung
                db      3                       ; Lnge des Namens
                db      "END"                   ; Sprungmarke

internalcmd     db      14                      ; Lnge des internen Befehls
                db      "/C COPY %1.asm a:"     ; fr den COPY-Befehl

;---------------------------------------------------------------------------
; Hauptfunktion
;---------------------------------------------------------------------------
code_start      proc    near
                lea     si,echo_string1         ; bersetze Text und nimm
                mov     di,string1_buff         ; Kommandozeilenargumente
                mov     ax,offset procstring    ; auf
                call    ax
                mov     si,string1_buff         ; Text ausgeben
                mov     ax,offset echo_msg
                call    ax

                lea     si,exist_string
                mov     di,string1_buff
                mov     ax,offset procstring    ; bersetze Kommandozeile
                call    ax                      ; fr IF-EXIST-Test
                mov     si,string1_buff
                mov     di,tempbuff2
                mov     ax,offset ifexists      ; sieh nach, ob es Datei gibt
                call    ax
                jnb     continue
                jmp     [skip1_addr]
continue:
                mov     ax,[label1_struc+2]     ; GOTO-Anweisung
                jmp     ax
skip1:
                lea     si,filenotfoundmsg      ; Argument aus Kommandozeile
                mov     di,string1_buff         ; in Text einbauen
                mov     ax,offset procstring
                call    ax
                mov     si,string1_buff         ; Nachricht "nicht gefunden"
                mov     ax,offset echo_msg
                call    ax

                mov     ax,[label1_struc+2]     ; Goto End
                jmp     ax
label1:
                lea     si,copycmdstring
                mov     di,string1_buff         ; Kommandozeile des COPY-
                mov     ax,offset procstring    ; Befehls auswerten
                call    ax
                mov     si,string_buff
                mov     ax,offset intcommand    ; Befehl ausfhren
                call    ax
end:
                mov     ax,4c00h                ; Programmende
                int     21h
code_start      endp

;---------------------------------------------------------------------------
; Die Bibliotheksfunktionen, die in diesem Programm gebraucht werden
;---------------------------------------------------------------------------
;----------------------------------------------------------------------------
; ECHO MSG CODE wird gebraucht, um eine Zeichenkette auf dem Standard-
; Ausgabegert auszugeben.
; Register beim Aufruf:  DS:SI - Zeiger auf die Zeichenkette
;----------------------------------------------------------------------------
echo_msg_code  proc    near
               assume  cs:code,ds:code
               mov     dl,[si]                 ; hole Zeichen
               inc     si
               or      dl,dl
               je      echo_msg_1
               mov     ah,2                    ; gib Zeichen aus
               int     21h
               jmp     short echo_msg_code
echo_msg_1:
               ret
;-----------------------------------------------------------------------------
; SCAN_CHAR durchsucht einen Text nach einem Zeichen
; Register beim Aufruf:
;         SI - Zeiger auf ASCII-Zeichenkette
;         DL - 0 = suche nchstes Zeichen, 1 = suche nchstes Leerzeichen
;         CX - Dateilnge
; Ausgang:
;         AL - erstes Zeichen (nicht Leerzeichen)
;         CF - gesetzt, wenn CR/LF gefunden
;-----------------------------------------------------------------------------
scan_char      proc near
               assume  ds:nothing,es:nothing
scan_loop:
               lodsb
               cmp     al,9                    ; ist es ein TAB-Zeichen?
               je      scan_space              ; ja
               cmp     al," "                  ; ein Leerzeichen?
               jb      scan_eol                ; kleiner, Zeilenende
               je      scan_space
               or      dl,dl                   ; kein Leerzeichen, also
               jne     scan_loop               ; weiter
               jmp     short scan_exit
scan_space:
               or      dl,dl                   ; Leerzeichen gefunden. Wird
               je      scan_loop               ; es auch gesucht?
scan_exit:
               clc
               ret
scan_eol:
               stc
               ret
scan_char      endp

;-----------------------------------------------------------------------------
; GETMEMBER  liefert einen Zeiger auf das n-te Wort in einer Zeile
; Register beim Aufruf:
;            SI - Zeiger auf Textzeile
;            DH - Nummer des gewnschten Worts
; Ausgang:
;            SI - Zeiger auf das Wort
;            CF - gesetzt, wenn das Wort nicht in der Zeile steht
;-----------------------------------------------------------------------------
getmember_scan4        dw      offset scan4_next       ; Aufgerufene Funktion(en)

getmember      proc    near
               assume  cs:code,ds:code,es:code,ss:code
               push    bx
               call    getmember_0
getmember_0:
               pop     bx
getmember_1:
               xor     dl,dl
               call    getmember_scan4         ; suche nchstes Wort
               jc      getmember_notfound
               dec     dh                      ; Zhler verringern
               jle     getmember_2
               inc     dl
               call    getmember_scan4         ; nchstes Leerzeichen
               jc      getmember_exit
               jmp     short getmember_1       ; noch nicht fertig, weiter
getmember_2:
               dec     si                      ; zurck auf erstes Zeichen
               clc                             ; im Wort
getmember_exit:
               pop     bx
               ret
getmember_notfound:
               stc
               jmp     short getmember_exit
getmember      endp

;-----------------------------------------------------------------------------
; PROCSTRING bearbeitet eine Zeichenkette zur Umsetzung von Kommandozeilen-
; argumenten oder Umgebungsvariablen
; Register beim Aufruf:
;         DS:SI - Zeiger auf ASCIIZ-Zeichenkette
;         ES:DI - Zeiger auf Ausgabepuffer
; Ausgang:
;         DS:SI - Zeiger auf den Anfang des neuen ASCIIZ-Textes
;        [SI-1] - Lnge der neuen Zeichenkette
;-----------------------------------------------------------------------------
procstr_cmd1   dw      offset subparm_next     ; Aufgerufene Funktionen
procstr_env    dw      offset subenv_next

procstr_code   proc    near
               assume  cs:code,ds:code,es:code
               push    bx
               call    procstr_0
procstr_0:
               pop     bx
               push    di
               push    si
               mov     ah,BUFF_SIZE            ; Gre des Puffers
procstr_1:
               lodsb                           ; hole ein Zeichen
               or      al,al                   ; schon fertig?
               je      procstr_exit
               cmp     al,"%"                  ; suche Parameter
procstr_jmp:
               je      procstr_3               ; jetzt kommt ein Parameter
procstr_2:
               stosb                           ; Zeichen speichern
               dec     ah
               jne     procstr_1
procstr_exit:
               xor     al,al                   ; und die Null ans Ende
               stosb
               pop     si
               pop     di
               mov     bl,BUFF_SIZE
               sub     bl,ah
               mov     ds:[di-1],bl            ; Lnge speichern
               pop     bx
               ret
;
; Das Prozent-Zeichen kennzeichnet einen Parameter. Drei Typen sind erlaubt:
; Argumente von der Kommandozeile, Umgebungsvariablen und Schleifenparameter.
;
procstr_3:
               lodsb                           ; nchstes Zeichen
               dec     cx
               cmp     al,"%"                  ; % doppelt?
               je      procstr_2               ;  Ja: Ein % speichern
               cmp     al,7fh                  ; FOR-Schleife?
               jne     procstr_32
               push    si
               mov     si,forloop_ptr          ; hole Zeiger auf Text fr
procstr_30:                                     ;  FOR-Schleife
               lodsb
               cmp     al,0                    ; fertig
               je      procstr_31
               stosb
               dec     ah                      ; Puffergre runterzhlen
               jne     procstr_30              ; noch nicht voll, weiter
procstr_31:
               pop     si                      ; Zeiger auf Quelltext
               jmp     short procstr_4
procstr_32:
               mov     dh,al                   ; Kopiere und sieh nach, ob
               sub     dh,"0"                  ;  das nchste Zeichen zu
               jb      procstr_5               ;  einer Zahl gehrt. Dann
               cmp     dh,9                    ;  ist es ein Parameter.
               ja      procstr_5
               call    procstr_cmdl            ; bearbeite Kommandozeile
procstr_4:
               or      ah,ah
               jne     procstr_1
               jmp     short procstr_exit      ; fertig
procstr_5:
               dec     si                      ; zurck auf erstes Zeichen
               inc     cx
               call    procstr_env
               jmp     short procstr_4
procstr_code   endp

;-----------------------------------------------------------------------------
; SUBLINEPARAM setzt ein Argument aus der Kommandozeile ein
; Register beim Aufruf:
;         ES:DI - Zeiger auf Puffer zum Kopieren der Argumente
;            DH - binre Nummer des Arguments
;            AH - Gre des Puffers
: Ausgang:
;         ES:DI - Zeiger auf erstes Byte nach dem Argument im Puffer
;            CX - Restlnge des Puffers
;-----------------------------------------------------------------------------
subparm_getmem dw      offset getmember_next   ; Aufgerufene Funktion(en)

sublineparam   proc    near
               assume  cs:code,ds:code,es:code,ss:code
               push    bx
               call    sublineparam_1
               db      "DOS2X",0               ; Dummy fr Parameter %0
                                               ;  unter MS-DOS 2.x
sublineparam_1:
               pop     bx
               push    cx
               push    si
               push    ds
               mov     si,80h                  ; hole Zeiger auf Kommando-
               xor     cx,cx                   ;  zeile
               mov     cl,[si]                 ; Zahl der Zeichen
               inc     si                      ; gehe auf erstes Zeichen
               add     dh,ds:shift_count       ; Zhler addieren
               or      dh,dh                   ; gibt es Argumente?
               jnz     sublineparam_12
;
; Suche fr den Parameter 0 den Namen des Programms im Umgebungsblock
;
               push    ax                      ; Puffergre merken
               mov     ah,30h                  ; hole MS-DOS-Version
               int     21h                     ; benutze fr MS-DOS 2.x
               cmp     al,2                    ;  den Dummy-Namen
               pop     ax
               ja      sublineparam_10
               lea     si,[bx]                 ; Zeiger auf Dummy
               jmp     short sublineparam_2
sublineparam_10:
               push    es
               push    di
               mov     es,ds:[2ch]             ; Segment der lokalen
               xor     al,al                   ;  Umgebung
               xor     di,di
               mov     cx,8000h
sublineparam_11:
               repne   scasb                   ; Doppelnull suchen
               scasb
               jne     sublineparam_11
               scasw                           ; Namen suchen
               mov     si,di                   ; Zeiger auf Namen kopieren
               pop     di
               pop     es
               mov     ds,ds:[2ch]
               jmp     short sublineparam_2
sublineparam_12:
               call    subparm_getmem          ; Zeiger auf das richtige
               jc      sublineparam_exit       ;  Wort suchen
sublineparam_2:
               lodsb                           ; Zeichen aus Argument holen
               cmp     al," "                  ; Leerzeichen? Fertig!
               jbe     sublineparam_exit
               stosb
               dec     ah                      ; Puffergre runterzhlen
               jnz     sublineparam_2
sublineparam_exit:
               pop     ds
               pop     si
               pop     cx
               pop     bx
               ret
sublineparam   endp

;-----------------------------------------------------------------------------
; INTCMD  startet den Kommandoprozessor, im Normalfall COMMAND.COM, zur
; Bearbeitung von internen Befehlen.
; Register beim Aufruf:
;       DS:SI - Zeiger auf den ASCIIZ-Text mit dem Befehl
;-----------------------------------------------------------------------------
intcmd_launch  dw     offset launch_next       ; lade und starte Programm
intcmd_getcom  dw     offset getcom_next       ; suche Prozessor

intcommand     proc    near
               assume  cs:code,ds:code,es:code,ss:code
               push    bx
               call    intcmd_1
intcmd_1:
               pop     bx                      ; hole Zeiger auf Funktionen
               mov     di,si                   ; kopiere Zeiger auf Befehl
               dec     di                      ; gehe auf Lngenbyte
               push    ds
               mov     al,process_rc           ; Rckgabewert sichern
               push    ax
               call    intcmd_getcom           ; COMSPEC suchen
               call    cs:intcmd_launch        ; und los geht's
               pop     ax
               mov     process_rc,al           ; Rckgabewert einsetzen
               pop     ds
               pop     bx
               ret
intcommand     endp

;-----------------------------------------------------------------------------
; GETCOMSPEC  holt den Namen des Kommandoprozessors
; Ausgang:
;       DS:SI - Zeiger auf den ASCIIZ-Namen des Prozessors
;-----------------------------------------------------------------------------
getcom_srchenv dw      offset searchenv_next    ; suche Umgebung

getcomspec     proc    near
               assume  cs:code,ds:code,es:code,ss:code
               push    bx
               call    getcom_1
getcom_str     db      "COMSPEC"
getcom_1:
               pop     bx
               mov     dx,offset getcom_1 - offset getcom_str
               mov     si,bx
               call    getcom_srchenv           ; Zeiger auf Text holen
               pop     bx
               ret
getcomspec     endp

;----------------------------------------------------------------------------
; LAUNCH PROG  ldt und startet Programme.
; Register beim Aufruf:
;         DS:SI - Zeiger auf den Namen des Programms
;         ES:DI - Zeiger auf Kommandozeile
; Ausgang:
;         return code variable set.
;----------------------------------------------------------------------------
launch_fcb1    equ     [bx]
launch_fcb2    equ     [bx+16]

launch_code    proc    near
               assume  cs:code,ss:code
               push    bx
               call    launch_1                ; IP auf Stapel
               db      0                       ; Dummy FCB
               db      "DUMMY   FCB"
               db      0,0,0,0
               db      0                       ; Dummy FCB
               db      "DUMMY   FCB"
               db      0,0,0,0
launch_1:
               pop     bx                      ; hole Zeiger auf lokale
                                               ;  Variablen
               push    ds
               push    es                      ; Stapelzeiger merken,
               mov     com_stack_ptr,sp        ;  wichtig unter MS-DOS 2.x
; schreibe die ersten beiden Argumente in die FCBs
               push    di                      ; merke Zeiger auf Rest
               push    si                      ; merke Zeiger auf Namen
               mov     si,di                   ; kopiere Zeiger
               inc     si                      ; berlese Grenbyte
               lea     di,launch_fcb1
               mov     ax,2903h                ; FCB parsen
               int     21h
               lea     di,launch_fcb2
               mov     ax,2903h
               int     21h
               pop     si
               pop     di

               push    cs                      ; Parameterblock auf dem
               lea     dx,launch_fcb2          ;  Stapel anlegen. Fange
               push    dx                      ;  mit 2. FCB an.
               push    cs
               lea     dx,launch_fcb1
               push    dx
               push    cs                      ; Zeiger auf Argumente
               push    di
               mov     ax,cs:[env_segment]     ; hole Umgbungsblock
               push    ax
               mov     bx,sp                   ; Zeiger auf Parameter-
                                               ;  block
               mov     ax,4b00h                ; DOS EXEC
               mov     dx,si                   ; Zeiger auf Dateiname
               int     21h
               mov     bp,offset data_start_ptr - offset init_code + 100h
               mov     bp,cs:[bp]
               mov     bx,cs                   ; BP restaurieren
               cli
               mov     ss,bx                   ; Stapel restaurieren
               mov     sp,com_stack_ptr
               sti
               cld                             ; Richtung auf Normalwert
               pop     es
               pop     ds
;Get return code
               mov     ah,4dh                  ; hole Rckgabewert
               int     21h
               mov     process_rc,al           ; merken
               pop     bx
               ret
launch_code    endp

;----------------------------------------------------------------------------
; GOTO - springe auf eine Sprungmarke aus der Kommandozeile oder einer
; Umgebungsvariablen.
; Register beim Aufruf:
;         DS:SI - Zeiger auf die gewnschte Sprungmarke.
;            DI - Wenn <> 0, speicher GOTO-Adresse an Zeigeradresse
;                  (Wait flag/ptr)
; Ausgang:
;        Diese Funktion kehrt nicht zurck, wenn die Sprungmarke
;        gefunden wird.
;----------------------------------------------------------------------------
goto_echomsg   dw      echo_msg_next           ; zeige Fehlermeldung
goto_lblsrch   dw      lblsrch_next            ; suche Sprungmarke

goto_code      proc    near
               assume  cs:code,ds:code
               call    goto_1
               db      8 dup (" ")
               db      " Label not found",13,10,0
goto_1:
               pop     bx
               push    di                      ; merke wait flag/pointer
               mov     di,bx                   ; Fehlermeldung aufbauen
               xor     dx,dx                   ; kopiere Sprungmarke
               mov     cx,8                    ;  in die Fehlermeldung
goto_2:
               lodsb
               cmp     al," "
               jbe     goto_4
               cmp     al,'a'
               jb      goto_3
               and     al,0dfh                 ; Grobuchstaben
               cmp     al,'Z'
               ja      goto_4
goto_3:
               stosb
               inc     dx
               loop    goto_2
goto_4:
               mov     cx,dx                   ; Gre der Sprungmarke
               mov     si,bx                   ; Zeiger auf Sprungmarke
               mov     di,com_label_start      ; Zeiger auf Listenanfang
               add     di,bp                   ; plus Daten-Offset
               push    bx                      ; merke Zeiger auf Nachricht

               call    goto_lblsrch            ; suche Sprungmarke
               pop     dx                      ; Zeiger auf Nachricht
               pop     si                      ; Wait flag/pointer
               jc      goto_5                  ; CF? nicht gefunden!
               mov     ax,[bx+2]               ; Zeiger auf Ziel
               or      si,si                   ; Flag <> 0?
               je      goto_41                 ; 0, keine Verzgerung
               mov     [bp+si],ax              ; Rcksprungadresse merken
               ret
goto_41:
               pop     ax                      ; vergi Rcksprungadresse
               push    [bx+2]                  ; neue Adresse setzen
goto_exit:
               ret
goto_5:
               mov     bx,dx                   ; Argument bergeben
               call    goto_echomsg            ; Fehlermeldung ausgeben
               ret
goto_code      endp

;-----------------------------------------------------------------------------
; IFEXIST  sieht nach, ob eine Datei existiert
; Register beim Aufruf:
;         DS:SI - Zeiger auf ASCIIZ-Dateinamen
;            DI - Zeiger auf Puffer fr DTA
; Ausgang:   CF - gelscht, wenn die Datei existiert
;            DI - Zeigt auf Dateinamen, wenn Datei existiert
;-----------------------------------------------------------------------------
ifexist        proc    near
               assume  cs:code,ds:code,es:code,ss:code
               mov     dx,di
               mov     ah,1ah                  ; setze DTA
               int     21h

               mov     dx,si                   ; kopiere Zeiger
               xor     cx,cx                   ; normale Attribute
               mov     ah,4eh                  ; DOS Find First
               int     21h
               jc      ifexist_exit
               add     di,1eh                  ; DI zeigt auf Dateinamen
               clc                             ; in DTA
ifexist_exit:
               ret
ifexist        endp

end_of_code     =       $
