/* C_17DOS3.C */

/******************************************************************/
/* Dieses Beispielprogramm zeigt:                                 */
/*  1. Abfrage von Zeit und Datum von DOS                         */
/*  2. Kursor am Bildschirm positionieren                         */
/*  3. Tastencodes lesen und ihre Codes darstellen                */
/*  4. Bildschirm rollen                                          */
/*  5. Programmformatierung fr leichtes Lesen                    */
/******************************************************************/

#include <stdio.h>
#include <conio.h>
#include <dos.h>

void box_zeichnen(void);
void taste_anzeigen(int inchar);
void zeit_lesen(int *stunde, int *minute, int *sekunde);
void zeit_datum_anzeigen(void);
void kursor_positionieren(char row, char column);
void fenster_rollen(void);

void main(void)
{
   int stunde, minute, sekunde, sekunde_alt;
   int tasten_code;

   box_zeichnen();              /* draw the boxes around the fields */
   sekunde_alt = 0;             /* this variable stores the old time
                               so we can look for a change      */

   do
   {
      if (kbhit())
      {
	 tasten_code = getch();
	 taste_anzeigen(tasten_code);
      }

      zeit_lesen(&stunde,&minute,&sekunde);      /* get the time of day */
      if (sekunde != sekunde_alt) {              /* if it has changed,  */
	 zeit_datum_anzeigen();               /* update the display  */
	 sekunde_alt = sekunde;                  /* save new time       */
      }

   }
   while (tasten_code != 'Q');        /* Quit when a Q is found */

   kursor_positionieren(0,0);              /* put cursor at top of screen */
}


/* *********************************************** box_zeichnen */
/* Zeichnet eine Box am Bildschirm. Die gedrckten Tasten und   */
/* Zeit und Datum werden in diesen Boxen angezeigt. Diese Boxen */
/* werden einfach durch printf ausgegeben.                      */
/* ************************************************************ */

void box_zeichnen(void)
{
   int index;
   char line[81];

   for ( index=0; index<80; index++ )         /* Drei Leerzeilen */
      line[index] = ' ';
   line[80] = NULL;
   for (index = 0;index < 3;index++)
      printf("%s",line);

   line[8] = 201;                       /* Oberste Zeile der Box */
   for (index = 9;index < 70;index++)
      line[index] = 205;
   line[70] = 187;
   printf("%s",line);

   line[8] = 186;                       /* Seiten der groen Box */
   for (index = 9;index < 70;index++)
      line[index] = ' ';
   line[70] = 186;
   for (index = 0;index < 15;index++)
      printf("%s",line);

   line[8] = 204;                     /* Zeile zwischen den Boxen */
   for (index = 9;index < 70;index++)
      line[index] = 205;
   line[70] = 185;
   printf("%s",line);

   line[8] = 186;                  /* Seiten fr Datums-/Zeit-Box */
   for (index = 9;index < 70;index++)
      line[index] = ' ';
   line[70] = 186;
   printf("%s",line);

   line[8] = 200;                             /* Fuzeile der Box */
   for (index = 9;index < 70;index++)
      line[index] = 205;
   line[70] = 188;
   printf("%s",line);

   for (index = 0;index < 80;index++)          /* Drei Leerzeilen */
      line[index] = ' ';
   for (index = 0;index < 3;index++)
      printf("%s",line);

}


/* ********************************************* taste_anzeigen */
/* Diese Funktion zeigt die tasten_codes am Bildschirm an.      */
/* Wenn der erste tasten_code Null ist, wurde eine Sondertaste  */
/* gedruckt und die Null wird angezeigt.                        */
/* ************************************************************ */

void taste_anzeigen(int inchar)
{
   fenster_rollen();
   kursor_positionieren(17,15);                /* Position der Mitteilung */

   if(inchar == 0)
   {
      printf(" 00 ");                            /* Sondertaste */
      inchar = getch();                        /* nchster Teil */
      switch (inchar) {
         case 59  :
         case 60  :
         case 61  :
         case 62  :
         case 63  :             /* Funktionstasten */
         case 64  :
         case 65  :
         case 66  :
         case 67  :
         case 68  : printf("%4d Funktionstaste F%d\n",inchar,inchar-58);
                    break;

         case 94  :
         case 95  :
         case 96  :
         case 97  :
         case 98  :         /* Funktionstasten mit CTRL */
         case 99  :
         case 100 :
         case 101 :
         case 102 :
         case 103 : printf("%4d Funktionstaste CTRL-F%d\n",inchar,inchar-93);
                    break;

         case 84  :
         case 85  :
         case 86  :
         case 87  :        /* Funktionstasten mit SHIFT */
         case 88  :
         case 89  :
         case 90  :
         case 91  :
         case 92  :
         case 93  : printf("%4d Funktionstaste SHIFT-F%d\n",inchar,inchar-83);
                    break;

         case 104 :
         case 105 :
         case 106 :
         case 107 :
         case 108 :          /* Funktionstasten mit ALT */
         case 109 :
         case 110 :
         case 111 :
         case 112 :
         case 113 : printf("%4d Funktionstaste ALT-F%d\n",inchar,inchar-103);
                    break;

         default  : printf("%4d Sondertaste\n",inchar);
      }

   } else                        /* Normale Taste */
      printf("    %4d (%c) Taste.\n",inchar,inchar);

   kursor_positionieren(25,1);       /* Kursor in der 26.Zeile verstecken */
}


/* ************************************************* zeit_lesen */
/* Ruft die DOS-Funktion zum Ablesen des Datums und der Uhrzeit */
/* bergabe in den drei verwendeten Pointern                    */
/* ************************************************************ */

void zeit_lesen(int *stunde, int *minute, int *sekunde)
{
   union REGS inregs;
   union REGS outregs;

   inregs.h.ah = 0x2c;               /* Zeit ablesen */
   int86(0x21,&inregs,&outregs);
   *stunde  = outregs.h.ch;
   *minute  = outregs.h.cl;
   *sekunde = outregs.h.dh;
}


/* ***************************************** zeit_datum_anzeigen */
/* Anzeige von Zeit und Datum an einer festen Bildschirmposition */
/* Holt die Zeit von zeit_lesen und holt das Datum selbstndig   */
/* Aus Symmetriegrnden sollte natrlich auch das Datum aus      */
/* einer selbstndigen Funktion stammen aber es handelt sich     */
/* hier um Beispiele, die nur die Mglichkeiten aufzeigen sollen */
/* Es wird auch die Funktion zum Kursorpositionieren gerufen,    */
/* um Zeit und Datum wie gewnscht auszugeben.                   */
/* ************************************************************* */

void zeit_datum_anzeigen()
{
   int stunde, minute, sekunde;
   union REGS inregs;
   union REGS outregs;

   kursor_positionieren(19,19);  /* position the cursor for date and time */

   inregs.h.ah = 42;              /* hex 2A - What is the date? */
   int86(0x21,&inregs,&outregs);  /* interrupt 21               */      
   printf("Datum = %2d/%2d/%2d    ",
      outregs.h.dh,                 /* month - 1 to 12          */
      outregs.h.dl,                 /* day - 1 to 31            */
      outregs.x.cx);                /* year - 1980 to 2099      */

   zeit_lesen(&stunde, &minute, &sekunde);
   printf("Zeit = %2d:%2d:%2d\n",stunde, minute, sekunde);

   kursor_positionieren(25,1);        /* hide the cursor on the 26th line */
}

/* *************************************** kursor_positionieren */
/* Positioniert den Kursor in der geforderten Zeile und         */
/* Spalte. Links oben ist 0,0.                                  */
/* ************************************************************ */

void kursor_positionieren(char row, char column)
{
   union REGS inregs;
   union REGS outregs;

   inregs.h.ah = 2;        /* service 2 - position the cursor   */
   inregs.h.dh = row;
   inregs.h.dl = column;
   inregs.h.bh = 0;
   int86(0x10,&inregs,&outregs);                /* interrupt 10 */
}


/* ********************************************* fenster_rollen */
/* Schiebt alles im Eingabefenster um eine Zeile hoch           */
/* und macht eine Zeile fr Eingaben frei.                      */
/* ************************************************************ */

void fenster_rollen(void)
{
   union REGS inregs;
   union REGS outregs;

   inregs.h.ah = 6;      /* service 6 - scroll window           */
   inregs.h.al = 1;      /* number of lines to scroll           */
   inregs.h.ch = 3;      /* top row of window                   */
   inregs.h.cl = 9;      /* left column of window               */
   inregs.h.dh = 17;     /* bottom row of window                */
   inregs.h.dl = 69;     /* right column of window              */
   inregs.h.bh = 7;      /* attribute of blank line             */
   int86(0x10,&inregs,&outregs);                /* interrupt 10 */

}

/* C_17DOS3.C */
