/* C_18LSTF.C */

/* *************************************************************** */
/* Funktionen, die durch das programm list.c verwendet werden      */
/* und die ganz allgemein fr andere, hnliche Aufgaben            */
/* verwendet werden knnten                                        */
/* *************************************************************** */

#include <string.h>
#include "c_18lstf.h"

char dateiname[15];
int  zeilennummer = 0;
int  seitennummer = 1;
int  zeilenzahl   = 0;         /* aktuelle Stand des Zeilenzhlers */

/* ************************************************ eroeffne_datei */
/* Erffnet eine Datei, deren Name in der Kommandozeile ber-      */
/* geben wurde. Wenn kein Name angegeben wurde, wird gefragt       */
/* *************************************************************** */

void eroeffne_datei(int no, char *name)

/* no    Zahl der Argumente */
/* name  Erstes Argument    */
{
   strcpy(dateiname,name);
   lese_datei = NULL;
   if (no == 2)
   {
      lese_datei = fopen(name,"r");
      if (lese_datei == NULL)
         printf("Dateiname existiert nicht!\n");
   }

   do
   {
      if (lese_datei == NULL)
      {
         printf("Eingabe Dateiname -> ");
         scanf("%s",dateiname);
         lese_datei = fopen(dateiname,"r");
         if (lese_datei == NULL)
            printf("Dateiname extstiert nicht, noch einmal.\n");
      }
   }
   while (lese_datei == NULL);
}


/* ****************************************** eroeffne_druck_datei */
/* Erffnen der Druckdatei                                         */
/* *************************************************************** */

void eroeffne_druck_datei(char *ziel)
{
   print_datei = fopen(ziel,"w");
}


/* ************************************************* zeile_drucken */
/* Druckt eine Textzeile und prft, ob Platz fr eine weitere      */
/* Textzeile besteht. Wenn nicht, Neubeginn einer Seite, mit       */
/* einem neuen Kopf. Ruft einige lokale Funktionen                 */
/* *************************************************************** */

void zeile_drucken(void)
{
   int index;

   header();
   printf("%5d %s",zeilennummer,zeile);

      /* Druckt eine Zeile mit weniger als 72 Zeichen */
      if (strlen(zeile) < 72)
         fprintf(print_datei,"%5d %s",zeilennummer,zeile);

      /* Druckt eine Zeile von 72 bis 143 Zeichen */
      else if (strlen(zeile) < 144)
      {
         fprintf(print_datei,"%5d ",zeilennummer);

         for (index = 0;index < 72;index++)
            fprintf(print_datei,"%c",zeile[index]);

         fprintf(print_datei,"<\n      ");

         for (index = 72;index < strlen(zeile);index++)
            fprintf(print_datei,"%c",zeile[index]);

         zeilenzahl++;
      }

      /* Druckt eine Zeile von 144 bis 235 Zeichen */
      else if (strlen(zeile) < 235)
      {
         fprintf(print_datei,"%5d ",zeilennummer);

         for (index = 0;index < 72;index++)
            fprintf(print_datei,"%c",zeile[index]);

         fprintf(print_datei,"<\n      ");

         for (index = 72;index < 144;index++)
            fprintf(print_datei,"%c",zeile[index]);

         fprintf(print_datei,"<\n      ");

         for (index = 144;index < strlen(zeile);index++)
            fprintf(print_datei,"%c",zeile[index]);

         zeilenzahl += 2;
      }

      /* Ausgabe eines Zeilenvorschubs bei der letzten Zeile, wenn ntig */
      if (zeile[strlen(zeile)-1] != '\n')
         fprintf(print_datei,"%c",'\n');

      zeilennummer++;
      zeilenzahl++;
}


/* ******************************************************** header */
/* Prft, ob ein Kopf ausgegeben werden soll. Prft auch das       */
/* Seitenende und schiebt das Papier vor                           */
/* *************************************************************** */

void header(void)
{
   int index;

    /* sind wir am Seitenende ? */
   if (zeilenzahl > MAXLINES)
   {  /* space paper up for bottom */
      for ( index=zeilenzahl; index<61; index++ )
         fprintf(print_datei,"\n");
      zeilenzahl = 0;
   }

            /* put a monitor header out only at the very beginning */
   if (zeilennummer == 0) {               /* display monitor header */
      printf("        Source file %s\n",dateiname);
      zeilennummer = 1;
   }

         /* check to see if we are at the top of the page either   */ 
         /* through starting a file, or following a bottom of page */
   if (zeilenzahl == 0) {        /* top of every printer page */
      fprintf(print_datei,"\n\n\n        ");
      fprintf(print_datei," Source file - %s        ",dateiname);
      fprintf(print_datei,"          Page %d\n\n", seitennummer);
      seitennummer++;
   }
}


/* *************************************************** neue_seite  */
/* Papiervorschub zur nchsten Seite, soda ein Neustart           */
/* korrekt erfolgt. Aufruf nur am Ende des Ausdrucks               */
/* *************************************************************** */

void neue_seite(void)
{
   int index;

   for ( index=zeilenzahl; index<61; index++ )
      fprintf(print_datei,"\n");
}

/* C_18LSTF.C */
