
/* C_19TOP1.C */

/* Ausprogrammiertes Programm Top-Down */
/* Gleichzeitig Beispiel fr lineare Liste, Bubble-Sort */

#include<stdio.h>
#include<stdlib.h>
#define forever for(;;)

static int temp;
#define SWAP(x,y) temp=(y);(y)=(x);(x)=temp;

struct DATEN
{
  int           zahl;
  struct DATEN *next;
};

struct DATEN *ds=0;

void Eingabe(void);
void Ausgabe(void);
void Loeschen(void);
void Sortieren(void);
void Speichern(void);
void Laden(void);

void Eingabe(void)
{
  int ein;
  struct DATEN *p,*daten;
  
  forever
  {
    printf("Eingabe, Ende mit 999 : ");
    scanf("%i",&ein);
    printf("\n");
    if (ein==999) return;
    daten = (struct DATEN *)malloc(sizeof(struct DATEN));
    daten->zahl=ein;
    daten->next=0;
    
    p=ds;
    
    if (p)
    {
      while (p->next) p=p->next;
      p->next=daten;
    }
    else
    {
      ds=daten;
    }
  }
}

void Ausgabe(void)
{ 
  struct DATEN *p=ds;
  
  if (p)
  {
    while(p->next)
    {
      printf("%i ",p->zahl);
      p=p->next;
    }
    printf("%i ",p->zahl);
  }
  else
    printf("keine\n");
}

void Loeschen(void)
{
  struct DATEN *p1=ds,*p2;
  
  if (p1)
  {
    while(p1->next)
    {
      p2=p1->next;
      free(p1);
      p1=p2;
    }
    free(p1);
    ds=0;
  }
  else
    printf("keine\n");
}

void Sortieren(void)
{
  struct DATEN *d1,*d2;
  if (ds)
  {
    d1=ds;
    d2=ds->next;
    forever
    {
      d1=d1->next;
      if (d1->next==d2->next) 
      { 
        if (!d2->next) return;
        d1=ds;
        d2=d2->next;   
      }
      if (d1->zahl>d2->zahl)
      {
        SWAP(d1->zahl,d2->zahl);
      }  
    }
  }
  else
  {
    printf("keine\n");
  }
}

void Speichern(void)
{
  struct DATEN *p=ds;

  char name[80];
  FILE *aus;
  
  printf("Dateiname:");
  scanf("%s",name);
  aus = fopen(name,"w");
  if (aus) printf("Datei erffnet\n");
  else
  {
    printf("Fehler beim erffnen der Datei\n");
    return;
  }
  if (p)
  {
    while(p->next)
    {
      fprintf(aus,"%i ",p->zahl);
      p=p->next;
    }
    fprintf(aus,"%i ",p->zahl);
  }
  else
    printf("keine\n");
  fclose(aus);
}

void Laden(void)
{
  int ein;
  struct DATEN *p,*daten;

  char name[80];
  FILE *e;
  
  printf("Dateiname:");
  scanf("%s",name);
  e = fopen(name,"r");
  if (e) printf("Datei erffnet\n");
  else
  {
    printf("Fehler beim Erffnen der Datei\n");
    return;
  }
  
  forever
  {
    int ende;
    ende=fscanf(e,"%i",&ein);
    if (ende==0) return;
    daten = (struct DATEN *)malloc(sizeof(struct DATEN));
    daten->zahl=ein;
    daten->next=0;
    
    p=ds;
    
    if (p)
    {
      while (p->next) p=p->next;
      p->next=daten;
    }
    else
    {
      ds=daten;
    }
  }
}


void main()
{
  int eingabe;
  
  forever
  { 
    printf("\n1.Eingabe\n");
    printf("2.Ausgabe\n");
    printf("3.Lschen\n");
    printf("4.Sortieren\n");
    printf("5.Speichern\n");
    printf("6.Laden\n");
    printf("7.Ende\n");

    scanf("%i",&eingabe);

    switch (eingabe)
    {
    case 1: Eingabe(); break;
    case 2: Ausgabe(); break;
    case 3: Loeschen(); break;
    case 4: Sortieren(); break;
    case 5: Speichern(); break;
    case 6: Laden(); break;
    case 7: return;
    }
  }
}
