
// CPPKLA6.CPP

// Von einer Klasse knnen mehrere Subklassen abgeleitet werden
// Memberfunktionen der Subklassen knnen normal oder virtuell
// berladen werden.

// Virtuelle Funktionen

// Eine Funktion kann in einer abgeleiteten Klasse
// a. von der Basisklasse geerbt sein
// b. berladen werden (sie tritt an Stelle der Basisklassenfunktion)
// c. virtuell sein (ein BasisKlassen-Pointer-Zugriff auf die 
//    abgeleitete Funktion liefert die abgeleitete Funktion zurck

// Von Basisklassen mit einer virtuellen Funktion 
// kann kein Objekt gebildet werden

#include <stdio.h>

// WURM.HPP

class WURM
{
protected:

  char *wurm;

public:

virtual void zeige() = 0;

     WURM(int laenge);
    ~WURM() { delete wurm; }
void loch(int position);
};

class HWURM : public WURM
{
public:
void zeige(void);
     HWURM(int laenge) : WURM(laenge)
     {}
};

class SWURM : public WURM
{
public:
void zeige(void);
     SWURM(int laenge) : WURM(laenge)
     {}
};

// WURMT.CPP

void main()
{
  // Wrmer
  HWURM hw(20);
  SWURM sw(6);

  // Zeiger auf Wrmer
  WURM *wp;

  wp = &hw;
  wp->zeige();
  wp = &sw;
  wp->zeige();
}

// WURM.CPP

WURM::WURM(int laenge)  // Konstruktor
{
  wurm = new char[laenge+1];
  for (int i=0; i<laenge; i++)
    wurm[i]='*';
  wurm[i]=0;
}

inline void WURM::loch(int position)
{
  wurm[position]='.';
}

void HWURM::zeige(void)
{
  printf("%s\n",wurm);
}

void SWURM::zeige(void)
{
  char *p=wurm;
  while (*p)
  {
    printf("%c\n",*p++);
  }
}



