
drsens_c segment code
       rseg drsens_c


; DRUCKSENSOR                                                       Version:  DRSENS.OL8
;
; BEGONNEN AM 19.11.90 ------------------------------------- FERTIIGGESTELLT AM 29.04.91
;
; AUTOR:  Markus ANDLINGER
;
;---------------------------------------------------------------------------------------
;  BIT VARIABLEN
;---------------------------------------------------------------------------------------

STATUS  equ 020h    ; BITREG. FR VERZW.
MODE    equ 021h    ; Modeinstellung ber INT0

;---------------------------------------------------------------------------------------
;  INT VARIABLEN 8-BIT
;---------------------------------------------------------------------------------------

MESS      equ 060h    ; Absol. Periodenz.
;         equ 061h
ZAHL1     equ 062h    ; Periodrmz. ADC
ZAHL2     equ 063h    ; Periodenz. MUX
ADCSP     equ 064h    ; Zwischensp. fr ADC-Wert
ADCPOINT  equ 065h    ; Pointer auf ADC-Register
FLACHE    equ 066h
TESTADC   equ 067h    ; ADC-Werte bei den ersten n Durchg. nicht Testen
FEHLER    equ 068h    ; Anzahl der ungltigen ADC-Werte
WADCH     equ 069h    ; ADCH-Reg. retten
WADCL     equ 06Ah    ; ADCON     retten
TESTBED   equ 06Bh    ; Anzahl der zu testenden BITS von ADCH
MPER      equ 06Ch    ; Anzahl der 20 ms Durchgnge
ADCFEHL   equ 06Dh    ; Fehler fr ADC-Eing. spezifisch
DIFFANZ   equ 06Eh    ; Zeiger auf die Differenzspeicherpl.
SP_ADC1   equ 06fh    ; Delay vor Messung
SETBIT    equ 070h    ; bestimmt welches Bit bei Division gesetzt werden soll
DIVID     equ 071h    ; DIVIDend
DIVISOR   equ 072h    ; DIVISOR
QUOT      equ 073h    ; QUOTIENT

p4     equ 0c0h      ; verw. Register: R0, R1
ien0   equ 0a8h
adcon  equ 0c5h
ADCH   equ 0c6h
IP0    equ 0b8h
IEN1   equ 0e8h
S0BUF  equ 099h
S0CON  equ 098h

;---------------------------------------------------------------------------------------
;  VARIABLEN 16-BIT
;---------------------------------------------------------------------------------------

; REGISTERBANK 1 fr ADC von 030h bis 03fh

ADC0H   EQU 030h    ; 16-Bit Variablen
ADC0L   EQU 031h    ; fr ADC-Ergebnisse

ADC1H   EQU 032h
ADC1L   EQU 033h

ADC4H   EQU 038h
ADC4L   EQU 039h


; REGISTERBANK 2 fr ADC von 040h bis 04fh

ADC0H2  EQU 040h    ; 16-Bit Variablen
ADC0L2  EQU 041h    ; fr ADC-Ergebnisse


;---------------------------------------------------------------------------------------
;  INTERRUPT VERZWEIGUNGEN
;---------------------------------------------------------------------------------------

ORG 000h                 ; RESET startadr.
    AJMP INITIAL

ORG 003H                 ; INT0 - Vektoradr
    AJMP SETM
    RETI

ORG 013h                 ; INT1 - Vektor
    SETB STATUS.4        ; Nullabgl. durch INT1
    RETI

ORG 00Bh                 ; Timer 0  Intvekt.            100 ys Takt
    SJMP TIME0
    RETI

ORG 001BH                ; Timer 1                      20 ys Takt
    ORL ADCON,#08h       ; SET ADCON.3  START ADC
    CLR TCON.6           ; Stop Timer 1
    RETI

ORG  023H                ; SIO-0 INTERRUPT
SIO: JMP RS232N
     RETI

ORG  02Bh                ; IC - INT
I2C: RETI

ORG  053h                ; ADC-Interruptvektoradr.
ADC: AJMP INT_ADC        ; INTR ADC
     RETI

ORG  060h
TIME0:    XCH A,R3             ; ACC retten
          MOV A,P4             ; MUX +1
          INC A                ; ohne MUX beim bergang von F auf 0 auszuschalten
          ORL A,#00001000b
          MOV P4,A

          MOV TL1,TH1          ; reload Timer1 mit exaktem Wert
          SETB TCON.6          ; RUN TIMER 1
          XCH A,R3             ; ACC zurckholen
          RETI                 ;


;---------------------------------------------------------------------------------------
; INITIALISIERUNG
;---------------------------------------------------------------------------------------

ORG 100h

INITIAL:

  MOV IEN0,#01001010b   ; INT voreinstellung, dis. INT global
                        ; ADC - IC - SIO - TIMER 1 - EXT 1 - TIMER 0 - EXT 0
  MOV IP0,#00001010b    ; INT Priority fr Timer 1 high
                        ;                  Timer 2 high
  MOV IEN1,#00h         ; T2 INT OFF
  MOV MODE,#00h
  MOV FLACHE,#00h

org 110H
RETMOD:

  MOV SP,#90H           ; STACKP. 90h
  MOV STATUS,#00h       ; alle Statusbits clear
  SETB STATUS.4         ; Abgleich vor Messung
  MOV ADCPOINT,#00h     ; Einstellen des zu messenden Ports
  ACALL RST_ADC         ; ADC-SPEICHER lschen

;---------------------------------------------------------------------------------------
; INITIAL TIMER 1 und 0
;---------------------------------------------------------------------------------------

TIMER:

  MOV TCON,#00000101b     ; INT0 edge-triggered
  MOV TMOD,#00100010b     ; Timer 0 MODE 2 -TIMER 1 MODE 2  RELOAD

  MOV TH0,#0A3h           ; Timer 0 soll alle 100 ys einen INT erzeugen
  MOV TL0,#240d           ; (256 - 100) beim ersten Start nur 6 ys

  MOV TH1,#0F4h           ; Timer 1 alle 20 ys ein INT
  MOV TL1,#0F4h           ;

;---------------------------------------------------------------------------------------
;  MAIN PROGRAM
;---------------------------------------------------------------------------------------

MAIN:

   CALL INITADC          ; Grundeinst. fr ADC_MR
   SETB IEN0.7           ; ENABLE INT
   SETB TCON.4           ; Run Timer 0

START:

   JNB STATUS.1,START    ; Nach Meende neuer Start der
       JMP VERARB_MW     ; Meroutiene

   SJMP START

;---------------------------------------------------------------------------------------
;  ADC_INITIALISIERUNG
;---------------------------------------------------------------------------------------

INITADC:

  ANL ADCON,#0EFh       ; RST ADC
  MOV ADCON,#03h        ; ANALOGEINGNANG auf 03

  MOV p4,#08h           ; Analogsch auf Ausg. 0 ,
                        ; Bit 5 mu 1 sein um Mux zu enablen
  MOV MESS,#0201d       ; 25 Durchg. fr 20ms Per.
  MOV MPER,#01h         ; 1 x 20 ms messen

  MOV ZAHL1,#0dh        ; kein ADC Per. 1.
  MOV TESTADC,#09d      ; kein Test fr den ersten Durchg.
                        ; fr mehr. Durchg. o.T. Val=09+08*n

  CLR STATUS.0          ; kein ADC Per. 1 bis 8
  CLR STATUS.1          ; keine Verzw. vor Meszende
  CLR STATUS.3          ; Speichern des 1. ADC-Wertes fr Test

  MOV FEHLER,#00h
  MOV ADCFEHL,#058H     ; Anfang fr Fehleranzeige
  MOV DIFFANZ,#050h     ; Anfang fr Differenzanzeige

  MOV R0,#31h           ; Einstellen des Datenspeicherzeigers
  MOV R1,ADCFEHL        ; Zeiger auf Fehlerstellen
  MOV DPTR,#00H         ; Datapointer fr Ext. Ram rckstellen  (NUR MIT EMULATOR )
  CLR TCON.5            ; Interruptflag von Timer 0 lschen

  RET


;=======================================================================================
;---------------------------------------------------------------------------------------
; MESZWERTVERARBEITUNGSROUTINE
;---------------------------------------------------------------------------------------

VERARB_MW:              ; Bildung der Differenzen zw. zwei Mezyklen

  PUSH IEN0             ; Interrupteinstellung retten
  MOV IEN0,#10000101b   ; EXT-INT0 zulassen

  CALL DIVI

  JNB STATUS.4,W6
      CALL COPY_ADC
      CLR STATUS.4

W6:   CALL DIFF

STOP:

  POP IEN0              ; Interrupteinstellung zurckholen
  CALL RS232            ; Senden der Mewerte ber UART
  CALL RST_ADC          ; Speicher Lschen
  JMP TIMER             ; Ende der Verarbeitungsr.

;---------------------------------------------------------------------------------------
;  DIFFERENZWERTBILDUNG      ( 8 - BIT DIFFERENZ )
;---------------------------------------------------------------------------------------
;  Verwendete Register:  A, R0, R1, R2, R3, CARRYFLAG
;                        ADC-BANK 1,2
;---------------------------------------------------------------------------------------

DIFF:

    MOV R0,#ADC0L       ; Speicheranfang Mew. 1
    MOV R1,#ADC0L2      ; Speicheranf. Mew. 2
    MOV R2,#50H         ; Speicherplatz fr Diffwerte
    MOV R3,#08H         ; 8 Durchgnge

WEITER2:                ; Differenzbildung zw. Me. 1 & 2

    CLR C               ; clear Carry
    MOV A,@R0           ; Subtraktion von Mew. 1 & 2
    SUBB A,@R1

    PUSH 01H
    MOV 01h,R2
    MOV @R1,A           ; Ergebnis auf R2 abspeichern
    INC R2
    INC R0
    INC R0
    POP 01h
    INC R1
    INC R1

 DJNZ R3,WEITER2
 RET

;---------------------------------------------------------------------------------------
;  COPIEREN DER ADC-BANK 1 IN ADC-BANK 2
;---------------------------------------------------------------------------------------
;  Verwendete REGISTER:  A, R0, R1, R2
;                        ADC-BANK 1, 2
;---------------------------------------------------------------------------------------

COPY_ADC:

    MOV R0,#ADC0H
    MOV R1,#ADC0H2
    MOV R2,#10h

LOOP1:

    MOV A,@R0           ; Werte in ADC-Bank zwei kopieren
    MOV @R1,A
    INC R0
    INC R1

DJNZ R2,LOOP1

     RET

;---------------------------------------------------------------------------------------
; LSCHEN DER ADC-SPEICHERPLATZE
;---------------------------------------------------------------------------------------
; Verwendete Register:   R0, R1, ADC-BANK 1
;---------------------------------------------------------------------------------------
RST_ADC:

   MOV R0,#ADC0H
   MOV R1,#010h

ST:
   MOV @R0,#00h
   INC R0

   DJNZ R1,ST

   RET

;---------------------------------------------------------------------------------------
;  D I V I S I O N
;---------------------------------------------------------------------------------------

; Die folgende Routiene dividiert eine 16-Bit Zahl durch eine 8-Bit Zahl
; wobei das Komma um zwei Stellen nach rechts verschoben wird.
;
; Verwendete Variablen:
;
;       R0 ... Zeiger auf die zu divid. Zahl (MSB)
;       R1 ... Zeiger auf die Stelle wo Ergebnis abgespeichert werden soll
;       R2 ... Zhlt wieviele Bits schon divid. worden sind (Stellen)
;       R3 ... Anzahl der 16-Bit Zahlen die divid. werden sollen
;
;       SETBIT  ... Bestimmt welches Bit bei Division gesetzt werden soll
;       DIVID   ... DIVIDend
;       DIVISOR ... DIVISOR
;       QUOT    ... QUOTient
;       STATUS.5 .. Verwendung fr Verzweigung
;
;       ADC-BANK 1
;---------------------------------------------------------------------------------------


DIVI: MOV R3,#08h               ; Anzahl der 16-Bit Zahlen die Divid. werden
      MOV R0,#ADC0H             ; Zeiger auf den Anfang der zu divid. Zahlen
      MOV R1,#ADC0H
DIVI1:
      MOV SETBIT,#0100b         ; bestimmt welches Bit im Ergebn. gesetzt wird
      MOV R2,#000h              ; Zhler fr Bit des Divisors
      MOV DIVID,#00h            ; Rcksetzen der Variablen
      MOV QUOT,#00h
      MOV DIVISOR,#25d          ; Division durch 25
      CLR STATUS.5              ; Ende nach 16-Bit Division

START1:
      INC R2
      CJNE R2,#09d,W2           ; Weiterstellen des DIVID
           JB STATUS.5,W2       ; nur beim ersten Mal
           INC R0

W2:   CJNE R2,#11d,WEITER3      ; Verschieben des Kommas ( es wird erst bei 10 Bit
                                ; Ergebnis das Ergebn. auf 8-Bit abgesp. (die oberen
                                ; 2 Bit gehen verloren)

           MOV SETBIT,#01d      ; Rckstellen fr die 2. 8-Bitzahl
           MOV @R1,QUOT         ; Rckstellen von SETBIT
           INC R1               ; Abspeichern der oberen vier Bit des Ergebn.
                                ; Zeiger auf die unteren 8-Bit des DIVID.

        JB STATUS.5,ENDE        ; Ende beim 17. Bit
           SETB STATUS.5        ; Setzen des Bits nach dem ersten Teil der Divi
           MOV R2,#03h          ; Stellung von R2 +3 damit nach 8 Bit Ergeb. abgesp.
           MOV QUOT,#00d        ; wird ( siehe W2 )

WEITER3:

      MOV A,@R0                 ; Es wird das MSB nach DIVID rotiert
      CLR C                     ; bzw. die folgeneden Bits nachr.
      RLC A
      MOV @R0,A                 ; Abspeichern der rotierten Zahl in @r0
      MOV A,DIVID               ;
      RLC A
      MOV DIVID,A
      CLR C
      SUBB A,DIVISOR            ; ist der DIVISOR im DIVID enthalten wird verzweigt
      MOV A,SETBIT              ;
      RR A                      ; Die Stelle die berechnet wurde wird bestimmt
      MOV SETBIT,A
   JC START1                    ; wenn das Carryflag gesetzt ist Sprung

W:    ORL QUOT,A                ; Setzen des gltigen Bits im Ergebnis
      MOV A,DIVID
      SUBB A,DIVISOR            ; Rest ermitteln
      MOV DIVID,A               ; und im DIVID abspeichern
      SJMP START1

ENDE: INC R0                    ; Ende der einzelnen 16-Bit Division
      DJNZ R3,DIVI1             ; Ende der ges. Division
      RET

;=======================================================================================

;=======================================================================================
;---------------------------------------------------------------------------------------
;  INTERRUPT - ROUTIENEN
;---------------------------------------------------------------------------------------
;  ADC  INTERRUPTR.
;---------------------------------------------------------------------------------------
;  Verwendete Register:
;
;       A, Carryflag, ( DPTR )
;       R0 ... Zeiger auf die aktuelle ADC-Speicherstelle
;     ( R1 ... Zeiger auf Fehleranzeige ) NUR EMULATOR
;       R3 ... Zwischenspeicher
;       R4 ... Zwischenspeicher
;
;       WADCH, WADCL ... Zwischenspeicher fr ADC-Werte ( da bei neuer ADC-Messung ADCH
;                        und ADCON berschrieben werden
;       ZAHL1        ... Zhler fr die ersten vier ungltigen Werte
;       MESS         ... Anzahl der ges. Messungen ( Eingestellt in INITADC )
;       MPER         ... Anzahl der 20ms Messungen ( es kann die Medauer in 20ms-Schritten
;                        verlngert werden
;       STATUS.0     ... Verzweigung nach den ersten vier ADC-Werten
;       STATUS.1     ... Verzweigung zur Meverarbeitung nach Meende
;     ( STATUS.3     ... Speichern des ersten ADC-Wertes fr Testzwecke) NUR EMULATOR
;
;       Es mu beachtet werden, da diese Routiene nicht lnger als ca. 70 ys (bitte am
;       EMULATOR berprfen) dauern darf. ( ADC-INT ist sonst noch nicht zu ende wenn der
;       nchste ADC-INT kommt)
;---------------------------------------------------------------------------------------

ORG 300h

INT_ADC:

    MOV WADCH,ADCH      ; ADC Register retten
    MOV WADCL,ADCON

    MOV A,ADCON         ; Meport wird um eins weitergesch.
    INC A               ; Es drfen nur die untersten drei Bit beeinfl. werden, da sonst
    ANL A,#11100111b    ; der ADC neu gestartet wird
    MOV ADCON,A         ; RESET ADC (Mep. kann nur verndert werd. wenn ADCON.3 u.4 low)
    MOV ADCON,A         ; stellen des Meports

; ----------   Bis hier mu die ADC-Interruptroutiene abgearbeitet sein, bevor der ADC neu
; ----------   gestartet werden darf !! ( ADC sonst nicht rckgesetzt und MPort gestellt )


   ; ---------------------
   ; TIMING DER MESSZYKLEN      --- Zustnde bei Einstieg in die Interruptroutiene

   ; 7   0  ! 1   2   3   4  ! 5   6   7  ! (8)    PERIODE X,n  ADC_INTERRUPTS
   ;        !                !            !
   ; A2  A3 ! A4  A5  A6  A7 ! A0  A1  A2 ! A3     ANALOGEINGANG
   ; T7  T0 ! T1  T2  T3  T4 ! T5  T6  T7 ! T0     MUX 1 (AUFL. DER KOND.)
   ;        !                !            !
   ; 35  37 ! 39  3B  3D  3F ! 31  33  35 ! 37     REGISTER-POINTER  (R0)
   ;        !                !
   ;        !100 200 300 400 !500                  Entladungsdauer des Kondens.
   ;        !                !                     C0 in ys
   ; C7  C0 ! C1  C2  C3  C4 ! C5  C6  C7   C0     Ladung der Kond.
   ;        !                  !
   ;  START !                  !
   ;                           !
   ;                             1. gltiger ADC-Wert  C0
   ;                                 Messung nach 420 ns
   ;

AF_PER01x:                 ; berspringen nach den ersten n Werten

    JB STATUS.0,AF_PER41x  ; ADC ungltig fr PER 1.x


AF_PER00X:                 ; Die ersten n ADC-Werte sind ungltig
                           ; und werden nicht eingelesen
    DJNZ ZAHL1,RETURN_INT
         SETB STATUS.0     ; bei nchsten Period. Spr.

         RETI


RETURN_INT:  RETI

                              ; Abfrage ob Meende erreicht
AF_PER41X:                    ; ENDE der 20 ms Meszper.
                              ; Ausstieg nach 32 Messungen
    DJNZ MESS,AF_PERx8        ;                 ----
         MOV MESS,#201d       ; RELOAD

      DJNZ MPER,AF_PERx8            ;
           CLR IEN0.7               ; dis INT
           SETB STATUS.1            ; verzw. nach RETI zu MW-Verarb.

    RETI



AF_PERx8:                   ; R0 wird rckgesetzt

    CJNE R0,#41h,ADCEINLESEN; R0 wird zur Ausscheidung benutzt

       MOV R0,#ADC0L        ; ADC-Registerpointer rcksetzen
       MOV R1,ADCFEHL       ; nur mit EMULATOR


 ADCEINLESEN:      ; getestet 04.10.90 OK        Speicherplan:
                   ; verndert 18.01.91          C   ADCH       ADCON
   CLR C           ;                             - ---- ----  ---- ----
   MOV A,WADCL     ; BIT 0 und 1 des ADC
   RL a            ; in R0 isolieren                 ADCxH      ADCxL
   RL a            ;                               ++++ ++oo  oooo oo**
   ANL A,#011B     ; Format  0000 00xx
   MOV R3,A        ; nach R3 retten                o .. Stellen von ADCH
                   ;                               * .. Stellen von ADCON
   MOV A,WADCH     ; um 2 bit rotieren             + .. Stellen durch Addition
   RL a            ;
   RL a
   MOV R4,A        ; nach R4 retten
   ANL A,#11111100B; Bit 2 bis 7 auf Format xxxx xx00 bringen
   ADD A,R3        ; bit 0 und 1 zu A addieren
   ADD A,@R0       ; Ergebnis zu den schon vorh. Werten addieren und
   MOV @R0,A       ; wieder auf @ R0 ablegen.

   DEC R0            ; Zeiger minus 1
   MOV A,R4          ; Bit 8 und 9 auf Format 0000 00xx bringen
   ANL A,#011b       ;
   ADDC A,@R0        ; A zu schon vorh. Werten addieren und wieder
   MOV @R0,A         ; ablegen; Add mit Carry.
   INC R0
   INC R0
   INC R0

;   INC @R1           ; nur fr EMULATOR
;   INC R1            ; nur fr EMULATOR

;     CJNE R0,#33h,RETURN_INT ;   N      ; R0 wird zur Ausscheidung benutzt
;                             ;   U
;       MOV A,wadch           ;   R   F  ; Es werden alle ADC-Werte eines Einganges
;       MOVX @DPTR,A          ;       
;       INC DPTR              ;   E   R  ; im Externen Ram abgelegt
;       MOV A,wadcl           ;   M      ; das ist nur mit Emulator mglich da sonst kein
;       ANL A,#11000000b      ;   U      ; ext. Ram vorhanden
;                             ;   L
;       MOVX @DPTR,A          ;   A
;       INC DPTR              ;   T
  ;  JB STATUS.3,RETURN_INT   ;   O
  ;     SETB STATUS.3         ;   R
  ;     MOV SP_ADC1,WADCH     ;

   RETI

;=======================================================================================


;---------------------------------------------------------------------------------------
; SERIELLE DATENBERTRAGUNG
;---------------------------------------------------------------------------------------
;  Verwendete Variablen:
;
;       R0 ... Zeiger auf die Speicherstelle die bertragen werden soll
;       R4 ... Anzahl der bertragenen Bytes
;
;       STATUS.6  ...  wenn gesetzt Ausstieg aus der bertragung
;
;       LOKALE VARIABLEN :   ALLE
;
;
;  Die bertragung der Mewerte wird mit dem zweimaligen bertragen von 'AA h' eingeleitet
;---------------------------------------------------------------------------------------

RS232:

     MOV S0CON,#01000000b   ; Mode 1 der SIO  nur senden
     MOV TH1,#0FAh          ; Timer 1 erzeugt eine Baudrate von 4800 Hz
     MOV TL1,#0FAh
     SETB TCON.6            ; Run TIMER 0
     MOV R0,#4Fh            ; Zeiger auf Speicherstellen ( DIFFERENZWERTE )
     CLR S0CON.1            ; Lschen des Transmit-int-Flag
     MOV S0BUF,#0AAh        ; Starten der bertragung von @R0

W3:  JBC S0CON.1,RS232N     ; Verzweigung wenn bertragung beendet
     JNB STATUS.6,W3        ; Ausstieg aus der bertragung
     CLR STATUS.6
     RET

RS232N:
     CLR S0CON.1            ; Lschen des Transmit-int-Flag
     CJNE R0,#4Fh,ABSOLUT   ; Senden von 2 mal "AA" als Start der bertragung
          MOV S0BUF,#0AAh
          INC R0
     SJMP W3

ABSOLUT:
     JNB MODE.0,REL          ; Verzweigung wenn Relativw. bertragen werden sollen
         JB MODE.7,W5        ; berspringen bei den nchsten Durchgngen.
            SETB MODE.7
            MOV R0,#ADC0H    ; Zeiger auf ADC0H

 W5: CJNE R0,#ADC0H2,W4      ; Ende der bertragung
          CLR MODE.7
          SETB STATUS.6
          SJMP W3


REL: CJNE R0,#58h,W4        ; Beendigung der bertragung der Relativwerte
     SETB STATUS.6
     SJMP W3

W4:  MOV S0BUF,@R0          ; Starten der bertragung von @R0
     INC R0
     SJMP W3


;---------------------------------------------------------------------------------------
;       MODE-EINSTELLUNG
;---------------------------------------------------------------------------------------

SETM:
          CLR IEN0.7        ; DIS INT
          PUSH 04           ; Register R4 retten
          CPL MODE.0        ; Umschalten des Modebits

;-------------------------------------------*
; BERTRAGUNG DER MODEEINSTELLUNG BER SIO  *
;-------------------------------------------*
;
;  Verwendete Variablen:
;
;       R4 ... Anzahl der bertragenen Bytes
;
;       STATUS.6  ...  wenn gesetzt Ausstieg aus der bertragung
;
;       LOKALE VARIABLEN :   ALLE
;
;  Die bertragung der Mewerte wird mit dem zweimaligen bertragen von '55 h' eingeleitet
;-------------------------------------------*
;
RS232_MODE:

     MOV S0CON,#01000000b   ; Mode 1 der SIO  nur senden
     MOV TMOD,#00100000b
     MOV TH1,#0FAh          ; Timer 1 erzeugt eine Baudrate von 4800 Hz
     MOV TL1,#0FAh

     SETB TCON.6            ; Run TIMER 0
     CLR S0CON.1            ; Lschen des Transmit-int-Flag

     MOV S0BUF,#055h        ; Starten der bertragung mit 55h
     MOV R4,#00h            ; zhler fr bertragene Bytes

X1:  JBC S0CON.1,RS232_M    ; Verzweigung wenn bertragung beendet
     JNB STATUS.6,X1        ; Ausstieg aus der bertragung
     CLR STATUS.6
     CLR S0CON.1            ; Lschen des Transmit-int-Flag

;     POP 08                 ; Verbiegen des PC um nach RETI von
;     POP 08                 ; Adresse 110H zu starten
;     MOV 08,#10H
;     PUSH 08
;     MOV 08,#01H
;     PUSH 08

     POP 04                 ; Register R4 retten
     CLR IEN0.0
     RETI

RS232_M:

     CJNE R4,#00h,X2        ; Senden von 2 mal "55" als Start der bertragung
          MOV S0BUF,#055h   ; 55 55 kennzeichnet die bertragung von MODE
          INC R4
     SJMP X1

X2:  CJNE R4,#03h,X3
          SETB STATUS.6
     SJMP X1

X3:  CJNE R4,#02H,X4
          MOV S0BUF,MODE
          INC R4
     SJMP X1

X4:                         ; Starten der bertragung von @R0
     MOV S0BUF,FLACHE
     INC R4
     SJMP X1

;---------------------------------------------------------------------------------------
;
; 11.01.91
; Vernderung des Programmes um Drucksensor zu Testen. Es wird
; eine unendlich Merutiene eingerichtet.
; weiters wird der Differenzwert zw. zwei Meperioden ermittelt
; Hardwarestand: Mainboard fertig, vorl. Sensor fertig und
;                zusammengebaut. Test am Emul 51
;
; 18.01.91
; Es wird die Mittelungsroutiene richtiggestellt, da vorher
; gewichtet wurde. Testroutiene wird ausgeschaltet, vorerst 32 messungen/per
;
; 21.01.91
; Die Entladedauer der Kondensatoren wird von 450 ys auf 150 ys verringert.
; Dies soll eine Verringerung der Strungen bewirken. Es wurde festgestellt, da
; der Multiplexer beim Weiterschalten Strungen verursacht.
;
; 31.01.91
; Die e - Funktion wird durch das Schalten des Mux gestrt. Es treten dabei
; nach dem Schalten Einschwingvorg. auf, die ca. 20 ys dauern. Es sollte daher
; nach dem Umschalten 20 ys gewartet werden, bevor gemessen wird. Weiters soll
; eine genaue Einhaltung der 20 ms Meperiode erzielt werden.
;
; 01.02.91
; Es wurde festgestellt, da die ADC-INT-Routiene lnger als 50 Zyclen dauert.
; Es wird daher der ADC mit Timer 1 gestartet.
;
; 11.02.91
; Wenn der Multiplexer mit der ADC-Routine weitergesch. wird dann werden keine
; exakten Perioden erreicht.
;
; 04.03.91
; Es wurde die serielle Schnittstelle in Betrieb genommen. Der Sensor funktioniert
; und die Messungen ergeben eine Spannung die auf 12-Bit genau ist. (+- 1/2 LSB)
;
; 29.04.91
; Abschlu der Arbeiten am Projekt DRSENS. Das Programm ist weitgehend fertiggestellt,
; ausgetestet und funktionstchtig.

END;
