 		
		; *********************
		; * Vereinbarungsteil *
		; *********************


ACOUNT:	equ	30H		;  Speicherpltze fr
FLANKE: equ	31H		;  VARIABLE

	
FDIST:	equ	00H		; 
HIMIN:	equ	00H		;  selbst
HIMAX:	equ	00H		;  definierte
LOWMIN:	equ	00H		;  KONSTANTEN
LOWMAX:	equ	00H		; 
TRMIN:	equ	00H		; 
TRMAX:	equ	00H		;  
DATT0:  equ	00H


TL0:	equ	8AH		; Timer 0 LOW
TL1:	equ	8BH		; Timer 1 LOW
IP:	equ	B8H		; Interrupt Priority



					; direkt adressierbare Bit
					; im RAM Bereich

IPAUSE:	equ	90H		; selbst          (in der Testphase
AUFBAU:	equ	91H		; definierte       auf den Port 1  
FENSTER:equ	92H		; BIT		   umgelegt)

TR0:	equ	8CH		; BIT in
TR1:	equ	8EH		; TCON

IEX0:	equ	A8H		; 
IET0:	equ	A9H		; 
IEX1:	equ	AAH		;  BIT in IE (Interrupt
IET1:	equ	ABH		; 	Enable)
IES:	equ	ACH		; 
IEA:	equ	AFH		; 

	org	0000H
	NOP
	AJMP    START
	LJMP	INTER0

	org	000BH
	LJMP	TIMER0

	org     0100H

START:	CLR	TR0
	CLR	TR1
	CLR	IEA
	CLR	IES
	CLR	IEX1	
	CLR	IET1			; Interruptbedingungen setzen

	CLR	A
	MOV	IP,A			; Interruptpriorityregister
					; loeschen
	MOV	FLANKE, A		; Flanke:=0
	MOV	ACOUNT, A		; Aufbau:=0
	SETB	IPAUSE
	SETB	AUFBAU
	CLR	FENSTER
	SETB	IEX0
	SETB	IET0		
	
		


;	*************************************
;	*  I N T E R R U P T S E R V I C E  * 
;	*          R O U T I N E N          *
;	*************************************


INTER0:	JB	IPAUSE, FSLOPE
	CLR	TR0			; STOP Timer 0
	CLR	C
	MOV	R1, FDIST		; untere Grenze laden
	MOV	7FH, TL0		; Vergleichswert laden
	MOV	R0, #FFH		; obere Grenze uninteressant
	ACALL   FENDISK			; Fensterdiskriminator aufrufen
	JB	FENSTER, SLOCOR		; Wenn das Bit "Fenster" gesetzt
					; ist, dann bedeutet das, da eine
					; korrekte Flanke erkannt wurde
	SETB	TR0			; START Timer 0
	SJMP    RETURN

SLOCOR: MOV	A, DATT0
	MOV	TL0, A			; neue Zeitkonstante laden
	SETB	TR0			; START Timer 0
	JB	AUFBAU, APHASE		; Kontrolle ob in Aufbauphase
	INC	FLANKE			; Flanke:=Flanke+1
	MOV     ACOUNT, #3		; Aufbau:=3
	SJMP	RETURN

APHASE: MOV	A,#3
	CJNE	A, ACOUNT, APCONT	; Aufbau=3?

	INC 	FLANKE			; Flanke:=Flanke+1
	CLR	AUFBAU
	SJMP	RETURN

APCONT: INC	ACOUNT			; Aufbau:=Aufbau+1
	SJMP	RETURN

FSLOPE: JB	TR1, BITCOR
	MOV	R0, TRMAX		; Grenzen fr das Trennzeichen
	MOV	R1, TRMIN		; laden
	MOV	7FH, TL1		; Timer 1 Zeit laden
	ACALL	FENDISK			; Fensterdiskriminator aufrufen
	JB	FENSTER, BITCOR

	MOV	R0, LOWMAX		; Grenzen fr die logische
	MOV	R1, LOWMIN		; 0 laden
	MOV	7FH, TL1		
	ACALL	FENDISK			; Fensterdiskriminator aufrufen
	JB	FENSTER, BITCOR

	MOV	R0, HIMAX		; Grenzen fr die logische
	MOV	R1, HIMIN		; 1 laden
	MOV	7FH, TL1
	ACALL	FENDISK			; Fensterdiskriminator aufrufen
	JB	FENSTER, BITCOR

	SJMP	RETURN

BITCOR: MOV	ACOUNT, #1		; Aufbau:=1
	SETB	AUFBAU
	CLR	IPAUSE
	MOV	FLANKE, #0		; Flanke:=0
	MOV 	A, DATT0
	MOV	TL0, A			; neue Zeitkonstante laden
	SETB	TR0

RETURN: RETI


	
TIMER0:



;	*******************************
;	*  U N T E R P R O G A M M E  *
;	*******************************

FENDISK:				; R0  obere  
					; R1  untere  Grenze
					; 7FH zu diskriminierender Wert
	CLR	FENSTER
	MOV	A, R0
	CLR	C
	SUBB	A, 7FH
	JC	BACK
	
	MOV	A, 7FH
	CLR	C
	SUBB	A, R1
	JC	BACK

	SETB	FENSTER

BACK:	RET

	end
