
/****************************************************************************/
/*    8051 C COMPILER SPECIAL FUNCTION REGISTER DECLARATIONS                */
/****************************************************************************/


extern  char  ACC; 	/* power control                            */
extern  char  B;  	/* power control                            */
extern  char  SP; 	/* power control                            */
extern  char  DPL;	/* power control                            */
extern  char  DPH;	/* power control                            */
extern  char  PSW;        /* program status word                      */

extern  char  P0;		/* port 0                                   */
extern  char  P1;		/* port 1                                   */
extern  char  P2;		/* port 2                                   */
extern  char  P3;		/* port 3                                   */
extern  char  P4;		/* port 4                                   */
extern  char  P5;		/* port 5                                   */
extern  char  ADCON;	/* ADC control                              */
extern  char  ADCH;	/* ADC high                                 */
extern  char  S0CON;	/* serial control                           */
extern  char  S0BUF;	/* serial buffer                            */
extern  char  TMOD;	/* timer mode                               */
extern  char  TCON;	/* timer control                            */
extern  char  PCON;	/* power control                            */
extern  char  TM2CON;	/* timer 2 control                          */
extern  char  CTCON;	/* capture control                          */

extern  char  S1CON;      /* serial 1 contorl                         */
extern  char  S1STA;      /* serial 1 status                          */
extern  char  S1DAT;      /* serial 1 data                            */
extern  char  S1ADR;      /* serial 1 address                         */

extern  char  TL0;	/* timer 0 low byte                         */
extern  char  TH0;	/* timer 0 high byte                        */
extern  char  TL1;	/* timer 1 low byte                         */
extern  char  TH1;	/* timer 1 high byte                        */
extern  char  TML2;	/* timer 2 low byte                         */
extern  char  TMH2;	/* timer 2 high byte                        */
extern  char  T3; 	/* timer 3                                  */

extern  char  IP0;	/* interrupt priority control               */
extern  char  IP1;	/* interrupt priority control               */
extern  char  IEN0;	/* interrupt enable control                 */
extern  char  IEN1;	/* interrupt enable control                 */
extern  char  TM2IR;      /* timer 2 inerrupt flags                   */
extern  char  STE;        /* set enable                               */
extern  char  RTE;        /* reset/toggle enable                      */

extern  char  PWMP;       /* PWM prescaler                            */
extern  char  PWM0;       /* PWM 0                                    */
extern  char  PWM1;       /* PWM 1                                    */

extern  char  SIGNAL;
extern  char  T2_OLD;

/****************************************************************************/
/*    8051 C COMPILER SPECIAL FUNCTION BIT DECLARATIONS                     */
/****************************************************************************/

struct special_function_bits
{                               /*   Bit Name                     Bit Value */

/* P0  (Port 0)                                                             */

unsigned int P0_0   : 1;	/* port 0, bit 0                        80h */
unsigned int P0_1   : 1;	/* port 0, bit 1                        81h */
unsigned int P0_2   : 1;	/* port 0, bit 2                        82h */
unsigned int P0_3   : 1;	/* port 0, bit 3                        83h */
unsigned int P0_4   : 1;	/* port 0, bit 4                        84h */
unsigned int P0_5   : 1;	/* port 0, bit 5                        85h */
unsigned int P0_6   : 1;	/* port 0, bit 6                        86h */
unsigned int P0_7   : 1;	/* port 0, bit 7                        87h */

/* TCON  (Timer Control)                                                    */

unsigned int IT0    : 1;	/* input INT0/ transition activated     88h */
unsigned int IE0    : 1;	/* external interrupt request flag 0    89h */
unsigned int IT1    : 1;	/* input INT1/ transition activated     8ah */
unsigned int IE1    : 1;	/* external interrupt request flag 1    8bh */
unsigned int TR0    : 1;	/* counter 0 enable/disable             8ch */
unsigned int TF0    : 1;	/* counter 0 interrupt req & overflow   8dh */
unsigned int TR1    : 1;	/* counter 1 enable/disable             8eh */
unsigned int TF1    : 1;	/* counter 1 interrupt req & overflow   8fh */

/* P1  (Port 1)                                                             */

unsigned int P1_0   : 1;	/* port 1, bit 0                        90h */
unsigned int P1_1   : 1;	/* port 1, bit 1                        91h */
unsigned int P1_2   : 1;	/* port 1, bit 2                        92h */
unsigned int P1_3   : 1;	/* port 1, bit 3                        93h */
unsigned int P1_4   : 1;	/* port 1, bit 4                        94h */
unsigned int P1_5   : 1;	/* port 1, bit 5                        95h */
unsigned int P1_6   : 1;	/* port 1, bit 6                        96h */
unsigned int P1_7   : 1;	/* port 1, bit 7                        97h */

/* SCON   (Serial Port Control)                                             */

unsigned int RI     : 1;	/* reception complete interrupt flag    98h */
unsigned int TI     : 1;	/* transmission complete interrupt flag 99h */
unsigned int RB8    : 1;	/* received data bit 8                  9ah */
unsigned int TB8    : 1;	/* transmitter data bit 8               9bh */
unsigned int REN    : 1;	/* receiver enable                      9ch */
unsigned int SM2    : 1;	/* conditional receiver enable          9dh */
unsigned int SM1    : 1;	/* serial port operation mode lsb       9eh */
unsigned int SM0    : 1;	/* serial port operation mode msb       9fh */

/* P2   (Port 2)                                                            */

unsigned int P2_0   : 1;	/* port 2, bit 0                        a0h */
unsigned int P2_1   : 1;	/* port 2, bit 1                        a1h */
unsigned int P2_2   : 1;	/* port 2, bit 2                        a2h */
unsigned int P2_3   : 1;	/* port 2, bit 3                        a3h */
unsigned int P2_4   : 1;	/* port 2, bit 4                        a4h */
unsigned int P2_5   : 1;	/* port 2, bit 5                        a5h */
unsigned int P2_6   : 1;	/* port 2, bit 6                        a6h */
unsigned int P2_7   : 1;	/* port 2, bit 7                        a7h */

/* IE   (Interrupt Enable)                                                  */

unsigned int EX0    : 1;	/* external request 0                   a8h */
unsigned int ET0    : 1;	/* internal timer/counter 0             a9h */
unsigned int EX1    : 1;	/* external request 1                   aah */
unsigned int ET1    : 1;	/* internal timer/counter 1             abh */
unsigned int ES     : 1;	/* internal serial port                 ach */
unsigned int IE_5   : 1;	/* reserved                             adh */
unsigned int IE_6   : 1;	/* reserved                             aeh */
unsigned int EA     : 1;	/* enable all                           afh */

/* P3   (Port 3)                                                            */

unsigned int P3_0   : 1;	/* port 3, bit 0                        b0h */
unsigned int P3_1   : 1;	/* port 3, bit 1                        b1h */
unsigned int P3_2   : 1;	/* port 3, bit 2                        b2h */
unsigned int P3_3   : 1;	/* port 3, bit 3                        b3h */
unsigned int P3_4   : 1;	/* port 3, bit 4                        b4h */
unsigned int P3_5   : 1;	/* port 3, bit 5                        b5h */
unsigned int P3_6   : 1;	/* port 3, bit 6                        b6h */
unsigned int P3_7   : 1;	/* port 3, bit 7                        b7h */

/* IP   (Interrupt Priority)                                                */

unsigned int PX0    : 1;	/* external request 0                   b8h */
unsigned int PT0    : 1;	/* internal timer/counter 0             b9h */
unsigned int PX1    : 1;	/* external request 1                   bah */
unsigned int PT1    : 1;	/* internal timer/counter 1             bbh */
unsigned int PS     : 1;	/* internal serial port                 bch */
unsigned int IP_5   : 1;	/* reserved                             bdh */
unsigned int IP_6   : 1;	/* reserved                             beh */
unsigned int IP_7   : 1;	/* reserved                             bfh */

/*      (Unimplemented)                                                     */

unsigned int C0H    : 1;	/* unimplemented                        c0h */
unsigned int C1H    : 1;	/* unimplemented                        c1h */
unsigned int C2H    : 1;	/* unimplemented                        c2h */
unsigned int C3H    : 1;	/* unimplemented                        c3h */
unsigned int C4H    : 1;	/* unimplemented                        c4h */
unsigned int C5H    : 1;	/* unimplemented                        c5h */
unsigned int C6H    : 1;	/* unimplemented                        c6h */
unsigned int C7H    : 1;	/* unimplemented                        c7h */

/*      (Unimplemented)                                                     */

unsigned int C8H    : 1;	/* unimplemented                        c8h */
unsigned int C9H    : 1;	/* unimplemented                        c9h */
unsigned int CAH    : 1;	/* unimplemented                        cah */
unsigned int CBH    : 1;	/* unimplemented                        cbh */
unsigned int CCH    : 1;	/* unimplemented                        cch */
unsigned int CDH    : 1;	/* unimplemented                        cdh */
unsigned int CEH    : 1;	/* unimplemented                        ceh */
unsigned int CFH    : 1;	/* unimplemented                        cfh */

/* PSW  (Processor Status Register)                                         */

unsigned int P      : 1;	/* parity                               d0h */
unsigned int PSW_1  : 1;	/* reserved                             d1h */
unsigned int OV     : 1;	/* overflow                             d2h */
unsigned int RS0    : 1;	/* register bank select 0               d3h */
unsigned int RS1    : 1;	/* register bank select 1               d4h */
unsigned int F0     : 1;	/* user flag 0                          d5h */
unsigned int AC     : 1;	/* auxiliary carry                      d6h */
unsigned int CY     : 1;	/* carry                                d7h */

/*      (Unimplemented)                                                     */

unsigned int D8H    : 1;	/* unimplemented                        d8h */
unsigned int D9H    : 1;	/* unimplemented                        d9h */
unsigned int DAH    : 1;	/* unimplemented                        dah */
unsigned int DBH    : 1;	/* unimplemented                        dbh */
unsigned int DCH    : 1;	/* unimplemented                        dch */
unsigned int DDH    : 1;	/* unimplemented                        ddh */
unsigned int DEH    : 1;	/* unimplemented                        deh */
unsigned int DFH    : 1;	/* unimplemented                        dfh */

/* ACC   (Accumulator)                                                      */

unsigned int ACC_0  : 1;	/* accumulator bit 0                    e0h */
unsigned int ACC_1  : 1;	/* accumulator bit 1                    e1h */
unsigned int ACC_2  : 1;	/* accumulator bit 2                    e2h */
unsigned int ACC_3  : 1;	/* accumulator bit 3                    e3h */
unsigned int ACC_4  : 1;	/* accumulator bit 4                    e4h */
unsigned int ACC_5  : 1;	/* accumulator bit 5                    e5h */
unsigned int ACC_6  : 1;	/* accumulator bit 6                    e6h */
unsigned int ACC_7  : 1;	/* accumulator bit 7                    e7h */

/*      (Unimplemented)                                                     */

unsigned int E8H    : 1;	/* unimplemented                        e8h */
unsigned int E9H    : 1;	/* unimplemented                        e9h */
unsigned int EAH    : 1;	/* unimplemented                        eah */
unsigned int EBH    : 1;	/* unimplemented                        ebh */
unsigned int ECH    : 1;	/* unimplemented                        ech */
unsigned int EDH    : 1;	/* unimplemented                        edh */
unsigned int EEH    : 1;	/* unimplemented                        eeh */
unsigned int EFH    : 1;	/* unimplemented                        efh */

/* B   (B Register)                                                         */

unsigned int B_0    : 1;	/* unimplemented                        f0h */
unsigned int B_1    : 1;	/* unimplemented                        f1h */
unsigned int B_2    : 1;	/* unimplemented                        f2h */
unsigned int B_3    : 1;	/* unimplemented                        f3h */
unsigned int B_4    : 1;	/* unimplemented                        f4h */
unsigned int B_5    : 1;	/* unimplemented                        f5h */
unsigned int B_6    : 1;	/* unimplemented                        f6h */
unsigned int B_7    : 1;	/* unimplemented                        f7h */

/*      (Unimplemented)                                                     */

unsigned int F8H    : 1;	/* unimplemented                        f8h */
unsigned int F9H    : 1;	/* unimplemented                        f9h */
unsigned int FAH    : 1;	/* unimplemented                        fah */
unsigned int FBH    : 1;	/* unimplemented                        fbh */
unsigned int FCH    : 1;	/* unimplemented                        fch */
unsigned int FDH    : 1;	/* unimplemented                        fdh */
unsigned int FEH    : 1;	/* unimplemented                        feh */
unsigned int FFH    : 1;	/* unimplemented                        ffh */

};



