.TITLE  Hauptmodul 
                   ;Name erscheint am Kopf
                   ;jeder Seite des Ausdrucks  
.COMMENT ;Beispiel eines bergeordneten Moduls 
MOD_AB,z.Bsp. eines Hauptprogrammes, das von einem
Modul MOD_A Daten bekommt und an ein Modul
MOD_B zur weiteren Bearbeitung bergibt.Die 
untergeordneten Module werden ber CALL aufgerufen.
VERSION X8051
===================================================;

;.MODULE  Mod_AB   ;Modulbestimmung fr die
                   ;Verwendung in "Librarian"-
                   ;Bibliothekverwaltungsprg.
;**********************************************
        DATA       ;Datenbereich 
        ORG 50H    ;Start ab 50H, weitere
                   ;Offset kann beim Linken
                   ;angegeben werden
Status: DS 1       ;1 Byte reserviert fr
                   ;lokalen Parameter  
;**********************************************
DatXSeg SECTION    ;selbstdef. Speicherbereich
                   ;hier Daten, eingebettet in den 
                   ;vordefinierten Bereich "DATA"
.PUBLIC xdat_AB     ;Diese Daten werden in Mod_AB
                   ;definiert, die Offset 0C000H
                   ;wird beim Linken angegeben 
xdat_AB:DS 10     ;Reservierung fr 10 Bytes
.EXTERN  xdat_A    ;Diese Daten werden im Mod_A
                  ;definiert (ext.Speicher)
        ENDS      ;Ende des selbstdef. Speicher-
                  ;bereiches
;**********************************************
        CODE      ;vordef. Bereich fr Befehle
.EXTERN  Mod_A,Mod_B
                  ;Adressen von Mod_A u. Mod_B
;**********************************************
        ORG 30H           ;Start nach den Inter-
                          ;ruptvektoren
Mod_AB: CALL Mod_A        ;Aufruf von Mod_A
        MOV B,#10         ;Schleifenzhler
Weiter: MOV DPTR,#xdat_A  ;Zeiger auf Daten
                          ;von Mod_A
        MOVX A,@DPTR      ;Daten ber Akku..
        MOV DPTR,#xdat_AB ;Zeiger auf Daten
                          ;von Mod_AB
        MOVX  @DPTR,A     ;..nach xdat_AB 
        DJNZ B,Weiter     ;10 Bytes
        CALL Mod_B        ;Aufruf von Mod_B
        MOV  <Status,#0ffH ;auf Addresse Status
                          ;wird 1 Byte geladen
                          ;Selber Name, aber 
                          ;andere Adresse als in
                          ;Mod_B
 ;      ENDMOD
        END  