/***************************************************************************/
/*                                                                         */
/*     INTEL 8051 LINKER MAP TO AVOCET AVSIM51 SYMBOL FORMAT CONVERTER     */
/*                                                                         */
/*                  (c) 1991 by W.MURTH (VIENNA/AUSTRIA)                   */
/*                                                                         */
/*                        VERSION 1.31                                     */
/*                                                                         */
/*      Compiler: MICROSOFT C 5.1, PDS 6.0                                 */
/*                MICROSOFT QUICKC 2.0, 2.5                                */
/*                BORLAND   C 2.0                                          */
/*                                                                         */
/*                                                                         */
/* Revision History:                                                       */
/*    1.0 : Erste Testversion                                              */
/*    1.3 : Erste freigegebene Version (mit DOC File!!!)                   */
/*             +Welcome Screen                                             */
/*             +SFR Erkennung                                              */
/*             +Report Option                                              */
/*                                                                         */
/*    1.31: Erste verffentlichte Version (ebenfalls mit DOC File)         */
/*             +SFR Erkennung verbessert                                   */
/*             +DISK FULL Erkennung                                        */
/*             .BORLAND C2.0 angepasst                                     */
/*             .CODE entrmpelt                                            */
/*                                                                         */
/*                                                                         */
/*                                                                         */
/*    Sonstiges:                                                           */
/*        Optimierung mglich durch komplettes Einlesen der .M51 Datei     */
/*         und darauffolgendes Schreiben der Symboldatei, statt            */
/*         alternierender Zugriff. (80 Segmente und Symbole bentigten     */
/*         beim Testlauf auf Harddisk (120Mb., 15ms) 0.44s, auf            */
/*         3.5" Laufwerk 8.5 Sekunden und auf 5.25" Laufwerk 5.7 Sekunden) */
/*         Diese Werte sind aber nur als nherungsweise Gre zu           */
/*         betrachten                                                      */
/*                                                                         */
/*        TAB-Abstand fr Drucker : 3                                      */
/*                                                                         */
/*         INTEL, MCS-51 sind eingetragene Warenzeichen der                */
/*           INTEL Corporation                                             */
/*         AVSIM51 ist ein eingetragenes Warenzeichen der                  */
/*           AVOCET SYSTEMS INC.                                           */
/*                                                                         */
/*                                                                         */
/*        Dieses Programm ist im Sinne der Public Domain Software zu       */
/*        verstehen. Es kann beliebig vervielfltigt und weitergegeben     */
/*        werden. Es besteht dabei die Auflage auch die Dokumentations-    */
/*        datei und die Sourcedatei mitzukopieren.                         */
/*                                                                         */
/*                                                                         */
/***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#if defined __TURBOC__
	#include <dir.h>
#endif


#define FALSE 0
#define TRUE  1

#define SYMADDR   2
#define SEGSTART 20
#define SEGEND   30
#define SYMNAME  30
#define BITSTART 26
#define BITEND   36
#define SEGNAME  53


/* Bei Microsoft besteht bei den drei verwendeten Compilern ein kleines
   Durcheinander bei der Versionserkennung. Folgende Definitionen gibt es:

    Compiler	   _MSC_VER    _QC
	 --------------------------------
	 QuickC 2.0      nein      ja
	 QuickC 2.5      ja        ja
	 PDS 6.0         ja        nein

   Um nun sowohl den QuickC Compiler, als auch PDS 6.0 verwenden zu knnen,
   wird bei Erkennen der Konstante _MSC_VER, bei nichtdefiniertem _QC,
   _QC definert. */


#if defined _MSC_VER
    #ifndef _QC
       #define _QC
    #endif
#endif



int dodataseg  ( void );         /* Verarbeitung der Segmentnamen */
int dosymbols  ( void );         /* Verarbeitung der Symbolnamen */

FILE *fin;                       /* Eingabekanal */
FILE *fout;                      /* Ausgabekanal */
int   report;                    /* TRUE wenn Reportoption erwnscht */


int main(int argc, char *argv[])
{

	char buffer[100];                   /* Input Buffer fr Dateneinlesen */


	#if defined _QC
		char file_in[_MAX_PATH];            /* Dateiname und Pfad der Eingabedatei */
		char file_out[_MAX_PATH];           /* Dateiname und Pfad der Ausgabedatei */

		char laufw[_MAX_DRIVE];             /* Laufwerk */
		char verz[_MAX_DIR];                /* Verzeichnis */
		char dname[_MAX_FNAME];             /* Filename */
		char erw[_MAX_EXT];                 /* Extension */
	 #elif defined __TURBOC__
		char file_in[MAXPATH];              /* Dateiname und Pfad der Eingabedatei */
		char file_out[MAXPATH];             /* Dateiname und Pfad der Ausgabedatei */

		char laufw[MAXDRIVE];               /* Laufwerk */
		char verz[MAXDIR];                  /* Verzeichnis */
		char dname[MAXFILE];                /* Filename */
		char erw[MAXEXT];                   /* Extension */
	#endif


	int  header;                        /* TRUE bei Daten vor Segmenteinteilung */
	int  fault;                         /* TRUE wenn Speichermedium voll */


	printf("\n\nINTEL 8051 LINKER MAP TO AVOCET AVSIM51 SYMBOL FORMAT CONVERTER\n");
	printf("       (c) 1991 by W.MURTH   VERSION 1.31\n\n");
	printf(" You can copy this program freely without any restrictions\n");
	printf(" Kopieren ohne Einschrnkungen erlaubt\n");
	printf("  WARNING: Source must have at least one label\n");
	printf("  ACHTUNG: Quelltext mu mindestens ein Label enthalten\n");

	/* berprfe Kommandozeilenparameter */

	if(argc <2)
	{
		printf("INVALID COMMAND LINE OPTION\n SYNTAX: MAP2SYM [d:]sourcefile[.m51] </r>\n");
		return(99);
	}

	/* Erzeuge Ein- und Ausgabedateinamen */


	#if defined _QC
		_splitpath(argv[1],laufw,verz,dname,erw);
		strcpy(erw,".M51");
		_makepath(file_in,laufw,verz,dname,erw);

		strcpy(erw,".SYM");
		_makepath(file_out,laufw,verz,dname,erw);
	 #elif defined __TURBOC__
		fnsplit(argv[1],laufw,verz,dname,erw);
		strcpy(erw,".M51");
		fnmerge(file_in,laufw,verz,dname,erw);

		strcpy(erw,".SYM");
		fnmerge(file_out,laufw,verz,dname,erw);
	#endif


	/* Teste ob ein Report erwnscht ist */

	report=FALSE;
	if(argc==3)
		if( (strcmp(argv[2],"/r")==0) || (strcmp(argv[2],"/R")==0) )
			report=TRUE;



	/* ffne Eingabedatei */

	if( (fin= fopen(file_in,"r")) == NULL )
	{
		printf("SOURCEFILE NOT FOUND\n PROGRAM HALTED\n");
		return(100);
	}

	/* ffne Ausgabedatei */

	fout = fopen(file_out,"w");

	header = TRUE;

	/* berlies die ersten Zeilen bis zur Segmenteinteilung */

	while(header==TRUE)
	{
		fgets(buffer,99,fin);
		if(buffer[12]== '-')
			header=FALSE;

	}


	fault=FALSE;

	/* Verarbeite Segmenteinteilung und Symboltabelle*/

	while( (fgets(buffer,99,fin) != NULL) && (!fault) )
	{
		fault=FALSE;

		if(buffer[0] != '\n')
		{
			if( (strncmp(&buffer[28],"D A T A",7)==0) )
			{
				if(report)
					printf("PROCESSING DATA SEGMENT\n");
				fault=dodataseg();
			}
			if( (strncmp(&buffer[27],"X D A T A",9)==0))
			{
				if(report)
					printf("PROCESSING XDATA SEGMENT\n");
				fault=dodataseg();
			}
			if( (strncmp(&buffer[28],"C O D E",7)==0))
			{
				if(report)
					printf("PROCESSING CODE SEGMENT\n");
				fault=dodataseg();
			}
			if( (buffer[0]  == '-'))
			{
				if(report)
					printf("PROCESSING SYMBOLS\n");
				fault=dosymbols();
			}
		}

	}

	/* Schliee Ein- und Ausgabedatei */

	fclose(fin);
	fclose(fout);

}


int dodataseg()
{
	char buffer[100];        /* Eingabebuffer */
	char outbuf[100];        /* Ausgabebuffer */
	int  segstart;           /* Segment Startadresse */
	int  segend;             /* Segment Endadresse */
	int  bitstart;           /* Bitsegment start */
	int  bitend;             /* Bitsegment Ende */
	int  datacount;          /* Zhler fr unbenannte Datensegmente */
	int  bitcount;           /* Zhler fr unbenannte Bitsegmente */
	int  xdatacount;         /* Zhler fr unbenannte externe Datensegmente */
	int  codecount;          /* Zhler fr unbenannte Codesegmente */

	int  pcount;             /* Anzahl der auf Disk geschriebenen Zeichen */
	int  print;              /* TRUE wenn ausgabe auf disk erfolgen soll */


	/* Setze Zhler fr unbenannte Segmente zurck */

	datacount =0;
	bitcount  =0;
	xdatacount=0;
	codecount =0;


	/* Wiederhole Schleife solange bis Leerzeile in der Quelldatei erkannt
		wird. */

	do
	{
		print=FALSE;

		fgets( buffer,99,fin);

		/* buffer[12] enthlt den ersten Buchstaben des Segmenttyps */

		if( ((strncmp(&buffer[12],"DATA" ,4)==0) ||
			  (strncmp(&buffer[12],"XDATA",5)==0) ||
			  (strncmp(&buffer[12],"CODE" ,4)==0)) && (buffer[0]!='\n') )
		{

			print=TRUE;
			/* lies Segmentanfang und -ende aus Buffer */

			sscanf(buffer+SEGSTART,"%x",&segstart);
			sscanf(buffer+SEGEND,"%x",&segend);

			/* Teste ob Segment benannt wurde, wenn ja dann ist der
				Eingabestring grer als 54 Zeichen */

			if( strlen(buffer)<55)
				{

					/* Segment wurde nicht benannt, daher nimm Defaultnamen
						und hnge laufende Nummer an. */


					switch(buffer[12])
					{
						case 'D':
									sprintf(outbuf,"SG DATA%i D:%4X %4X",datacount,segstart,segstart+segend-1);
									datacount++;
									break;
						case 'X':
									sprintf(outbuf,"SG XDATA%i X:%4X %4X",xdatacount,segstart,segstart+segend-1);
									xdatacount++;
									break;
						case 'C':
									sprintf(outbuf,"SG CODE%i C:%4X %4X",codecount,segstart,segstart+segend-1);
									codecount++;
									break;
					}
				}
			 else
				{
					/* Das Segment wurde benannt.
						Schreibe zuerst Segmentnamen in Ausgangsbuffer, dann erst
						Segmentstart und -lnge. Dies ist notwendig um das
						abschlieende '\n' nach dem Segmentnamen zu berschreiben.*/

					sprintf(outbuf,"SG %s",buffer+SEGNAME);

					switch(buffer[12])
					{
						case 'D':
									sprintf(outbuf+strlen(outbuf)-1," D:%4X %4X",segstart,segstart+segend-1);
									break;
						case 'X':
									sprintf(outbuf+strlen(outbuf)-1," X:%4X %4X",segstart,segstart+segend-1);
									break;
						case 'C':
									sprintf(outbuf+strlen(outbuf)-1," C:%4X %4X",segstart,segstart+segend-1);
									break;
					}
				}

		}

		if( strncmp(&buffer[12],"BIT",3)==0)  /* check if label is not a GAP area */
		{
			print=TRUE;

			sscanf(buffer+SEGSTART,"%x",&segstart);
			sscanf(buffer+SEGEND  ,"%x",&segend);
			sscanf(buffer+BITSTART,"%i",&bitstart);
			sscanf(buffer+BITEND  ,"%i",&bitend);


			/* Berechne Start- und Endaddresse des Bitsegmentes.
				Da der Bitbereich beim 8051 erst bei 20h anfngt, mu dieser Wert
				von der Byteadresse abgezogen werden.
				Hier erfolgt die Umrechnung der INTEL Darstellung von Byte.Bit in
				die AVOCET Darstellung Bit. Z.B. INTEL-Adresse 21H.1
				entspricht AVOCET Adresse 09H */

			segstart = (segstart-0x20)*8+bitstart;
			segend   = segstart+segend*8+bitend-1;

			/* Teste ob Segment benannt wurde, wenn ja dann ist der
				Eingabestring grer als 54 Zeichen */

			if( strlen(buffer)<55)
				{
					/* Segment wurde nicht benannt, daher nimm Defaultnamen BIT
						und hnge laufende Nummer an. */

					sprintf(outbuf,"SG BIT%i B:%4X %4X",bitcount,segstart,segend);
					bitcount++;
				}
			 else
				{

					/* Das Segment wurde benannt.
						Schreibe zuerst Segmentnamen in Ausgangsbuffer, dann erst
						Segmentstart und -lnge. Dies ist notwendig um das
						abschlieende '\n' nach dem Segmentnamen zu berschreiben.*/

					sprintf(outbuf,"SG %s",buffer+SEGNAME);
					sprintf(outbuf+strlen(outbuf)-1," B:%4X %4X",segstart,segend);

				}
		}

		if(print)
		{

			/* Schreibe Ausgangsbuffer auf Disk */

			pcount=fprintf(fout,"%s\n",outbuf);
			if(report)
				printf("   %s                \r",outbuf);


			/* Teste ob die Anzahl der geschriebene Zeichen, mit der des
				Ausgabebuffers bereinstimmt. Wenn nicht, ist kein Platz mehr am
				Zielmedium. Daher Fehler melden und Konvertierung beenden.
				(pcount -1) wegen abschlieendem Carriage Return!! */

			if((pcount-1) != strlen(outbuf))
			{
				printf("\nDISK FULL - MAP2SYM HALTED \n");
				return(TRUE);
			}
		}

	}while(buffer[0] != '\n');
	printf("\n");

	return(FALSE);
}


int dosymbols(void)
{
	char buffer[100];        /* Eingabebuffer */
	char outbuf[100];        /* Ausgabebuffer */
	int  saddr;              /* Symboladresse */
	int  sbit;               /* Bitnummer */
	char stype;              /* Symbolart (B, C, D, X) */
	char sname[20];          /* Symbolname */
	int  systemsym;          /* TRUE wenn Symbol von INTEL oder AVOCET
										 definiert ist. */
	int  pcount;             /* Anzahl der auf Disk geschriebenen Zeichen */


	/* Solange Daten einlesen bis Datei zu Ende ist */

	while( fgets(buffer,99,fin) != NULL)
	{
		/* teste ob SYMBOL oder PUBLIC vorliegt */

		if( (buffer[1]==':') && ((buffer[17]=='Y') || (buffer[16]=='P')) )
		{
			stype = buffer[0];                  /* Merke Symbolart */
			sscanf(buffer+SYMADDR,"%x",&saddr); /* lies Symboladresse */
			sscanf(buffer+SYMNAME,"%s",sname);  /* lies Symbolname */

			systemsym = FALSE;

			/* Teste ob Symbol im SFR Bereich liegt, d.h. von Intel bereits
				definiert ist.
				Ausnahmen bei Byteadressen:
								80H   Port0
								90H   Port1
								A0H   Port2
								B0H   Port3

				Ausnahmen bei Bitadressen:
								80H   Port0
								90H   Port1
								A0H   Port2
								B0H   Port3
								E0H   Akkumulator
								F0H   B Register
								*/

			if( ((stype=='D') &&
					 ((saddr >0x80)&&(saddr!=0x90)&&(saddr!=0xA0)&&(saddr!=0xB0)) ) ||
				 ((stype=='B') &&
					 ((saddr> 0x80)&&(saddr!=0x90)&&(saddr!=0xA0)&&(saddr!=0xB0)&&
					  (saddr!=0xE0)&&(saddr!=0xF0))                               ) )
				systemsym=TRUE;


			if(!systemsym)
			{
				if(stype=='B')
				{

					/* Symbol liegt im Bitadressbereich */

					sscanf(buffer+8,"%i",&sbit);  /* hole Bitnummer */

					/* Teste ob Bit im SFR Bereich liegt */

					if(saddr<0x80)
						saddr=(saddr-0x20)*8+sbit;
					 else
						saddr=saddr+sbit;
				}

				sprintf(outbuf,"AS %s %c:%04X",sname,stype,saddr);

				pcount=fprintf(fout,"%s\n",outbuf);

				if(report)
					printf("   %s                \r",sname);

				/* Teste ob die Anzahl der geschriebene Zeichen, mit der des
					Ausgabebuffers bereinstimmt. Wenn nicht, ist kein Platz mehr am
					Zielmedium. Daher Fehler melden und Konvertierung beenden.
					(pcount -1) wegen abschlieendem Carriage Return!! */

				if((pcount-1) != strlen(outbuf))
				{
					printf("\nDISK FULL - MAP2SYM HALTED \n");
					return(TRUE);
				}

			}


		}


	}

	printf("\n");

	return(FALSE);
}
