#include <stdio.h>
#include <conio.h>
#include <dos.h>

unsigned char ega=0;

				/* Makro zur Definition eines Far-Zeigers, */
#ifndef MK_FP                              /* existiert in Turbo C bereits */
#define MK_FP(seg,ofs) ((void far *) (((unsigned long) (seg) << 16) \
		       | (unsigned) (ofs)))
#endif
union REGS reg;                              /* Fr die Prozessor-Register */
unsigned char AktuelleSeite;
char far* VideoRam=MK_FP(0x0a000,0);               /* Zeiger auf Video-RAM */

void SetzePageBit(Bit)
/* --------------------------------------------------------------------------
   Setzt das Page-Bit in einen 0- oder 1-Zustand. Als Parameter sind die
   Werte 0 oder 1 zulssig
   --------------------------------------------------------------------------
*/
unsigned char Bit;
{
 if (ega==0)                                          /* Ist es VGA-Karte? */
 {
  if (Bit==0)                                               /* Bit lschen */
     outp(0x3c2,(inp(0x3cc) & 0x0df));        /* lesen, lschen, schreiben */
  else                                                       /* Bit setzen */
     outp(0x3c2,(inp(0x3cc) | 0x20));          /* lesen, setzen, schreiben */
 }
 else                                                         /* EGA-Karte */
 {
  if (Bit==0)                                               /* Bit lschen */
     outp(0x3c2,0x87);                                   /* Wert schreiben */
  else                                                       /* Bit setzen */
     outp(0x3c2,0x0a7);                                  /* Wert schreiben */
 }
}

void ModusSetzen()
/* --------------------------------------------------------------------------
   Textmodus 03h setzen und Bildschirmspeicher ab A000:0000h mit 64 KByte
   adressieren
   --------------------------------------------------------------------------
*/
{
 reg.x.ax=0x0003;                               /* Funktion 00h, Modus 03h */
 int86(0x10,&reg,&reg);                          /* Interrupt 10h aufrufen */
 outp(0x3ce,6);                                     /* Auf 64 KByte RAM ab */
 outp(0x3cf,6);                                     /* A000:0000h schalten */
 AktuelleSeite=0;
}

void ModusZuruecksetzen()
/* --------------------------------------------------------------------------
   Standard-Textmodus setzen und Bildschirmspeicher ab B800:0000h mit
   32 KByte adressieren
   --------------------------------------------------------------------------
*/
{
 outp(0x3ce,6);                                   /* Auf 32 KByte schalten */
 outp(0x3cf,14);
 reg.x.ax=0x0003;                                      /* Modus 03h setzen */
 int86(0x10,&reg,&reg);
}

void SeiteWaehlen(seite)
/* --------------------------------------------------------------------------
   Eine von 32 Bildschirmseiten whlen und zur Vernderung und Darstellung
   auf dem Bildschirm anzeigen
   --------------------------------------------------------------------------
*/
unsigned char seite;
{
 unsigned int WordOffset;
 AktuelleSeite=seite;                                      /* Seite merken */
 if (seite>15)                            /* Wenn Seite > 15, mu Page-Bit */
    SetzePageBit(0);                                    /* gelscht werden */
 else                                                             /* sonst */
    SetzePageBit(1);                                    /* Page-Bit setzen */
 WordOffset=seite*0x800;                      /* Start der Seite berechnen */
 outp(0x3d4,0x0d);                     /* Start in den CRTC-Reg. eintragen */
 outp(0x3d5,WordOffset & 0x0ff);               /* Low-Byte in Register 0Dh */
 outp(0x3d4,0x0c);
 outp(0x3d5,WordOffset >> 8);                 /* High-Byte in Register 0Ch */
}

void ZeichenSchreiben(x,y,zeichen,attribut)
/* --------------------------------------------------------------------------
   Darstellung eines Zeichens auf der aktuellen Bildschirmseite. bergabe
   der Bildschirmkoordinate mit den Parametern "x" und "y", des Zeichencodes
   mit dem Parameter "zeichen" und des Attributs mit dem Parameter "attribut"
   --------------------------------------------------------------------------
*/
unsigned char x,y,attribut;
char zeichen;
{
 unsigned int Offset;
 Offset=(AktuelleSeite & 0x0f)*0x1000+y*160+(x << 1);  /* Offset berechnen */
 VideoRam[Offset]=zeichen;                            /* Zeichen schreiben */
 VideoRam[Offset+1]=attribut;                        /* Attribut schreiben */
}

void SeitenVollschreiben()
/* --------------------------------------------------------------------------
   Alle 32 Seiten mit Buchstaben vollschreiben, bei 'A' beginnen
   --------------------------------------------------------------------------
*/
{
 unsigned char PageBit,Schreibseite,zcode,x,y;
 unsigned int Offset,Zaehler,Speicherwort;
 zcode='A';                                  /* Erste Seite mit 'A' fllen */
 for (PageBit=0;PageBit<2;PageBit++)           /* Zwei Blcke mit 64 KByte */
 {                            /* Page-Bit setzen, zunchst auf 1, dann auf */
  SetzePageBit(PageBit ^ 1);                  /* 0, daher mit XOR umdrehen */
  for (Schreibseite=0;Schreibseite<16;Schreibseite++)     /* 16 Seiten pro */
  {                                            /* Speicherblock ansprechen */
   AktuelleSeite=PageBit*16+Schreibseite;        /* Seitennummer bestimmen */
   for (y=0;y<25;y++)                                     /* 25 Zeilen mit */
    for (x=0;x<80;x=x+2)                                     /* 80 Spalten */
    {                                                /* mit Zeichen fllen */
     ZeichenSchreiben(x,y,zcode,7);        /* Zuerst aktuellen Buchstaben, */
     ZeichenSchreiben(x+1,y,' ',7);                  /* danach Leerzeichen */
    }
   zcode++;                              /* Neuer Buchstabe fr neue Seite */
   if (zcode>'Z') zcode='0';          /* Wenn Alphabet beendet, weiter mit */
  }                                                     /* Zahlen '0' - .. */
 }
}

void main()
/* --------------------------------------------------------------------------
   Hauptprogramm
   --------------------------------------------------------------------------
*/
{
 unsigned char seite;
 printf("Darstellung von 32 vollgeschriebenen Seiten. Bitte drcken\n");
 printf("Sie fr jede neue Seite eine Taste.");
 while (getch()==0);                                   /* Auf Taste warten */
 ModusSetzen();                                    /* Modus initialisieren */
 SeitenVollschreiben();                              /* Bildschirme fllen */
 for (seite=0;seite<32;seite++)                     /* 32 Seiten der Reihe */
 {                                                      /* nach darstellen */
  SeiteWaehlen(seite);                                     /* Seite whlen */
  while (getch()==0);                                  /* Auf Taste warten */
 }
 ModusZuruecksetzen();                     /* Zurck in Standard-Textmodus */
}
