program vga32;
{----------------------------------------------------------------------------
 Stellt 32 Textseiten auf EGA- und VGA-Karten zur Verfgung
 Autor: Martin Althaus 3/91
 ----------------------------------------------------------------------------
}
 uses crt,dos;
const
 ega=0;                           {Beim Einsatz einer EGA-Karte auf 1 setzen}
var
 register: registers;
 AktuelleSeite, seite:byte;

procedure SetzePageBit(Bit:byte);
{----------------------------------------------------------------------------
 Setzt oder lscht das Page-Bit im Miscellaneous-Output-Register der Grafik-
 karte. bergeben wird der Wert 0 oder 1
 ----------------------------------------------------------------------------
}
begin
 if ega=0                                          {VGA-Karte angeschlossen?}
  then
   if Bit=0 then port[$3c2]:=port[$3cc] and $DF       {ja, nur Bit 5 lschen}
            else port[$3c2]:=port[$3cc] or $20                  {oder setzen}
  else
   if Bit=0 then port[$3c2]:=$87         {keine VGA-Karte, Register komplett}
            else port[$3c2]:=$A7;                             {neu schreiben}
end;

procedure ModusSetzen;
{----------------------------------------------------------------------------
 Setzt Textmodus 03h und vergrert den Bildschirmspeicher auf 64 KByte
 ab A000:0000h
 ----------------------------------------------------------------------------
}
begin
 register.ax:=$0003;                                {Funktion 00h, Modus 03h}
 intr($10,register);                                    {Video-BIOS aufrufen}
 port[$3ce]:=6;                                             {GC-Register 06h}
 port[$3cf]:=6;                                            {Bits 3-2 auf 01b}
 AktuelleSeite:=0;                                {Seitennummer auf 0 setzen}
end;

procedure ModusZuruecksetzen;
{----------------------------------------------------------------------------
 Schaltet in den Standard-Textmodus mit 32 KByte RAm ab B800:0000h
 ----------------------------------------------------------------------------
}
begin
 port[$3ce]:=6;                                             {GC-Register 06h}
 port[$3cf]:=14;                                    {Bits 3-2 auf 11b setzen}
 register.ax:=0003;                                          {Videomodus 03h}
 intr($10,register);                                       {ber BIOS setzen}
end;

procedure SeiteWaehlen(seite:byte);
{----------------------------------------------------------------------------
 Whlt eine der 32 Bildschirmseiten zur Vernderung und Darstellung auf
 dem Bildschirm aus.
 ----------------------------------------------------------------------------
}
var
 WordOffset: word;              {Offset des Darstellungsbeginns im Video-RAM}
begin
 AktuelleSeite:=seite;                              {Gewnschte Seite merken}
 if seite>15 then SetzePageBit(0)                            {RAM einblenden}
             else SetzePageBit(1);
 WordOffset:=seite*$800;                    {RAM-Offset berechnen (in Words)}
 port[$3d4]:=$d;                          {Low-Byte in Register 0Dh des CRTC}
 port[$3d5]:=WordOffset and $ff;
 port[$3d4]:=$c;                         {High-Byte in Register 0Ch des CRTC}
 port[$3d5]:=WordOffset shr 8;
end;

procedure ZeichenSchreiben(x,y:byte;zeichen:char;attribut:byte);
{----------------------------------------------------------------------------
 Auf der aktuellen Bildschirmseite ein Zeichen darstellen. bergeben wird
 die Bildschirmkoordinate mit den Parametern "x" und "y", der Zeichen-Code
 mit dem Parameter "zeichen" und das Attribut mit dem Parameter "attribut"
 ----------------------------------------------------------------------------
}
var
 offset:word;
begin
 offset:=(AktuelleSeite mod 16)*$1000+y*160+(x shl 1);    {Adresse berechnen}
 mem[$a000:offset]:=byte(zeichen);                           {Zeichen setzen}
 mem[$a000:offset+1]:=attribut;                             {Attribut setzen}
end;

procedure SeitenVollschreiben;
{----------------------------------------------------------------------------
 Schreibt alle 32 Speicherseiten mit Buchstaben voll, 'A' auf Seite 1, 'B'
 auf Seite 2 usw.
 ----------------------------------------------------------------------------
}
var
 PageBit,Schreibseite,zcode:byte;
 offset,zaehler,SpeicherWort:word;
begin
 zcode:=byte('A');                         {Beginne mit 'A' auf erster Seite}
 for PageBit:=0 to 1 do                {Zwei Blcke mit 64 KByte durchlaufen}
  begin
   SetzePageBit(PageBit xor 1);             {Page-Bit setzen, erst 1, dann 0}
    for Schreibseite:=0 to 15 do                {16 Seiten pro Speicherblock}
     begin
      Speicherwort:=zcode or $0700;           {Zeichen-Code mit Attribut 07h}
      offset:=Schreibseite*$1000;                {Offset der Bildschirmseite}
      for zaehler:=0 to 999 do                  {1000 x 2 Zeichen darstellen}
       begin
        memw[$a000:offset]:=Speicherwort;                 {Aktuelles Zeichen}
        memw[$a000:offset+2]:=$0720;                   {Dahinter Leerzeichen}
        inc(offset,4);                          {Auf nchste Position zeigen}
       end;                                             {der Bildschirmseite}
      inc(zcode);                                        {nchster Buchstabe}
      if char(zcode)>'Z' then zcode:=byte('0');     {Wenn Alphabet beendet, }
     end;                                               {dann bei '0' weiter}
  end;                                                   {Ende der 16 Seiten}
end;                                                 {Ende der beiden Blcke}

begin
 clrscr;
 writeln('Darstellung von 32 vollgeschriebenen Seiten. Bitte drcken');
 writeln('Sie fr jede neue Seite eine Taste.');
 repeat until readkey<>#0;                                 {Auf Taste warten}
 ModusSetzen;                                          {Modus initialisieren}
 SeitenVollschreiben;                          {Seiten mit Buchstaben fllen}
 for seite:=0 to 31 do                               {Alle Seiten darstellen}
  begin
   SeiteWaehlen(seite);                                   {Auswahl der Seite}
   repeat until readkey<>#0;                               {auf Taste warten}
  end;
 ModusZuruecksetzen;                                {Alten Modus einschalten}
end.
