/* --------------------------------------------------------------------------
   Programm zur Realisierung von 2 Grafikseiten im 320x200-Modus 13h der
   VGA-Karte.
   Autor: Martin Althaus 4/91
   --------------------------------------------------------------------------
*/
#include <stdio.h>
#include <conio.h>
#include <dos.h>

unsigned char AktuellerModus;
unsigned char aufgerufen=0;

				/* Makro zur Definition eines Far-Zeigers, */
#ifndef MK_FP                              /* existiert in Turbo C bereits */
#define MK_FP(seg,ofs) ((void far *) (((unsigned long) (seg) << 16) \
		       | (unsigned) (ofs)))
#endif
union REGS reg;                              /* Fr die Prozessor-Register */
unsigned char AktuelleSeite;
char far* VideoRam=MK_FP(0x0a000,0);               /* Zeiger auf Video-RAM */

void BlendeSeiteEin(Seite)
/* --------------------------------------------------------------------------
   Aktiviert eine von zwei Grafikseiten zur Vernderung im Bildschirmspeicher
   --------------------------------------------------------------------------
*/
unsigned char Seite;
{
  if (Seite==1)                                               /* Bit lschen */
     outp(0x3c2,(inp(0x3cc) & 0x0df));        /* lesen, lschen, schreiben */
  else                                                       /* Bit setzen */
     outp(0x3c2,(inp(0x3cc) | 0x20));          /* lesen, setzen, schreiben */
}

void ZeigeSeite(seite)
/* --------------------------------------------------------------------------
   Stellt eine der zwei Grafikseiten auf dem Bildschirm dar.
   --------------------------------------------------------------------------
*/
unsigned char seite;
{
 unsigned int WordOffset;
 WordOffset=(unsigned int) (seite) << 15;     /* Start der Seite berechnen */
 outp(0x3d4,0x0d);                     /* Start in den CRTC-Reg. eintragen */
 outp(0x3d5,WordOffset & 0x0ff);               /* Low-Byte in Register 0Dh */
 outp(0x3d4,0x0c);
 outp(0x3d5,WordOffset >> 8);                 /* High-Byte in Register 0Ch */
}

void ModusSetzen13h()
/* --------------------------------------------------------------------------
   Setzt Modus 13h und lscht beide Grafikseiten
   --------------------------------------------------------------------------
*/
{
 unsigned int x;
 reg.h.ah=0x0f;                                              /* Modus ber */
 int86(0x10,&reg,&reg);                                   /* BIOS auslesen */
 AktuellerModus=reg.h.al;                               /* und abspeichern */
 aufgerufen=1;                         /* Flag: gespeicherter Modus gltig */
 reg.x.ax=0x0013;                               /* Funktion 00h, Modus 03h */
 int86(0x10,&reg,&reg);                          /* Interrupt 10h aufrufen */
 BlendeSeiteEin(1);                       /* Zweite Grafikseite ansprechen */
 for (x=0;x<0x0ffff;x++)                     /* In einer Schleife gesamtes */
  VideoRam[x]=0;                          /* RAM der zweiten Seite lschen */
 BlendeSeiteEin(0);                              /* Erste Seite einblenden */
}

void ModusZuruecksetzen()
/* --------------------------------------------------------------------------
   Setzt den Videomodus, der vor Einschalten von Modus 13h aktiv war.
   --------------------------------------------------------------------------
*/
{
 if (aufgerufen==1)                          /* gespeicherter Modus gltig */
 {
  reg.h.ah=0;                                                /* Modus ber */
  reg.h.al=AktuellerModus;                                  /* BIOS setzen */
  int86(0x10,&reg,&reg);
  aufgerufen=0;                              /* Modus 13h nicht mehr aktiv */
  BlendeSeiteEin(0);                                 /* Seite 0 einblenden */
 }
}

void PunktSetzen13h(x,y,farbe)
/* --------------------------------------------------------------------------
   Setzt einen Punkt auf der aktuell eingeblendeten Seite im Video-RAM
   --------------------------------------------------------------------------
*/
unsigned char farbe;
unsigned int x,y;
{
 VideoRam[y*320+x]=farbe;                    /* Punkt berechnen und setzen */
}

void main()
/* --------------------------------------------------------------------------
   Hauptprogramm
   --------------------------------------------------------------------------
*/
{
 unsigned char StartSeite;
 unsigned int bewegung,quadrat,kante;
 aufgerufen=0;
 printf("Darstellung von 2 Grafikseiten im Modus 13h.\n");
 printf("Bitte drcken Sie eine Taste zum Starten und Beenden. ");
 while (getch()==0);                                   /* Auf Taste warten */
 ModusSetzen13h();                                 /* Modus initialisieren */
 StartSeite=0;                                 /* Mit erster Seite starten */
 bewegung=0;
 while (kbhit()==0)                    /* solange keine Taste gedrckt ist */
 {
  ZeigeSeite(StartSeite);                       /* Aktuelle Seite anzeigen */
  BlendeSeiteEin(StartSeite ^ 1);               /* Andere Seite einblenden */
  for (quadrat=18+bewegung;quadrat<=38+bewegung;quadrat++)
   for (kante=18+bewegung;kante<=38+bewegung;kante++)
   {
    PunktSetzen13h(kante,quadrat,0);              /* Strich oben und links */
    PunktSetzen13h(quadrat,kante,0);                            /* lschen */
   }
  for (quadrat=20+bewegung;quadrat<=40+bewegung;quadrat++)
   for (kante=20+bewegung;kante<=40+bewegung;kante++)
    PunktSetzen13h(quadrat,kante,quadrat-bewegung+30);
  StartSeite=StartSeite ^ 1;                             /* Seite wechseln */
  bewegung++;                                           /* Quadrat bewegen */
 }
 ModusZuruecksetzen();                     /* Zurck in Standard-Textmodus */
}
