program vga2grafikseiten;
{----------------------------------------------------------------------------
 Stellt 2 Grafikseiten im Modus 13h auf VGA-Karten zur Verfgung
 Autor: Martin Althaus 4/91
 ----------------------------------------------------------------------------
}
 uses crt,dos;
var
 register: registers;
 AktuellerModus, seite:byte;
 aufgerufen: boolean;                        {zeigt an, ob Modus 13h gesetzt}

procedure BlendeSeiteEin(seite:byte);
{----------------------------------------------------------------------------
 Setzt oder lscht das Page-Bit im Miscellaneous-Output-Register der Grafik-
 karte. bergeben wird der Wert 0 oder 1. Dadurch wird Grafikseite 0 oder 1
 zur Vernderung ausgewhlt
 ----------------------------------------------------------------------------
}
begin
 if seite=1 then
  port[$3c2]:=port[$3cc] and $DF                          {nur Bit 5 lschen}
 else
  port[$3c2]:=port[$3cc] or $20                                 {oder setzen}
end;

procedure ModusSetzen13h;
{----------------------------------------------------------------------------
 Setzt Textmodus 13h und lscht die zweite Grafikseite
 ----------------------------------------------------------------------------
}
var
 x:word;
begin
 register.ah:=$0f;                                   {Funktion: Status lesen}
 intr($10,register);                                     {ber BIOS aufrufen}
 AktuellerModus:=register.al;                     {Aktuellen Modus speichern}
 aufgerufen:=true;                               {Zeiger: bereits aufgerufen}
 register.ax:=$0013;                                {Funktion 00h, Modus 03h}
 intr($10,register);                                    {Video-BIOS aufrufen}
 BlendeSeiteEin(1);                                 {Zweite Seite ansprechen}
 for x:=0 to $ffff do                                      {Alle 64 KByte in}
 begin                                               {einer Schleife lschen}
  memw[$a000:x]:=0;                                    {Lschen eines Wortes}
  inc(x);                                                    {Folgendes Wort}
 end;
 BlendeSeiteEin(0);                                 {Erste Seite einschalten}
end;

procedure ModusZuruecksetzen;
{----------------------------------------------------------------------------
 Schaltet in den Standard-Videomodus
 ----------------------------------------------------------------------------
}
begin
 if aufgerufen then
  begin
   register.ah:=0;                                                   {Modus}
   register.al:=AktuellerModus;                               {auslesen und}
   intr($10,register);                                    {ber BIOS setzen}
   aufgerufen:=false;
   BlendeSeiteEin(0);
  end;
end;

procedure PunktSetzen13h(x,y:word; farbe:byte);
{---------------------------------------------------------------------------
 Setzt einen Grafikpunkt. bergeben werden die Koordinaten und die Farbe
 ---------------------------------------------------------------------------
}
begin
 mem[$a000:y*320+x]:=farbe;
end;

procedure ZeigeSeite(seite:byte);
{----------------------------------------------------------------------------
 Whlt eine der Bildschirmseiten zur Darstellung auf dem Bildschirm aus.
 ----------------------------------------------------------------------------
}
var
 WordOffset: word;              {Offset des Darstellungsbeginns im Video-RAM}
begin
 WordOffset:=seite*$8000;                   {RAM-Offset berechnen (in Words)}
 port[$3d4]:=$d;                          {Low-Byte in Register 0Dh des CRTC}
 port[$3d5]:=WordOffset and $ff;
 port[$3d4]:=$c;                         {High-Byte in Register 0Ch des CRTC}
 port[$3d5]:=WordOffset shr 8;
end;

{----------------------------------------------------------------------------
 Hauptprogramm
 ----------------------------------------------------------------------------
}
var
 StartSeite:byte;
 bewegung,quadrat,kante:word;
begin
 clrscr;
 aufgerufen:=false;
 writeln('Demonstration fr 2 Grafikseiten im Modus 13h. Bitte drcken');
 writeln('Sie eine Taste zum Starten und Beenden.');
 repeat until readkey<>#0;                                 {Auf Taste warten}
 ModusSetzen13h;                                       {Modus initialisieren}
 StartSeite:=0;
 repeat
  ZeigeSeite(StartSeite);                                    {Seite anzeigen}
  BlendeSeiteEin(StartSeite xor 1);                  {Andere Seite verndern}
  for Quadrat:=18+bewegung to 38+bewegung do
   for kante:=18+bewegung to 38+bewegung do
    begin
     PunktSetzen13h(kante,quadrat,0);                     {Oberkante lschen}
     PunktSetzen13h(quadrat,kante,0);
    end;
  for quadrat:=20+bewegung to 40+bewegung do
   for kante:=20+bewegung to 40+bewegung do
    PunktSetzen13h(quadrat,kante,quadrat-bewegung+30);     {Quadrat zeichnen}
  StartSeite:=StartSeite xor 1;
  inc(bewegung);
 until keypressed;
 repeat until readkey<>#0;                                 {Auf Taste warten}
 ModusZuruecksetzen;                                {Alten Modus einschalten}
end.
