 ; TITLE '-Profi Software'
 ;dieses Programm liet die Schalterstellung von der gefertigten Platine
 ;als Bitmuster in den Akkumulator, verarbeitet sie, berprft auf
 ;Richtigkeit der Eingabe und gibt dann entsprechende Bitmuster wieder aus.
 ;
 ;************************** logischer Beginn *++**************************
 ;
           ORG     A000h
 ;
 ;**************************** HAUPTPROGRAMM ******************************
 ;
 ;
 Start:    ACALL   EINLESEN
           ACALL   EINSZHL
           AJMP    VERZWEIG

 ;*****************************UNTERPROGRAMME *****************************

 ;-------------------- Einlesen der Schalterstellung ----------------------

 EINLESEN: MOV     A,#0h                  ;Akku zur Sicherheit lschen
           MOV     DPTR,#C004h            ;Leseadresse fr Schalterstellung
           MOVX    A,@DPTR                ;in Akku laden
           RET


 ;---------------- Anzahl der "1" im geholten Bitmuster -------------------


 EINSZHL: PUSH    A                      ;Akkuwert retten
           MOV     R4,#00h                ;Bitanzahl auf 0 setzen
           MOV     R3,#08h                ;Schleife 8x durchlaufen
     Sch1: CLR     C                      ;Carry-bit lschen
           RLC     A                      ;Akku nach rechts rotieren
           JNC     Weiter                 ;wenn bit 0, dann widerholen
           INC     R4                     ;wenn bit 1, Anzahl erhhen
   Weiter: DJNZ    R3,Sch1                ;Schleifenanzahl um 1 Verringern
           POP     A
           RET

 ;---------------- Verzweigungen zu den jeweiligen Job's ------------------

 VERZWEIG: CJNE    R4,#1,Fehler1          ;Bitanzahl ungleich 1 -> Fehler
           JNB     A.0,J1                 ;einzelne Bits werden abgefragt
           LJMP    Job1                   ;wenn 1.bit = 1 => Job1,usw
      J1:  JNB     A.1,J2
           LJMP    Job2
      J2:  JNB     A.2,J3
           LJMP    Job3
      J3:  JNB     A.3,J4
           LJMP    Job4
      J4:  JNB     A.4,J5
           LJMP    Job5
      J5:  JNB     A.5,J6
           LJMP    Job6
      J6:  JNB     A.6,J7
           LJMP    Job7
      J7:  JNB     A.7,Fehler1
           LJMP    Job8
  Fehler1: CJNE    R4,#0,Fehler2          ;Unterscheidung -> zahl 0 od >1
           MOV     A,#01111001b           ;"E" fr Eingabe auf 7-Segment
           ACALL   AUSG_SEG
           MOV     A,#0h                  ;keine Anzeige an den LED's
           ACALL   AUSG_LED
           LJMP    Start                  ;wenn 0, dann neu einlesen
  Fehler2: LJMP    Jobf                   ;wenn >1, dann auf Fehlerjob

 ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

     Job1:                                ;alle 8 LED's leuchten (Testprg.)
           MOV     A,#00000110b           ;"1" auf 7-Segment
           ACALL   AUSG_SEG
           MOV     A,#FFh                 ;Akku mit "11111111" fllen
           ACALL   AUSG_LED               ;Ausgabe
           LJMP    Start                  ;neu einlesen

 ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

     Job2:                                ;Lauflicht langsam
           MOV     A,#01011011b           ;"2" auf 7-Segment
           ACALL   AUSG_SEG
           MOV     A,#80h                 ;Bitmuster "1000 0000" in Akku
     Sch2: ACALL   AUSG_LED               ;Ausgabe auf LED's
           RRC     A                      ;"0100 0000",0010 0000".....
           CLR     C                      ;Carry-Bit lschen
           ACALL   LANGSAM                ;mehr verzgern
           JNZ     Sch2                   ;Wiederholung
           LJMP    Start

 ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

     Job3:                                ;Lauflicht schnell
           MOV     A,#01001111b           ;"3" auf 7-Segment
           ACALL   AUSG_SEG
           MOV     A,#80h                 ;Bitmuster "1000 0000" in Akku
     Sch3: ACALL   AUSG_LED               ;Ausgabe auf LED's
           RRC     A                      ;wieder nach rechts verschieben
           CLR     C                      ;Carry lschen
           ACALL   SCHNELL                ;weniger verzgern
           JNZ     Sch3                   ;Wiederholung
           LJMP    Start

 ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
     Job4:                                ;(1.,3.,5.,7.LED)/(2.,4.,6.,8.LED)
           MOV     A,#01100110b           ;"4" auf 7-Segment 
           ACALL   AUSG_SEG
           MOV     A,#AAh                 ;"10101010" im Akku
           ACALL   AUSG_LED               ;ausgeben
           ACALL   LANGSAM                ;verzgern
           MOV     A,#AAh                 ;"10101010" wieder laden
           CPL     A                      ;"01010101" komplementieren
           ACALL   AUSG_LED               ;ausgeben
           ACALL   LANGSAM                ;verzgern (gleicher wie oben)
           LJMP    Start                  ;wieder einlesen

 ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
     Job5:                                ;Lauflicht links/rechts
           MOV     A,#01101101b           ;"5" auf 7-Segment
           ACALL   AUSG_SEG
           MOV     A,#80h                 ;Bitmuster "1000 0000" in Akku
     Sch4: ACALL   AUSG_LED               ;Ausgabe auf LED's
           RRC     A                      ;nach rechts rotieren
           CLR     C                      ;Carry lschen
           ACALL   SCHNELL                ;verzgern
           JNZ     Sch4                   ;solange wiederholen, bis A=0
           MOV     A,#1h                  ;Bitmuster "0000 0001" in Akku
     Sch5: ACALL   AUSG_LED               ;Ausgabe auf LED's
           RLC     A                      ;nach links rotieren
           CLR     C                      ;Carry lschen
           ACALL   SCHNELL                ;verzgern
           JNZ     Sch5                   ;solange wiederholen, bis A=0
           LJMP    Start                  ;neu einlesen
                 
 ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
   
     Job6:                                ;Lauflicht auen/innen
           MOV     A,#01111101b           ;"6" auf 7-Segment
           ACALL   AUSG_SEG
           MOV     A,#0h                  ;"0000 0000" auf LED's ausgeben
           ACALL   AUSG_LED
           ACALL   SCHNELL                ;verzgern
           MOV     A,#81h                 ;"1000 0001" auf LED's ausgeben
           ACALL   AUSG_LED
           ACALL   SCHNELL                ;verzgern
           MOV     A,#C3h                 ;"1100 0011" auf LED's ausgeben
           ACALL   AUSG_LED
           ACALL   SCHNELL                ;verzgern
           MOV     A,#E7h                 ;"1110 0111" auf LED's ausgeben
           ACALL   AUSG_LED
           ACALL   SCHNELL                ;verzgern
           MOV     A,#FFh                 ;"1111 1111" auf LED's ausgeben
           ACALL   AUSG_LED
           ACALL   SCHNELL                ;verzgern
           LJMP    Start                  ;neu einlesen

 ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

     Job7:                                ;Lauflicht links (immer + 1 LED)
           MOV     A,#00000111b           ;"7" auf 7-Segment
           ACALL   AUSG_SEG
           MOV     R3,#08h                ;Schleife 8x durchlaufen
           MOV     A,#1h                  ;im Akku steht "00000001"
     Sch6: ACALL   AUSG_LED               ;ausgeben
           ACALL   SCHNELL                ;verzgern
           MOV     R4,A                   ;Akku-Wert in Register
           INC     R4                     ;um 1 erhhen
           ADD     A,R4                   ;Akku:"00000011", "00000111".....
           DEC     R3                     ;Schleife um 1 dekrementieren
           CJNE    R3,#0h,Sch6            ;wenn Schleife nicht 0 -> nochmals
           LJMP    Start                  ;wenn ja -> neu einlesen

 ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

     Job8:                                ;inverses Lauflicht
           MOV     A,#01111111b           ;"8" auf 7-Segment
           ACALL   AUSG_SEG
           MOV     R3,#08h                ;Schleife 8x durchlaufen
           MOV     A,#FFh                 ;Akku: "11111111"
     Sch7: ACALL   AUSG_LED               ;ausgeben
           ACALL   SCHNELL                ;verzgern
           DEC     A                      ;Akku um 1 verringern
           MOV     B,#2h                  ;und durch 2 dividieren
           DIV     AB                     ;Akku:"01111111", "00111111" ....
           DEC     R3                     ;Schleifenvariable verkleinern
           CJNE    R3,#0,Sch7             ;wenn Schleife nicht 0 -> nochmals
           LJMP    Start                  ;wenn ja -> neu einlesen

 ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

     Jobf:                                ;Fehlerjob: bei falscher Eingabe
           MOV     A,#01110001b           ;"F" auf 7-Segment
           ACALL   AUSG_SEG
           MOV     A,#18h                 ;Akku: "00011000"
           ACALL   AUSG_LED               ;ausgeben
           ACALL   LANGSAM                ;verzgern
           MOV     A,#0h                  ;Akku lschen
           ACALL   AUSG_LED               ;ausgeben
           ACALL   LANGSAM                ;verzgern
           LJMP    Start                  ;einlesen


   ;------------------ Ausgabe der errechneten Bitmuster --------------------


 AUSG_LED:
           MOV     DPTR,#C004h            ;Ausgabeadresse fr LED's
           MOVX    @DPTR,A                ;Wert des Akkus auf LED's
           RET

  
 AUSG_SEG: 
           MOV     DPTR,#C003h            ;Ausgabeadresse fr 7-Segment
           MOVX    @DPTR,A                ;Wert des Akkus auf 7-Segment
           RET

 ;------------------------ Verzgerungen --------------------------------

 LANGSAM:
           MOV     R0,#0Ah                ;Zeitkonstante (gro) in Register
  Sprung1: CLR     TR0                    ;Timer wird auf 0 rckgesetzt
           CLR     TF0                    ;Flag fr bertrag auf 0
           MOV     TL0,#00h               ;niederwertiges Byte auf 0
           MOV     TH0,#00h               ;hherwertiges Byte auf 0
           MOV     TMOD,#00110001b        ;Baustein auf Timer-Mode
           MOV     TCON,#00010000b        ;Timer starten
  Eigene1: JNB     TF0,Eigene1            ;solange Zhler ungleich 0, Sprung
           DJNZ    R0,Sprung1             ;wenn 0 erreicht -> Konstante um
           RET                            ;1 verringern und wiederholen


 SCHNELL:
           MOV     R0,#02h
  Sprung2: CLR     TR0
           CLR     TF0
           MOV     TL0,#00h
           MOV     TH0,#00h
           MOV     TMOD,#00110001b
           MOV     TCON,#00010000b
  Eigene2: JNB     TF0,Eigene2
           DJNZ    R0,Sprung2
           RET