/****************************************************************************/
/*                              D L G . C                                   */
/*--------------------------------------------------------------------------*/
/*    Aufgabe        : Stellt im Rahmen der SAA-Serie eine Funktion zur     */
/*                     Erstellung und Verwaltung beliebiger Dialogboxen zur */
/*                     Verfgung.                                           */
/*--------------------------------------------------------------------------*/
/*    Autor          : MICHAEL TISCHER                                      */
/*    entwickelt am  : 13.07.1989                                           */
/*    letztes Update : 17.07.1989                                           */
/*--------------------------------------------------------------------------*/
/*    Erstellung     : CL /A[S|M|C|L|H] DLG.C [ DLGEDIT.C, DLGAB.C ...] /C  */
/*                     dann mit einem anderen Modul linken                  */
/****************************************************************************/

/*-- Include-Dateien einbinden ---------------------------------------------*/

#include <string.h>
#include <memory.h>
#include <malloc.h>
#include <dos.h>
#include "dlg.h"

/*-- globale Variablen -----------------------------------------------------*/

DLGCOL dlgcol = { 0x70, 0x70, 0x07, 0x01, 0x70, 0x70 };    /* Dialog-Farben */

BOOL      ende,                            /* zeigt das Ende der Eingabe an */
          maus;           /* ist TRUE, wenn die Mausaktivitt verfolgt wird */
BYTE      aktiv,                        /* Nummer des aktiven Dialog-Feldes */
          retcode;                              /* Return-Wert fr Aufrufer */
void   ** idptr,             /* Zeiger auf Vektor mit Id-Zeigern der Felder */
        * aktip;                   /* Zeiger auf Element des aktiven Feldes */
DLGDPTR   aktdlgp;           /* Zeiger auf Infos ber aktuelles Dialog-Feld */
DIGDES    dp;                                   /* Daten der Dialogstruktur */

#define FKT(x)  (*(aktdlgp->fkts->x))     /* Dlg-Fkt. des akt. Feldes aufr. */
#define FKTL(x) (*(dlgdptr->fkts->x))

/*****************************************************************************
*  Funktion         : D l g i P r o c e s s K e y                            *
**--------------------------------------------------------------------------**
*  Aufgabe          : Interne Funktion des DLG-Moduls, bearbeitet eine ein-  *
*                     gegebene Taste.                                        *
*  Eingabe-Parameter: KEY = Code der bettigten Taste                        *
*  Return-Wert      : keiner                                                 *
*  Globals          : ENDE, RETCODE, AKTIV, AKTIP, AKTDLGP                   *
*****************************************************************************/

BYTE DlgiProcessKey( TASTE key )
{
 BYTE      neuaktiv;                     /* Nummer des neuen aktiven Feldes */
 void   ** lidptr;                            /* Laufzeiger in IDPTR-Vektor */
 DLGDPTR   dlgdptr;         /* Laufzeiger in Vektor auf den dp.datptr zeigt */

 switch ( retcode = FKT(taste)( aktip, key ) ) /* Taste an akt. Feld senden */
  {
   case TF_FELD_VOR   :             /* nachfolgendes Dialog-Feld aktivieren */
    neuaktiv = aktiv;                                  /* Suche im nchsten */
    lidptr = idptr + neuaktiv;                         /* Dialog-Feld be-   */
    dlgdptr = aktdlgp;                                 /* ginnen            */
    do                                                      /* Suchschleife */
     {
     if ( ++neuaktiv == dp.anz )               /* zum ersten Feld springen? */
      {                                                               /* Ja */
       neuaktiv = 0;                              /* bei Feld #0 fortfahren */
       lidptr   = idptr;                    /* Zeiger auf das jeweils erste */
       dlgdptr  = dp.datptr;                /* Element im Vektor setzen     */
      }
     else                                   /* Nein, es folgt noch ein Feld */
      {
       ++lidptr;                     /* die beiden Zeiger auf das nchste   */
       ++dlgdptr;                    /* Element im jeweiligen Vektor setzen */
      }
     }
    while ( ! ( neuaktiv == aktiv  ||  FKTL(can)( *lidptr ) ) );
    if ( neuaktiv != aktiv )           /* wurde ein anderes Feld aktiviert? */
     {                                                                /* Ja */
      FKT(deak)( aktip );                    /* aktuelles Feld deaktivieren */
      aktip   = *lidptr;    /* Ptr auf Datenblock des aktiven Feldes merken */
      aktdlgp = dlgdptr;   /* Ptr auf Daten mit Infos ber akt. Feld merken */
      aktiv   = neuaktiv;                       /* Nummer des Feldes merken */
      FKT(aktiv)( aktip, TF_FELD_VOR );            /* neues Feld aktivieren */
     }
    break;

   case TF_FELD_RUECK :            /* vorhergehendes Dialog-Feld aktivieren */
    neuaktiv = aktiv;                                   /* Suche im vorher- */
    lidptr = idptr + neuaktiv;                          /* gehenden Dialog- */
    dlgdptr = aktdlgp;                                  /* Feld beginnen    */
    do                                                      /* Suchschleife */
     {
     if ( neuaktiv-- == 0)                    /* zum letzten Feld springen? */
      {                                                               /* Ja */
       neuaktiv = dp.anz-1;                   /* bei Feld #anz-1 fortfahren */
       lidptr   = idptr + neuaktiv;        /* Zeiger auf das jeweils letzte */
       dlgdptr  = dp.datptr + neuaktiv;    /* Element im Vektor setzen      */
      }
     else                             /* Nein, es geht noch ein Feld voraus */
      {
       --lidptr;                 /* die beiden Zeiger auf das vorhergehende */
       --dlgdptr;                /* Element im jeweiligen Vektor setzen     */
      }
     }
    while ( ! ( neuaktiv == aktiv  ||  FKTL(can)( *lidptr ) ) );
    if ( neuaktiv != aktiv )           /* wurde ein anderes Feld aktiviert? */
     {                                                                /* Ja */
      FKT(deak)( aktip );                    /* aktuelles Feld deaktivieren */
      aktip   = *lidptr;    /* Ptr auf Datenblock des aktiven Feldes merken */
      aktdlgp = dlgdptr;   /* Ptr auf Daten mit Infos ber akt. Feld merken */
      aktiv   = neuaktiv;                       /* Nummer des Feldes merken */
      FKT(aktiv)( aktip, TF_FELD_RUECK );          /* neues Feld aktivieren */
     }
    break;

   case TF_WEITER     :         /* Feld suchen, das diese Taste verarbeitet */
    neuaktiv = aktiv;                                  /* Suche im nchsten */
    lidptr = idptr + neuaktiv;                         /* Dialog-Feld be-   */
    dlgdptr = aktdlgp;                                 /* ginnen            */
    do                                                      /* Suchschleife */
     {
     if ( ++neuaktiv == dp.anz )               /* zum ersten Feld springen? */
      {                                                               /* Ja */
       neuaktiv = 0;                              /* bei Feld #0 fortfahren */
       lidptr   = idptr;                    /* Zeiger auf das jeweils erste */
       dlgdptr  = dp.datptr;                /* Element im Vektor setzen     */
      }
     else                                   /* Nein, es folgt noch ein Feld */
      {
       ++lidptr;                     /* die beiden Zeiger auf das nchste   */
       ++dlgdptr;                    /* Element im jeweiligen Vektor setzen */
      }
     }
    while ( neuaktiv != aktiv  &&
            ( retcode = FKTL(taste)(*lidptr, key) ) == TF_WEITER );
    if ( neuaktiv != aktiv )                /* wurde die Taste verarbeitet? */
     {                                                                /* Ja */
      if ( retcode == TF_AKTIV )                    /* das Feld aktivieren? */
       {                                                              /* Ja */
        FKT(deak)( aktip );                  /* aktuelles Feld deaktivieren */
        aktip   = *lidptr;  /* Ptr auf Datenblock des aktiven Feldes merken */
        aktdlgp = dlgdptr;   /*Ptr auf Daten mit Infos ber akt. Feld merken*/
        aktiv   = neuaktiv;                     /* Nummer des Feldes merken */
        FKT(aktiv)( aktip, TF_AKTIV );             /* neues Feld aktivieren */
       }
      else                  /* Nein, mit zurckgeliefertem Code terminieren */
       ende = TRUE;                                   /* Return-Flag setzen */
     }
    break;

   case TF_ACCEPTED   :                          /* Taste wurde verarbeitet */
    break;                                               /* nichts passiert */

   default            :           /* jeder andere Code bedeutet Termination */
    FKT(deak)( aktip );                      /* aktuelles Feld deaktivieren */
    ende = TRUE;                                      /* Return-Flag setzen */
    break;
  }
}

/*****************************************************************************
*  Funktion         : D l g S t a r t                                        *
**--------------------------------------------------------------------------**
*  Aufgabe          : Steuert die Bearbeitung einer Dialog-Box               *
*  Eingabe-Parameter: DPTR = Zeiger auf eine Dialogstruktur                  *
*  Return-Wert      : Terminations-Code                                      *
*****************************************************************************/

BYTE DlgStart( DIGDESPTR dptr )
{
 BYTE      i,                                            /* Schleifenzhler */
           mx,                   /* Position des Mauscursors als Koordinate */
           my;                   /* in Bezug auf den gesamten Bildschirm    */
 int       event;                            /* Ereignis von KbmEventWait() */
 void   ** lidptr;                            /* Laufzeiger in IDPTR-Vektor */
 DLGDPTR   dlgdptr;         /* Laufzeiger in Vektor auf den dp.datptr zeigt */
 TASTE     key;                                         /* empfangene Taste */

 dp = *dptr;                 /* Dialogstruktur in globale Variable kopieren */
 MouHideMouse();                                  /* Maus-Cursor ausblenden */
 VioWinOpen( dp.x_start, dp.y_start,        /* Fenster fr Dialogbox ffnen */
             dp.x_start + dp.x_len - 1, dp.y_start + dp.y_len - 1 );
 VioFrame( VL(0), VO(0), VR(0), VU(0), EINRA, F(dlgbox) );
 VioFill( VL(1), VO(1), VR(-1), VU(-1), ' ', F(dlgbox) );

 if ( dp.paintfkt != NOPAINTFKT )           /* gibt es eine Paint-Funktion? */
  (*dp.paintfkt)();                          /* Ja, diese Funktion aufrufen */

 /*-- Vektor zur Aufnahme der Identifikations-Pointer allokieren und Dia-  -*/
 /*-- logfunktion STARTFKT der einzelnen Dialog-Felder aufrufen            -*/

 lidptr = idptr = (void **) malloc( sizeof( void * ) * dp.anz );
 for ( dlgdptr = dp.datptr, i = 0; i < dp.anz; ++dlgdptr, ++i )
  *lidptr++ = FKTL(start)( (dlgdptr)->daten );

 /*-- Eingabeschleife, zunchst aktives Dialog-Feld ermitteln --------------*/

 for ( aktiv = 0, lidptr = idptr, dlgdptr = dp.datptr;
       ! FKTL(can)( *lidptr );
       ++aktiv, ++dlgdptr, ++lidptr )
  ;
 MouShowMouse();                             /* Maus-Cursor wieder anzeigen */

 aktip   = *lidptr;      /* Zeiger auf Datenblock des aktiven Feldes merken */
 aktdlgp = dlgdptr;  /* Zeiger auf Daten mit Infos ber aktives Feld merken */
 FKT(aktiv)( aktip, TF_FELD_VOR );   /* ausgewhltes Dialog-Feld aktivieren */
 maus = ende = FALSE;
 do
  {
   if ( maus )                            /* mu die Maus berwacht werden? */
    {                       /* Ja, Ereignis von Maus oder Tastatur erwarten */
     event = KbmEventWait( EV_KEY_AVAIL | EV_MOU_ALL );
     if ( event & EV_KEY_AVAIL )                         /* Taste bettigt? */
      DlgiProcessKey( KbdGetKey() );             /* Ja, holen und auswerten */
     else                                            /* Nein, Maus-Ereignis */
      {                 /* Dialog-Feld suchen, das sich der Maus bemchtigt */
       mx = MouGetCol();                       /* Position des Maus-Cursors */
       my = MouGetRow();                       /* holen und merken          */
       retcode = FKT(maus)( aktip, mx, my, event );  /* Mausev. bermitteln */
       if ( retcode == TF_WEITER )          /* wurde das Event verarbeitet? */
        {                 /* Nein, Feld suchen, das das Ereignis akzeptiert */
         for ( i = 0, lidptr = idptr, dlgdptr = dp.datptr;
               i < dp.anz;
               ++i, ++dlgdptr, ++lidptr )
          if ( i != aktiv  &&
               FKTL(maus)( *lidptr, mx, my, event ) == TF_MAUS )
           break;

         if ( i < dp.anz )                /* wurde ein Dialog-Feld gefunden */
          {                                                           /* Ja */
           FKT(deak)( aktip );               /* aktuelles Feld deaktivieren */
           aktip   = *lidptr;  /* Ptr auf Datenblock des akt. Feldes merken */
           aktdlgp = dlgdptr;        /* Ptr auf Daten ber akt. Feld merken */
           aktiv   = i;                         /* Nummer des Feldes merken */
           FKT(aktiv)( aktip, TF_MAUS );           /* neues Feld aktivieren */
          }
         else                       /* kein Feld nimmt die Maus in Anspruch */
          maus = FALSE;                       /* Maus nicht mehr berwachen */
        }
       else                                      /* kein TF_WEITER emfangen */
        ende = ( retcode != TF_ACCEPTED );                  /* terminieren? */
      }
    }
   else
    {       /* Nein, auf Taste oder Bettigung des linken Mausknopfs warten */
     event = KbmEventWait( EV_KEY_AVAIL | EV_LEFT_PRESS );
     if ( event & EV_KEY_AVAIL )                         /* Taste bettigt? */
      DlgiProcessKey( KbdGetKey() );             /* Ja, holen und auswerten */
     else                    /* Nein, linker Mausknopf wurde niedergedrckt */
       {                /* Dialog-Feld suchen, das sich der Maus bemchtigt */
        mx = MouGetCol();                      /* Position des Maus-Cursors */
        my = MouGetRow();                      /* holen und merken          */
        for ( i = 0, lidptr = idptr, dlgdptr = dp.datptr;
              i < dp.anz  &&
              FKTL(maus)( *lidptr, mx, my, EV_LEFT_PRESS ) != TF_MAUS;
              ++i, ++dlgdptr, ++lidptr )
         ;
        if ( i < dp.anz )                 /* wurde ein Dialog-Feld gefunden */
         {                                                            /* Ja */
          FKT(deak)( aktip );                /* aktuelles Feld deaktivieren */
          aktip   = *lidptr;   /* Ptr auf Datenblock des akt. Feldes merken */
          aktdlgp = dlgdptr; /*Ptr auf Daten mit Infos ber akt. Feld merken*/
          aktiv   = i;                          /* Nummer des Feldes merken */
          FKT(aktiv)( aktip, TF_MAUS );            /* neues Feld aktivieren */
          maus = TRUE;                             /* Maus jetzt berwachen */
         }
       }
    }
  }
 while ( !ende );               /* wiederholen, bis Ende-Flag gesetzt wurde */

 /*-- die einzelnen Dialogfelder durchlaufen und die Dialog-Funktion -------*/
 /*-- ENDEFKT aufrufen                                                     -*/

 MouHideMouse();                                  /* Maus-Cursor ausblenden */
 lidptr = idptr;    /* jeweils den von STARTFKT retournierten Zeiger berg. */
 for ( dlgdptr = dp.datptr, i = 0;
       i < dp.anz;
       ++dlgdptr, ++i )
  ( *(dlgdptr)->fkts->ende )( *lidptr++  );

 VioWinClose( TRUE );                     /* Dialogfenster wieder schlieen */
 MouShowMouse();                           /* Maus-Cursor wieder einblenden */
 return retcode;                               /* Return-Code zurckliefern */
}

/*****************************************************************************
*  Funktion         : D l g P r i n t                                        *
**--------------------------------------------------------------------------**
*  Aufgabe          : Steht allen Arten von Dialog-Feldern zur Verfgung,    *
*                     die einen Text innerhalb der Dialog-Box ausgeben       *
*                     mchten.                                               *
*                     Trifft die Funktion innerhalb des auszugebenden Textes *
*                     auf das Zeichen HOTKEY, betrachtet es den nachfolgen-  *
*                     den Buchstaben als den Hotkey des Dialog-Feldes und    *
*                     liefert dessen Tastaturcode in Verbindung mit der ALT- *
*                     Taste zurck                                           *
*  Eingabe-Parameter: x, y  = Ausgabeposition in Bezug auf den gesamten      *
*                             Bildschirm.                                    *
*                     str   = Zeiger auf den auszugebenden String.           *
*                     fn    = Farbe fr normale Zeichen.                     *
*                     fh    = Farbe fr den Hotkey.                          *
*  Return-Wert      : NOKEY, wenn kein Hotkey entdeckt wurde, sonst der Tas- *
*                     taturcode des Hotkeys.                                 *
*****************************************************************************/

TASTE DlgPrint( BYTE x, BYTE y, char * str, BYTE fn, BYTE fh )
{
 static TASTE altcodes[] =                          /* Codes der Alt-Tasten */
  {
   ALT_A, ALT_B, ALT_C, ALT_D, ALT_E, ALT_F, ALT_G, ALT_H,
   ALT_I, ALT_J, ALT_K, ALT_L, ALT_M, ALT_N, ALT_O, ALT_P,
   ALT_Q, ALT_R, ALT_S, ALT_T, ALT_U, ALT_V, ALT_W, ALT_X,
   ALT_Y, ALT_Z
  };
 TASTE retkey;                                  /* zurckgelieferter Hotkey */

 retkey = NOKEY;                               /* nicht von Hotkey ausgehen */
 while ( *str )                            /* den Ausgabestring durchlaufen */
  {
   if ( *str == HOTKEY )                                /* Hotkey entdeckt? */
    {                                                                 /* Ja */
     retkey = altcodes[ tolower( *++str ) - 'a' ];         /* Hotkey merken */
     VioPrintf(x++, y, fh, FALSE, "%c", *str++ );        /* Hotkey ausgeben */
    }
   else                                                      /* kein Hotkey */
     VioPrintf( x++, y, fn, FALSE, "%c", *str++ );      /* Zeichen ausgeben */
  }
 return retkey;                                 /* den Hotkey zurckliefern */
}

/*****************************************************************************
*  Funktion         : D l g D e l a y                                        *
**--------------------------------------------------------------------------**
*  Aufgabe          : Realisiert eine Zeitverzgerung auf der Basis des BIOS *
*                     Timers.                                                *
*  Eingabe-Parameter: PAUSLEN = Lnge der Pause in Ticks                     *
*                               (1 Ticks entspricht 1/18,2 sec.)             *
*  Return-Wert      : keiner                                                 *
*****************************************************************************/

void DlgDelay( int pauslen )
{
 register unsigned int zeit_hi,                               /* Zeitzhler */
                       zeit_lo;
 union REGS            inregs,                         /* Prozessorregister */
                       outregs;

 inregs.h.ah = 0;                     /* Funktion 00h = Zeitzhler auslesen */
 int86( 0x1a, &inregs, &outregs );                 /* Zeit holen und merken */
 zeit_hi = outregs.x.cx;
 zeit_lo = outregs.x.dx;

 while ( pauslen )                        /* wiederholen, bis pauslen auf 0 */
  {                                       /* heruntergezhlt wurde          */
   int86( 0x1a, &inregs, &outregs );                          /* Zeit holen */

   /*-- neuer Tick angebrochen?-------------------------------------------- */

   if ( zeit_hi != outregs.x.cx  ||  zeit_lo != outregs.x.dx )
    {                                                                 /* Ja */
     zeit_hi = outregs.x.cx;            /* neue Werte der Zeitzhler merken */
     zeit_lo = outregs.x.dx;
     --pauslen;                /* Anzahl verbleibender Ticks dekrementieren */
    }
  }
}

/*****************************************************************************
*  Funktion         : D l g B o x                                            *
**--------------------------------------------------------------------------**
*  Aufgabe          : Zieht einen Rahmen innerhalb einer Dialogbox und setzt *
*                     einen Titel hinein.                                    *
*  Eingabe-Parameter: X, Y  = Start des Rahmens relativ zu oberen linken     *
*                             Ecke der Dialogbox                             *
*                     XLEN, = Breite des Rahmens                             *
*                     YLEN, = Hhe des Rahmens                               *
*                     TYP   = Rahmentyp (EINRA, DOPRA etc.)                  *
*                     TITEL = der Titel, der in der ersten Rahmenzeile aus-  *
*                             gegeben wird                                   *
*                     AKTIV = TRUE, Rahmen und Titel werden in den Farben    *
*                             aktiver Felder gezeichnet.                     *
*  Return-Wert      : keiner                                                 *
*  Info             : Hotkey-Markierungen im Titel werden nicht bercksich-  *
*                     tigt und wie normale Zeichen ausgegeben.               *
*****************************************************************************/

void DlgBox( BYTE x, BYTE y, BYTE xlen, BYTE ylen,
             BYTE typ, char * titel, BOOL aktiv )

{
 BYTE f;                                                    /* Ausgabefarbe */

 VioFrame( VL(x), VO(y), VL(x+xlen-1), VO(y+ylen-1),
           typ, f = aktiv ? F(hi) : F(nm) );
 VioPrint( VL( x+(xlen-strlen(titel) >> 1) ), VO( y ), f, FALSE, titel );
}
