/****************************************************************************/
/*                               D L G A B . C                              */
/*--------------------------------------------------------------------------*/
/*    Aufgabe        : Enthlt die Funktionen zur Verwaltung von Action-    */
/*                     Buttons, die innerhalb von Dialog-Boxen zum Einsatz  */
/*                     kommen.                                              */
/*                     Dieses Modul mu in Verbindumg mit dem DLG-Modul zum */
/*                     Einsatz kommen.                                      */
/*--------------------------------------------------------------------------*/
/*    Autor          : MICHAEL TISCHER                                      */
/*    entwickelt am  : 13.07.1989                                           */
/*    letztes Update : 17.07.1989                                           */
/*--------------------------------------------------------------------------*/
/*    Erstellung     : CL /A[S|M|C|L|H] DLGAB.C /C                          */
/*                     dann mit dem DLG-Modul und anderen Moduln verbinden  */
/****************************************************************************/

/*-- Include-Dateien einbinden ---------------------------------------------*/

#include <malloc.h>
#include <string.h>
#include "dlg.h"

/*-- interne Datenstruktur des Dialogtyps AB (Action Button )---------------*/

typedef struct    /* die Daten werden fr jeden Action-Button festgehalten -*/
 {
  TASTE hotkey;          /* Hotkey des Action Buttons (NOKEY = kein Hotkey) */
  BYTE  x1, x2,                             /* Start- und Endspalte des ABs */
        y,                                                         /* Zeile */
        xcur;                               /* Spalte fr blinkenden Cursor */
 } ABINTERN;

typedef ABINTERN *ABIP;              /* Zeiger auf eine interne AP-Struktur */

/*-- Prototypen fr Funktionen, die in diesem Modul deklariert und in der --*/
/*-- globalen Variablen std_ab_fkt zusammengefat werden                  --*/

void * ab_start ( ABGROUP * dptr );
void   ab_newval( ABIP abip, void * dptr );
void   ab_ende  ( ABIP abip );
BYTE   ab_taste ( ABIP abip, TASTE key );
void   ab_deak  ( ABIP abip );
void   ab_aktiv ( ABIP abip, BYTE why );
BOOL   ab_maus  ( ABIP abip, BYTE x, BYTE y, BYTE ev );
BOOL   ab_can   ( ABIP abip );

/*-- globale Variablen, ffentlich -----------------------------------------*/

DLGFKT std_ab_fkt =                       /* Standard Dialog-Funktionen fr */
 {                                        /* eine Gruppe von Action-Buttons */
   ab_start, ab_newval, ab_ende , ab_taste,
   ab_deak,  ab_maus,   ab_aktiv, ab_can
 };

/*-- globale Variablen, modulintern ----------------------------------------*/

static ABGROUP   abg;        /* dient den Funktionen fr die Action-Buttons */
static BYTE      aktab;                                     /* aktueller AB */
static BOOL      abaktiv;                   /* ist TRUE, wenn innerhalb ABs */
static BOOL      stdinvert;        /* ist TRUE, wenn Standard-AB invertiert */

/*****************************************************************************
* A B            Es folgen die verschiedenen Funktionen des Dialogtyps AB    *
*                ( eine Gruppe von Action Buttons )                          *
*****************************************************************************/

/*****************************************************************************
*  Funktion         : a b _ t e s t k e y                                    *
**--------------------------------------------------------------------------**
*  Aufgabe          : Stellt fest, ob die bergebene Taste einem der Action- *
*                     Buttons zugeordnet wurde, oder dessen Hotkey ent-      *
*                     spricht.                                               *
*  Eingabe-Parameter: ABIP = Zeiger auf internen AB-Vektor                   *
*                     KEY  = Taste                                           *
*  Return-Wert      : -1, wenn kein zugehriger Action Button gefunden wurde,*
*                     sonst die Nummer des Action-Buttons                    *
*  Info             : Diese Funktion findet nur intern Verwendung, sie wird  *
*                     nicht vom Scheduler aufgerufen.                        *
*****************************************************************************/

int ab_testkey( ABIP abip, TASTE key )
{
 BYTE  i;                                                /* Schleifenzhler */
 ABPTR labptr;                         /* Laufzeiger in Vektor mit AB-Daten */

 /*-- den Vektor mit den AB-Beschreibern durchlaufen -----------------------*/
 for ( i = 0, labptr = abg.abp;
       i < abg.anz  &&  !(labptr->key == key  &&  labptr->enabled);
       ++i, ++labptr )
  ;
 if ( i == abg.anz )                             /* Taste bereits entdeckt? */
  {                                  /* Nein, jetzt die Hotkeys untersuchen */
   for ( i = 0; i < abg.anz  &&  abip->hotkey != key; ++i, ++abip )
    ;
  }
 return ( i < abg.anz ) ? i : -1;                /* i < abg.anz : gefunden! */
}

/*****************************************************************************
*  Funktion         : a b _ m a r k                                          *
**--------------------------------------------------------------------------**
*  Aufgabe          : Markiert einen Action-Button als gewhlt oder nicht    *
*                     gewhlt.                                               *
*  Eingabe-Parameter: ABIP = Zeiger auf internen AB-Vektor                   *
*                     NR   = Nummer des angesprochenen Action-Buttons        *
*                     MARK = TRUE, wenn es sich um den aktuellen Action-     *
*                            Button handelt                                  *
*  Return-Wert      : keiner                                                 *
*  Info             : - Mit dieser Funktion knnen nur Action-Button bear-   *
*                       beitet werden, die enabled sind.                     *
*                     - Diese Funktion findet nur intern Verwendung, sie     *
*                       wird nicht vom Scheduler aufgerufen.                 *
*****************************************************************************/

void ab_mark( ABIP abip, BYTE nr, BOOL mark )
{
 register BYTE f,                                           /* Ausgabefarbe */
               s,                                          /* Ausgabespalte */
               z;                                           /* Ausgabezeile */

 MouHideMouse();                                  /* Maus-Cursor ausblenden */
 abip += nr;                /* den Beschreiber des angespr. ABs adressieren */
 VioPrint( s = abip->x1, z = abip->y, f = mark ? F(hi) : F(nm), FALSE, "<" );
 VioPrint( abip->x2, z, f, FALSE, ">" );
 DlgPrint( s+1, z, (abg.abp+nr)->name, F(nm), F(hk) );
 if ( mark )                           /* aktuellen Action Button markiert? */
  VioSetCursor( abip->xcur, z );                /* Ja, Cursor darauf setzen */
 if ( nr == abg.standard )             /* wurde der Standard-AB gezeichnet? */
  stdinvert = FALSE;                   /* Ja, Standard-AB nicht mehr invers */
 MouShowMouse();                           /* Maus-Cursor wieder einblenden */
}

/*****************************************************************************
*  Funktion         : a b _ i n v e r t                                      *
**--------------------------------------------------------------------------**
*  Aufgabe          : Invertiert einen Action-Button                         *
*  Eingabe-Parameter: ABIP = Zeiger auf internen AB-Vektor                   *
*                     NR   = Nummer des angesprochenen Action-Buttons        *
*  Return-Wert      : keiner                                                 *
*  Info             : - Mit dieser Funktion knnen nur Action-Button bear-   *
*                       beitet werden, die enabled sind.                     *
*                     - Diese Funktion findet nur intern Verwendung, sie     *
*                       wird nicht vom Scheduler aufgerufen.                 *
*****************************************************************************/

void ab_invert( ABIP abip, BYTE nr )
{
 abip += nr;                /* den Beschreiber des angespr. ABs adressieren */

 MouHideMouse();                                  /* Maus-Cursor ausblenden */
 VioColor( abip->x1, abip->y, abip->x2, abip->y, F(hi) );
 VioSetCursor( abip->xcur, abip->y );                      /* Cursor setzen */
 MouShowMouse();                           /* Maus-Cursor wieder einblenden */
 if ( nr == abg.standard )             /* wurde der Standard-AB gezeichnet? */
  stdinvert = TRUE;                     /* Ja, Standard-AB ist jetzt invers */
}

/*****************************************************************************
*  Funktion         : a b _ s t a r t                                        *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler whrend der Initialisierung einer   *
*                     Dialogbox fr die Gruppe der Action Buttons aufgerufen.*
*  Eingabe-Parameter: DPTR = Zeiger auf den Datenblock des Actions Buttons   *
*  Return-Wert      : Ein Zeiger, den der Scheduler bei allen folgenden Auf- *
*                     rufen den Funktionen abaktiv, abtast etc. bergibt.    *
*****************************************************************************/

void * ab_start ( ABGROUP * dptr )
{
 BYTE   i,                                               /* Schleifenzhler */
        f;                                                  /* Ausgabefarbe */
 char * sptr;                    /* Zeiger auf den Namen des Action-Buttons */
 ABIP   abip,           /* Zeiger auf allokierten Vektor mit internen Infos */
        labip;                               /* Laufzeiger in obigen Vektor */
 ABPTR  labptr;                      /* Laufzeiger auf einen AB-Beschreiber */

 abg = *dptr;       /* bergebene Struktur in globale Variable ABG kopieren */

 /*-- die einzelnen Action-Buttons aufbauen, Hotkeys und Pos. merken -------*/

 labip = abip = (ABIP) malloc( sizeof(ABINTERN) * abg.anz );
 for ( labptr = abg.abp, i = abg.anz; i ; --i, ++labip, ++labptr )
  {                             /* den AB, auf den LABPTR zeigt, bearbeiten */
   labip->x2 = VL( labptr->x + strlen( labptr->name ) + 1 );
   labip->hotkey = DlgPrint( (labip->x1 = VL(labptr->x) ) + 1,
                             labip->y = VO(labptr->y),
                             sptr = labptr->name,
                             f = labptr->enabled? F(nm) : F(da),
                             labptr->enabled? F(hk) : F(dk)          );

   if ( !labptr->enabled )                          /* ist der AB disabled? */
    labip->hotkey = NOKEY;                     /* Ja, es gibt keinen Hotkey */

   if ( labip->hotkey != NOKEY)                    /* gibt es einen Hotkey? */
    {                                                                 /* Ja */
     --labip->x2;                /* Hotkey-Zeichen nicht in Lnge mitzhlen */
     labip->xcur = labip->x1 + 1 + ( strchr( sptr, HOTKEY ) - sptr );
    }
   else                                            /* es gibt keinen Hotkey */
     {                        /* erstes nicht-Space im Namen des ABs suchen */
      for ( sptr = labptr->name; *sptr == ' '; ++sptr )
       ;
      labip->xcur = labip->x1 + 1 + ( sptr - labptr->name );
     }

   /*-- Begrenzer ausgeben -------------------------------------------------*/

   VioPrint( labip->x1, labip->y, f, FALSE, "<" );
   VioPrint( labip->x2, labip->y, f, FALSE, ">" );
  }

 ab_mark( abip, aktab = abg.standard, TRUE );      /* akt. Button markieren */

 abaktiv = FALSE;                              /* ABs sind noch nicht aktiv */
 return abip;                          /* Zeiger an Scheduler zurckliefern */
}

/*****************************************************************************
*  Funktion         : a b _ n e w v a l                                      *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird nicht direkt vom Scheduler, sondern von einer mit *
*                     ihm zusammenarbeitenden Interaktions-Fukntion aufge-   *
*                     rufen, wenn sich der Inhalt eines EDIT-Feldes durch    *
*                     ueres Ereignis verndert hat.                        *
*  Eingabe-Parameter: EP = der Zeiger, der beim Aufruf von ab_start zurck-  *
*                          geliefert wurde.                                  *
*  Return-Wert      : keiner                                                 *
*****************************************************************************/

void ab_newval( ABIP abip, void * dptr )
{
}

/*****************************************************************************
*  Funktion         : a b _ e n d e                                          *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler whrend des Schlieens des Dialog-  *
*                     box aufgerufen, um EDIT Gelgegenheit zu geben, Clean-  *
*                     Up-Arbeiten durchzufhren.                             *
*  Eingabe-Parameter: EP = der Zeiger, der beim Aufruf von ab_start zurck-  *
*                          geliefert wurde.                                  *
*  Return-Wert      : keiner                                                 *
*****************************************************************************/

void ab_ende( ABIP abip )
{
 free( abip );                   /* den allokierten Vektor wieder freigeben */
}

/*****************************************************************************
*  Funktion         : a b _ t a s t e                                        *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um dem Dialog-Feld eine *
*                     Taste zu bergeben.                                    *
*  Eingabe-Parameter: EP    = der Zeiger, der beim Aufruf von ab_start zu-   *
*                             rckgeliefert wurde.                           *
*                     TASTE = Code der zu bearbeitenden Taste                *
*  Return-Wert      : Reaktionscode (TF_...)                                 *
*****************************************************************************/

BYTE ab_taste( ABIP abip, TASTE key )
{
 ABIP labip;                        /* Laufzeiger in den internen AB-Vektor */
 int  retcode,                                     /* nimmt Return-Code auf */
      neuakt;                                         /* neuer aktueller AB */

 if ( abaktiv )                                      /* sind die ABs aktiv? */
  {                                                                   /* Ja */
   switch ( key )                                        /* Taste auswerten */
    {
     case ' '   :    /*----------- SPACE whlt aktuellen Action Button aus -*/
       labip = abip + aktab;    /* Zeiger auf interne Infos zu aktuellen AB */
       DlgPrint(labip->x1+1, labip->y, (abg.abp+aktab)->name, F(hi), F(hk));
       return aktab;      /* Terminationscode ist Nummer des Action Buttons */

     case TAB   :    /*-------------- TAB fhrt zum nchsten Action-Button -*/
       for ( neuakt = aktab ;
             ++neuakt != abg.anz  &&  !(abg.abp+neuakt)->enabled; )
        ;
       if ( neuakt == abg.anz )               /* auf letztem Action-Button? */
        return TF_FELD_VOR;         /* Ja, ins nchste Dialog-Feld springen */
       else                  /* Nein, auf nchsten Action-Button umschalten */
        {
         ab_mark( abip, aktab, FALSE );          /* aktuellen AB ausblenden */
         ab_mark( abip, aktab = neuakt, TRUE );      /* neuen AB einblenden */
         return TF_ACCEPTED;                     /* Taste wurde verarbeitet */
        }

     case BACKTAB   :    /*- BACKTAB fhrt zum vorhergehenden Action-Button */
       for ( neuakt = aktab;
             --neuakt != -1  &&  !(abg.abp+neuakt)->enabled ; )
        ;
       if ( neuakt != -1 )                     /* auf erstem Action-Button? */
        {              /* Nein, auf vorhergehenden Action-Button umschalten */
         ab_mark( abip, aktab, FALSE );          /* aktuellen AB ausblenden */
         ab_mark( abip, aktab = neuakt, TRUE );      /* neuen AB einblenden */
         return TF_ACCEPTED;                     /* Taste wurde verarbeitet */
        }
       else                  /* Ja, zum vorhergehenden Dialog-Feld springen */
        return TF_FELD_RUECK;

     case CR        : /*-------------------------------------------- RETURN */
       return (( retcode = ab_testkey( abip, key ) ) != -1 ) ? retcode
                                                             : aktab;

     default :       /*--------------------------------- jede andere Taste -*/
       return (( retcode = ab_testkey( abip, key ) ) != -1 ) ? retcode
                                                             :  TF_WEITER;
    }
  }
 else                                /* Action Button sind noch nicht aktiv */
  if ( key == CR )                                /* wurde RETURN bettigt? */
   return abg.standard;             /* Ja, RETURN whlt den Standard-AB aus */
  else                      /* Nein, ist ein AB mit dieser Taste verbunden? */
  return (( retcode = ab_testkey( abip, key ) ) != -1 ) ? retcode
                                                        :  TF_WEITER;
}

/*****************************************************************************
*  Funktion         : a b _ d e a k                                          *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um das Dialog-Feld von  *
*                     seiner Deaktivierung in Kenntnis zu setzen.            *
*  Eingabe-Parameter: EP = der Zeiger, der beim Aufruf von ab_start zurck-  *
*                          geliefert wurde.                                  *
*  Return-Wert      : keiner                                                 *
*****************************************************************************/

void ab_deak( ABIP abip )
{
 /*-- den Standard-Button aktivieren ---------------------------------------*/

 if ( aktab != abg.standard )                /* ist der bereits ausgewhlt? */
  {                             /* Nein, alten ausblenden, neuen einblenden */
   ab_mark( abip, aktab, FALSE );
   ab_mark( abip, aktab = abg.standard , TRUE );
  }
 abaktiv = FALSE;                                   /* ABs nicht mehr aktiv */
 VioHideCursor();                        /* Cursor vom Bildschirm entfernen */
}

/*****************************************************************************
*  Funktion         : a b _ m a u s                                          *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um dem Dialog-Feld ein  *
*                     Mausereignis zu bergeben                              *
*  Eingabe-Parameter: EP    = der Zeiger, der beim Aufruf von edit_start zu- *
*                             rckgeliefert wurde.                           *
*                     X, Y  = Position des Mauscursors realtiv zu oberen     *
*                             linken Bildschirmecke                          *
*                     EV    = Event-Maske, die das Ereignis beschreibt, um   *
*                             dessentwillen die Funktion aufgerufen wird     *
*  Return-Wert      : Reaktionscode (TF_...)                                 *
*****************************************************************************/

BYTE ab_maus  ( ABIP abip, BYTE x, BYTE y, BYTE ev )
{
 BYTE  i;                                                /* Schleifenzhler */
 ABPTR labptr;               /* Laufzeiger auf die einzelnen AB-Beschreiber */
 ABIP  labip;            /* Laufzeiger in Vektor mit internen Informationen */

 if ( abaktiv )                           /* sind die Action-Buttons aktiv? */
  {                                                                   /* Ja */
   if ( ev & EV_LEFT_REL )       /* wurde der linke Mausbutton losgelassen? */
    {             /* Ja, feststellen, ob sich die Maus ber einem AB befand */
     for ( i = 0, labptr = abg.abp; i < abg.anz ; ++i, ++abip, ++labptr )
      if ( labptr->enabled  &&  y==abip->y  &&  x>=abip->x1  &&  x<=abip->x2 )
       return i;                                  /* Ja, Dialog-Box beenden */
     return TF_WEITER;                                /* Maus nicht ber AB */
    }
   else                      /* der linke Mausknopf ist noch niedergedrckt */
    {    /* feststellen, ob sich die Maus noch ber dem aktiven AB befindet */
     labip = abip + aktab;   /* Zeiger auf internen Beschreiber des akt. AB */
     if ( y!=labip->y  || x<labip->x1  ||  x>labip->x2 )
      {               /* Maus ist jetzt nicht mehr auf dem aktuellen Button */
       /*-- testen, ob sich die Maus ber einem anderen AB befindet-------- */

       for ( i = 0, labptr = abg.abp, labip = abip;
             i < abg.anz ;
             ++i, ++labip, ++labptr )
        if ( labptr->enabled  &&  y==labip->y  &&
             x>=labip->x1  &&  x<=labip->x2 )
         break;                                     /* Maus ber anderem AB */

       if ( i != abg.anz )                   /* Maus ber einem anderen AB? */
        {                                                             /* Ja */
         ab_mark( abip, aktab, FALSE );          /* aktuellen AB ausblenden */
         ab_invert( abip, aktab = i );             /* Ja, neuen invertieren */
        }
       else                    /* Nein, Standard-AB auswhlen und markieren */
        {
         if ( aktab != abg.standard )            /* bereits auf Standard-AB */
          {                                                         /* Nein */
           ab_mark( abip, aktab, FALSE );        /* aktuellen AB ausblenden */
           ab_mark( abip, aktab = abg.standard, TRUE );
          }
         else
          if ( stdinvert )
           ab_mark( abip, aktab, TRUE );
        }
      }
     else                                   /* noch auf dem gleichen Button */
      if ( aktab == abg.standard  &&  !stdinvert )
       ab_invert( abip, aktab );        /* Std-AB war noch nicht invertiert */

     return TF_ACCEPTED;                         /* Event wurde verarbeitet */
    }
  }
 else                                     /* Nein, die ABs sind nicht aktiv */
  if  ( ev & EV_LEFT_PRESS )  /* wurde der linke Mausbutton niedergedrckt? */
   {                 /* ja, testen, ob sich die Maus ber einem AB befindet */
    for ( i = 0, labptr = abg.abp; i < abg.anz ; ++i, ++abip, ++labptr )
     if ( labptr->enabled  &&  y==abip->y  &&  x>=abip->x1  &&  x<=abip->x2 )
      {                      /* Maus befindet sich ber einem enableden AB! */
       aktab = i;                                  /* Nummer des ABs merken */
       return TF_MAUS;                                     /* AB aktivieren */
      }
    return TF_WEITER;                      /* Maus nicht ber einem der ABs */
   }
  else                                                              /* Nein */
   return TF_WEITER;
}

/*****************************************************************************
*  Funktion         : a b _ c a n                                            *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um festzustellen, ob    *
*                     das Dialogfeld bereit ist, aktiviert zu werden.        *
*  Eingabe-Parameter: EP = der Zeiger, der beim Aufruf von ab_start zurck-  *
*                          geliefert wurde.                                  *
*  Return-Wert      : TRUE, wenn das Dialog-Feld aktiviert werden kann,      *
*                     sonst FALSE                                            *
*****************************************************************************/

BOOL ab_can( ABIP abip )
{
 return TRUE;                                /* ABs knnen aktiviert werden */
}

/*****************************************************************************
*  Funktion         : a b _ a k t i v                                        *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um das Dialog-Feld von  *
*                     seiner Aktivierung in Kenntnis zu setzen.              *
*  Eingabe-Parameter: EP  = der Zeiger, der beim Aufruf von ab_start zurck- *
*                           geliefert wurde.                                 *
*                     WHY = warum wird das Feld aktiviert                    *
*  Return-Wert      : keiner                                                 *
*****************************************************************************/

void ab_aktiv( ABIP abip, BYTE why )
{
 BYTE neuab;                   /* Nummer des neuen aktuellen Action Buttons */

 abaktiv = TRUE;                                         /* ABs jetzt aktiv */

 /*-- Wurde der Aufruf durch eine TF_FELD_VOR- oder TF_FELD_RUECK-Message --*/
 /*-- herbeigefhrt, mu ein aktiver Action-Button ausgewhlt werden. Bei --*/
 /*-- allen anderen Messages (TF_AKTIV etc.) wird davon ausgegangen, da  --*/
 /*-- bereits ein aktiver Action Button gewhlt und seine Nummer in der   --*/
 /*-- Variablen aktab gespeichert wurde                                   --*/

 neuab = aktab;       /* davon ausgehen, da neuer AB bereits gewhlt wurde */
 switch ( why )                            /* Grund des Aufrufs untersuchen */
  {
   case TF_FELD_VOR   :                                     /* ein Feld vor */
     for ( neuab = 0; !(abg.abp+neuab)->enabled; ++neuab )
       ;
     break;

   case TF_FELD_RUECK :                                  /* ein Feld zurck */
     for ( neuab = abg.anz-1; !(abg.abp+neuab)->enabled; --neuab )
       ;
     break;

   case TF_MAUS       :                           /* aktivierung durch Maus */
     if ( aktab != abg.standard )        /* wird der Standard-AB aktiviert? */
      ab_mark( abip, abg.standard, FALSE );        /* Nein, alten AB ausbl. */
     ab_invert( abip, aktab );                      /* neuen AB invertieren */
     break;
  }
 if ( neuab != aktab )                       /* wurde ein neuer AB gewhlt? */
  {                               /* Ja, alten ausblenden, neuen einblenden */
   ab_mark( abip, aktab, FALSE );
   ab_mark( abip, aktab = neuab, TRUE );
  }
 else                                      /* Nein, nur Cursor in AB setzen */
   VioSetCursor( (abip+aktab)->xcur, (abip+aktab)->y );
}

