/****************************************************************************/
/*                            D L G D E M O. C                              */
/*--------------------------------------------------------------------------*/
/*    Aufgabe        : Demonstriert die Erstellung und Verwaltung von Dia-  */
/*                     logboxen durch die Module DLG, DLGEDIT und DLGAB.    */
/*--------------------------------------------------------------------------*/
/*    Autor          : MICHAEL TISCHER                                      */
/*    entwickelt am  : 13.07.1989                                           */
/*    letztes Update : 17.07.1989                                           */
/*--------------------------------------------------------------------------*/
/*    Erstellung     : CL /A[S|M|C|L|H] DLGDEMO.C DLG.C DLGAB.C DLGEDIT.C   */
/*                                      VIO.C KBM.C                         */
/****************************************************************************/

/*-- Include-Dateien einbinden ---------------------------------------------*/

#include "dlg.h"

/*-- Forward-Funktionsdeklarationen ----------------------------------------*/

void paint( void );

DLGCOL demofarbe =                /* Farben in der Dialogox fr Color-Modus */
 {
  COL( WEISS, CYAN ),                            /* Rahmenfarbe             */
  COL( SCHWARZ, CYAN ),                          /* normale Zeichen         */
  COL( GELB, SCHWARZ ),                          /* hervorgehobene Zeichen  */
  COL( ROT, CYAN ),                              /* Hotkeys                 */
  COL( HGRAU, CYAN ),                            /* inaktive Felder         */
  COL( HGRAU, CYAN )                             /* inaktive Felder, hotkey */
 };

/*-- Daten fr Eingabefeld #1 ----------------------------------------------*/

BYTE f1buf[21] = "";                                       /* Eingabepuffer */
EMENGE f1menge;                                             /* Eingabemenge */

EDITFELD tb_dlgf1 =
 {
  TRUE, 3, 2, 20, 20, "alpha#numerisch : ", f1buf, f1menge
 };

/*-- Daten fr Eingabefeld #2 ----------------------------------------------*/

BYTE f2buf[81] = "";                                       /* Eingabepuffer */
EMENGE f2menge;                                             /* Eingabemenge */

EDITFELD tb_dlgf2 =
 {
  TRUE, 3, 4, 80, 23, "#Dateiname      : ", f2buf, f2menge
 };

/*-- Daten fr Eingabefeld #3 ----------------------------------------------*/

BYTE f3buf[11] = "1,23";                                   /* Eingabepuffer */
EMENGE f3menge;                                             /* Eingabemenge */

EDITFELD tb_dlgf3 =
 {
   TRUE, 3, 6, 10, 10, "#Integer        : ", f3buf, f3menge
 };

/*-- Daten fr die Action-Buttons------------------------------------------ */

ONEAB tb_absdef[] =
 {
  { TRUE,  3, 9, "   OK   ",    NOKEY },
  { TRUE, 22, 9, "ESC = #Abbruch", ESC },
  { TRUE, 48, 9, "F1 = #Hilfe",    F1 },
  { TRUE, 50, 4, " #tu dies ",     NOKEY },
  { TRUE, 50, 5, " tu da#s  ",     NOKEY }
 };

ABGROUP tb_abs = { 5, 0, tb_absdef };

/*-- Beschreibung der einzelnen Dialogfelder -------------------------------*/

DLGDATEN tb_dfvek[] =
 {
  EDIT(tb_dlgf1),                     /* die Reihenfolge bestimmt auch die  */
  EDIT(tb_dlgf2),                     /* Reihenfolge, mit der die einzelnen */
  EDIT(tb_dlgf3),                     /* Felder mit TAB und mit SHIFT TAB   */
  ACTBUT(tb_abs)                      /* angesprungen werden knnen         */
 };

/*-- Beschreibung der Dialogbox --------------------------------------------*/

DIGDES testbox = { 8, 8, 65, 11, 4, paint, tb_dfvek };

/*****************************************************************************
*  Funktion         : p a i n t                                              *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird von der Dialog-Prozedur DlgStart whrend des Auf- *
*                     baus der Demo-Dialogbox aufgerufen.                    *
*  Eingabe-Parameter: keine                                                  *
*  Return-Wert      : keiner                                                 *
*****************************************************************************/

void paint( void )
{
 VioPrint( VL(28), VO(0), F(hi), FALSE, " DEMOBOX " );    /* Titel ausgeben */
 VioPrintf( VL(0), VU(-2), F(dlgbox), FALSE, "%s",
            VioStrep( '', VR(-1) - VL(1) + 1 ) );
 DlgBox( 1, 1, 45, 7, EINRA, " EDIT-Felder ", FALSE );
 DlgBox( 47, 2, 17, 6, EINRA, " Action Button ", FALSE );
}

/*==========================================================================*/
/*== Hauptprogramm =========================================================*/
/*==========================================================================*/

void main( void )
{
 BYTE    auswahl;          /* nimmt Nr. des ausgewhlten Action-Buttons auf */
 BEREICH bereich;            /* Koordinaten des OK-Buttons im Hilfe-Fenster */
 BOOL    ende;

 VioInit();                     /* die SAA-Modul VIO und KBM initialisieren */
 KbmInit();

 SetMengeAN( f1menge );           /* die drei Eingabemengen initialisieren  */
 SetMengeDatei( f2menge );
 SetMengeInt( f3menge );

 if ( VioIsColor() )                /* ist ein Color-Adapter angeschlossen? */
  dlgcol = demofarbe;      /* Ja, Farbeinstellungen fr Dialogbox vornehmen */
 VioClearScreen( VioIsColor() ? COL( WEISS, BLAU ) : NORMAL );
 VioClear( 0, 0, anzcol-1, 0, VioIsColor() ? COL( WEISS, ROT ) : INVERS );
 VioPrint( 22, 0, VioIsColor() ? COL( WEISS, ROT ) : INVERS , FALSE,
           "DLGDEMO - (c) 1989 by MICHEAL TISCHER");
 MouShowMouse();                                    /* Maus-Cursor anzeigen */

 do                                                      /* Eingabeschleife */
  {
   auswahl = DlgStart( &testbox ); /* Dlgbox aufb., Eingaben entgegennehmen */
   if ( auswahl == 2 )                              /* Hilfetaste bettigt? */
    {                                                                 /* Ja */
     /*-- Hilfe-Fenster ffnen und aufbauen --------------------------------*/

     MouHideMouse();                              /* Maus-Cursor ausblenden */
     VioWinOpen( 40, 16, 73, 24 );
     VioFrame( VL(0), VO(0), VR(0), VU(0), DOPRA, F(dlgbox) );
     VioClear( VL(1), VO(1), VR(-1), VU(-1), F(nm) );
     VioPrint( VL(13), VO(0), F(hi), FALSE, " Hilfe! " );
     VioPrint( VL(7), VO(2), F(nm), FALSE, "Bitte \x11 bettigen" );
     VioFrame( VL(21), VO(5), VR(-3), VU(-1), EINRA, F(dlgbox) );
     VioPrint( VL(25), VO(6), F(nm), FALSE, "OK" );
     MouPushPara();                                /* Mausparameter sichern */
     bereich.x1 = VL(21);                   /* Position des OK-Felds setzen */
     bereich.y1 = VO( 5);
     bereich.x2 = VR(-3);
     bereich.y2 = VU(-1);
     bereich.ptr_mask = MouPtrMask( PTRDIFCHAR( 251 ), PTRDIFCOLB( 0x70 ) );
     MouSetBereich( 1, &bereich );                /* das OK-Feld definieren */
     ende = FALSE;
     MouShowMouse();
     do
      {                                                 /* auf Event warten */
       if ( KbmEventWait( EV_LEFT_PRESS | EV_KEY_AVAIL ) & EV_KEY_AVAIL )
        ende = ( KbdGetKey() == CR );              /* Taste. Ist es Return? */
       else                              /* linker Mausknopf niedergedrckt */
        if ( MouGetBereich() == 0 )                          /* im OK-Feld? */
         {                          /* Ja, auf Loslassen des Buttons warten */
          KbmEventWait( EV_LEFT_REL );
          ende = TRUE;
         }
      }
     while ( !ende );
     MouPopPara();                       /* alte Mausparameter restaurieren */
     MouHideMouse();                              /* Maus-Cursor ausblenden */
     VioWinClose( TRUE );
     MouShowMouse();
    }
  }
 while ( auswahl!=0  &&  auswahl!=1 );

 MouHideMouse();                           /* Maus-Cursor wieder ausblenden */
 VioSetCursor( 0, 0 );              /* Cursor in obere linke Bildschirmecke */
}
