/****************************************************************************/
/*                            D L G E D I T . C                             */
/*--------------------------------------------------------------------------*/
/*    Aufgabe        : Enthlt die Funktionen zur Verwaltung von EDIT-      */
/*                     Feldern, die innerhalb von Dialog-Boxen zum Einsatz  */
/*                     kommen.                                              */
/*                     Dieses Modul mu in Verbindumg mt dem DLG-Modul zum  */
/*                     Einsatz kommen.                                      */
/*--------------------------------------------------------------------------*/
/*    Autor          : MICHAEL TISCHER                                      */
/*    entwickelt am  : 13.07.1989                                           */
/*    letztes Update : 17.07.1989                                           */
/*--------------------------------------------------------------------------*/
/*    Erstellung     : CL /A[S|M|C|L|H] DLGEDIT.C /C                        */
/*                     dann mit dem DLG-Modul und anderen Moduln verbinden  */
/****************************************************************************/

/*-- Include-Dateien einbinden ---------------------------------------------*/

#include <string.h>
#include <memory.h>
#include <malloc.h>
#include <dos.h>
#include "dlg.h"

/*-- interne Datenstrukturen des Dialogtyps EDIT ---------------------------*/

typedef struct  /* diese Daten werden fr jedes einzelne EDIT-Feld festgeh. */
 {
  BOOL     aktiv,                      /* ist das Dialog-Feld gerade aktiv? */
           maus,                        /* linker Mausknopf niedergedrckt? */
           insert;                                 /* zeigt INSERT-Modus an */
  BYTE     x,        /* Nr der Bildschirmspalte am linken Rand des E-Feldes */
           y,                                               /* Ausgabezeile */
           xlinks,            /* Nummer der ersten sichtbaren Eingabespalte */
           xcur;     /* Cursorpos. relativ zur linken Rand des Eingabefelds */
  TASTE    hotkey;            /* ist 0, wenn das Feld keinen Hotkey besitzt */
  EDITFELD d;                            /* die Daten aus der Edit-Struktur */
 } EDITINTERN;

typedef EDITINTERN * EDITP;        /* Zeiger auf eine interne EDIT-Struktur */

/*-- Konstanten ------------------------------------------------------------*/

#define FILL_CHAR 255         /* Fll-Zeichen zur Unterscheidung von Spaces */
#define INSERT    338                   /* INSERT-Taste, in KBM.H vergessen */

/*-- Prototypen der EDIT-Funktionen, die in diesem Modul deklariert und in -*/
/*-- der globalen Variable std_edit_fkt zusammengefat werden              -*/

void * edit_start ( EDITFELD * dptr );
void   edit_newval( EDITP ep, void * dptr );
void   edit_ende  ( EDITP ep );
BYTE   edit_taste ( EDITP ep, TASTE key );
void   edit_deak  ( EDITP ep );
void   edit_aktiv ( EDITP ep, BYTE why );
BYTE   edit_maus  ( EDITP ep, BYTE x, BYTE y, BYTE ev );
BOOL   edit_can   ( EDITP ep );

/*-- globale Variablen, ffentlich -----------------------------------------*/

DLGFKT std_edit_fkt =                     /* Standard Dialog-Funktionen fr */
 {                                        /* ein EDIT-Dialogfeld            */
   edit_start, edit_newval, edit_ende , edit_taste,
   edit_deak,  edit_maus,   edit_aktiv, edit_can
 };

/*****************************************************************************
* E D I T        Es folgen die verschiedenen Funktionen des Dialogtyps EDIT  *
*                ( alphanumerische Eingabefelder )                           *
*****************************************************************************/

/*****************************************************************************
*  Funktion         : E d S e t M e n g e                                    *
**--------------------------------------------------------------------------**
*  Aufgabe          : Dient einem Programm, das eine Dialog-Box erstellen    *
*                     mchte, bei der Definition der Eingabemenge fr ein    *
*                     Edit-Feld                                              *
*  Eingabe-Parameter: MPTR = Zeiger auf den Puffer der Eingabemenge          *
*                     VON  = ASCII-Code des ersten erlaubten Zeichens        *
*                     BIS  = ASCII-Code des letzten erlaubten Zeichens       *
*                     SET  = TRUE wenn die Zeichen erlaubt sein sollen,      *
*                            sonst FALSE                                     *
*  Return-Wert      : keiner                                                 *
*  Info             : Die Funktion darf beliebig oft aufgerufen werden, um   *
*                     nacheinander verschiedene Zeichenbereiche als erlaubt  *
*                     zu markieren.                                          *
*****************************************************************************/

void EdSetMenge( EMP mptr, BYTE von, BYTE bis, BOOL set )
{
 int  imin,              /* Indexadressen fr Zugriff auf den Mengen-Vektor */
      imax;
 BYTE i;                                                 /* Schleifenzhler */

 imin = von + 7 >> 3;              /* Inidizes fr Zugriffe auf den Mengen- */
 imax = bis - 7 >> 3;              /* Vektor ber MEMSET berechnen          */
 if ( imax > imin )            /* wird mindestens ein Byte komplett belegt? */
  {                                          /* Ja,  Bytes imin-imax setzen */
   memset( mptr + imin, set ? 0xff : 0, imax - imin + 1 );

   /*-- die Bits setzen, die vor IMIN liegen------------------------------- */

   if ( ( von & 7 ) != 0)                         /* gibt es Bits vor IMIN? */
    {                                                                 /* ja */
     if ( set )                                             /* Bits setzen? */
      *(mptr + imin - 1) |= ~( 0xff << ( 8 - ( von & 7 ) ) );         /* Ja */
     else                                             /* Nein, Bits lschen */
      *(mptr + imin - 1) &= ( 0xff << ( 8 - ( von & 7 ) ) );
    }

   /*-- die Bits setzen, die hinter IMAX liegen---------------------------- */

   if ( ( bis & 7 ) != 7)                      /* gibt es Bits hinter IMAX? */
    {                                                                 /* Ja */
     if ( set )                                              /* Bits setzen */
      *(mptr + imax + 1) |= ( 0xff << ( 7 - ( bis & 7 ) ) );          /* Ja */
     else                                                  /* Nein, lschen */
      *(mptr + imax + 1) &= ~( 0xff << ( 7 - ( bis & 7 ) ) );
    }
  }
 else                                       /* nein die Bits einzeln setzen */
  if ( set )                                   /* Bits setzen oder lschen? */
   for ( i = von ; i <= bis ; ++i )                               /* setzen */
    *(mptr + ( i >> 3 )) |= ( 1 << ( 7 - ( i & 7 ) ) );
  else                                                           /* lschen */
   for ( i = von ; i <= bis ; ++i )
    *(mptr + ( i >> 3 )) &= ~( 1 << ( 7 - ( i & 7 ) ) );
}

/*****************************************************************************
*  Funktion         : e d i t _ f i l l                                      *
**--------------------------------------------------------------------------**
*  Aufgabe          : Fllt den Eingabe-String eines Edit-Feldes auf seine   *
*                     maximale Lnge mit dem Fllzeichen FILL_CHAR auf.      *
*  Eingabe-Parameter: EP  = Zeiger auf eine interne EDIT-Datenstruktur.      *
*  Return-Wert      : keiner                                                 *
*  Info             : Diese Funktion findet nur intern Verwendung, sie wird  *
*                     nicht vom Scheduler aufgerufen.                        *
*****************************************************************************/

void edit_fill( EDITP ep )
{
 BYTE  lstr,                                   /* Lnge des Eingabe-Strings */
       len,                           /* maximale Lnge des Eingabe-Strings */
     * sp;                                   /* Zeiger auf den Eingabstring */

 /*-- Eingabe-String mit gesperrten Leerzeichen (ASCII 255 ) auffllen -----*/

 lstr = strlen( sp = ep->d.eingabe );   /* Lnge des Eingabe-Str. ermitteln */
 memset( sp + lstr, FILL_CHAR, ( len = ep->d.len ) - lstr );   /* auffllen */
 *( sp + len ) = '\0';                            /* Ende-Markierung setzen */
}

/*****************************************************************************
*  Funktion         : e d i t _ s h r i n k                                  *
**--------------------------------------------------------------------------**
*  Aufgabe          : Entfernt die bei edit_fill eingefgten Leerzeichen     *
*                     aus einem Edit-String wieder und schneidet den String  *
*                     nach dem letzten eingegebenen nicht-Fllzeichen ab.    *
*  Eingabe-Parameter: EP  = Zeiger auf eine interne EDIT-Datenstruktur.      *
*  Return-Wert      : keiner                                                 *
*  Info             : Diese Funktion findet nur intern Verwendung, sie wird  *
*                     nicht vom Scheduler aufgerufen.                        *
*****************************************************************************/

void edit_shrink( EDITP ep )
{
 BYTE   i,                                               /* Schleifenzhler */
      * lp,                              /* Laufzeiger in den Eingabestring */
      * sp;                     /* Zeiger auf den Anfang des Eingabestrings */

 lp = ( sp = ep->d.eingabe ) + ( i = ep->d.len ) - 1;    /* von hinten nach */
 for (  ; i  &&  *lp == FILL_CHAR; --i, --lp )           /* vorne suchen    */
  ;
 *( lp+1 ) = '\0';                                    /* String abschlieen */

 /*-- alle vorhergenden FILL_CHARs in Spaces umwandeln ---------------------*/

 for ( ; lp > sp ; --lp )          /* den String bis zum Anfang durchlaufen */
  if ( *lp == FILL_CHAR )                            /* FILL_CHAR entdeckt? */
   *lp = ' ';                                     /* Ja, in Space umwandeln */
}

/*****************************************************************************
*  Funktion         : e d i t _ t o g g l e _ i n s e r t                    *
**--------------------------------------------------------------------------**
*  Aufgabe          : Schaltet den Insert-Status eines EDIT-Feldes um und    *
*                     definiert einen Block-Cursor, falls der INSERT-Modus   *
*                     aktiviert wird.                                        *
*  Eingabe-Parameter: EP  = Zeiger auf eine interne EDIT-Datenstruktur.      *
*  Return-Wert      : keiner                                                 *
*  Info             : Diese Funktion findet nur intern Verwendung, sie wird  *
*                     nicht vom Scheduler aufgerufen.                        *
*****************************************************************************/

void edit_toggle_insert( EDITP ep )
{
 union REGS   regs;                /* Prozessorregister zum Interruptaufruf */

 /*-- Register CL und CH mit Start- und Endzeile des Cursors laden ---------*/

 regs.h.cl = VioIsColor() ? 7 : 13;                      /* Cursor-Endzeile */
 regs.h.ch = (ep->insert = !ep->insert) ? 0 : regs.h.cl-1;    /* Startzeile */
 regs.h.ah = 0x01;                                     /* Cursor definieren */
 int86( 0x10, &regs, &regs );                        /* Video-BIOS aufrufen */
}

/*****************************************************************************
*  Funktion         : e d i t _ p r i n t                                    *
**--------------------------------------------------------------------------**
*  Aufgabe          : Gibt den EDIT-String eines EDIT-Feldes auf dem Bild-   *
*                     schirm aus.                                            *
*  Eingabe-Parameter: EP    = Zeiger auf eine interne EDIT-Datenstruktur.    *
*                     FARBE = Ausgabefarbe des Strings                       *
*  Return-Wert      : keiner                                                 *
*  Info             : - Diese Funktion findet nur intern Verwendung, sie     *
*                       wird nicht vom Scheduler aufgerufen.                 *
*                     - Ausgabeposition und auszugebender Teil des EDIT-     *
*                       Strings ergeben sich aus den Informationen in der    *
*                       bergebenen Datenstruktur.                           *
*****************************************************************************/

void edit_print( register EDITP ep, BYTE farbe )
{
 BYTE   merke,                     /* merkt sich ein Zeichen aus dem String */
      * mpos,                               /* Zeiger auf das Merke-Zeichen */
      * start;                                           /* Ausgabeposition */

 /*-- Zeichen mit Hilfe von VioPrint ausgeben, indem hinter das letzte -----*/
 /*-- auszugebende Zeichen eine Ende-Markierung geschrieben wird       -----*/

 merke = *(mpos = (start=ep->d.eingabe+ep->xlinks) + ep->d.visi );
 *mpos = '\0';                       /* Ende-Markierung fr VioPrint setzen */
 VioPrint( ep->x, ep->y, farbe, FALSE, start );          /* String ausgeben */
 *mpos = merke;                            /* altes Zeichen zurckschreiben */
}

/*****************************************************************************
*  Funktion         : e d i t _ s t a r t                                    *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler whrend der Initialisierung einer   *
*                     Dialogbox fr jedes EDIT-Feld aufgerufen.              *
*  Eingabe-Parameter: DPTR = Zeiger auf den Datenblock des EDIT-Feldes.      *
*  Return-Wert      : Ein Zeiger, den der Scheduler bei allen folgenden Auf- *
*                     rufen den Funktionen edit_aktiv, edit_tast etc. ber-  *
*                     gibt.                                                  *
*****************************************************************************/

void * edit_start ( EDITFELD * dptr )
{
 EDITP ep;              /* Zeiger auf die anzulegende interne Datenstruktur */
 BYTE  farbe_n,                                    /* Ausgabefarbe fr Feld */
       farbe_h,                     /* Farbe des Hotkeys (soweit vorhanden) */
       s,                        /* nimmt Startspalte des Eingabefeldes auf */
       z;                                         /* nimmt Ausgabezeile auf */

 /*-- Speicherplatz fr interne Struktur allok. und Struktur initialisieren */

 ep = (EDITP) malloc( sizeof( EDITINTERN ) );   /* Speicherplatz allokieren */
 z = ep->y = VO( dptr->y );                          /* Ausgabezeile merken */
 ep->xlinks = ep->xcur = 0; /* Cursor am linken Rand des Feldes in Spalte 0 */
 ep->maus = ep->aktiv = ep->insert = FALSE;             /* alle Flags FALSE */

 ep->d = *dptr;                                   /* EDIT-Struktur kopieren */

 /*-- Eingabefeld auf dem Bildschirm aufbauen ------------------------------*/

 farbe_n = ( dptr->enabled ) ? F(nm) : F(da);     /* Ausgabefarbe festlegen */
 farbe_h = ( dptr->enabled ) ? F(hk) : F(dk);     /* Ausgabefarbe festlegen */

 ep->hotkey = DlgPrint( VL( dptr->x ), z, dptr->text, farbe_n, farbe_h );
 s = VL( strlen( dptr->text ) + dptr->x + 1 );      /* Ausgabesp. im E-Feld */
 if ( ep->hotkey != NOKEY )                   /* wurde ein Hotkey entdeckt? */
  --s;        /* Ja, Spalte  mu dekermentiert werden, weil '#' nicht zhlt */
 VioPrint( (ep->x=s)-1, z, farbe_n, FALSE, "[" );     /* Begrenzer ausgeben */
 VioPrint( s + dptr->visi , z, farbe_n, FALSE, "]" );

 edit_fill( ep );                                /* Eingabestring auffllen */
 edit_print( ep, farbe_n );             /* Inhalt des Eingabefelds ausgeben */
 edit_shrink( ep );                          /* String in alte Form bringen */

 return ep;                 /* Zeiger auf internen Datenblock zurckliefern */
}

/*****************************************************************************
*  Funktion         : e d i t _ n e w v a l                                  *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird nicht direkt vom Scheduler, sondern von einer mit *
*                     ihm zusammenarbeitenden Interaktions-Funktion aufge-   *
*                     rufen, wenn sich der Inhalt eines EDIT-Feldes durch    *
*                     ueres Ereignis verndert hat.                        *
*  Eingabe-Parameter: EP = der Zeiger, der beim Aufruf von edit_start zu-    *
*                          rckgeliefert wurde.                              *
*  Return-Wert      : keiner                                                 *
*****************************************************************************/

void edit_newval( EDITP ep, void * dptr )
{
}

/*****************************************************************************
*  Funktion         : e d i t _ l i n k s                                    *
**--------------------------------------------------------------------------**
*  Aufgabe          : Bewegt den Cursor im Edit-Feld um eine Spalte nach     *
*                     links.                                                 *
*  Eingabe-Parameter: EP = der Zeiger, der beim Aufruf von edit_start zu-    *
*                          rckgeliefert wurde.                              *
*  Return-Wert      : keiner                                                 *
*  Info             : - Diese Funktion findet nur intern Verwendung, sie     *
*                       wird nicht vom Scheduler aufgerufen.                 *
*****************************************************************************/

void edit_links( EDITP ep )
{
 if ( ep->xcur )                      /* Cursor am linken Rand des E-Felds? */
  VioSetCursor( ep->x + --ep->xcur, ep->y );         /* Nein, nur neue Pos. */
 else                                                                 /* Ja */
  if ( ep->xlinks )                     /* bereits erstes Zeichen sichtbar? */
   {                              /* Nein, Eingabefeld nach rechts scrollen */
    --ep->xlinks;
    edit_print( ep, F(hi) );                           /* Feld neu ausgeben */
   }
}

/*****************************************************************************
*  Funktion         : e d i t _ r e c h t s                                  *
**--------------------------------------------------------------------------**
*  Aufgabe          : Bewegt den Cursor im Edit-Feld um eine Spalte nach     *
*                     rechts.                                                *
*  Eingabe-Parameter: EP = der Zeiger, der beim Aufruf von edit_start zu-    *
*                          rckgeliefert wurde.                              *
*  Return-Wert      : keiner                                                 *
*  Info             : - Diese Funktion findet nur intern Verwendung, sie     *
*                       wird nicht vom Scheduler aufgerufen.                 *
*****************************************************************************/

void edit_rechts( EDITP ep )
{
 if ( ep->xcur != ep->d.visi-1)                       /* Cursor am r. Rand? */
  VioSetCursor( ep->x + ++ep->xcur, ep->y );         /* Nein, nur neue Pos. */
 else                              /* Ja, bereits letztes Zeichen sichtbar? */
  if ( ep->xlinks < ep->d.len - ep->d.visi )
   {                               /* Nein, Eingabefeld nach links scrollen */
    ++ep->xlinks;
    edit_print( ep, F(hi) );                           /* Feld neu ausgeben */
   }
}

/*****************************************************************************
*  Funktion         : e d i t _ e n d e                                      *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler whrend des Schlieens der Dialog-  *
*                     box aufgerufen, um EDIT Gelgegenheit zu geben, Clean-  *
*                     Up-Arbeiten durchzufhren.                             *
*  Eingabe-Parameter: EP = der Zeiger, der beim Aufruf von edit_start zu-    *
*                          rckgeliefert wurde.                              *
*  Return-Wert      : keiner                                                 *
*****************************************************************************/

void edit_ende( EDITP ep )
{
 free( ep );                 /* den allokierten Datenblock wieder freigeben */
}

/*****************************************************************************
*  Funktion         : e d i t _ t a s t e                                    *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um dem Dialog-Feld eine *
*                     Taste zu bergeben.                                    *
*  Eingabe-Parameter: EP    = der Zeiger, der beim Aufruf von edit_start zu- *
*                             rckgeliefert wurde.                           *
*                     TASTE = Code der zu bearbeitenden Taste                *
*  Return-Wert      : Reaktionscode (TF_...)                                 *
*****************************************************************************/

BYTE edit_taste( EDITP ep, TASTE key )
{
 BYTE   i,                                               /* Schleifenzhler */
        zeichen,          /* Zeichen an letzter Eingabepos. im INSERT-Modus */
      * lp,                    /* Zeiger zum Durchlaufen des Eingabestrings */
      * sp,                    /* Zeiger auf den Anfang des Eingabe-Strings */
        retcode;                                             /* Return-Code */

 if ( ep->aktiv )                             /* ist das Dialog-Feld aktiv? */
  {                                                                   /* Ja */
   MouHideMouse();                                /* Maus-Cursor ausblenden */
   switch ( key )                                      /* Taste untersuchen */
    {
     case TAB     :      /*-------------------------------------------- Tab */
      retcode = TF_FELD_VOR;
      break;

     case BACKTAB :      /*---------------------------------------- BackTab */
      retcode = TF_FELD_RUECK;
      break;

     case INSERT  :      /*------------------------------ Insert umschalten */
      edit_toggle_insert( ep );                 /* Insert-Status umschalten */
      retcode = TF_ACCEPTED;                  /* die Taste wurde akzeptiert */
      break;

     case CLEFT   :      /*----------------------------------- Cursor links */
      edit_links( ep );
      retcode = TF_ACCEPTED;                  /* die Taste wurde akzeptiert */
      break;

     case CRIGHT  :      /*---------------------------------- Cursor rechts */
      edit_rechts( ep );
      retcode = TF_ACCEPTED;                  /* die Taste wurde akzeptiert */
      break;

     case CHOME   :      /*------------------------------------ Cursor Home */
      ep->xlinks = ep->xcur = 0;
      VioSetCursor( ep->x + ep->xcur, ep->y );  /* Cursor neu positionieren */
      edit_print( ep, F(hi) );                         /* Feld neu ausgeben */
      retcode = TF_ACCEPTED;                  /* die Taste wurde akzeptiert */
      break;

     case CEND    :      /*------------------------------------- Cursor End */
      /*-- letztes nicht FILL_CHAR-Zeichen suchen-------------------------- */

      lp = ep->d.eingabe + ( i = ep->d.len ) - 1;        /* von hinten nach */
      for (  ; i  &&  *lp == FILL_CHAR; --i, --lp )      /* vorne suchen    */
       ;
      if ( i < ep->d.visi )   /* ist Zeichen unter den ersten VISI-Zeichen? */
       {                         /* Ja, Eingabe ab erstem Zeilen darstellen */
       ep->xlinks = 0;
       ep->xcur   = i;
       }
      else              /* Nein, Eingabe so darstellen, da sich der Cursor */
       {                /* in der letzten Spalte des Eingabefeldes befindet */
       ep->xlinks = i - ep->d.visi + 1;
       if ( i == ep->d.len )            /* ist die letzte Pos. beschrieben? */
        --ep->xlinks;               /* Ja, Cursor steht auf letztem Zeichen */
       ep->xcur = ep->d.visi - 1;     /* Cursor in letzte Ausgabesp. setzen */
       }
      edit_print( ep, F(hi) );                         /* Feld neu ausgeben */
      VioSetCursor( ep->x + ep->xcur, ep->y );  /* Cursor neu positionieren */
      retcode = TF_ACCEPTED;                  /* die Taste wurde akzeptiert */
      break;

     case DELETE  :      /*----------------------------------------- Delete */
      lp = ep->d.eingabe + ( i = ep->xlinks + ep->xcur );
      memmove( lp, lp+1, ep->d.len - i - 1);         /* Zeichen heranziehen */
      *( ep->d.eingabe + ep->d.len - 1 ) = FILL_CHAR;            /*auffllen*/
      edit_print( ep, F(hi) );                         /* Feld neu ausgeben */
      retcode = TF_ACCEPTED;                  /* die Taste wurde akzeptiert */
      break;

     case BS      :      /*-------------------------------------- Backspace */
      if ( ep->xcur  ||  ep->xlinks )         /* Cursor auf erstem Zeichen? */
       {  /* Nein, Zeichen ab Cursorpos. um ein Zeichen nach links schieben */
       lp = ep->d.eingabe + ( i = ep->xlinks + ep->xcur );
       memmove( lp-1, lp, ep->d.len - i);            /* Zeichen heranziehen */
       *( ep->d.eingabe + ep->d.len - 1 ) = FILL_CHAR;           /*auffllen*/
       if ( ep->xcur )                /* Cursor am linken Rand des E-Felds? */
        {                                                           /* Nein */
         --ep->xcur;                     /* eine Spalte nach links schieben */
         VioSetCursor( ep->x + ep->xcur, ep->y );        /* Cursor neu pos. */
        }
       else                         /* Ja, Eingabefeld nach rechts scrollen */
        --ep->xlinks;
       edit_print( ep, F(hi) );                        /* Feld neu ausgeben */
       }
      retcode = TF_ACCEPTED;                  /* die Taste wurde akzeptiert */
      break;

     case CTRL_HOME:     /*------------------------------------ Ctrl + Home */
      memset( ep->d.eingabe, FILL_CHAR, ep->d.len );  /* Eingabe-Str leeren */
      edit_print( ep, F(hi) );                         /* Feld neu ausgeben */
      retcode = TF_ACCEPTED;                  /* die Taste wurde akzeptiert */
      break;

     default :           /*--------------------------- jedes andere Zeichen */
      if ( key < 256 &&
           (*(ep->d.mptr + (key >> 3)) & (1 << (7 - (key & 7)))) )
       {            /* das Zeichen darf laut Eingabemenge eingegeben werden */
        i = ep->xlinks + ep->xcur;    /* Offsetposition in Eingbe-Str. ber. */
        lp = ep->d.eingabe + i;    /* Zeiger auf akt. Pos. eim Eingabe-Str. */
        if ( ep->insert )                               /* Im Insert-Modus? */
         {                        /* Ja, letztes Zeichen mu noch leer sein */
          if ( (zeichen = *(ep->d.eingabe+ep->d.len-1)) == ' '  ||
                zeichen == FILL_CHAR )
           {                               /* letztes Zeichen ist noch leer */
            if ( i != ep->d.len - 1 )        /* Cursor auf letztem Zeichen? */
             memmove( lp+1, lp, ep->d.len - i - 1); /*N, Zeichen wegschieben*/
            *lp = key;                   /* Taste im Eingabe-Str. speichern */
            if ( ep->xcur != ep->d.visi-1)            /* Cursor am r. Rand? */
              VioSetCursor( ep->x + ++ep->xcur, ep->y );            /* Nein */
            else                                                      /* Ja */
             if ( i != ep->d.len - 1 )       /* Cursor auf letztem Zeichen? */
               ++ep->xlinks;     /* ganzes Eingabefeld nach rechts scrollen */
            edit_print( ep, F(hi) );                   /* Feld neu ausgeben */
           }
         }
        else                                       /* nicht im Insert-Modus */
         {
          *lp = key;                     /* Taste im Eingabe-Str. speichern */
          if ( ep->xcur != ep->d.visi-1)              /* Cursor am r. Rand? */
           {                         /* Nein, nur das neue Zeichen ausgeben */
            VioPrintf( ep->x+ep->xcur, ep->y, F(hi), FALSE, "%c", (char) key);
            VioSetCursor( ep->x + ++ep->xcur, ep->y ); /*Nein, nur neue Pos.*/
           }
          else                     /* Ja, bereits letztes Zeichen sichtbar? */
           {
            if ( i != ep->d.len - 1 )
             ++ep->xlinks;                    /* Nein, nach rechts scrollen */
            edit_print( ep, F(hi) );                   /* Feld neu ausgeben */
           }
         }
        retcode = TF_ACCEPTED;                /* die Taste wurde akzeptiert */
       }
      else               /* die Taste wurde nicht akzeptiert, weiterreichen */
        retcode = TF_WEITER;
      break;
    }
   MouShowMouse();                           /* Maus-Cursor wieder anzeigen */
   return retcode;                             /* Return-Code zurckliefern */
  }
 else                            /* Feld ist nicht aktiv, auf Hotkey testen */
  return (ep->hotkey == key  &&  ep->d.enabled) ? TF_AKTIV : TF_WEITER;
}

/*****************************************************************************
*  Funktion         : e d i t _ d e a k                                      *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um das Dialog-Feld von  *
*                     seiner Deaktivierung in Kenntnis zu setzen.            *
*  Eingabe-Parameter: EP = der Zeiger, der beim Aufruf von edit_start zu-    *
*                          rckgeliefert wurde.                              *
*  Return-Wert      : keiner                                                 *
*****************************************************************************/

void edit_deak( EDITP ep )
{
 /*-- farbliche Hervorhebung des Feldes zurcknehmen -----------------------*/

 MouHideMouse();                                  /* Maus-Cursor ausblenden */
 VioPrint( ep->x-1, ep->y, F(nm), FALSE, "[" );
 VioPrint( ep->x + ep->d.visi, ep->y, F(nm), FALSE, "]" );
 ep->xlinks = ep->xcur = 0;                /* Feld ab Position 0 darstellen */
 edit_print( ep, F(nm) );
 ep->maus = ep->aktiv = FALSE;                          /* nicht mehr aktiv */
 if ( ep->insert )                           /* ist der Insert-Modus aktiv? */
  edit_toggle_insert( ep );                               /* Ja, abschalten */
 edit_shrink( ep );                          /* String in alte Form bringen */
 VioHideCursor();                        /* Cursor vom Bildschirm entfernen */
 MouShowMouse();                           /* Maus-Cursor wieder einblenden */
}

/*****************************************************************************
*  Funktion         : e d i t _ m a u s                                      *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um dem Dialog-Feld ein  *
*                     Mausereignis zu bergeben                              *
*  Eingabe-Parameter: EP    = der Zeiger, der beim Aufruf von edit_start zu- *
*                             rckgeliefert wurde.                           *
*                     X, Y  = Position des Mauscursors realtiv zu oberen     *
*                             linken Bildschirmecke                          *
*                     EV    = Event-Maske, die das Ereignis beschreibt, um   *
*                             dessentwillen die Funktion aufgerufen wird     *
*  Return-Wert      : Reaktionscode (TF_...)                                 *
*****************************************************************************/

BYTE edit_maus( EDITP ep, BYTE x, BYTE y, BYTE ev )
{
 if ( ep->aktiv )                            /* ist das Feld bereits aktiv? */
  {                         /* Ja, Status des linken Mausknopfs feststellen */
   if ( ev & EV_LEFT_REL )        /* wurde der linke Mausknopf losgelassen? */
    {
     ep->maus = FALSE;
     return TF_WEITER;                        /* Ja, Ereignis weiterreichen */
    }
   else                                     /* Nein, Mausposition auswerten */
    if ( ep->maus )                            /* auf Mausbewegung eingehen */
     {
      if ( x < ep->x )                            /* links vom Eingabefeld? */
       {                                                              /* Ja */
        edit_links( ep );                  /* Cursor eine Spalte nach links */
        MausPause();                    /* Programmausfhrung kurz anhalten */
       }
      else
       if ( x >= ep->x + ep->d.visi )            /* rechts vom Eingabefeld? */
        {                                                             /* Ja */
         edit_rechts( ep );               /* Cursor eine Spalte nach rechts */
         MausPause();                   /* Programmausfhrung kurz anhalten */
        }
       else                                        /* Cursor im Eingabefeld */
        {
         ep->xcur = x - ep->x;                    /* Cursorspalte berechnen */
         VioSetCursor( ep->x + ep->xcur, ep->y );          /* Cursor setzen */
        }
      return TF_ACCEPTED;
     }
    else                              /* die Maus wird noch nicht berwacht */
     {               /* befindet sich die Maus innerhalb des Eingabefeldes? */
      if ( y==ep->y  &&  x>=ep->x  &&  x<= ep->x+ep->d.visi-1 )
       {                                                              /* Ja */
        ep->xcur = x - ep->x;           /* Cursorpos. im Eingabefeld merken */
        ep->maus = TRUE;                         /* Mausbewegung berwachen */
        return TF_ACCEPTED;
       }
      else                              /* Maus auerhalb des Eingabefeldes */
       return TF_WEITER;
     }
  }
 else                            /* Nein, testen ob es jetzt aktiviert wird */
  {
   if ( ( ev & EV_LEFT_PRESS )     &&          /* linker Maus-Button mu    */
        y == ep->y                 &&          /* niedergedrckt sein und   */
        x >= ep->x                 &&          /* der Maus-Cursor mu sich  */
        x <= ep->x + ep->d.visi -1 &&          /* im Eingabefeld befinden   */
        ep->d.enabled                 )        /* und Feld mu enabled sein */
    {
     ep->xcur = x - ep->x;              /* Cursorpos. im Eingabefeld merken */
     ep->maus = TRUE;                            /* Mausbewegung berwachen */
     return TF_MAUS;
    }
   else          /* obige Bedingung wird nicht erfllt, Event weiterreichen */
    return TF_WEITER;
  }
}

/*****************************************************************************
*  Funktion         : e d i t _ c a n                                        *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um festzustellen, ob    *
*                     das Dialogfeld bereit ist, aktiviert zu werden.        *
*  Eingabe-Parameter: EP = der Zeiger, der beim Aufruf von edit_start zu-    *
*                          rckgeliefert wurde.                              *
*  Return-Wert      : TRUE, wenn das Dialog-Feld aktiviert werden kann,      *
*                     sonst FALSE                                            *
*****************************************************************************/

BOOL edit_can( EDITP ep )
{
 return ep->d.enabled;       /* ENABLE-Flag aus EDIT-Struktur zurckliefern */
}

/*****************************************************************************
*  Funktion         : e d i t _ a k t i v                                    *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um das Dialog-Feld von  *
*                     seiner Aktivierung in Kenntnis zu setzen.              *
*  Eingabe-Parameter: EP = der Zeiger, der beim Aufruf von edit_start zu-    *
*                          rckgeliefert wurde.                              *
*                     WHY= warum wurde das Feld aktiviert.                   *
*  Return-Wert      : keiner                                                 *
*  Info             : Der WHY-Parameter enthlt eine der TF_...-Konstanten   *
*                     wie TF_FELD_VOR, TF_MAUS etc.                          *
*****************************************************************************/

void edit_aktiv( EDITP ep, BYTE why )
{
 /*-- Dialog-Feld farblich hervorheben, Cursor anzeigen --------------------*/

 if ( !ep->aktiv )                           /* ist das Feld bereits aktiv? */
  {                                                                 /* Nein */
   MouHideMouse();                                /* Maus-Cursor ausblenden */
   if ( why != TF_MAUS )                         /* Aktivierung durch Maus? */
     ep->xcur = 0;                           /* Nein, Cursor an linken Rand */
   VioPrint( ep->x-1, ep->y, F(hi), FALSE, "[" );
   VioPrint( ep->x + ep->d.visi, ep->y, F(hi), FALSE, "]" );
   ep->xlinks = 0;              /* Cursor steht am linken Rand des E-Feldes */
   edit_fill( ep );                             /* Eingabesgtring auffllen */
   edit_print( ep, F(hi) );                       /* Eingabestring ausgeben */
   VioSetCursor( ep->x + ep->xcur, ep->y );
   ep->aktiv = TRUE;                                /* Feld ist jetzt aktiv */
   MouShowMouse();                         /* Maus-Cursor wieder einblenden */
  }
}
