/*********************************************************************

 ---------------- S P L I T --------- DOS-Application ---------------

**********************************************************************  

This program parses the file HELP.TXT into its single help text files.

Copyright 1989 by Marcellus Buchheit, Buchheit software research
All rights reserved.

*********************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

/* =============
   main function
   =============
*/

void main(VOID)

 {FILE *rSrcFile;
  FILE *rDestFile;
  char zLine[80+1];
  char rzFileName[80];
  char *rz;
  int nFiles=0;

  /* open source file */
  rSrcFile=fopen("HELP.TXT","rt");
  if (!rSrcFile)
   {/* file not opened: error message, abort */
    printf("SPLIT: Cannot open file HELP.TXT.\n");
    exit(2); /* unable to start operation */
   } /* if */
  fgets(zLine,sizeof(zLine)-1,rSrcFile);
  while (!feof(rSrcFile))
   {/* skip '%' in header line, create dest. file, read help text */
    rz=zLine; /* pointer to start of line */
    while (*rz=='%') rz++;
    if (rz[strlen(rz)-1]=='\n') rz[strlen(rz)-1]=0;
    strcpy(rzFileName,rz);
    rDestFile=fopen(rzFileName,"w+t");
    if (!rDestFile)
     {/* file not created: error message, abort */
      printf("SPLIT: Cannot create file %s.\n",rzFileName);
      exit(2); /* unable to start operation */
     } /* if */
    fgets(zLine,sizeof(zLine)-1,rSrcFile);
    while (!feof(rSrcFile) && zLine[0]!='%')
     {/* copy text to destination file */  
      fputs(zLine,rDestFile);
      fgets(zLine,sizeof(zLine)-1,rSrcFile);
     } /* while */
    /* close file */
    fputc(26,rDestFile);
    if (fclose(rDestFile))
     {/* cannot close destination file */
      printf("SPLIT: Cannot close file %s.\n",rzFileName);
      exit(2); /* unable to start operation */
     } /* if */
    nFiles++;
   } /* while */
  printf("%d help text files created.\n",nFiles);
  exit(0);
 } /* main() */
