title   math_module

.287                    ; MASM ber das Vorhandensein von Coprozessor-
                        ; befehlen informieren.

public  init_math
public  imul_32

        present equ     0
        missing equ     1
          
code    segment         public  'code'
        assume cs:code
        
        cp_flag         db      1       ; Status fr '87er vor-
                                        ; handen / nicht vorhanden 
        ctrl_word       dw      0       ; '87er Control-Wort
        
;-------------------------------------------------------------------;
; init_math: Sucht nach dem Coprozessor und setzt entsprechend dem 
;            Ergebnis das globale Flag cp_flag. Es gibt an, ob
;            der Coprozessor oder die Emulation benutzt werden
;            soll. Diese Routine mu daher unbedingt VOR Aufruf
;            der anderen beiden gestartet werden.
;-------------------------------------------------------------------;   

init_math       PROC    FAR

        fninit                          ; '87er initialisieren
        fnstcw  cs:ctrl_word            ; Controlwort ablegen
        cmp     byte ptr cs:[ctrl_word+1],3; Sind nur die Bits 8 und 9 
        je      yes_cp                  ; gesetzt, ist ein Co-
        mov     cs:cp_flag,missing      ; prozessor installiert
        jmp     init_math_exit          
        
yes_cp: 
        mov     cs:cp_flag,present
        
init_math_exit:
        ret
        
init_math       ENDP


;-------------------------------------------------------------------;
; imul_32: Diese Routine multipliziert zwei 32-Bit-Integer mit Vor-
;          zeichen. Sie kann auch fr die Multiplikation von zwei
;          32-Bit-Festkommazahlen genutzt werden.
;
;          Input:  Zwei 32-Bit-Integer
;                  ds:si Zeiger auf Integer A
;                  ds:di Zeiger auf Integer B
;                  
;          Output: 64-Bit-Ergebnis, abgelegt ab Adresse [es:bx]
;-------------------------------------------------------------------;

imul_32         PROC    FAR

        cmp     cs:cp_flag,missing      ; Falls kein Coprozessor
        je      emulate_imul_32         ; vorhanden, dann Emulation
                                        ; sonst 80X87 benutzen.
        fild    dword ptr [si]          ; ST(0)=A
        fimul   dword ptr [di]          ; ST(0)=A*B
        fistp   qword ptr es:[bx]               ; Ergebnis ablegen und POP
        fwait                           ; Ablage abwarten
        jmp     imul_32_exit            ; Fertig

;-------------------------------------------------------------------;
; Bei der Emulation teilen sich A und B wie folgt auf:
;       A ist ein 32-Bit-Integer bestehend aus
;         einem low word A0 und einem high word A1 und
;       B ist ein 32-Bit-Integer bestehend aus 
;         einem low word B0 und einem high word B1.
;
; Das Ergebnis wird durch Addition der vier Teilprodukte berechnet.
; Diese Teilprodukte ergeben sich aus den vorzeichenlosen Multipli-
; kationen von A0*B0, A0*B1, A1*B0 und A1*B1. Das Vorzeichen des
; Endergebnisses wird am Schlu der Berechnungen korrigiert.
;-------------------------------------------------------------------;

emulate_imul_32:
        
        push    ax              ; Zustzliche Register sichern
        push    cx
        push    dx
        push    bp
        
A0_x_B0:
        mov     ax,[si]         ; ax=A0 
        mul     word ptr [di]   ; dx=A0B0h, ax=A0B0l
        mov     es:[bx],ax      ; A0B0l ablegen (4.Spalte)
        mov     cx,dx           ; cx=A0B0h
A1_x_B0:
        mov     ax,[si+2]       ; ax=A1 
        mul     word ptr [di]   ; dx=A1B0h, ax=A1B0l
        push    bx              ; Zeiger spter wiederverwenden
        mov     bx,ax           ; bx=A1B0l 
        mov     bp,dx           ; bp=A1B0h
A0_x_B1:
        mov     ax,[si]         ; ax=A0 
        mul     word ptr [di+2] ; dx=A0B1h, ax=A0B1l
        add     cx,bx           ; cx=A0B0h+A1B1l
        adc     cx,ax           ; cx=A0B0h+A1B1l+A0B1l+carry
        pop     bx              ; Ablagezeiger holen
        mov     es:[bx+2],cx    ; 3.Spalte speichern
        push    bx              ; Zeiger spter wiederverwenden
        xor     bx,bx           ; bx lschen
        adc     bx,0            ; Carry-Information sichern
        mov     cx,dx           ; cx=A0B1h
A1_x_B1:
        mov     ax,[si+2]       ; ax=A1 
        mul     word ptr [di+2] ; dx=A1B1h, ax=A1B1l
        add     cx,bx           ; cx=A0B1h+carry
        adc     cx,bp           ; cx=A0B1h+A1B0h
        adc     cx,ax           ; cx=A0B1h+A1B0h+A1B1l+carry
        pop     bx              ; Ablagezeiger holen
        mov     es:[bx+4],cx    ; 2.Spalte speichern
        adc     dx,0            ; dx=A1B1+carry
        mov     es:[bx+6],dx    ; 1.Spalte speichern
        
; Jetzt mu noch eine Vorzeichenkorrektur durchgefhrt werden.          
                        
test_A:
        mov     ah,[si+2]       ; ah=high byte von A
        or      ah,ah           ; Falls A negativ ist,
        js      substract_B     ; subtrahiere B von  
        
test_B:         
        mov     ah,[di+2]       ; ah=high byte von B
        or      ah,ah           ; Falls B negativ ist,
        js      substract_A     ; subtrahiere A von  
        
        jmp     emulate_done
        
substract_B:
        mov     ax,[di]         ; ax=B0
        mov     cx,[di+2]       ; cx=B1
        sub     es:[bx+4],ax    ; die beiden high words abgleichen
        sbb     es:[bx+6],cx    
        jmp     test_B

substract_A:    
        mov     ax,[si]         ; ax=A0
        mov     cx,[si+2]       ; cx=B1
        sub     es:[bx+4],ax    ; die beiden high words abgleichen
        sbb     es:[bx+6],cx    

emulate_done:
        pop     bp              ; Register wiederherstellen
        pop     dx
        pop     cx
        pop     ax

imul_32_exit:
        ret
        
imul_32 ENDP

code    ends
        end
                        
