/*    
    Formatiert die spezifizierte Disk-Spur mit einem 
    Standard 360K, DSDD Spur-Format. Gibt 0 zurueck, wenn 
    die Formatierung erfolgreich ist; andernfalls wird ein 
    Fehlercode zurueckgegeben, der von der aufrufenden 
    Routine dazu verwendet werden kann, den naechsten 
    Schritt festzulegen. 
*/ 
 

#include <stdio.h> 
#include <dos.h> 
 
#define DISK    0x13 
 
fmt_trk(dsk,trk,head) 
 
int  dsk;  
int  trk; 
int  head; 
 
{ 
     union REGS regs; 
     char trktbl[36]; 
     int  i; 
 
     for(i=0; i< 9; i++){ 
          trktbl[ i*4]   = trk; 
          trktbl[ i*4+1] = head; 
          trktbl[ i*4+2] = i; 
          trktbl[ i*4+3] = 2; 
     } 
     regs.h.ah = 0x05; 
     regs.h.ch = trk; 
     regs.h.dh = head; 
     regs.h.dl = dsk; 
     regs.x.bx = trktbl; 
     int86(DISK,&regs,&regs); 
     if(regs.x.cflag) 
          return(fmt_error(regs.h.ah)); 
     return(0); 
} 
 
fmt_error(code) 

 
/* 
 Verarbeitet einen Disk-Formatierfehler durch Reset des 
 Laufwerks und Rueckgabe eines Fehlercodes. Der Code, der 
 an diese Routine uebergeben wird, ist ein Bitcode, der so 
 interpretiert wird, wie es in Tabelle 8 gezeigt wird. 
 Diese Routine gibt einen Fehlercode 1 zurueck, um 
 anzuzeigen, dass ein "Schreibschutz"-Fehler (write-protect 
 error) aufgetreten ist (der festgestellt werden kann).
 Die Routine nimmt an, dass alle anderen Fehler nicht 
 unterschieden werden koennen; deshalb werden sie alle 
 zusammengeworfen. 
*/ 
 
char code; 
 
{ 
     union REGS regs; 
 
     regs.h.ah = 0; 
     int86(DISK,&regs,&regs); 
     return((code==3)?1:2); 
} 
 
/* ===================================================== */ 
