/*********************************************************************

 ----  D U M P  ------------ MS-Windows Application ------------------
                             ### Header file

======================================================================

This MS-Windows application displayes the data of a MS-DOS file as a
hexadecimal table. The application uses 4 panes within its application
window.

----------------------------------------------------------------------

Copyright 1989 by
          Marcellus Buchheit, Buchheit software research
          Zaehringerstrasse 47, D-7500 Karlsruhe 1
          Phone (0) 721/37 67 76    (West Germany)

Release 1.00 of 89-Sep-13 --- All rights reserved.

*********************************************************************/

/* define/undefine non-debugging option name */
#define NDEBUG

#define NOMINMAX
#include <WINDOWS.H>
#include "DEFS.H"

/* further C standard headers */
#include <STDLIB.H>
#include <STRING.H>
#include <STDIO.H>
#include <STDARG.H>

/* window function parameter macros */
#define P2LO LOWORD(ulP2)
#define P2HI HIWORD(ulP2)
#define LADDR(r) (LONG)(LPSTR)(r)


/* ===================================================================
   FILESPEC                                File specification for DUMP
   -------------------------------------------------------------------
   vSize ... contains the length of the files in bytes.
   seHead    size of header in entries
   hmgHead   is the handle of the global memory block which contains
             the handles of the 4-KB-data-blocks.
   seHead    size of header in entries
   hf ...... is the handle of the opened file.   
   ===================================================================
*/

typedef struct
 {LONG vSize;
  HANDLE hmgHead;
  WORD seHead;
  HANDLE hf;
 } FILESPEC;


/* ==============================
   application specific variables
   ==============================
*/
extern BYTE zAppName[];  /* application module name */
extern BYTE *rzAppTitle; /* pointer to application title name */
extern BYTE *rzNoMemory; /* pointer to error string "no memory" */
extern HANDLE hiMain;  /* handle to application instance */
extern HWND hwMain;    /* handle to main window */

/* global file module variables */
extern BYTE zCurrentFile[12+1]; /* name of file without path */
extern BYTE zNewFile[12+1]; /* name of new file from dialog box */
extern int hfNewFile; /* handle to new file, <=0 if file not opened */
extern FILESPEC FileSpec; /* file specification of the dump file */
extern HCURSOR hcrWait;   /* hourglass */


/* =======================================
   panes manager control types & variables
   =======================================
*/

/* ===================================================================
   PANE                              Single pane control specification
   -------------------------------------------------------------------
   wrc ... determines the rectangle of the pane within the client area
           of the pane window. This rectangle includes the vertical
           headers of pane 0 and 2 and the horizontal headers of pane
           1 and 3.
   iVBase  is the index of the first vertical unit (line) which is
           displayed in the pane.
   iHBase  is the index of the first horizontal unit (character,
           column etc) which is displayed in the pane.
   iVPos   is the current vertical position in vertical units in the
           pane.
   iHPos   is the current horizontal position in horizontal units in
           the pane.
   bValid  is TRUE if pane is valid (displayed),
           FALSE if not (non-existent).
   The index values can be in range -1073741824..+1073741823
   (-2**30..2**30-1).
   ===================================================================
*/

typedef struct
 {RECT wrc;
  LONG iVBase;
  LONG iHBase;
  LONG iVPos;
  LONG iHPos;
  BOOL bValid;
 } PANE;


/* ===================================================================
   DATASPEC             Data specification for horizontal and vertical
   -------------------------------------------------------------------
   iMin   is the long index of the first unit of the data object.
   iMax   is the long maximum value of the scroll range (including).
   iPos   is the index of the selected unit. This is the caret
          location.
   iBase  is an array for every pane in the specified direction.
          The first
          value is the index of the first unit in the left or top
          pane, the second value is the index of the first unit in
          the right or bottom pane.
   sUnit  is the size in device units of a base element in the window
          (for vertical the line height, for horizontal a width spec)
   sHead  is the size in device units of the head (for vertical is
          this a top line in pane 0 and 1, for horizontal is this a
          left column in pane 0 and 2).
   uExt   is the multiply factor for the conversation from scroll bar
          values to scroll values. The value can be in range 1..32768.

   Typical horizontal units are characters, cells or columns. Typical
   vertical units are lines. The value of <iMin>, <iMax> and <iPos>
   can be in range -1073741824..+1073741823 (-2**30..2**30-1).
   ===================================================================
*/

typedef struct
 {LONG iMin;
  LONG iMax;
  LONG iPos;
  LONG iBase[2];
  WORD sUnit;
  WORD sMedian;
  WORD sHead;
  WORD uExt;
 } DATASPEC;


/* scroll bar specification (privat type) */
typedef struct
 {BOOL bVisible; /* scroll bar is visible */
  HWND hw;       /* handle of scroll bar window */
  int iMin;   /* minimum value of scroll bar */
  int iMax;   /* maximum value of scroll bar */
  int iPos;   /* current scrollbar value */
  int nUnits; /* units (lines, characters etc) per pane */
 } SCROLL;


/* ===================================================================
   PANESPEC             Data specification for horizontal and vertical
   -------------------------------------------------------------------
   hwPane ........ is the window which contains the panes.
   H ............. is the horiz. data specification of type DATASPEC.
   V ............. is the vert. data specification of type DATASPEC.
   wrcTrackRedraw  is the invalidation rectangle for redrawing of the
                   displayed panes.
   iFocusPane .... is the index of the pane which has the input focus
                   if the pane window has the input focus.
   pxMullion ..... is the relative horizontal pane location within the
                   client area of the pane window.
   pyTransom ..... is the relative vertical pane location within the
                   client area of the pane window.
   ===================================================================
*/

typedef struct
 {HWND hwPane;
  DATASPEC H;
  DATASPEC V;
  RECT wrcTrackRedraw;
  int iFocusPane; /* pane which has the input focus */
  int pxMullion; /* relative horizontal pane location */
  int pyTransom; /* relative vertical pane location */
  PANE Pane[4];
  /* private used data structures */
  SCROLL Scroll[4];
  HWND hwHSplit;
  HWND hwVSplit;
 } PANESPEC;

extern PANESPEC *rCPS; /* pointer to current pane specification */


/* public functions in DUMP.C */
VOID DrawTrackPos(int iPane,LONG iTrackBase);
VOID CreateDrawingTools(HDC hdc);
VOID SetPaneFocus(int iPane,BOOL bChange);
VOID DrawPane(HDC hdc,int iPane,WORD sxPane,WORD syPane);
VOID DestroyDrawingTools(VOID);

/* public functions in FILE.C */
VOID ErrorNoMem(HWND hw);
VOID PrintMessage(WORD iString,...);
BOOL ReadDialog(WORD uBox,FARPROC rfd);
BOOL LoadFile(FILESPEC *rSpec);
HANDLE ReadDataBlock(FILESPEC *rSpec,DWORD uaFile);
VOID CloseFile(FILESPEC *rSpec);
BOOL FAR PASCAL fdOpenFile(HWND hw,WORD iMsg,WORD uP1,DWORD ulP2);

/* public functions in PANE.C */
BOOL InitPaneManager(HANDLE hiPrev);
BOOL CreatePaneWindows(VOID);
VOID SetScrollValues(BOOL bRedraw);
VOID SetPaneWindow(int sxWindow,int syWindow);
VOID ClosePanes(VOID);
VOID ScrollPane(int iScroll,WORD uCmd,int iNewPos);
VOID ChangePaneSize(VOID);
LONG ProcessPaneMsg(HWND hw,WORD iMsg,WORD uP1,DWORD ulP2);
