{ ---------------------------------------------------------------------
  DISKPARA.PAS  /  09.89  /  F-J Steiner

  Liest die Diskettenparametertabelle (Interrupt 1Ehex)
  und verndert sie nach Bedarf
  --------------------------------------------------------------------- }


program diskpara;

    uses crt, dos;

{ ------ Globale Variablen -------------------------------------------- }

    var  nachlauf, anlauf,
	 stepbyte,
	 initbyte, ruhe,
	 byte_sektor, sektor_spur : byte;
	 eingabe, steprate        : char;

{ ------ Zuweisung der Tabellenadresse -------------------------------- }

	 offs : integer absolute $0:$1E*4;     { Offset-Adresse  }
	 segm : integer absolute $0:$1E*4 + 2; { Segment-Adresse }

{ ------ Prozedurdeklarationen ---------------------------------------- }

 procedure disk_init;
 { ===  fhrt einen Reset des Diskettencontrollers durch  === }
   var reg : registers;
 begin
       reg.ah := 0;		{ Funktion 0hex }
       reg.dl := 0;		{ Kennwert fr Diskettenlaufwerk }
       intr($13,reg);           { Aufruf von Interrupt 13hex }
 end;

 procedure cursor(oben, unten : byte);
 { ===  ndert die Gre des Cursors  === }
   var reg : registers;
 begin
	reg.ah := 1;		{ Funktion 1hex }
	reg.ch := oben; 	{ Cursorrand oben  }
	reg.cl := unten;        { Cursorrand unten }
	intr($10,reg);          { Aufruf von Interrupt 10hex }
 end;

 procedure lies_tab;
 { ===  liest Ausschnitte der Parametertabelle
	und bergibt die Werte an Variablen       ===  }

 begin
	stepbyte    := mem[segm:offs];
		if stepbyte = 223 then steprate := '6'
		   else if stepbyte = 239 then steprate := '4'
		   else if stepbyte = 255 then steprate := '2';

	nachlauf    := mem[segm:offs+2];
	byte_sektor := mem[segm:offs+3];
	sektor_spur := mem[segm:offs+4];
	initbyte    := mem[segm:offs+8];
	ruhe        := mem[segm:offs+9];
	anlauf      := mem[segm:offs+10];
 end;

 procedure zeige_tab;
 { === stellt die bergebenen Werte am Bildschirm dar  === }

 begin
	gotoxy(3,3);
	highvideo;
	write('Aktuelle Diskettenparameter:');
	normvideo;
	gotoxy(3,6);
	write('Steprate-Byte      (ms):  ',steprate);
	gotoxy(3,8);
	write('Motor-Nachlauf (sec/18):  ',nachlauf);
	gotoxy(3,10);
	write('Byte je Sektor:           ',byte_sektor);
	gotoxy(3,12);
	write('Sektoren je Spur:         ',sektor_spur);
	gotoxy(3,14);
	write('Init-Byte fr FORMAT:     ');
	write(chr(initbyte));
	gotoxy(3,16);
	write('Kopfberuhigung     (ms):  ',ruhe);
	gotoxy(3,18);
	write('Motor-Anlauf    (sec/8):  ',anlauf);
 end;

 procedure lies_byte(x,y : byte; var wert : byte; max : byte);
 { ===  Einlesen von Byte-Variablen von der Tastatur  ===
   Eingaben:	Bildschirmkoordinaten:	x, y
		Zu nderndes Byte: 	wert
		Maximal zul. Wert: 	max
   Ausgaben:	Vernderter Wert  ======================= }

	var eing_str  : string[3];
	    fehler,i  : integer;
	    ch	      : char;
 begin
	repeat
		gotoxy(x,y); write(wert);
		gotoxy(x,y);
		fehler := 0;
		eing_str := '';
		readln(eing_str);
		if length(eing_str) > 0 then
			val(eing_str,wert,fehler);
	until (fehler = 0) and (wert >= 0) and (wert <= max);
 end;

 procedure lies_char(x,y : byte; var wert : char);
 { ===  Einlesen von Char-Variablen von der Tastatur  ===
   Eingaben:	Bildschirmkoordinaten:	x, y
		Zu nderndes Zeichen: 	wert
   Ausgaben:	Vernderter Wert  ======================= }

	var ok 	: boolean;
 begin
	repeat
		ok := false;
		gotoxy(x,y); write(wert);
		gotoxy(x,y);
		eingabe := readkey;
		if eingabe = #13 then ok := true
		  else if eingabe in ['!'..''] then
				begin
					wert := eingabe;
					ok := true;
				end;
		gotoxy(x,y);
		write(wert);
	until ok;
  end;

 procedure aendere_tab;
 { ===  ndert die Parametertabelle  === }
	var initchar 	: char;
 begin
	cursor(0,13);
	gotoxy(40,3);
	highvideo;
	write('neue Parameter:');
	gotoxy(60,3);
	write('mgliche Werte');
	normvideo;
	gotoxy(60,6);
	write('2, 4 oder 6');
	gotoxy(60,8);
	write('0 ... 255');
	gotoxy(60,10);
	write('fix');
	gotoxy(60,12);
	write('fix');
	gotoxy(60,14);
	write('beliebiges Zeichen');
	gotoxy(60,16);
	write('0 ... 255');
	gotoxy(60,18);
	write('0 ... 255');
	repeat
		lies_char(40,6,steprate);
	until steprate in ['6','4','2'];
		if steprate = '6' then stepbyte := 223
		   else if steprate = '4' then stepbyte := 239
		   else if steprate = '2' then stepbyte := 255;

	lies_byte(40,8,nachlauf,255);
	gotoxy(40,10);
	write(byte_sektor);
	gotoxy(40,12);
	write(sektor_spur);
	initchar := chr(initbyte);
	lies_char(40,14,initchar);
	initbyte := ord(initchar);
	lies_byte(40,16,ruhe,255);
	lies_byte(40,18,anlauf,255);
	mem[segm:offs]   := stepbyte;
	mem[segm:offs+2] := nachlauf;
	mem[segm:offs+8] := initbyte;
	mem[segm:offs+9] := ruhe;
	mem[segm:offs+10] := anlauf;
	cursor(6,7);
 end;


{ --------------------------------------------------------------------- }
{              Haupt - Programm                                         }
{ --------------------------------------------------------------------- }

begin
	clrscr;				{ Bildschirmaufbau }
	textcolor(0); textbackground(7);
	clreol;                         { inverse Darstellung }
	write(' DISKPARA  liest und ndert die Disketten',
	      'parametertabelle  mit QuickPascal 1.0');
	gotoxy(1,24);
	clreol;
	write('    (c) 1989  F-J Steiner');
	textcolor(7); textbackground(0);

	lies_tab;			{ Tabelle lesen }
	zeige_tab;                      { und darstellen }
	gotoxy(3,21);
	highvideo;
	write('Sollen die Parameter gendert werden ?  j/n : ');
	normvideo;
	eingabe := readkey;
	if eingabe in ['j','J'] then    { Tabelle ndern, wenn }
		begin                   { gewnscht; nach der  }
			aendere_tab;    { nderung den Disketten-   }
			disk_init;      { controller initialisieren }
		end;
	gotoxy(1,24);
end.

