/*
[ ]------------------------------------------------------------------------[ ]
 |                                                                          |
 |     Include-Datei    : DLG.H                                             |
 |     zur Einbindung   : der Funktionen zur Erstellung und Verwaltung von  |
 |                        SAA-Dialogboxen                                   |
 |     erstellt am      : 15.06.1989                                        |
 |     letztes Update am: 20.06.1989                                        |
 |                                                                          |
 |     (Copyright)      : 1989 by MICHAEL TISCHER                           |
 |                                                                          |
[ ]------------------------------------------------------------------------[ ]
*/

#include "vio.h"              /* diese beiden SAA-Include-Dateien aufnehmen */
#include "kbm.h"

/*-- Makros ----------------------------------------------------------------*/

#define F(farbe) ( dlgcol.farbe )  /* liefert Farbe aus der DLGCOL-Struktur */

/*-- die folgenden Makros helfen bei der Anlage von DLGDATEN-Strukturen fr */
/*-- die einzelnen Objekte innerhalb einer Dialogbox                        */

#define EDIT( p )     { &p, &std_edit_fkt }
#define ACTBUT( p )   { &p, &std_ab_fkt   }
#define PUSHBUT( p )  { &p, &std_pb_fkt   }
#define RADIOBUT( p ) { &p, &std_rb_fkt   }

/*-- Konstanten ------------------------------------------------------------*/

#define HOTKEY     '#'                /* Zeichen, das einen Hotkey markiert */
#define NOKEY      ((TASTE) 0)                               /* keine Taste */
#define NOPAINTFKT ((PAINTFKT) 0)                   /* keine 'Mal'-Funktion */

/*-- Rckgabecodes fr die TASTFKT -----------------------------------------*/

#define TF_MAUS       250 /* aktiviere mich aufgrund eines Maus-Ereignisses */
#define TF_AKTIV      251 /* aktiviere mich aufgrund einer Taste            */
#define TF_WEITER     252 /* Taste/Mausereignis wurde nicht verarbeitet     */
#define TF_ACCEPTED   253 /* Taste/Mausereignis wurde verarbeitet           */
#define TF_FELD_VOR   254 /* ein Feld weiterschalten                        */
#define TF_FELD_RUECK 255 /* ein Feld zurck                                */
                          /* alle weiteren Codes werden als Terminations-   */
                          /* codes aufgefat                                */

/*-- Typdeklarationen ------------------------------------------------------*/

typedef BYTE BOOL;

typedef struct   /* Farben, die innerhalb einer Dialogbox Verwendung finden */
 {
  BYTE dlgbox,               /* Fll-Farbe fr gesamte Dialogbox und Rahmen */
       nm,                                                 /* normale Farbe */
       hi,                                          /* hervorgehobene Farbe */
       hk,                                          /* Farbe fr den Hotkey */
       da,                          /* Farbe fr inaktive Felder (disabled) */
       dk;                     /* Farbe fr den Hotkey in inaktiven Feldern */
 } DLGCOL;

extern DLGCOL dlgcol;               /* Variable mit Farben fr Dialog-Boxen */

/*-- Deklaration der Funktionen, die jedes Dialog-Feld bereitstellen mu -----
|                                                                            |
|                                                                            |
|    STARTFKT  : Wird beim Aufbau der Maske aufgerufen. Liefert dem Aufru-   |
|                fer einen Zeiger zurck, der bei allen kommenden Aufrufen   |
|                der verschiedenen Dialogfunktionen bergeben wird.          |
|                                                                            |
|    Jeder der folgenden Funktionen wird bei ihrem Aufruf der Zeiger ber-   |
|    geben, den die STARTFKT zurckgeliefert hat und an der die Funktion     |
|    feststellen kann, welches der mglicherweise mehreren Dialog-Felder     |
|    dieses Typs angesprochen wird.                                          |
|                                                                            |
|      AKTIVFKT  : Aktiviert ein Dialog-Feld, nachdem es zuvor ber die      |
|                  Funktion CANAKTFKT seine Bereitschaft erklrt hat,        |
|                  aktiviert zu werden. Teilt dem Dialog-Feld anhand eines   |
|                  der TF_...-Konstanten mit, warum es aktiviert wurde.      |
|                                                                            |
|      TASTFKT   : Der Aufruf erfolgt sowohl whrend das Dialog-Feld aktiv   |
|                  ist, manchmal aber auch, wenn ein anderes Dialog-Feld     |
|                  aktiv ist, dieses die Taste aber abgelegt hat. In diesem  |
|                  Fall mu das Dialog-Feld feststellen, ob es die Taste     |
|                  verarbeiten kann - ggf. sogar aktiviert wird.             |
|                                                                            |
|      MAUSFKT   : Wie TASTFKT wird diese Funktion sowohl aufgerufen, wh-   |
|                  rend ein Dialogfeld aktiv ist, als auch, wenn es nicht    |
|                  aktiv ist, um festzustellen, ob es durch ein Mausereig-   |
|                  nis aktiviert werden mu.                                 |
|                                                                            |
|      CANAKTFKT : Teilt dem Aufrufer mit, ob das Dialog-Feld bereits ist,   |
|                  aktiviert zu werden.                                      |
|                                                                            |
|      NEWVALFKT : Wird nicht vom Scheduler, sondern von einer Verbindungs-  |
|                  prozedur des Anwenders/Programmierers aufgerufen, um dem  |
|                  Dialog-Feld mitzuteilen, da sich sein Inhalt durch ein   |
|                  ueres Ereignis verndert hat. In den Standardversionen  |
|                  der verschiedenen Dialogtypen sind diese Funktionen       |
|                  Dummys.                                                   |
|                                                                            |
|      DEAKFKT   : Teilt dem Dialog-Feld mit, da es daktiviert wurde.       |
|                                                                            |
|      ENDFKT    : Wird nach der Beendigung der Eingabe innerhalb der Dia-   |
|                  logbox aufgerufen, damit das Dialog-Feld einen Reset auf  |
|                  seine Daten durchfhren kann. Vom Bildschirm mu es sich  |
|                  nicht entfernen.                                          |
|                                                                            |
|                                                                            |
----------------------------------------------------------------------------*/

typedef void * (*STARTFKT) ( void * iptr );
typedef void   (*NEWVALFKT)( void * iptr, void * dptr );
typedef void   (*ENDEFKT)  ( void * iptr );
typedef void   (*DEAKFKT)  ( void * iptr );
typedef void   (*AKTIVFKT) ( void * iptr, BYTE why );
typedef BYTE   (*TASTFKT)  ( void * iptr, TASTE key );
typedef BYTE   (*MAUSFKT)  ( void * iptr, BYTE x, BYTE y, BYTE ev );
typedef BOOL   (*CANAKTFKT)( void * iptr );

typedef struct         /* Struktur mit den verschiedenen Funktions-Pointern */
 {
  STARTFKT  start;
  NEWVALFKT newval;
  ENDEFKT   ende;
  TASTFKT   taste;
  DEAKFKT   deak;
  MAUSFKT   maus;
  AKTIVFKT  aktiv;
  CANAKTFKT can;
 } DLGFKT;

typedef DLGFKT *DLGFKTPTR;     /* Zeiger auf eine Dialog-Funktions-Struktur */

/*-- Markos, die bei der Definition von Eingabemengen fr EDIT-Felder helfen*/

#define SM(m, x, y )      EdSetMenge(m, x, y, TRUE )
#define CM(m, x, y )      EdSetMenge(m, x, y, FALSE)
#define ClearMenge(m)     CM( m, 0, 255 )
#define SetMengeAll(m)    SM( m, 0, 255 )
#define SetMengeInt(m)    ( SM( m, '0', '9' ), SM( m, '+', '-' ) )

#define SetMengeAN(m)     ( SM( m, ' ', '~' ), SM( m, '', '' ),   \
                            SM( m, '', '' ), SM( m, '', '' ),   \
                            SM( m, '', '' ), SM( m, '', '' ),   \
                            SM( m, '', '' ), SM( m, '', '' ) )

#define SetMengeDatei(m)  ( SM( m, 'a', 'z' ), SM( m, 'A', 'Z' ),   \
                            SM( m, '!', '%' ), CM( m, 34, 34 ),     \
                            SM( m, '-', '-' ), SM( m, '_', '_' ),   \
                            SM( m, '', '' ), SM( m, '', '' ),   \
                            SM( m, '', '' ), SM( m, '', '' ),   \
                            SM( m, '', '' ), SM( m, '', '' ) )

#define SetMengePath(m)   ( SetMengeDatei(m), \
                            SM( m, ':', ':' ), SM( m, 92, 92 ) )

/*-- Beschreibung der Struktur eines Dialogbox-Beschreibers ----------------*/

extern DLGFKT std_edit_fkt;          /* Funktionen zur Verwaltung von Edit- */
extern DLGFKT std_ab_fkt;            /* Feldern, Action-, Push- und Radio-  */
extern DLGFKT std_pb_fkt;            /* Buttons                             */
extern DLGFKT std_rb_fkt;

typedef void (*PAINTFKT)( void );    /* Fkt. zur Gestaltung einer Dialogbox */

typedef struct          /* Daten, die fr jedes Dialog-Feld bentigt werden */
 {
  void      * daten;                               /* Zeiger auf Datenblock */
  DLGFKTPTR   fkts;            /* Zeiger auf Struktur mit Dialog-Funktionen */
 } DLGDATEN;

typedef DLGDATEN * DLGDPTR;                      /* Zeiger auf Dialog-Daten */

typedef struct                                 /* beschreibt eine Dialogbox */
 {
  BYTE     x_start,                         /* Koordinaten obere linke Ecke */
           y_start,                         /* der Dialogbox                */
           x_len,                                 /* Gre der Dialogbox in */
           y_len,                                 /* Spalten und Zeilen     */
           anz;                                  /* Anzahl der Dialogfelder */
  PAINTFKT paintfkt;               /* Funktion zur Gestaltung der Dialogbox */
  DLGDPTR  datptr;                         /* Zeiger auf Vektor mit Zeigern */
                                           /* auf Dialogfeld-Daten          */
 } DIGDES;

typedef DIGDES * DIGDESPTR;                /* Zeiger auf Dialogbox-Struktur */

/*-- Beschreibung der Strukturen, die fr ein alphanumerisches Eingabefeld -*/
/*-- vom Type EDIT bentigt werden                                         -*/

typedef BYTE EMENGE[ 64 ];                                  /* Eingabemenge */
typedef BYTE *EMP;                          /* Zeiger auf eine Eingabemenge */

typedef struct               /* beschreibt ein alphanumerisches Eingabefeld */
 {
  BOOL   enabled;                        /* darf das Feld angewhlt werden? */
  BYTE   x,                         /* Anfangskoordinate relativ zur oberen */
         y,                         /* linken Ecke des Dialogbox            */
         len,                          /* Anzahl der Zeichen im Eingabefeld */
         visi;                             /* Anzahl der sichtbaren Zeichen */
  char * text;                                  /* Text vor dem Eingabefeld */
  BYTE * eingabe;                           /* Zeiger auf den Eingabepuffer */
  EMP    mptr;                    /* Zeiger auf die Menge erlaubter Zeichen */
 } EDITFELD;

/*-- Beschreibung der Strukturen, die fr die Verwaltung von Action Buttons */
/*-- (AB) bentigt werden.                                                  */
/*-- ACHTUNG! Action Buttons darf es im Gegensatz zu EDIT-Feldern, Push-    */
/*-- Buttons etc. nur einmal pro Dialogbox geben                            */

typedef struct                            /* beschreibt einen Action-Button */
 {
  BOOL   enabled;                         /* darf der AB ausgewhlt werden? */
  BYTE   x,                        /* Bildschirmposition relativ zur oberen */
         y;                        /* linken Ecke des Dialogfensters        */
  char * name;                               /* Pointer auf String mit Text */
  TASTE  key;             /* Taste, mit der dieser AP (zustzlich zum evtl. */
                          /* vorhandenen Hotkey) verbunden wird             */
 } ONEAB;

typedef ONEAB *ABPTR;                    /* Zeiger auf einen AB-Beschreiber */

typedef struct                 /* beschreibt eine Gruppe von Action-Buttons */
 {
  BYTE anz,                                    /* Anzahl der Action-Buttons */
       standard;                                   /* Default Action-Button */
  ABPTR abp;                        /* Zeiger auf Vektor mi AB-Beschreibern */
 } ABGROUP;

/*-- Beschreibung der Strukturen, die fr die Verwaltung von Radio-Buttons -*/
/*-- (RB) bentigt werden.                                                  */

typedef struct                             /* beschreibt einen Radio-Button */
 {
  BOOL   enabled;                         /* darf der RB ausgewhlt werden? */
  BYTE   x,                        /* Bildschirmposition relativ zur oberen */
         y;                        /* linken Ecke des Dialogfensters        */
  char * name;                               /* Pointer auf String mit Text */
 } ONERB;

typedef ONERB *RBPTR;                    /* Zeiger auf einen RB-Beschreiber */

typedef struct    /* beschreibt eine Gruppe zusammengehriger Radio-Buttons */
 {
  BYTE    anzahl,                               /* Anzahl der Radio-Buttons */
        * varptr;    /* Zeiger auf Variable, die die Nummer des RB aufnimmt */
  RBPTR   rbvek;           /* Zeiger auf den Vektor mit den RB-Beschreibern */
 } RBGROUP;

typedef RBGROUP * RBGROUPTR;

/*-- Beschreibung der Struktur, die fr die Verwaltung von Push-Buttons ----*/
/*-- (PB) bentigt wird.                                                    */
/*-- ACHTUNG! Im Gegensatz zu den Radio-Buttons besteht ein Push-Button     */
/*-- immer nur aus einem Eintrag, auch wenn mehrere Push-Buttons auf dem    */
/*-- Bildschirm untereinander angeordnet werden                             */

typedef struct                              /* beschreibt einen Push-Button */
 {
  BOOL   enabled;                         /* darf der PB ausgewhlt werden? */
  BYTE   x,                        /* Bildschirmposition relativ zur oberen */
         y;                        /* linken Ecke des Dialogfensters        */
  char * name;                               /* Pointer auf String mit Text */
  BOOL * varptr;   /* Zeiger auf die Variable, mit der der PB verbunden ist */
 } ONEPB;

typedef ONEPB *PBPTR;                    /* Zeiger auf einen PB-Beschreiber */

/*-- ffentliche Funktionen ------------------------------------------------*/

BYTE  DlgStart  ( DIGDESPTR dptr );
TASTE DlgPrint  ( BYTE x, BYTE y, char * str, BYTE fn, BYTE fh );
void  DlgDelay  ( int pauslen );
void  DlgBox    ( BYTE x, BYTE y, BYTE xlen, BYTE ylen,
                  BYTE typ, char * titel, BOOL aktiv );
void  EdSetMenge( EMP mptr, BYTE von, BYTE bis, BOOL set );

/*-- Funktionsdeklarationen ber Makros ------------------------------------*/

#define MausPause()  DlgDelay( 1 )             /* Pause bei Mausereignissen */
