/****************************************************************************/
/*                               D L G P B . C                              */
/*--------------------------------------------------------------------------*/
/*    Aufgabe        : Enthlt die Funktionen zur Verwaltung von Push-      */
/*                     Buttons, die innerhalb von Dialog-Boxen zum Einsatz  */
/*                     kommen.                                              */
/*                     Dieses Modul mu in Verbindumg mit dem DLG-Modul ein-*/
/*                     gesetzt werden.                                      */
/*--------------------------------------------------------------------------*/
/*    Autor          : MICHAEL TISCHER                                      */
/*    entwickelt am  : 16.09.1989                                           */
/*    letztes Update : 18.09.1989                                           */
/*--------------------------------------------------------------------------*/
/*    Erstellung     : CL /A[S|M|C|L|H] DLGPB.C /C                          */
/*                     dann mit dem DLG-Modul und anderen Moduln verbinden  */
/****************************************************************************/

/*-- Include-Dateien einbinden ---------------------------------------------*/

#include <malloc.h>
#include <string.h>
#include "dlg.h"

/*-- interne Datenstruktur des Dialogtyps PB (Push Button) -----------------*/

typedef struct /* hier werden die Daten fr jeden Push-Button festgehalten -*/
 {
  BOOL    aktiv,                       /* ist der Push-Button gerade aktiv? */
          enabled,               /* darf der Push-Button ausgewhlt werden? */
        * varptr;                      /* Zeiger auf die BOOL-Variable, mit */
                                       /* der der PB verbunden ist          */
  TASTE   hotkey;          /* Hotkey des Push-Buttons (NOKEY = kein Hotkey) */
  BYTE    x1,                                     /* Startspalte des Textes */
          x2,                                       /* Endspalte des Textes */
          y;                                                       /* Zeile */
 } PBINTERN;

typedef PBINTERN *PBIP;              /* Zeiger auf eine interne PB-Struktur */

/*-- Prototypen fr Funktionen, die in diesem Modul deklariert und in der --*/
/*-- globalen Variablen std_pb_fkt zusammengefat werden                  --*/

void * pb_start ( PBPTR dptr );
void   pb_newval( PBIP pbip, void * dptr );
void   pb_ende  ( PBIP pbip );
BYTE   pb_taste ( PBIP pbip, TASTE key );
void   pb_deak  ( PBIP pbip );
void   pb_aktiv ( PBIP pbip, BYTE why );
BOOL   pb_maus  ( PBIP pbip, BYTE x, BYTE y, BYTE ev );
BOOL   pb_can   ( PBIP pbip );

/*-- globale Variablen, ffentlich -----------------------------------------*/

DLGFKT std_pb_fkt =                       /* Standard Dialog-Funktionen fr */
 {                                        /* jeweils einen Push-Button      */
   pb_start, pb_newval, pb_ende , pb_taste,
   pb_deak,  pb_maus,   pb_aktiv, pb_can
 };

/*-- globale Variablen, modulintern ----------------------------------------*/

static BOOL justrel;     /* zeigt an, ober Button gerade umgeschaltet wurde */

/*****************************************************************************
* PB             Es folgen die verschiedenen Funktionen des Dialogtyps PB    *
*                ( jeweils ein Push-Button )                                 *
*****************************************************************************/

/*****************************************************************************
*  Funktion         : p b i _ t o g g l e                                    *
**--------------------------------------------------------------------------**
*  Aufgabe          : Schaltet den Push-Button um.                           *
*  Eingabe-Parameter: PBIP = Zeiger auf den Datenblock des Push-Buttons      *
*  Return-Wert      : keiner                                                 *
*****************************************************************************/

void pbi_toggle( PBIP pbip )
{
 *pbip->varptr = !*pbip->varptr;                           /* Flag umdrehen */
 MouHideMouse();                                  /* Maus-Cursor ausblenden */
 VioPrint( pbip->x1+1, pbip->y, F(nm), FALSE, ( *pbip->varptr ) ? "X" : " " );
 MouShowMouse();                             /* Maus-Cursor wieder anzeigen */
}

/*****************************************************************************
*  Funktion         : p b _ s t a r t                                        *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler whrend der Initialisierung einer   *
*                     Dialogbox fr jeden Push-Button aufgerufen.            *
*  Eingabe-Parameter: DPTR = Zeiger auf den Datenblock des Push-Buttons      *
*  Return-Wert      : Ein Zeiger, den der Scheduler bei allen folgenden Auf- *
*                     rufen den Funktionen pb_aktiv, pb_tast etc. bergibt.  *
*****************************************************************************/

void * pb_start ( PBPTR dptr )
{
 BYTE   f;                                                  /* Ausgabefarbe */
 PBIP   pbip;          /* Zeiger auf allokierte Struktur mit internen Infos */

 pbip = (PBIP) malloc( sizeof(PBINTERN) );
 pbip->varptr = dptr->varptr;             /* Zeiger auf BOOL-Variable laden */
 pbip->enabled = dptr->enabled;                      /* Enabled-Flag merken */
 pbip->aktiv = FALSE;                        /* Push-Button ist nicht aktiv */
 pbip->x2 = VL( dptr->x + strlen( dptr->name ) + 3 );
 pbip->hotkey = DlgPrint( (pbip->x1 = VL(dptr->x)) + 4 ,
                          pbip->y = VO(dptr->y),
                          dptr->name,
                          f = (pbip->enabled = dptr->enabled)? F(nm) : F(da),
                          dptr->enabled? F(hk) : F(dk)                      );
 if ( pbip->hotkey != NOKEY )                      /* gibt es einen Hotkey? */
  --pbip->x2;                               /* Ja, Endspalte dekrementieren */

 if ( !pbip->enabled )                              /* ist der PB disabled? */
  pbip->hotkey = NOKEY;                        /* Ja, es gibt keinen Hotkey */

 /*-- den eigentlichen Button ausgeben -------------------------------------*/

 VioPrint( pbip->x1, pbip->y, f, FALSE, *(pbip->varptr) ? "[X]" : "[ ]" );

 return pbip;                          /* Zeiger an Scheduler zurckliefern */
}

/*****************************************************************************
*  Funktion         : p b _ n e w v a l                                      *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird nicht direkt vom Scheduler, sondern von einer mit *
*                     ihm zusammenarbeitenden Interaktions-Funktion aufge-   *
*                     rufen, wenn sich der Inhalt der Variablen, mit der der *
*                     PB verbunden ist, durch ein ueres Ereignis verndert *
*                     hat.                                                   *
*  Eingabe-Parameter: PBIP = der Zeiger, der beim Aufruf von pb_start zurck-*
*                            geliefert wurde.                                *
*                     DPTR = Zeiger auf eine objektspezifische Information   *
*  Return-Wert      : keiner                                                 *
*****************************************************************************/

void pb_newval( PBIP pbip, void * dptr )
{
}

/*****************************************************************************
*  Funktion         : p b _ e n d e                                          *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler whrend des Schlieens der Dialog-  *
*                     box aufgerufen, um PB Gelgegenheit zu geben, Clean-Up  *
*                     Arbeiten durchzufhren.                                *
*  Eingabe-Parameter: PBIP = der Zeiger, der beim Aufruf von pb_start zurck-*
*                            geliefert wurde.                                *
*  Return-Wert      : keiner                                                 *
*****************************************************************************/

void pb_ende( PBIP pbip )
{
 free( pbip );                  /* die allokierte Struktur wieder freigeben */
}

/*****************************************************************************
*  Funktion         : p b _ t a s t e                                        *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um dem Dialog-Feld eine *
*                     Taste zu bergeben.                                    *
*  Eingabe-Parameter: PBIP  = der Zeiger, der beim Aufruf von pb_start zu-   *
*                             rckgeliefert wurde.                           *
*                     TASTE = Code der zu bearbeitenden Taste                *
*  Return-Wert      : Reaktionscode (TF_...)                                 *
*****************************************************************************/

BYTE pb_taste( PBIP pbip, TASTE key )
{
 if ( pbip->aktiv )                           /* ist der Push-Button aktiv? */
  {                                                                   /* Ja */
   switch ( key )                                        /* Taste auswerten */
    {
     case CUP    : /*-------------- Cursor-Up und -Left schalten Button an -*/
     case CLEFT  :
       *pbip->varptr = FALSE;              /* BOOL-Variable auf TRUE setzen */
       pbi_toggle( pbip );                 /* (das erledigt pbi_toggle() )  */
       return TF_ACCEPTED;                        /* Taste wurde angenommen */

     case CDOWN  : /*---------- Cursor-Down und -Right schalten Button aus -*/
     case CRIGHT :
       *pbip->varptr = TRUE;              /* BOOL-Variable auf FALSE setzen */
       pbi_toggle( pbip );                /* (das erledigt pbi_toggle() )   */
       return TF_ACCEPTED;                        /* Taste wurde angenommen */

     case ' '    : /*-------------- die SPACE-Taste schaltet den Button um -*/
       pbi_toggle( pbip );                                 /* Flag umdrehen */
       return TF_ACCEPTED;                        /* Taste wurde angenommen */

     case TAB    : /*----------------------- TAB springt zum nchsten Feld -*/
       return TF_FELD_VOR;

     case BACKTAB: /*----------- SHIFT+TAB springt zum vorhergehenden Feld -*/
       return TF_FELD_RUECK;

     default     : /*--------------- jede andere Taste, ist es der Hotkey? -*/
       if ( key == pbip->hotkey )                                /* Hotkey? */
        {                                                             /* Ja */
         pbi_toggle( pbip );                               /* Flag umdrehen */
         return TF_ACCEPTED;
        }
       else                                       /* Nein, nicht der Hotkey */
        return TF_WEITER;
    }
  }
 else            /* der Push-Button ist noch nicht aktiv, auf Hotkey testen */
  if ( key == pbip->hotkey )                                     /* Hotkey? */
   {                                                                  /* Ja */
    pbi_toggle( pbip );                                    /* Flag umdrehen */
    return TF_AKTIV;
   }
  else                                            /* Nein, nicht der Hotkey */
   return TF_WEITER;
}

/*****************************************************************************
*  Funktion         : p b _ d e a k                                          *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um den Push-Button von  *
*                     seiner Deaktivierung in Kenntnis zu setzen.            *
*  Eingabe-Parameter: PBIP = der Zeiger, der beim Aufruf von pb_start zurck-*
*                            geliefert wurde.                                *
*  Return-Wert      : keiner                                                 *
*****************************************************************************/

void pb_deak( PBIP pbip )
{
 pbip->aktiv = FALSE;                                /* neuen Status merken */
 VioHideCursor();                        /* Cursor vom Bildschirm entfernen */
}

/*****************************************************************************
*  Funktion         : p b _ m a u s                                          *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um dem Dialog-Feld ein  *
*                     Mausereignis zu bergeben                              *
*  Eingabe-Parameter: PBIP  = der Zeiger, der beim Aufruf von pb_start zu-   *
*                             rckgeliefert wurde.                           *
*                     X, Y  = Position des Mauscursors relativ zu oberen     *
*                             linken Bildschirmecke                          *
*                     EV    = Event-Maske, die das Ereignis beschreibt, um   *
*                             dessentwillen die Funktion aufgerufen wird     *
*  Return-Wert      : Reaktionscode (TF_...)                                 *
*****************************************************************************/

BYTE pb_maus( PBIP pbip, BYTE x, BYTE y, BYTE ev )
{
 if ( pbip->aktiv )                          /* ist der Push-Buttons aktiv? */
  {                                                                   /* Ja */
   if ( ev & EV_LEFT_REL )       /* wurde der linke Mausbutton losgelassen? */
    {               /* Ja, feststellen, ob sich die Maus ber dem PB befand */
     if ( justrel == FALSE)         /* Mausknopf gerade schon umgeschaltet? */
      {                                                             /* Nein */
       justrel = TRUE;                                        /* jetzt aber */
       if ( pbip->y == y  &&  x >= pbip->x1  &&  x <= pbip->x2  )
        {                               /* Maus ber Push-Button und Button */
         if ( pbip->enabled )                    /* ist der Button enabled? */
          pbi_toggle( pbip );                          /* Ja, Flag umdrehen */
         return TF_ACCEPTED;                  /* Ereignis wurde verarbeitet */
        }
       else                            /* die Maus befindet sich nicht ber */
        return TF_WEITER;              /* dem aktuellen Button              */
      }
     else                           /* Mausknopf wurde bereits umgeschaltet */
       return TF_ACCEPTED;                /* Mausereignis trotzdem annehmen */
    }
  else                                 /* Mausknopf wurde nicht losgelassen */
   {
    if ( ev & EV_LEFT_PRESS )                  /* wurde Mausknopf bettigt? */
     {                                                                /* Ja */
      if ( pbip->y == y  &&  x >= pbip->x1  &&  x <= pbip->x2  )
       {                                  /* Maus ber dem aktuellen Button */
        justrel = FALSE;                /* Umschaltung kann wieder erfolgen */
        return TF_ACCEPTED;                        /* Ereignis aktzeptieren */
       }
      else                              /* Maus nicht ber aktuellem Button */
       return TF_WEITER;                          /* Ereignis weiterreichen */
     }
    else                                        /* unbekanntes Mausereignis */
     return TF_WEITER;
   }
  }
 else                              /* Nein, der Push-Button ist nicht aktiv */
  {
   if  ( ev & EV_LEFT_PRESS ) /* wurde der linke Mausbutton niedergedrckt? */
    if ( pbip->enabled  &&  pbip->y == y  &&
         x >= pbip->x1  &&  x <= pbip->x2  )                          /* Ja */
      return TF_MAUS;           /* Maus ber dem Button und Button enablded */
   return TF_WEITER;                               /* Mausereignis abweisen */
  }
}

/*****************************************************************************
*  Funktion         : p b _ c a n                                            *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um festzustellen, ob    *
*                     das Dialogfeld bereit ist, aktiviert zu werden.        *
*  Eingabe-Parameter: PBIP = der Zeiger, der beim Aufruf von pb_start zurck-*
  *                          geliefert wurde.                                *
*  Return-Wert      : TRUE, wenn das Dialog-Feld aktiviert werden kann,      *
*                     sonst FALSE                                            *
*****************************************************************************/

BOOL pb_can( PBIP pbip )
{
 return pbip->enabled;                          /* Enabled-Flag entscheidet */
}

/*****************************************************************************
*  Funktion         : p b _ a k t i v                                        *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um das Dialog-Feld von  *
*                     seiner Aktivierung in Kenntnis zu setzen.              *
*  Eingabe-Parameter: PBIP = der Zeiger, der beim Aufruf von pb_start zurck-*
*                            geliefert wurde.                                *
*                     WHY  = warum wird das Feld aktiviert                   *
*  Return-Wert      : keiner                                                 *
*****************************************************************************/

void pb_aktiv( PBIP pbip, BYTE why )
{
 justrel = FALSE;
 pbip->aktiv = TRUE;                                 /* neuen Status merken */
 VioSetCursor( pbip->x1+1, pbip->y );           /* Cursor auf den PB setzen */
}
