/****************************************************************************/
/*                               D L G R B . C                              */
/*--------------------------------------------------------------------------*/
/*    Aufgabe        : Enthlt die Funktionen zur Verwaltung von Radio-     */
/*                     Buttons, die innerhalb von Dialog-Boxen zum Einsatz  */
/*                     kommen.                                              */
/*                     Dieses Modul mu in Verbindumg mit dem DLG-Modul ein-*/
/*                     gesetzt werden.                                      */
/*--------------------------------------------------------------------------*/
/*    Autor          : MICHAEL TISCHER                                      */
/*    entwickelt am  : 16.09.1989                                           */
/*    letztes Update : 18.09.1989                                           */
/*--------------------------------------------------------------------------*/
/*    Erstellung     : CL /A[S|M|C|L|H] DLGRB.C /C                          */
/*                     dann mit dem DLG-Modul und anderen Moduln verbinden  */
/****************************************************************************/

/*-- Include-Dateien einbinden ---------------------------------------------*/

#include <malloc.h>
#include <string.h>
#include "dlg.h"

/*-- interne Datenstruktur des Dialogtyps RB (Radio Button) ----------------*/

typedef struct      /* interne Informationen fr jeweils einen Radio-Button */
 {
  TASTE hotkey;                                        /* der Hotkey des RB */
  BOOL  enabled;                                             /* RB whlbar? */
  BYTE  y,                                                         /* Zeile */
        x1, x2;                              /* erste Spalte, letzte Spalte */
 } RBINFO;

typedef struct                   /* Daten fr jede Gruppe von Radio-Buttons */
 {
  BOOL     aktiv,                           /* ist das Objekt gerade aktiv? */
           mouout;      /* wurde Mausknopf  auerhalb eines RB losgelassen? */
  RBINFO * infoptr;                /* Zeiger auf den Vektor mit den Hotkeys */
  BYTE     anz,                /* Anzahl der Radio-Buttons in dieser Gruppe */
         * varptr;                    /* Zeiger auf die zugehrige Variable */
 } RBINTERN;

typedef RBINTERN *RBIP;              /* Zeiger auf eine interne RB-Struktur */

/*-- Prototypen fr Funktionen, die in diesem Modul deklariert und in der --*/
/*-- globalen Variablen std_rb_fkt zusammengefat werden                  --*/

void * rb_start ( RBGROUPTR dptr );
void   rb_newval( RBIP rbip, void * dptr );
void   rb_ende  ( RBIP rbip );
BYTE   rb_taste ( RBIP rbip, TASTE key );
void   rb_deak  ( RBIP rbip );
void   rb_aktiv ( RBIP rbip, BYTE why );
BOOL   rb_maus  ( RBIP rbip, BYTE x, BYTE y, BYTE ev );
BOOL   rb_can   ( RBIP rbip );

/*-- globale Variablen, ffentlich -----------------------------------------*/

DLGFKT std_rb_fkt =                       /* Standard Dialog-Funktionen fr */
 {                                        /* jeweils einen Radio-Button     */
   rb_start, rb_newval, rb_ende , rb_taste,
   rb_deak,  rb_maus,   rb_aktiv, rb_can
 };

/*-- globale Variablen, modulintern ----------------------------------------*/

static BOOL justrel;     /* zeigt an, ober Button gerade umgeschaltet wurde */

/*****************************************************************************
* RB             Es folgen die verschiedenen Funktionen des Dialogtyps RB    *
*                ( jeweils eine Gruppe von Radio-Buttons )                   *
*****************************************************************************/

/*****************************************************************************
*  Funktion         : r b i _ n e x t                                        *
**--------------------------------------------------------------------------**
*  Aufgabe          : Interne Funktion, die zur Auswahl eines neuen RBs nach *
*                     der Bettigung einer Cursor-Taste oder einer Maus-     *
*                     auswahl aufgerufen wird.                               *
*  Eingabe-Parameter: RBIP   = Zeiger auf den internen Datenblock            *
*                     OFFSET = Suchrichtung (+1, -1 etc.)                    *
*  Return-Wert      : keiner                                                 *
*****************************************************************************/

void rbi_next( RBIP rbip, int offset )
{
 RBINFO * ifp;                      /* Laufzeiger in den internen RB-Vektor */
 int      i;                                         /* Nummer des neuen RB */

 i = *rbip->varptr;        /* I mit der Nummer des aktuellen Elements laden */
 ifp = rbip->infoptr+i;       /* ifp auf aktuelles Element im Vektor setzen */

 MouHideMouse();                                  /* Maus-Cursor ausblenden */
 VioPrint( ifp->x1+1, ifp->y, F(nm), FALSE, " " );     /* Button ausblenden */


 /*-- den nchsten RB in der ber OFFSET angegebenen Richtung suchen, der --*/
 /*-- enabled ist                                                         --*/

 do
  {
   i += offset;             /* I mit der Nummer des nchsten Elements laden */
   if ( i < 0 )                              /* Wrap-Around zum letzten RB? */
    ifp = rbip->infoptr + (i = rbip->anz-1 );
   else                                                             /* Nein */
    if ( i == rbip->anz )                     /* Wrap-Around zum ersten RB? */
     {                                                                /* Ja */
      ifp = rbip->infoptr;
      i = 0;
     }
    else                                            /* gar kein Wrap-Around */
     ifp += offset;
  }
 while ( ifp->enabled == FALSE );

 /*-- es wurden ein Button gefunden, der enabled ist -----------------------*/

 *rbip->varptr = i;                  /* Nummer des neuen akt. Button setzen */
 VioPrint( ifp->x1+1, ifp->y, F(nm), FALSE, "\x07" );   /* Button markieren */
 VioSetCursor( ifp->x1+1, ifp->y );                   /* Cursor draufsetzen */
 MouShowMouse();                           /* Maus-Cursor wieder einblenden */
}

/*****************************************************************************
*  Funktion         : r b i _ h o t k e y                                    *
**--------------------------------------------------------------------------**
*  Aufgabe          : Interne Funktion, die bei der Suche nach einem Hotkey  *
*                     innerhalb eines RBs eingesetzt wird.                   *
*  Eingabe-Parameter: RBIP   = Zeiger auf den internen Datenblock            *
*                     KEY    = die bettigte Taste und vermeintlicher Hotkey *
*  Return-Wert      : TF_ACCEPTED, wenn es sich um einen Hotkey handelt und  *
*                     TF_WEITER, wenn die Taste nicht als ein solcher iden-  *
*                     tifiziert werden konnte.                               *
*  Info             : Wird die Taste als Hotkey erkannt, wird auch gleich    *
*                     der neue RB angezeigt.                                 *
*****************************************************************************/

BYTE rbi_hotkey( RBIP rbip, TASTE key )
{
 BYTE     i;                                             /* Schleifenzhler */
 RBINFO * lrip;        /* Laufzeiger in internen Vektor mit RB-Beschreibern */

 for ( lrip = rbip->infoptr, i = 0;
       i < rbip->anz  &&  lrip->hotkey != key;
       ++i, ++lrip );
 if ( i < rbip->anz )                         /* wurde der Hotkey entdeckt? */
  {                                                                   /* Ja */
   rbi_next( rbip, i-*rbip->varptr );                  /* neuen RB anzeigen */
   return TF_ACCEPTED;
  }
 else                                    /* der Hotkey wurde nicht entdeckt */
  return TF_WEITER;
}

/*****************************************************************************
*  Funktion         : r b i _ m a u s                                        *
**--------------------------------------------------------------------------**
*  Aufgabe          : Interne Funktion, die feststellt, ob sich die angege-  *
*                     bene Bildschirmposition innerhalb eines der verschie-  *
*                     denen Radio-Buttons befindet.                          *
*  Eingabe-Parameter: RBIP   = Zeiger auf den internen Datenblock            *
*                     X, Y   = absolute Bildschirmposition                   *
*  Return-Wert      : Die Nummer des RB oder -1, wenn sich kein RB an der    *
*                     angegebenen Position befindet.                         *
*****************************************************************************/

int rbi_maus( RBIP rbip, BYTE x, BYTE y )
{
 BYTE     i;                                             /* Schleifenzhler */
 RBINFO * lrip;        /* Laufzeiger in internen Vektor mit RB-Beschreibern */

 for ( lrip = rbip->infoptr, i = 0; i < rbip->anz; ++i, ++lrip )
  if ( lrip->y == y  &&  x >= lrip->x1  &&  x <= lrip->x2 )
   return i;                                                /* RB entdeckt! */

 return -1;                                           /* keinen RB entdeckt */
}

/*****************************************************************************
*  Funktion         : r b _ s t a r t                                        *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler whrend der Initialisierung einer   *
*                     Dialogbox fr jeden Radio-Button aufgerufen.           *
*  Eingabe-Parameter: DPTR = Zeiger auf den Datenblock des Radio-Buttons     *
*  Return-Wert      : Ein Zeiger, den der Scheduler bei allen folgenden Auf- *
*                     rufen den Funktionen rb_aktiv, rb_tast etc. bergibt.  *
*****************************************************************************/

void * rb_start ( RBGROUPTR dptr )
{
 BYTE    i,                                              /* Schleifenzhler */
         f;                                                 /* Ausgabefarbe */
 RBPTR   lrbptr;                 /* Laufzeiger in den bergebenen RB-Vektor */
 RBINFO *lrifp;                     /* Laufzeiger in den internen RB-Vektor */
 RBIP    rbip;         /* Zeiger auf allokierte Struktur mit internen Infos */

 /*-- Puffer fr interne Struktur und zugehrigen Vektor allokieren --------*/

 rbip = (RBIP) malloc( sizeof(RBINTERN) );
 rbip->infoptr = (RBINFO *) malloc( dptr->anzahl * sizeof( RBINFO ) );

 rbip->anz = dptr->anzahl;                     /* Anzahl der Buttons merken */
 rbip->varptr = dptr->varptr;             /* Zeiger auf BYTE-Variable laden */
 rbip->aktiv = FALSE;                         /* das Objekt ist nicht aktiv */

 /*-- die einzelnen Radio-Buttons durchlaufen, dabei Informationen in den --*/
 /*-- Vektor eintragen und die RBs ausgeben                               --*/

 for ( lrbptr = dptr->rbvek, lrifp = rbip->infoptr, i = 0;
       i < dptr->anzahl;
       ++i, ++lrbptr, ++lrifp )
  {
   lrifp->x2 = VL( lrbptr->x + strlen( lrbptr->name ) + 3 );

   lrifp->hotkey =
     DlgPrint( (lrifp->x1 = VL(lrbptr->x)) + 4 ,
               lrifp->y = VO(lrbptr->y),
               lrbptr->name,
               f = (lrifp->enabled = lrbptr->enabled)? F(nm) : F(da),
               lrbptr->enabled? F(hk) : F(dk)                         );
   VioPrint( lrifp->x1, lrifp->y, f, FALSE,
             ( *rbip->varptr == i ) ? "(\x07)" : "( )" );

   if ( lrifp->hotkey != NOKEY )                   /* gibt es einen Hotkey? */
    --lrifp->x2;                            /* Ja, Endspalte dekrementieren */

   if ( !lrifp->enabled )                           /* ist der RB disabled? */
     lrifp->hotkey = NOKEY;                    /* Ja, es gibt keinen Hotkey */
  }

 return rbip;                          /* Zeiger an Scheduler zurckliefern */
}

/*****************************************************************************
*  Funktion         : r b _ n e w v a l                                      *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird nicht direkt vom Scheduler, sondern von einer mit *
*                     ihm zusammenarbeitenden Interaktions-Funktion aufge-   *
*                     rufen, wenn sich der Inhalt der Variablen, mit der der *
*                     RB verbunden ist, durch ein ueres Ereignis verndert *
*                     hat.                                                   *
*  Eingabe-Parameter: RBIP = der Zeiger, der beim Aufruf von rb_start zurck-*
*                            geliefert wurde.                                *
*                     DPTR = Zeiger auf eine objektspezifische Information   *
*  Return-Wert      : keiner                                                 *
*****************************************************************************/

void rb_newval( RBIP rbip, void * dptr )
{
}

/*****************************************************************************
*  Funktion         : r b _ e n d e                                          *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler whrend des Schlieens des Dialog-  *
*                     box aufgerufen, um RB Gelegegenheit zu geben, Clean-Up *
*                     Arbeiten durchzufhren.                                *
*  Eingabe-Parameter: RBIP = der Zeiger, der beim Aufruf von rb_start zurck-*
*                            geliefert wurde.                                *
*  Return-Wert      : keiner                                                 *
*****************************************************************************/

void rb_ende( RBIP rbip )
{
 free( rbip->infoptr );       /* Vektor mit internen RB-Beschreibern freig. */
 free( rbip );                  /* die allokierte Struktur wieder freigeben */
}

/*****************************************************************************
*  Funktion         : r b _ t a s t e                                        *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um dem Dialog-Feld eine *
*                     Taste zu bergeben.                                    *
*  Eingabe-Parameter: RBIP  = der Zeiger, der beim Aufruf von rb_start zu-   *
*                             rckgeliefert wurde.                           *
*                     TASTE = Code der zu bearbeitenden Taste                *
*  Return-Wert      : Reaktionscode (TF_...)                                 *
*****************************************************************************/

BYTE rb_taste( RBIP rbip, TASTE key )
{
 if ( rbip->aktiv )                                /* ist das Objekt aktiv? */
  {                                                                   /* Ja */
   switch ( key )                                        /* Taste auswerten */
    {
     case CUP    : /*----- Cursor-Up und -Left springen einen RB nach oben -*/
     case CLEFT  :
       rbi_next( rbip, -1 );                   /* nchsten Button markieren */
       return TF_ACCEPTED;                        /* Taste wurde angenommen */

     case CDOWN  : /*- Cursor-Down und -Right springen einen RB nach unten -*/
     case CRIGHT :
       rbi_next( rbip, 1 );                    /* nchsten Button markieren */
       return TF_ACCEPTED;                        /* Taste wurde angenommen */

     case TAB    : /*----------------------- TAB springt zum nchsten Feld -*/
       return TF_FELD_VOR;

     case BACKTAB: /*----------- SHIFT+TAB springt zum vorhergehenden Feld -*/
       return TF_FELD_RUECK;

     default     : /*------------------------- andere Taste, Hotkey testen -*/
       return rbi_hotkey( rbip, key );
    }
  }
 else           /* der Radio-Button ist noch nicht aktiv, auf Hotkey testen */
  return ( rbi_hotkey( rbip, key ) == TF_ACCEPTED ) ? TF_AKTIV : TF_WEITER;
}

/*****************************************************************************
*  Funktion         : r b _ d e a k                                          *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um den Radio-Button von *
*                     seiner Deaktivierung in Kenntnis zu setzen.            *
*  Eingabe-Parameter: RBIP = der Zeiger, der beim Aufruf von rb_start zurck-*
*                            geliefert wurde.                                *
*  Return-Wert      : keiner                                                 *
*****************************************************************************/

void rb_deak( RBIP rbip )
{
 rbip->aktiv = FALSE;                                /* neuen Status merken */
 VioHideCursor();                        /* Cursor vom Bildschirm entfernen */
}

/*****************************************************************************
*  Funktion         : r b _ m a u s                                          *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um dem Dialog-Feld ein  *
*                     Mausereignis zu bergeben                              *
*  Eingabe-Parameter: RBIP  = der Zeiger, der beim Aufruf von rb_start zu-   *
*                             rckgeliefert wurde.                           *
*                     X, Y  = Position des Mauscursors relativ zu oberen     *
*                             linken Bildschirmecke                          *
*                     EV    = Event-Maske, die das Ereignis beschreibt, um   *
*                             dessentwillen die Funktion aufgerufen wird     *
*  Return-Wert      : Reaktionscode (TF_...)                                 *
*****************************************************************************/

BYTE rb_maus( RBIP rbip, BYTE x, BYTE y, BYTE ev )
{
 int mourb;                            /* fr Suche nach einem Radio-Button */

 if ( rbip->aktiv  &&  !rbip->mouout )     /* RB aktiv und nicht auerhalb? */
  {                                                                   /* Ja */
   if ( ev & EV_LEFT_REL )       /* wurde der linke Mausbutton losgelassen? */
    {               /* Ja, feststellen, ob sich die Maus ber dem RB befand */
     if ( ( mourb = rbi_maus( rbip, x, y ) ) != -1 )
      {                                     /* Maus ber einem Radio-Button */
       if ( justrel == FALSE)       /* Mausknopf gerade schon umgeschaltet? */
        {                                                           /* Nein */
         justrel = TRUE;                                      /* jetzt aber */
         if ( (rbip->infoptr+mourb)->enabled )       /* ist der RB enabled? */
          rbi_next( rbip, mourb-*rbip->varptr );            /* Ja, anwhlen */
         else                            /* Nein, Cursor wieder auf akt. RB */
          VioSetCursor( (rbip->infoptr+*rbip->varptr)->x1+1,
                        (rbip->infoptr+*rbip->varptr)->y );
         return TF_ACCEPTED;                  /* Ereignis wurde verarbeitet */
        }
       else                         /* Mausknopf wurde bereits umgeschaltet */
        return TF_ACCEPTED;               /* Mausereignis trotzdem annehmen */
      }
     else                     /* die Maus befindet sich nicht ber einem RB */
      {
       VioSetCursor( (rbip->infoptr+*rbip->varptr)->x1+1,     /* Cursor auf */
                        (rbip->infoptr+*rbip->varptr)->y );   /* akt RB     */
       justrel = TRUE;                                /* gerade losgelassen */
       rbip->mouout = TRUE;            /* auerhalb der Buttons losgelassen */
       return TF_WEITER;                      /* Ereignis nicht akzeptieren */
      }
    }
  else                                 /* Mausknopf wurde nicht losgelassen */
   {
    if ( ev & EV_LEFT_PRESS )                  /* wurde Mausknopf bettigt? */
     {                                                                /* Ja */
      if ( ( mourb = rbi_maus( rbip, x, y ) ) != -1 )
       {                               /* Maus ber einem der Radio-Buttons */
        justrel = FALSE;                /* Umschaltung kann wieder erfolgen */
        if ( (rbip->infoptr+mourb)->enabled )    /* ist der Button enabled? */
         VioSetCursor((rbip->infoptr+mourb)->x1+1, (rbip->infoptr+mourb)->y);
       }
      return TF_ACCEPTED;             /* Ereignis in jedem Fall akzeptieren */
     }
    else                                        /* unbekanntes Mausereignis */
     return TF_WEITER;
   }
  }
 else                /* RB nicht aktiv oder Mausknopf auerhalb losgelassen */
  {
   if  ( ev & EV_LEFT_PRESS ) /* wurde der linke Mausbutton niedergedrckt? */
    if ( ( mourb = rbi_maus( rbip, x, y ) ) != -1  &&
         (rbip->infoptr+mourb)->enabled  )
      return TF_MAUS;            /* Maus ber dem Button und Button enabled */
   return TF_WEITER;                               /* Mausereignis abweisen */
  }
}

/*****************************************************************************
*  Funktion         : r b _ c a n                                            *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um festzustellen, ob    *
*                     das Dialogfeld bereit ist, aktiviert zu werden.        *
*  Eingabe-Parameter: RBIP = der Zeiger, der beim Aufruf von rb_start zurck-*
  *                          geliefert wurde.                                *
*  Return-Wert      : TRUE, wenn das Dialog-Feld aktiviert werden kann,      *
*                     sonst FALSE                                            *
*****************************************************************************/

BOOL rb_can( RBIP rbip )
{
 return TRUE;
}

/*****************************************************************************
*  Funktion         : r b _ a k t i v                                        *
**--------------------------------------------------------------------------**
*  Aufgabe          : Wird vom Scheduler aufgerufen, um das Dialog-Feld von  *
*                     seiner Aktivierung in Kenntnis zu setzen.              *
*  Eingabe-Parameter: RBIP = der Zeiger, der beim Aufruf von rb_start zurck-*
*                            geliefert wurde.                                *
*                     WHY  = warum wird das Feld aktiviert                   *
*  Return-Wert      : keiner                                                 *
*****************************************************************************/

void rb_aktiv( RBIP rbip, BYTE why )
{
 RBINFO * riptr;                /* Zeiger auf Element im internen RB-Vektor */

 rbip->aktiv = TRUE;                                 /* neuen Status merken */
 rbip->mouout = FALSE; /* Mausknopf nicht auerhalb der Buttons losgelassen */
 justrel = FALSE;                     /* noch keine Umschaltung vorgenommen */
 riptr = rbip->infoptr + *rbip->varptr;   /* Zeiger auf akt. Element setzen */
 VioSetCursor( riptr->x1+1, riptr->y );  /* Cursor auf den aktuellen Button */
}

