{****************************************************************************}
{*                    Auswertung von Ausdruecken                            *}
{*                                                                          *}
{*    p Berechne uebergibt das Ergebnis und den Fehlercode                  *}
{*    Der Fehlercode kann mehrere Fehler ausdruecken:                       *}
{*    0     : kein Fehler                                                   *}
{*    1..15 : einfache Fehler (Klartext von Error)                          *}
{*    <0    : Ergebnis ist relativ zum PC zu interpretieren                 *}
{*    32    : externes Label ist aufgetreten                                *}
{****************************************************************************}

procedure Berechne(z : zeile; var ergebnis, fehler:integer);

  label  EXIT;
  var    p1,p2 : byte;
         t     : zeile;
         fc    : integer;
         h     : boolean;

  type  Operator = (IntMal,IntDiv,IntMod,IntShl,IntShr,IntPlus,
                    IntMinus,IntNot,IntAnd,IntOr,IntXor,
                    Ungleich,Kleiner,Groesser,Gleich,Low,High);

  procedure reval(z : zeile; var ergebnis, fehler: integer);
    var Temp : tEintrag;
        vz:-1..1;

    function Umwandlung
              (z : zeile; Basis : byte; var fehler : integer) : integer;
      var   i,t,p,n : integer;
      begin
        fehler:=0; p:=1; t:=0;
        for i:=length(z) downto 1 do
          begin
            case z[i] of
             '0'..'9' : n:=ord(z[i])-48;
             'A'..'F' : n:=ord(z[i])-55
             else n:=-1;
            end;
            if not (n in [0..Basis-1])
               then fehler:=fehler or 1 else t:=t+n*p;
            p:=p*Basis
          end;
          Umwandlung:=t
      end;

  begin {reval};
    fehler:=0; vz:=1;
    if pos(#39,z)=1
      then
        begin
          delete(z,1,1);
          if z<>'' then if z[length(z)]=#39 then delete(z,length(z),1);
          while pos(#39#39,z)>0 do delete(z,pos(#39#39,z),1);
          if length(z)>1 then Ergebnis:=(ord(z[1]) shl 8) or ord(z[2]) else
          if length(z)=1 then Ergebnis:=ord(z[1])
          else fehler:=2
        end
      else
        begin
          while pos(' ',z)>0 do delete(z,pos(' ',z),1);
          if z<>'' then begin
             if z[1]='-' then begin vz:=-1; delete(z,1,1) end;
             if not (z[1] in ['$','A'..'Z']) then
               case z[length(z)] of
                'H'    : Ergebnis:=vz*Umwandlung(copy(z,1,length(z)-1),16,fehler);
                'O','Q': Ergebnis:=vz*Umwandlung(copy(z,1,length(z)-1),8,fehler);
                'B'    : Ergebnis:=vz*Umwandlung(copy(z,1,length(z)-1),2,fehler)
                else Ergebnis:=vz*Umwandlung(z,10,fehler)
               end else
             if z='$' then begin Ergebnis:=PC; fehler:=$8000 end
            else
              begin
                Temp.VarName:=z; Suche(VarListe,Temp,SuchListe);
                if SuchListe=NIL then fehler:=4
                                 else with SuchListe^.Eintrag do
                                   begin
                                     if Art=extern then fehler:=32 else
                                     if Art=macro  then fehler:=12 else
                                       begin
                                         Ergebnis:=VarRef;
                                         if Art=relativ then fehler:=$8000
                                       end
                                   end
              end
          end else fehler:=5
        end
  end;

function OperatorVorhanden
         (var z:zeile; var op:Operator;
          var a1,a2:integer; var fehler:integer):boolean;

  const OpName : array[Operator] of string[5] =
                  ('*','\',' MOD ',' SHL ',' SHR ',
                  '+','-','NOT ',' AND ',' OR ',' XOR ',
                  '<>','<','>','=','LO ','HI ');
        Erlaubt: set of char = ['a'..'z','A'..'Z','0'..'9','_','$','~',''''];
  var p              : byte;
      fc, m1, m2     : integer;
      as1, as2       : string[20];

  procedure Check(o1,o2:Operator; var p : byte; var op : Operator);
    var q : byte;
        i : operator;
    begin
      for i:=o1 to o2 do
        begin
          q:=pos(OpName[i],z);
          if p=0 then begin p:=q; op:=i end
                 else if (q>0) and (q<p) then begin p:=q; op:=i end
        end
    end;

  begin p:=0; as1:=''; as2:='';
    while pos(' ',z)=1 do delete(z,1,1);
    if z<>'' then if z[1]='-' then z[1]:='~';
    Check(Low,High,p,op);
    if p=0 then Check(IntMal,IntMod,p,op);
    if p=0 then Check(IntShl,IntShr,p,op);
    if p=0 then Check(IntPlus,IntMinus,p,op);
    if p=0 then Check(IntNot,IntNot,p,op);
    if p=0 then Check(IntAnd,IntXor,p,op);
    if p=0 then Check(Ungleich,Gleich,p,op);
    if p>0 then
      begin m1:=p+length(OpName[op]);
        while (m1<length(z)) and (z[m1]=' ') do m1:=succ(m1); z:=z+' ';
        m2:=m1; while z[m2] in Erlaubt do m2:=succ(m2);
        as2:=copy(z,m1,m2-m1);
        delete(z,p,m2-p); delete(z,length(z),1);
        insert('?',z,p);
        if not (op in [IntNot,Low,High]) then
          begin
            z:=':'+z;
            m1:=p;
            while z[m1]=' ' do m1:=pred(m1);
            m2:=m1; while z[m2] in Erlaubt do m2:=pred(m2);
            as1:=copy(z,m2+1,m1-m2); delete(z,m2+1,p-m2);
            delete(z,1,1);
          end
      end;
    OperatorVorhanden:=p>0; if z[1]='~' then z[1]:='-';
    if p>0 then begin
       if as2[1]='~' then as2[1]:='-'; if as1[1]='~' then as1[1]:='-';
       reval(as2,a2,fc); fehler:=fc;
       if not (op in [IntNot, Low, High]) then reval(as1,a1,fc);
       fehler:=fehler xor fc or fc and $7FFF
    end
  end;

  procedure rechne(var z : zeile; var fehler : integer);
    label EXIT;
    var o : Operator;
        s : string[6];
        a,b,fc : integer;
    begin
      fehler:=0;
      while OperatorVorhanden(z,o,a,b,fc) and ((fc and $7FDF)=0) do
        begin
          fehler:=fehler xor fc or fc and $7FFF;
          if (fehler and 32)=32 then goto EXIT;
          case o of
            IntPlus : a:=a+b;
            IntMal  : a:=a*b;
            IntMod  : a:=a MOD b;
            IntDiv  : if b<>0 then a:=a div b else begin fehler:=6; a:=0 end;
            IntMinus: a:=a-b;
            IntSHL  : a:=a SHL b;
            IntSHR  : a:=a SHR b;
            IntAND  : a:=a AND b;
            IntOR   : a:=a OR b;
            IntXOR  : a:=a XOR b;
            IntNOT  : a:=NOT b;
            Kleiner : if a<b then a:=-1 else a:=0;
            Groesser: if a>b then a:=-1 else a:=0;
            Gleich  : if a=b then a:=-1 else a:=0;
            UnGleich: if a<>b then a:=-1 else a:=0;
            low     : a:=LO(b);
            high    : a:=HI(b)
          end;
          str(a,s); if s[1]='-' then s[1]:='~';
          insert(' '+s+' ',z,pos('?',z)); delete(z,pos('?',z),1);
        end;
        EXIT:
    end;

  begin {Berechne}
    fehler:=0;
    while pos(')',z)>0 do
      begin
        p1:=pos(')',z); p2:=p1-1;
        while (p2>0) and (z[p2]<>'(') do p2:=p2-1;
        if p2<=0 then begin h:=error(13,z); goto EXIT end;
        if (p2=1) and (p1=length(z))
          then begin delete(z,1,1); delete(z,length(z),1) end
          else begin
                 t:=copy(z,p2+1,p1-p2-1); delete(z,p2,p1-p2+1);
                 insert('?',z,p2); rechne(t,fc); fehler:=fehler xor fc or fc and $7FFF;
                 if (fc and $7FFF)<>0 then goto EXIT;
                 if t[1]='-' then t[1]:='~';
                 insert(' '+t+' ',z,p2); delete(z,pos('?',z),1)
               end
      end;
    rechne(z,fc); fehler:=fehler xor fc or fc and $7FFF;
    reval(z,ergebnis,fc); fehler:=fehler xor fc or fc and $7FFF;
    EXIT:
  end;
