                 {       -------------------------     }
                 {       DISASSEMBLER FR DEN 8052     }
                 {       (c) 1986  by  Paul KOSTAL     }
                 {       -------------------------     }

program disas;

type txt    = string[2];
     txt2   = string[4];
     txt3   = string[80];
     Adr    = string[10];
var fname   : string[14];
    COMFile : file;
    PZ,PC,PC0,PC0Lo,PC0Hi,PC1,error   : integer;
    Befehl,sta : Adr;
    ASCII   : txt2;
    Taste   : char;
    ausg,p,first  : boolean;
    Puffer  : array[0..maxint] of byte;

procedure Menue;
  begin ClrScr;
    writeln;
    writeln('(c) 1986 by Paul KOSTAL':42);
    writeln;
    writeln('Disassembler-Befehle':40);
    writeln('--------------------':40);
    writeln;writeln;
    writeln('    D            Disassembliere ab Adresstand');
    writeln('    D xxxx       Disassembliere ab Adresse xxxx');
    writeln('    M            Hexdump ab Adresstand');
    writeln('    M xxxx       Hexdump ab Adresse xxxx');
    writeln('    P            Print Disassembler');
    if p=true then
    writeln('                 ----- on -----')
    else
    writeln('                 ----- off -----');
    writeln('    ^S           Anhalten/Weiter');
    writeln('    RETURN       Stopt Funktion');
    writeln('    PgUp         Seite vor');
    writeln('    PgDn         Seite rckwrts');
    writeln('    Home         Anfang');
    writeln('    End          Ende');
    writeln('    ? od.       Zeigt dieses Men');
    writeln('    QUIT         Ausstieg');
    writeln;
  end;

function HEX(a:integer):txt;
  var b : integer;
  const hd : array[0..15] of char =
      ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
  begin
    b:=a div 16;
    a:=a mod 16;
    HEX:=hd[b]+hd[a];
  end;

function HEX2(a:integer):txt2;
  var b : integer;
      neg : boolean;
  begin
    if a<0 then neg:=true else neg:=false;
    b:=abs(a div 256);
    a:=abs(a mod 256);
    if neg then begin b:=256-b-1;
      if a=0 then b:=succ(b) else a:=256-a end;
    HEX2:=HEX(b)+HEX(a);
  end;

procedure GetLoHi(Adresse:Adr; var Low,High:integer);
  var LO,HI : txt;
    begin
      LO:=copy(Adresse,3,2);
      HI:=copy(Adresse,1,2);
      val('$'+LO,Low,error);
      if error=0 then val('$'+HI,High,error);
    end;


procedure GetAdr;
  var PC1Lo,PC1Hi : integer;
  begin
    if (length(Befehl)>1) and (Befehl<>'QUIT') and (Befehl<>'quit') then
    begin
      delete(Befehl,1,1);
      GetLoHi(Befehl,PC1Lo,PC1Hi);
      if error>0 then Taste:=#0 else
      if PC1Hi<PC0Hi then PC1:=0 else begin
        PC1Hi:=PC1Hi-PC0Hi;
        if PC1Lo<PC0Lo then
        begin
          PC1Hi:=PC1Hi-1;
          PC1Lo:=PC1Lo-PC0Lo+256;
        end else PC1Lo:=PC1Lo-PC0Lo;
        PC1:=PC1Lo+PC1Hi*256
      end;
    end;
    PC0:=PC0Lo+PC0Hi*256;
  end;

procedure GetBefehl;
  begin
    TextColor(Yellow+Blink);write(#205,#16,' '); TextColor(White);
    readln(Befehl);
    while pos(' ',Befehl)>0 do delete(Befehl,pos(' ',Befehl),1);
    Taste:=Befehl[1];
    Taste:=UpCase(Taste);
    GetAdr;
  end;

procedure Hexdump;
  var I,S : integer;
  begin
    S:=0;
    Taste:=#0;
    ausg:=true;
    if PC1>PC then PC1:=PC-12*16;
    ClrScr;
    repeat
       if ausg=false then begin S:=12; PC1:=PC1-16; end else begin
        TextColor(White);
        write(HEX2(PC1+PC0):5,'   ');
        for I:=PC1 to PC1+15 do write(HEX(Puffer[I]):4);
        writeln; write(' ':7);
        TextColor(LightRed);
        for I:=PC1 to PC1+15 do
          if Puffer[I] IN [32..125] then write (chr(Puffer[I]):4) else
          write (#176:4);
        S:=succ(S); writeln;
      end;
      if S=12 then begin
        S:=0; read(kbd,Taste);
        ausg:=true;
        if Taste=#27 then begin read(kbd,Taste);
          case Taste of
 {PageUp}   #73: if PC1=11*16 then ausg:=false else
                   begin ClrScr; PC1:=PC1-24*16; if PC1<0 then PC1:=-16
                 end;
 {PageDn}   #81: if PC1<PC-16 then ClrScr else ausg:=false;
 {Home}     #71: if PC1=11*16 then ausg:=false else
                   begin ClrScr; PC1:=-16; end;
 {End}      #79: if PC1=PC-16 then ausg:=false else
                   begin ClrScr; PC1:=PC-13*16; end;
          end; end else ausg:=false;
      end;
      PC1:=PC1+16;
    until Taste=#13;
  end;

{$I DISASSEM.INC}


begin
  p:=false; first:=true; {default}
  TextColor(White);
  ClrScr; writeln('  Disassembler fr 8052':45);writeln;
  repeat
    if (ParamCount=0) or (not first) then
      begin write('Filename:');readln(fname) end
    else begin fname:=ParamStr(1); first:=false; end;
    writeln;
    assign(COMFile,fname);
    {$I-};
    reset(COMFile);
    {$I+};
  until (IOresult = 0);
  PZ:=FileSize(COMFile);
  if PZ>255 then begin PZ:=255; write('File zu lang !!        '); end;
  blockread(COMfile,Puffer,PZ);
  close(COMFile);
  PC:=PZ*128;
  writeln(PC,' Bytes geladen');
  writeln;
  repeat
    write('Startadresse in Hex (xxxx):');readln(sta);
    GetLoHi(sta,PC0Lo,PC0Hi);
  until error=0;
  PC1:=0;
  Menue;
  repeat
    GetBefehl;
    case Taste of
      'D': Disassemb;
      'M': Hexdump;
      'P': begin
             if p=true then p:=false else p:=true;
             Menue;
           end;
      '?': Menue;
      '': Menue;
      'Q': ;
    else writeln('Falscher Befehl oder Adresse');
  end;
  until (Befehl='QUIT') or (Befehl='quit')
end.
