{**********************************************************************}
{*                                                                    *}
{*   Hier sind die eigentlichen Assembler-Durchlaeufe. Da PASS1 und   *}
{*   PASS2 sehr aehnlich sind, wurden sie in einer Prozedur DOPASS    *}
{*   vereint.                                                         *}
{**********************************************************************}

procedure DoPass(PASS : byte);

type PseudoOpcode = (pNO,pORG,pDS,pDB,pDL,pDW,pEXT,pEQU,
                     pSET,pIF,pELSE,pENDIF,pEND,pMACRO,
                     pZ80,p6502,p8080,p8086,p8052);

const NoLabelOp : set of PseudoOpcode = [pEQU,pSET,pDL,pEXT,pMACRO];

var  DoFlag                               : array[byte] of boolean;
     IfCount1, IfCount2, BZ               : byte;
     OPCODE, Lab                          : LabelString;
     POp                                  : PseudoOpcode;
     SourceZeile, Com, L, Arg1, Arg2, h1  : zeile;
     te                                   : tEintrag;
     Fehler, i, er, pc1, Anzahl           : integer;
     EndOfSource, Do1,
     h, PrintFlag                         : boolean;
     L1                                   : zeile;
     local                                : char;

procedure SkipString(var z : zeile; var h1 : zeile);
  begin
    h1:='';
    delete(z,1,1);
    repeat
      if pos(#39#39,z)=1 then delete(z,1,1);
      if z<>'' then begin h1:=h1+z[1]; delete(z,1,1) end
    until (z='') or ((pos(#39,z)=1) and (pos(#39#39,z)<>1));
    if pos(#39,z)=1 then delete(z,1,1);
    SkipLeftBlanks(z);
    if pos(',',z)=1 then delete(z,1,1);
    SkipLeftBlanks(z)
  end;

procedure SkipWord(var z : zeile; var e : integer);
  var fc : integer; p : byte; h : boolean; t : zeile;
  begin
    p:=pos(',',z);
    if p=0
       then begin t:=z; z:='' end
       else begin t:=copy(z,1,p-1); delete(z,1,p) end;
    SkipLeftBlanks(t); SkipRightBlanks(t); Berechne(t,e,fc);
    SkipLeftBlanks(z); if PASS=2 then h:=error(fc,t)
  end;

procedure DBString(z : zeile; var h1 : zeile; var Anzahl : byte);
  var e : integer; t : zeile;
  begin  Anzahl:=0; h1:=''; SkipLeftBlanks(z);
    while z<>'' do
     if z[1]=''''
      then begin SkipString(z,t); h1:=h1+t; Anzahl:=Anzahl+length(t) end
      else begin SkipWord(z,e); h1:=h1+chr(e); Anzahl:=succ(Anzahl) end
  end;

procedure DWString(z : Zeile; var h1 : zeile; var Anzahl : byte);
  var e : integer; t : zeile; h : boolean;
  begin  h1:=''; SkipLeftBlanks(z); L:='';
    if z[length(z)]<>',' then z:=z+',';
    while z<>'' do
      if z[1]=''''
       then
          begin
            SkipString(z,t);
            if length(t)<>2
              then h:=error(2,t)
              else L:=L+'/$'+HexByte(ord(t[2]))+'/$'+HexByte(ord(t[1]))
          end
       else begin
              L:=L+'/'+copy(z,1,pos(',',z)-1);
              Delete(z,1,Pos(',',z));
              SkipLeftBlanks(z)
            end;
       Delete(L,1,1);
       Anzahl:=ByteZahl(L);
       if PASS=2 then
       begin PC:=PC+Anzahl; Konvertiere(PC-Anzahl,L); PC:=PC-Anzahl end
  end;

function PseudoOp(o:LabelString):PseudoOpcode;
  begin
   if o='ORG'   then PseudoOp:=pOrg
   else if (o='DS') or (o='DEFS') then PseudoOp:=pDS
   else if (o='DB') or (o='DEFB') then PseudoOp:=pDB
   else if (o='DW') or (o='DEFW') then PseudoOp:=pDW
   else if (o='DL') or (o='DEFL') then PseudoOp:=pDL
   else if o='EXT'   then PseudoOp:=pEXT
   else if o='EQU'   then PseudoOp:=pEQU
   else if o='SET'   then PseudoOp:=pSET
   else if o='IF'    then PseudoOp:=pIF
   else if o='ELSE'  then PseudoOp:=pELSE
   else if o='ENDIF' then PseudoOp:=pENDIF
   else if o='END'   then PseudoOp:=pEND
   else if o='MACRO' then PseudoOp:=pMACRO
   else if o='.Z80'  then PseudoOp:=pZ80
   else if o='.6502' then PseudoOp:=p6502
   else if o='.8080' then PseudoOp:=p8080
   else if o='.8086' then PseudoOp:=p8086
   else if o='.8052' then PseudoOp:=p8052
   else PseudoOp:=pNO
  end;

begin
  Prozessor := MPC_Z80; {Default} first:=true; local:='A';
  PC:=0; IfCount1:=0; IfCount2:=0; DoFlag[0]:=true; TextStack:=NIL;
  reset(Source); EndOfSource:=false;
  writeln('PASS ',PASS); if PASS=2 then writeln(Objekt,'INLINE (');
  while (not EOF(Source)) and (not EndOfSource) do begin
    L:=''; L1:=''; PrintFlag:=true; pc1:=PC; h1:=''; Anzahl:=0;
    if TextStack=NIL
      then readln(Source,SourceZeile)
      else PopZeile(SourceZeile);
    ScanLine(SourceZeile,Lab,OPCODE,Arg1,Arg2,Com,local);
    POp:=PseudoOp(OPCODE); Do1:=DoFlag[IfCount1];
    if POp=pSET then if Arg2<>'' then POp:=pNO;
    if (Lab<>'') and (Do1) and (not(POp in NoLabelOp))
      then with te do
       begin
         VarName:=Lab; Art:=relativ; VarRef:=PC;
         Suche(VarListe,te,SuchListe);
         if PASS=1
           then
             if SuchListe=NIL then FuegeEin(VarListe,te) else
             h:=error(7,Lab)
           else
             if SuchListe^.Eintrag.VarRef<>VarRef
               then h:=error(11,Lab)
       end;

    case POp of
      pIF  : begin IfCount2:=succ(IfCount2); PrintFlag:=False;
              if Do1 then
                begin
                  Berechne(Arg1,er,Fehler); IfCount1:=succ(IfCount1);
                  DoFlag[IfCount1]:=er<>0 ; h:=error(Fehler,Arg1)
                end
             end;
      pENDIF : if IfCount2=0 then h:=error(17,'') else
               begin IfCount2:=Pred(IfCount2); PrintFlag:=false;
                 if IfCount2=IfCount1-1 then IfCount1:=pred(IfCount1)
               end;
      pELSE  : if IfCount2=0 then h:=error(16,'') else
               begin PrintFlag:=false;
                 if IfCount1=IfCount2 then
                   if IfCount1>0 then
                     DoFlag[IfCount1]:=not DoFlag[IfCount1]
               end
    end;

    if Do1 and (not(POp in [pIF,pENDIF,pELSE])) then with te do
    case POp of
      pMACRO : if PASS=1 then
                 begin  if Arg2<>'' then Arg1:=Arg1+','+Arg2;
                   MachMacro(Lab,Arg1)
                 end else begin PrintFlag:=false; SkipMacro(Lab) end;
      pEXT : if Lab<>'' then begin
               Art:=extern; VarName:=Lab; FuegeEin(VarListe,te) end;
      pEQU : if Lab<>'' then
               begin
                 Art:=absolut; VarName:=Lab;
                 Berechne(Arg1,VarRef,Fehler);
                 L1:='('+HexWord(VarRef)+')';
                 if not error(Fehler,Arg1) then
                   begin Suche(VarListe,te,SuchListe);
                     if PASS=1 then
                       if SuchListe=NIL then FuegeEin(VarListe,te)
                                        else h:=error(10,Lab)
                     else if SuchListe<>NIL then
                             if SuchListe^.Eintrag.VarRef<>VarRef then
                                             h:=error(11,Lab)
                   end
               end; {with}
      pSET : if Lab<>'' then
                 begin Berechne(Arg1,VarRef,Fehler); Art:=absolut;
                   VarName:=Lab; L1:='('+HexWord(VarRef)+')';
                   if not error(Fehler,Arg1) then FuegeEin(VarListe,te)
                 end;
      pDL  : if Lab<>'' then
                 begin Berechne(Arg1,VarRef,Fehler);
                   if Fehler < 0 then Art:=relativ else Art:=absolut;
                   VarName:=Lab; L1:='('+HexWord(VarRef)+')';
                   if not error(Fehler,Arg1) then FuegeEin(VarListe,te)
                 end;
      pDS  : begin Berechne(Arg1,er,Fehler);
               if not error(Fehler,Arg1) then
                 begin PC:=PC+er; Anzahl:=er end end;
      pDB  : begin DBString(Arg1+','+Arg2,h1,BZ); PC:=PC+BZ end;
      pDW  : begin DWString(Arg1+','+Arg2,h1,BZ); PC:=PC+BZ end;
      pORG : begin berechne (Arg1,er,Fehler);
             if Fehler and $7FFF<>0 then begin if Error(4,Arg1) then end
               else PC:=er;
             if (PASS=2) and (Fehler and $7FFF=0) then
               writeln(objekt,'{*=',er,'}') end;
      pZ80 : Prozessor := MPC_Z80;
      p6502: Prozessor := MPC_6502;
      p8080: Prozessor := MPC_8080;
      p8086: Prozessor := MPC_8086;
      p8052: Prozessor := MPC_8052;
      pEND : begin EndOfSource:=true end

      else if OPCODE<>'' then
             begin
               VarName:=OPCODE; Suche(VarListe,te,SuchListe);
               if SuchListe<>NIL
                 then
                   begin
                     if SuchListe^.Eintrag.Art=macro then
                       begin
                         if Arg2<>'' then begin Arg1:=Arg1+','+Arg2;
                           Arg2:='' end;
                         with SuchListe^,Eintrag do
                           begin
                            PushMacro(MPtr^,Arg1);
                            local:=MPtr^.local; MPtr^.local:=succ(local)
                           end
                       end
                   end
                 else
                  begin
                    case Prozessor of
                      MPC_Z80  : HexLine1(OPCODE,Arg1,Arg2,L);
                      MPC_6502 : HexLine2(OPCODE,Arg1,Arg2,L);
                      MPC_8080 : HexLine3(OPCODE,Arg1,Arg2,L);
                      MPC_8086 : HexLine4(OPCODE,Arg1,Arg2,L);
                      MPC_8052 : HexLine5(OPCODE,Arg1,Arg2,L)
                    end;
                    PC:=PC+ByteZahl(L);
                    if L=''
                      then
                        begin
                          if Arg2<>'' then begin Arg1:=Arg1+','+Arg2;
                            Arg2:=''end;
                          h:=error(14,OPCODE+' '+Arg1)
                        end
                      else if PASS=2 then Konvertiere(PC-ByteZahl(L),L)
                  end
             end
    end; {case}

    if (PASS=2) and (PrintFlag) and (Do1) then
      begin write(PRNFile,'*',HexWord(pc1),' ');
        write(Objekt,L);
        Arg1:=copy(Lab+'         ',1,9)+OPCODE+' '+Arg1;
        if Arg2<>'' then Arg1:=Arg1+','+Arg2;
        if Arg1='          ' then Arg1:='';
        if Com<>'' then Arg1:=Arg1+'  ;'+Com;

        if Anzahl>0 then
          begin
            str(Anzahl,L1); L1:='('+L1+' Bytes res.)';
            for i:=1 to Anzahl do
              begin
                if not first then write(Objekt,'/') else first:=false;
                write(Objekt ,'$00');
                if (i MOD 19) = 0 then writeln(Objekt);
              end;
            if (Anzahl mod 19)<>0 then writeln(Objekt)
          end;
        if h1<>'' then for i:=1 to length(h1) do
          begin
             if first then first:=false
               else begin write(Objekt,'/'); write(PRNFile,'/') end;
             write(Objekt ,'$'+HexByte(ord(h1[i])));
             write(PRNFile,'$'+HexByte(ord(h1[i])));
             if (i MOD 19) = 0 then writeln(Objekt);
             if (i mod 6 ) = 0 then
               write(PRNFile,#13#10'*',HexWord(pc1+i),' ')
          end;
        if h1<>'' then if (length(h1) mod 19)<>0 then writeln(Objekt);
        if Arg1<>'' then
          if KommentarFlag then
            begin if length(L)>23 then
              begin writeln(Objekt); write(Objekt,'':24) end
              else  write(Objekt,'':24-length(L));
              writeln(Objekt,'(*',copy(arg1,1,45),'*)':47-length(Arg1))
            end
          else if L<>'' then writeln(Objekt);
        if L='' then L:=L1;
        if h1='' then begin
           while length(L)>24 do begin i:=24;
             while (i>0) and (L[succ(i)]<>'/')
                 do i:=pred(i);
                 if i=0 then i:=length(L);
                 writeln(PRNFile,copy(L,1,i));
                 Delete(L,1,i);
                 if L='' then i:=0
                 else i:=ByteZahl(copy(L,2,length(L)-1));
                 Write(PrnFile,'*',HexWord(PC-i),' ')
             end;
             write(PRNFile,L,'':24-length(L))
           end
           else for i:=(length(h1) mod 6) to 5 do write(PRNFile,'    ');
        writeln(PRNFile,' ',copy(Arg1,1,47));
      end;
    PrintFlag:=true;
  end; {while}

  if IfCount2>0 then h:=error(18,'');
  if PASS=2 then
    begin
     writeln(Objekt,')');
     if FehlerZahl>0 then
       writeln(Objekt,FehlerZahl,' Fehler aufgetreten.')
    end;
  writeln(PRNFile,FehlerZahl,' Fehler aufgetreten.');
end;
