{ Berechnet den Z80-Code }
overlay
procedure HexLine1(var o : LabelString; a1 , a2 : zeile; var H : zeile);


  type string3  = string[4];
       string30 = string[30];

  const IB : array[1..2] of integer = ($DD,$FD);

  var d       : string30;
      fc,b    : integer;
      on      : byte;
      DR,I,R1,R2,C : integer;
      D1,D2        : byte;

function NI(x:byte):string3;
  begin NI:='$'+HexByte(IB[x])+'/' end;

function DD(var a : string3) : byte; var i,t:byte;
  const DRN : array[1..6] of string[2]=('BC','DE','HL','IX','IY','SP');
  begin  t:=0; for i:=1 to 6 do if DRN[i]=a then t:=i; DD:=t end;

const HH : array[0..67] of integer =  (-1,
       -1, -1, -1, -1, -1, $3F, -1, $EDA9, $EDB9, $EDA1,
       $EDB1, $2F, $27, -1, $F3, -1, $FB, -1, $D9, $76,
       -1, -1, -1, $EDAA, $EDBA, $EDA2, $EDB2, -1, -1, -1,
       $EDA8, $EDB8, $EDA0, $EDB0, $ED44, $00, -1, $EDBB, $EDB3, -1,
       $EDAB, $EDA3, -1, -1, -1, -1, $ED4D, $ED45, -1, $17,
       -1, $07, $ED6F, -1, $1F, -1, $0F, $ED67, -1, -1,
       $37, -1, -1, -1, -1, -1, -1);

function OpCodeNummer(var z : LabelString):integer;
  const OpcodeName : array[1..67] of string[4] =
               ('ADC','ADD','AND','BIT','CALL','CCF','CP','CPD','CPDR','CPI',
                'CPIR','CPL','DAA','DEC','DI','DJNZ','EI','EX','EXX','HALT',
                'IM','IN','INC','IND','INDR','INI','INIR','JP','JR','LD',
                'LDD','LDDR','LDI','LDIR','NEG','NOP','OR','OTDR','OTIR','OUT',
                'OUTD','OUTI','POP','PUSH','RES','RET','RETI','RETN','RL','RLA',
                'RLC','RLCA','RLD','RR','RRA','RRC','RRCA','RRD','RST','SBC',
                'SCF','SET','SLA','SRA','SRL','SUB','XOR');
  var i,j,m : integer;
  begin i:=1; j:=67;
     repeat m:=(i+j) div 2; if z<=OpCodeName[m] then j:=m else i:=m+1 until i=j;
     if OpCodeName[i]=z then OpCodeNummer:=i
                        else OpCodeNummer:=0
  end;

  procedure HNorm(x:integer; var HN : zeile);
    begin
      HN:='';
      if x<>-1 then
        begin
         if Hi(x)>0 then HN:='$'+HexByte(Hi(x))+'/';
         HN:=HN+'$'+HexByte(Lo(x))
        end
    end;

  function Regs(var a : zeile) : integer;
    const RegName : array[0..6] of char = 'BCDEHLA';
    var  i : 0..6;
    begin
      Regs:=-1;
      for i:=0 to 6 do if a=RegName[i] then if i=6 then Regs:=7 else Regs:=i;
    end;

  function DubRegs(var a : zeile; rr : string3) : integer;
    const RegName : array[0..3] of string[2] = ('BC','DE','HL','SP');
    var i    : 0..3;
    begin if rr='AF' then begin RegName[2]:='HL'; RegName[3]:=rr end
                     else begin RegName[2]:=rr; RegName[3]:='SP' end;
      DubRegs:=-1;
      for i:=0 to 3 do if a=RegName[i] then DubRegs:=i;
    end;

  function Cond(var a : zeile) : integer;
    const CondName : array[0..7] of string[2] =
                    ('NZ','Z','NC','C','PO','PE','P','M');
    var i    : 0..7;
    begin
      Cond:=-1;
      for i:=0 to 7 do if a=CondName[i] then Cond:=i;
    end;

  function Indexed(a : string30; var d : zeile) : integer;
    begin
      while pos(' ',a)>0 do delete(a,pos(' ',a),1);
      if length(a)>4 then d:='<'+copy(a,5,length(a)-5) else d:='';
      if copy(a,1,4)='(IX+' then Indexed:=1 else
      if copy(a,1,4)='(IY+' then Indexed:=2 else Indexed:=-1
    end;

   procedure HStandard(var a2 : zeile; rg,sh,n,hl:byte; var HS:string30);
     var R,I:integer;
     begin R:=Regs(a2); I:=Indexed(a2,d);
       if R>=0 then HNorm(rg or (R shl sh),HS) else
       if I>0 then begin HNorm((IB[I] shl 8) or hl,HS); HS:=HS+'/'+d end else
       if a2='(HL)' then HNorm(hl,HS)
       else begin HNorm(n,HS); HS:=HS+'/<'+a2 end
    end;

   procedure HBit(var a2:zeile; b2,b:byte; var HB : string30);
     var I,R : integer;
     begin i:=Indexed(a2,d); r:=Regs(a2);
       if R>=0 then HNorm($CB00 or (b2 or R or (b shl 3)),HB) else
       if I>0 then begin HNorm(b2 or 6 or (b shl 3),HB);
                     HB:=NI(I)+'$CB/'+d + '/'+ HB end else
       if a2='(HL)' then HNorm($CB00 or (b2 or 6 or (b shl 3)),HB)
       else HB:=''
     end;

   procedure HRot(var a:zeile; b1,rc:Byte; var HR : string30);
     var R,I : integer;
     begin R:=Regs(a); I:=Indexed(a,d);
       if R>=0 then HNorm($CB00 or (rc or R),HR) else
       if a='(HL)' then HNorm($CB00 or b1,HR) else
       if I>0 then begin HNorm(b1,HR); HR:=NI(I)+'$CB/'+d+'/'+HR end
       else HR:=''
     end;

   begin R1:=Regs(a1); R2:=Regs(a2); D1:=DD(a1); D2:=DD(a2);
    C:=Cond(a1); on:=OpCodeNummer(o);
    HNorm(HH[on],H);
    if H='' then
    case on of
      1: if a1='A' then HStandard(a2,$88,0,$CE,$8E,H) else
         if D1=3 then begin DR:=DubRegs(a2,a1);
             if DR>=0 then HNorm($ED00 or ($4A or (DR SHL 4)),H) end;
      2: if a1='A' then HStandard(a2,$80,0,$C6,$86,H)
         else
           begin DR:=DubRegs(a2,a1); if DR>=0 then
             case D1 of
               3 : HNorm($09 or (DR SHL 4),H);
               4 : HNorm($DD00 or ($09 or (DR SHL 4)),H);
               5 : HNorm($FD00 or ($09 or (DR SHL 4)),H)
             end
           end;
      3: HStandard(a1,$A0,0,$E6,$96,H);
      4: begin Berechne(a1,b,fc); Hbit(a2,$40,Lo(b),H) end;
      5: if C>=0 then begin HNorm($C4 or (C shl 3),H); H:=H+'/'+a2 end
                 else H:='$CD/'+a1;
      7: HStandard(a1,$B8,0,$FE,$BE,H);
     14: begin DR:=DubRegs(a1,'HL');
          if DR>=0 then HNorm($0B or (DR shl 4),H) else
          if D1=4 then HNorm($DD2B,H) else
          if D1=5 then HNorm($FD2B,H)
          else HStandard(a1,$05,3,0,$35,H) end;
     16: H:='$10/~'+a1;
     18: if a1='(SP)' then
           case D2 of
             3 : HNorm($E3,H);
             4 : HNorm($DDE3,H);
             5 : HNorm($FDE3,H)
            end else
         if (a1='AF') and (a2='AF''') then HNorm($08,H) else
         if (D1=2) and (D2=3) then HNorm($EB,H);
     21: case a1[1] of
          '0' : HNorm($ED46,H);
          '1' : HNorm($ED56,H);
          '2' : HNorm($ED5E,H)
         end;
     22: if a2='(C)' then begin if Regs(a1)>=0
                            then HNorm($ED00 or ($40 or (Regs(a1) shl 3)),H)
                          end else
         if a1='A' then begin SkipPar(a2); H:='$DB/<'+a2 end;
     23: begin DR:=DubRegs(a1,'HL');
          if DR>=0 then HNorm($03 or (DR shl 4),H) else
          if D1=4 then HNorm($DD23,H) else
          if D1=5 then HNorm($FD23,H)
          else HStandard(a1,$04,3,0,$34,H) end;
     28: if C>=0 then H:='$'+HexByte($C2 or (C shl 3))+'/'+a2 else
         if a1='(HL)' then HNorm($E9,H) else
         if a1='(IX)' then HNorm($DDE9,H) else
         if a1='(IY)' then HNorm($FDE9,H)
         else H:='$C3/'+a1;
     29: if C>=0 then H:='$'+HexByte($20 or (C shl 3))+'/~'+a2 else H:='$18/~'+a1;

     30: if geklammert(a1) then
           begin I:=Indexed(a1,d); SkipPar(a1);
             if a1='HL' then
                if R2>=0 then H:='$'+HexByte($70 or R2) else H:='$36/<'+a2 else
             if (a1='BC') and (R2=7) then H:='$02' else
             if (a1='DE') and (R2=7) then H:='$12' else
             if I>0 then
                if R2>=0 then H:=NI(I)+'$'+HexByte($70 or R2)+'/'+d
                         else H:=NI(I)+'$36/'+d+'/<'+a2 else
             if R2=7 then H:='$32/'+a1 else
             case D2 of
               1 : H:='$ED/$43/'+a1;
               2 : H:='$ED/$53/'+a1;
               3 : H:='$22/'+a1;
               4 : H:='$DD/$22/'+a1;
               5 : H:='$FD/$22/'+a1;
               6 : H:='$ED/$73/'+a1
             end
           end else
         if geklammert(a2) then
           begin I:=Indexed(a2,d); SkipPar(a2);
             if a2='HL' then
                if R1>=0 then H:='$'+HexByte($46 or (R1 shl 3)) else else
             if (a2='BC') and (R1=7) then H:='$0A' else
             if (a2='DE') and (R1=7) then H:='$1A' else
             if I>0 then
                if R1>=0 then H:=NI(I)+'$'+HexByte($46 or (R1 shl 3))+'/'+d
                         else  else
             if R1=7 then H:='$3A/'+a2 else
             case D1 of
               1 : H:='$ED/$4B/'+a2;
               2 : H:='$ED/$5B/'+a2;
               3 : H:='$2A/'+a2;
               4 : H:='$DD/$2A/'+a2;
               5 : H:='$FD/$2A/'+a2;
               6 : H:='$ED/$7B/'+a2
             end
           end else
            if a1='SP' then
              if D2=3 then H:='$F9' else
              if D2=4 then H:='$DD/$F9' else
              if D2=5 then H:='$FD/$F9'
              else H:='$31/'+a2 else
            if (R1>=0) and (R2>=0) then H:='$'+HexByte($40 or (R1 SHL 3) or R2) else
            if (R1=7) and (a2='I') then H:='$ED/$57' else
            if (R1=7) and (a2='R') then H:='$ED/$5F' else
            if R1>=0 then H:='$'+HexByte($06 or (R1 shl 3))+'/<'+a2 else
            if DubRegs(a1,'HL')>=0 then
               H:='$'+HexByte($01 or (DubRegs(a1,'HL') shl 4))+'/'+a2 else
            if D1=4 then H:='$DD/$21/'+a2 else
            if D1=5 then H:='$FD/$21/'+a2 else
            if (R2=7) and (a1='I') then H:='$ED/$47' else
            if (R2=7) and (a1='R') then H:='$ED/$4F';

     37: HStandard(a1,$B0,0,$F6,$B6,H);
     40: if a1='(C)' then begin if R2>=0
                            then HNorm($ED00 or ($41 or (R2 shl 3)),H)
                          end else
         if a2='A' then begin SkipPar(a1); H:='$D3/<'+a1 end;

     43: if D1=4 then HNorm($DDE1,H) else
         if D1=5 then HNorm($FDE1,H) else
         if DubRegs(a1,'AF')>=0 then HNorm($C1 or (DubRegs(a1,'AF') shl 4),H);
     44: if D1=4 then HNorm($DDE5,H) else
         if D1=5 then HNorm($FDE5,H) else
         if DubRegs(a1,'AF')>=0 then HNorm($C5 or (DubRegs(a1,'AF') shl 4),H);
     45: begin Berechne(a1,b,fc); Hbit(a2,$80,Lo(b),H) end;
     46: if C>=0 then HNorm($C0 or (C shl 3),H) else H:='$C9';
     49: HRot(a1,$16,$10,H);

     51: HRot(a1,$06,$00,H);
     54: HRot(a1,$1E,$18,H);
     56: HRot(a1,$0E,$08,H);
     59: begin
           Berechne(a1,b,fc);
           if fc=0 then
             if (b mod 8)=0 then HNorm($C7 or Lo(b),H)
         end;
     60: if a1='A' then HStandard(a2,$98,0,$DE,$9E,H) else
         if D1=3 then if DubRegs(a2,'HL')>=0 then HNorm($ED00 or
                               ($42 or (DubRegs(a2,'HL') shl 4)),H);

     62: begin Berechne(a1,b,fc); HBit(a2,$C0,Lo(b),H) end;
     63: HRot(a1,$26,$20,H);
     64: HRot(a1,$2E,$28,H);
     65: HRot(a1,$3E,$38,H);
     66: HStandard(a1,$90,0,$D6,$96,H);
     67: HStandard(a1,$A8,0,$EE,$AE,H)
    end;
   end;
                                                            