{ Enthaelt die Umwandlungs-Prozedur fuer 6502-Code}
overlay
procedure HexLine2 (var o : LabelString; var a1,a2 : Zeile; var h : Zeile);

type adressierung = (accu,immed,zp,zpx,zpy,ab,abx,aby,inx,iny,ind);

const OBID = '<';

      imax = 25 ;

      implied : array [1..imax] of
                record
                name : array [1..3] of char;
                code : array [1..2] of char
                end
              = ((name : 'BRK' ; code : '00' ),
                 (name : 'CLC' ; code : '18' ),
                 (name : 'CLD' ; code : 'D8' ),
                 (name : 'CLI' ; code : '58' ),
                 (name : 'CLV' ; code : 'B8' ),
                 (name : 'DEX' ; code : 'CA' ),
                 (name : 'DEY' ; code : '88' ),
                 (name : 'INX' ; code : 'E8' ),
                 (name : 'INY' ; code : 'C8' ),
                 (name : 'NOP' ; code : 'EA' ),
                 (name : 'PHA' ; code : '48' ),
                 (name : 'PHP' ; code : '08' ),
                 (name : 'PLA' ; code : '68' ),
                 (name : 'PLP' ; code : '28' ),
                 (name : 'RTI' ; code : '40' ),
                 (name : 'RTS' ; code : '60' ),
                 (name : 'SEC' ; code : '38' ),
                 (name : 'SED' ; code : 'F8' ),
                 (name : 'SEI' ; code : '78' ),
                 (name : 'TAX' ; code : 'AA' ),
                 (name : 'TAY' ; code : 'A8' ),
                 (name : 'TSX' ; code : 'BA' ),
                 (name : 'TXA' ; code : '8A' ),
                 (name : 'TXS' ; code : '9A' ),
                 (name : 'TYA' ; code : '98' ));

      rmax = 8;

      relative : array [1..rmax] of
                 record
                 name : array [1..3] of char;
                 code : array [1..2] of char
                 end
               = ((name : 'BPL' ; code : '10' ),
                  (name : 'BMI' ; code : '30' ),
                  (name : 'BVC' ; code : '50' ),
                  (name : 'BVS' ; code : '70' ),
                  (name : 'BCC' ; code : '90' ),
                  (name : 'BCS' ; code : 'B0' ),
                  (name : 'BNE' ; code : 'D0' ),
                  (name : 'BEQ' ; code : 'F0' ));

      nmax = 23;

      normal  : array [1..nmax] of
                record
                name : array [1..3] of char;
                code : array [adressierung,1..2] of char
                end
              = (
        { AC   IM   ZP   ZPX  ZPY  AB   ABX  ABY  INX  INY  IND }
(name : 'ADC' ;
 code : ('  ','69','65','75','  ','6D','7D','79','61','71','  ')),
(name : 'AND' ;
 code : ('  ','29','25','35','  ','2D','3D','39','21','31','  ')),
(name : 'ASL' ;
 code : ('0A','  ','06','16','  ','0E','1E','  ','  ','  ','  ')),
(name : 'BIT' ;
 code : ('  ','  ','24','  ','  ','2C','  ','  ','  ','  ','  ')),
(name : 'CMP' ;
 code : ('  ','C9','C5','D5','  ','CD','DD','D9','C1','D1','  ')),
(name : 'CPX' ;
 code : ('  ','E0','E4','  ','  ','EC','  ','  ','  ','  ','  ')),
(name : 'CPY' ;
 code : ('  ','C0','C4','  ','  ','CC','  ','  ','  ','  ','  ')),
(name : 'DEC' ;
 code : ('  ','  ','C6','D6','  ','CE','DE','  ','  ','  ','  ')),
(name : 'EOR' ;
 code : ('  ','49','45','55','  ','4D','5D','59','41','51','  ')),
(name : 'INC' ;
 code : ('  ','  ','E6','F6','  ','EE','FE','  ','  ','  ','  ')),
(name : 'JMP' ;
 code : ('  ','  ','  ','  ','  ','4C','  ','  ','  ','  ','6C')),
(name : 'JSR' ;
 code : ('  ','  ','  ','  ','  ','20','  ','  ','  ','  ','  ')),
(name : 'LDA' ;
 code : ('  ','A9','A5','B5','  ','AD','BD','B9','A1','B1','  ')),
(name : 'LDX' ;
 code : ('  ','A2','A6','  ','B6','AE','  ','BE','  ','  ','  ')),
(name : 'LDY' ;
 code : ('  ','A0','A4','B4','  ','AC','BC','  ','  ','  ','  ')),
(name : 'LSR' ;
 code : ('4A','  ','46','56','  ','4E','5E','  ','  ','  ','  ')),
(name : 'ORA' ;
 code : ('  ','09','05','15','  ','0D','1D','19','01','11','  ')),
(name : 'ROL' ;
 code : ('2A','  ','26','36','  ','2E','3E','  ','  ','  ','  ')),
(name : 'ROR' ;
 code : ('6A','  ','66','76','  ','6E','7E','  ','  ','  ','  ')),
(name : 'SBC' ;
 code : ('  ','E9','E5','F5','  ','ED','FD','F9','E1','F1','  ')),
(name : 'STA' ;
 code : ('  ','  ','85','95','  ','8D','9D','99','81','91','  ')),
(name : 'STX' ;
 code : ('  ','  ','86','  ','96','86','  ','  ','  ','  ','  ')),
(name : 'STY' ;
 code : ('  ','  ','84','94','  ','8C','  ','  ','  ','  ','  '))
                );

var i      : integer;
    art    : adressierung;

function conv(aa:zeile):zeile;
var x   : integer;
    anf : boolean;
begin
x := 1; anf := true;
while x<=length(aa) do
  begin
  if aa[x]='''' then anf := not anf;
  if anf and (aa[x]='$') then
    begin
    aa[x]:='0';
     repeat
     x := succ(x);
     until (x>length(aa)) or not (aa[x] in ['0'..'9','A'..'F']);
    if x<=length(aa) then Insert ('H',aa,x)
                     else aa:=aa+'H'
    end;
  x := succ(x)
  end;
while pos('=' , aa)>0 do aa[pos('=' , aa)] := '$';
conv := aa
end;

begin

h := '';

if (a1='') and (a2='') then {Implizit}
   begin
      for i:=1 to imax do
          with implied[i] do
              if o=name then h:='$'+code
   end

else
if (o[1]='B') and (o<>'BIT') and (a1<>'') and (a2='') then
   begin if a1[1]<>'(' then {Relativ}
       begin
       for i:=1 to rmax do
          with relative[i] do
              if o=name then h:='$'+code+'/~'+conv(a1)
   end end

else if a1<>'' then begin
     if (a1[1] = '(') and (a1[length(a1)]= ')') and (a2='')  then art := ind
else if (a1[1] = '(') and (a1[length(a1)]= ')') and (a2='Y') then art := iny
else if (a1[1] = '(') and (a2='X)') then art := inx
else if (a1[1] = '#') and (a2='')   then art := immed
else if (a1='A') and (a2='')        then art := accu
else if (a1[1] = '*') and (a2='')   then art := zp
else if (a1[1] = '*') and (a2='Y')  then art := zpy
else if (a1[1] = '*') and (a2='X')  then art := zpx
else if a2=''  then art := ab
else if a2='X' then art := abx
else if a2='Y' then art := aby
               else EXIT;

for i:=1 to nmax do
    with normal[i] do
        if o=name then
            if code[art]<>'  ' then h:='$'+code[art];

if h<>'' then

case art of

accu      :;

ab,abx,
   aby    : h := h+'/'+conv(a1);

ind       : h := h+'/'+conv(copy(a1,2,length(a1)-2));

immed,zp,
 zpx,zpy,
    inx   : h := h+'/'+OBID+conv(copy(a1,2,length(a1)-1));

iny       : h := h+'/'+OBID+conv(copy(a1,2,length(a1)-2));

end

end
end;