(****************************************************************************)
(*                     Inline-Code fuer 8080 und 8085                       *)
(****************************************************************************)

overlay
procedure HexLine3(o : LabelString; var a1 , a2 : zeile; var H : zeile);

  Const OBID = '<';

        Maximp   = 27;
        Maxdata  = 10;
        Maxlabel = 22;
        Maxreg   =  8;

  Type  STRING3  = STRING [3];
        Befehl   = Record
                      name : STRING [4];
                      code : Byte
                   end;

  Const Implizit : Array [1..Maximp] of Befehl =
        ((name : 'CMA'; code : $2F ),
         (name : 'CMC'; code : $3F ),
         (name : 'DAA'; code : $27 ),
         (name : 'DI'; code : $F3 ),
         (name : 'EI'; code : $FB ),
         (name : 'HLT'; code : $76 ),
         (name : 'NOP'; code : $00 ),
         (name : 'PCHL'; code : $E9 ),
         (name : 'RAL'; code : $17 ),
         (name : 'RAR'; code : $1F ),
         (name : 'RC'; code : $D8 ),
         (name : 'RET'; code : $C9 ),
         (name : 'RIM'; code : $20 ),
         (name : 'RLC'; code : $07 ),
         (name : 'RM'; code : $F8 ),
         (name : 'RNC'; code : $D0 ),
         (name : 'RNZ'; code : $C0 ),
         (name : 'RP'; code : $F0 ),
         (name : 'RPE'; code : $E8 ),
         (name : 'RPO'; code : $E0 ),
         (name : 'RRC'; code : $0F ),
         (name : 'RZ'; code : $C8 ),
         (name : 'SIM'; code : $30 ),
         (name : 'SPHL'; code : $F9 ),
         (name : 'STC'; code : $37 ),
         (name : 'XCHG'; code : $EB ),
         (name : 'XTHL'; code : $E3 ));

        Data     : Array [1..Maxdata] of Befehl =
        ((name : 'ACI'; code : $CE ),
         (name : 'ADI'; code : $C6 ),
         (name : 'ANI'; code : $E6 ),
         (name : 'CPI'; code : $FE ),
         (name : 'IN'; code : $DB ),
         (name : 'ORI'; code : $F6 ),
         (name : 'OUT'; code : $D3 ),
         (name : 'SBI'; code : $DE ),
         (name : 'SUI'; code : $D6 ),
         (name : 'XRI'; code : $EE ));

        Labelled : Array [1..Maxlabel] of Befehl =
        ((name : 'CALL'; code : $CD ),
         (name : 'CC'; code : $DC ),
         (name : 'CM'; code : $FC ),
         (name : 'CNC'; code : $D4 ),
         (name : 'CNZ'; code : $C4 ),
         (name : 'CP'; code : $F4 ),
         (name : 'CPE'; code : $EC ),
         (name : 'CPO'; code : $E4 ),
         (name : 'CZ'; code : $CC ),
         (name : 'JC'; code : $DA ),
         (name : 'JM'; code : $FA ),
         (name : 'JMP'; code : $C3 ),
         (name : 'JNC'; code : $D2 ),
         (name : 'JNZ'; code : $C2 ),
         (name : 'JP'; code : $F2 ),
         (name : 'JPE'; code : $EA ),
         (name : 'JPO'; code : $E2 ),
         (name : 'JZ'; code : $CA ),
         (name : 'LDA'; code : $3A ),
         (name : 'LHLD'; code : $2A ),
         (name : 'SHLD'; code : $22 ),
         (name : 'STA'; code : $32 ));

        Register : Array [1..Maxreg] of Befehl =
        ((name : 'ADC'; code : $88 ),
         (name : 'ADD'; code : $80 ),
         (name : 'ANA'; code : $A0 ),
         (name : 'CMP'; code : $B8 ),
         (name : 'ORA'; code : $B0 ),
         (name : 'SBB'; code : $98 ),
         (name : 'SUB'; code : $90 ),
         (name : 'XRA'; code : $A8 ));

  Var Fehler : Boolean;
      i      : Integer;

  Function RegPair : Integer;
  { Testet, ob a1=B,D,H oder SP,
    sonst wird Fehler gesetzt.
    Global Fehler, a1              }
    Begin if a1='B' then RegPair := 0
     else if a1='D' then RegPair := 16
     else if a1='H' then RegPair := 32
     else if a1='SP' then RegPair := 48
     else begin Fehler := True; Regpair := 0 end
    end;

  Function Reg (Var x : Zeile) : Integer;
  { Testet, ob x=A..H & M,
    sonst wird Fehler gesetzt.
    Global Fehler                  }
    Begin
    if length(x)<>1 then begin Fehler := True; Reg := 0 end
    else case x[1] of
         'B' : Reg := 0; 'C' : Reg := 1;
         'D' : Reg := 2; 'E' : Reg := 3;
         'H' : Reg := 4; 'L' : Reg := 5;
         'M' : Reg := 6; 'A' : Reg := 7
         else Fehler := True; Reg := 0
         end
    end;

  Function hex (x : Byte) : STRING3;

    Const Trans : Array [0..15] of Char = '0123456789ABCDEF';
    Begin
    hex := '$' + Trans[x SHR 4] + Trans[x AND 15]
    end;

  Begin Fehler := False; H := '';
  if (a1='') and (a2='') then
    begin
    for i := 1 to Maximp do with Implizit[i] do
        if o=name then H := hex(code)
    end
  else if (a1<>'') and (a2='') then
    begin
    for i := 1 to Maxdata do with Data[i] do
        if o=name then H := hex(code)+'/'+OBID+a1;
    if H='' then
      begin
      for i := 1 to Maxlabel do with Labelled[i] do
          if o=name then H := hex(code)+'/'+a1;
      if H='' then
        begin
        for i := 1 to Maxreg do with Register[i] do
            if o=name then H := hex(code+Reg(a1));
        if H='' then
          if o='DCR' then H := hex($05+8*Reg(a1))
          else if o='INR' then H := hex($04+8*Reg(a1))
          else if o='DAD' then H := hex($09+RegPair)
          else if o='DCX' then H := hex($0B+RegPair)
          else if o='INX' then H := hex($03+RegPair)
          else if o='POP' then
                  begin
                  if a1='PSW' then H := '$F1'
                  else if a1<>'SP' then H := hex($C1+RegPair)
                  end
          else if o='PUSH' then
                  begin
                  if a1='PSW' then H := '$F5'
                  else if a1<>'SP' then H := hex($C5+RegPair)
                  end
          else if o='LDAX' then
                  begin
                  if (a1='B') or (a1='D') then H := hex($0A+RegPair)
                  end
          else if o='STAX' then
                  begin
                  if (a1='B') or (a1='D') then H := hex($02+RegPair)
                  end
          else if o='RST' then
                  if a1[1] in ['0'..'7'] then H := hex($C7+8*(ord(a1[1])-48))
        end
      end
    end
  else if o='LXI' then H := hex($01+RegPair)+'/'+a2
  else if o='MVI' then H := hex($06+8*Reg(a1))+'/'+OBID+a2
  else if o='MOV' then
          if (a1<>'M') or (a2<>'M') then H := hex($40+8*Reg(a1)+Reg(a2));

  if Fehler then H := ''
  end;

                                                                                