(****************************************************************************)
(*                     Inline-Code fuer 8086/88                             *)
(****************************************************************************)
overlay
procedure HexLine4(o : LabelString; a1 , a2 : zeile; var H : zeile);

  Label 123,666;

  Const ShortDISP = '~';
        LongDISP  = '`';
        OBID      = '<';
        Maximpl = 25;
        Implizit: Array [1..MaxImpl] of
                    Record Name : String[5];
                           Code : Byte
                    end
                =((Name : 'XLAT'; Code : $D7 ),
                  (Name : 'LAHF'; Code : $9F ),
                  (Name : 'SAHF'; Code : $9E ),
                  (Name : 'PUSHF'; Code : $9C ),
                  (Name : 'POPF'; Code : $9D ),
                  (Name : 'AAA'; Code : $37 ),
                  (Name : 'DAA'; Code : $27 ),
                  (Name : 'AAS'; Code : $3F ),
                  (Name : 'DAS'; Code : $2F ),
                  (Name : 'CBW'; Code : $98 ),
                  (Name : 'CWD'; Code : $99 ),
                  (Name : 'RET'; Code : $C3 ),
                  (Name : 'RETF'; Code : $CB ),
                  (Name : 'INTO'; Code : $CE ),
                  (Name : 'IRET'; Code : $CF ),
                  (Name : 'CLC'; Code : $F8 ),
                  (Name : 'CMC'; Code : $F5 ),
                  (Name : 'STC'; Code : $F9 ),
                  (Name : 'CLD'; Code : $FC ),
                  (Name : 'STD'; Code : $FD ),
                  (Name : 'CLI'; Code : $FA ),
                  (Name : 'STI'; Code : $FB ),
                  (Name : 'HLT'; Code : $F4 ),
                  (Name : 'WAIT'; Code : $9B ),
                  (Name : 'NOP'; Code : $90 ));

  Type SpeicherFormat = (Byteformat,Wortformat,unbestimmt);
       RegisterNr     = 0..7;
       Ergebnis       = record
                         Adressierung : (Register,SegReg,Immediat,
                                          Indiziert,Absolut);
                         Format       : SpeicherFormat;
                         Reg          : RegisterNr
                        end;

       STRING3       = STRING[3];

  Var  SegmentReg    : (ES,CS,SS,DS,keines);
       Fehler,Lockflag
                     : Boolean;
       Art           : SpeicherFormat;
       Res1,Res2     : Ergebnis;
       Wert,i        : Integer;


  Function hex (x : Byte) : STRING3;

    Const Trans : Array [0..15] of Char = '0123456789ABCDEF';
    Begin
    hex := '$' + Trans[x SHR 4] + Trans[x AND 15]
    end;

  Procedure Strip (var x : zeile);
  { Fuehrende Blanks entfernen }

    Function test : Boolean;
      begin
      if x='' then test:=false
              else test:=x[1]=' '
      end;

    begin
    while test do delete(x,1,1)
    end;

  Procedure Skip;
  { Erstes Wort von a1 entfernen }
    begin
    if pos(' ',a1)=0 then a1:=''
                     else delete (a1,1,pos(' ',a1));
    Strip(a1)
    end;

  Procedure Drop;
  { Erstes Wort von a1 in o uebertragen }
    begin
    if pos(' ',a1)=0 then
       begin o:=a1;
             a1:=''
       end
    else begin
         o := copy(a1,1,pos(' ',a1)-1);
         Skip
         end
    end;

  Function oder(x,y:SpeicherFormat):SpeicherFormat;
    begin
    if x=unbestimmt then oder := y
    else if y=unbestimmt then oder := x
    else if x=y then oder := x
    else begin oder :=unbestimmt; Fehler := True end
    end;

  Function Festwert(var x : Zeile):Boolean;
  { Testet, ob x ein konstanter Ausdruck ist, und liefert
     ggf. den Wert ab.                                      }

    var HilfsListe : Suchbaum;
        Fehlercode : Integer;

    begin
    HilfsListe:=VarListe; VarListe := NIL;
    Berechne (x,Wert,Fehlercode);
    VarListe:= HilfsListe;
    Festwert := Fehlercode=0
    end;

  Procedure Scan(var x : Zeile; var res : Ergebnis);
    { Syntax-Check }

    Type STRING15 = STRING [15];

    var Flag1,Flag2 : Boolean;
        Tmp         : LabelString;

    Function Kompakt(l:STRING15):LabelString;

      begin
      while pos(' ',l)<>0 do delete(l,pos(' ',l),1);
      if length(l)>4 then begin
                          if copy(l,3,2)='][' then begin
                                                   Delete(l,3,2);
                                                   Insert('+',l,3)
                                                   end;
                          if copy(l,2,2)='I+' then l := copy(l,4,length(l)-3)
                                                        +'+'+copy(l,1,2)
                          end;
      Kompakt := l
      end;

    begin with res do
          if length(x)<2 then begin Adressierung:=Immediat;
                                    Format:=Unbestimmt;
                                    Reg:=0
                              end
          else
          if length(x)=2 then
             begin
             if (x[1] in ['A'..'D']) and (x[2]='X')
             then begin Adressierung:=Register;
                        Format:=WortFormat;
                        case x[1] of
                        'A': reg:=0; 'B': reg:=3; 'C': reg:=1; 'D': reg:=2
                        end
                  end
             else if(x[1] in ['A'..'D']) and (x[2] in ['H','L'])
             then begin Adressierung:=Register;
                        Format:=ByteFormat;
                        case x[1] of
                        'A': reg:=0; 'B': reg:=3; 'C': reg:=1; 'D': reg:=2
                        end;
                        reg:=reg+4*ord(x[2]='H')
                  end
             else if (x[1] in ['E','C','S','D']) and (x[2]='S')
             then begin Adressierung:=SegReg;
                        Format:=WortFormat;
                        case x[1] of
                        'E': reg:=0; 'C': reg:=1; 'S': reg:=2; 'D': reg:=3
                        end
                  end
             else if x='SP' then begin Adressierung:=Register;
                                       Format:=WortFormat;
                                       reg:=4
                                 end
             else if x='BP' then begin Adressierung:=Register;
                                       Format:=WortFormat;
                                       reg:=5
                                 end
             else if x='SI' then begin Adressierung:=Register;
                                       Format:=Wortformat;
                                       reg:=6
                                 end
             else if x='DI' then begin Adressierung:=Register;
                                       Format:=WortFormat;
                                       reg:=7
                                 end
             else begin Adressierung:=Immediat;
                        Format:=Unbestimmt;
                        Reg:=0
                  end
             end
          else
          begin Flag1:=False; Flag2:=False; Reg:=0;
             if (x[1] in ['E','C','S','D']) and (x[2]='S') and (x[3]=':')
                then begin case x[1] of
                           'E': SegmentReg:=ES;
                           'C': SegmentReg:=CS;
                           'S': SegmentReg:=SS;
                           'D': SegmentReg:=DS
                           end;
                           Flag1:=True;
                           Delete(x,1,3);
                     end;
             if x<>'' then
                     if (x[length(x)]=']') and (pos('[',x)<>0)
                        then begin
                             Flag2:=True;
                             Tmp:=Kompakt(copy(x,pos('[',x)+1,length(x)-pos('[',x)-1));
                             x:=copy(x,1,pos('[',x)-1);
                                  if Tmp='BX+SI' then reg := 0
                             else if Tmp='BX+DI' then reg := 1
                             else if Tmp='BP+SI' then reg := 2
                             else if Tmp='BP+DI' then reg := 3
                             else if Tmp='SI'    then reg := 4
                             else if Tmp='DI'    then reg := 5
                             else if Tmp='BP'    then reg := 6
                             else if Tmp='BX'    then reg := 7
                             else Fehler := True
                        end;
             Strip(x);
             if flag1 then if reg in [2,3,6]
                              then begin if SegmentReg=SS
                                            then SegmentReg := keines
                                   end
                              else begin if SegmentReg=DS
                                            then SegmentReg := keines
                                   end;
             if Flag2 then Adressierung := Indiziert
             else if Flag1 then Adressierung := Absolut
             else Adressierung := Immediat;
             Format := unbestimmt
          end
      end;

   Procedure MakeDISP(mid:RegisterNr; var a:Zeile; daten:Ergebnis);

     begin with daten do
                 case Adressierung of
                 Absolut  : H := H+'/'+hex(mid shl 3 + 6)+'/'+a;
                 Indiziert: if a='' then
                               Begin if Reg=6 then H := H+'/'+hex($46 + mid shl 3)+'/$00'
                                     else H := H+'/'+hex(mid shl 3 + Reg)
                               End
                            else if Festwert(a) and (Wert>=-128) and (Wert<=127)
                            then H := H+'/'+hex($40 + mid shl 3 + reg)+'/'+hex(lo(Wert))
                            else H := H+'/'+hex($80 + mid shl 3 + Reg)+'/'+a;
                 Register : H := H+'/'+hex($C0 + mid shl 3 + Reg);
                 Immediat,SegReg : Fehler := True
                 end
     end;

  Function Wort(x:SpeicherFormat):Byte;
    begin if x=unbestimmt then Fehler := True;
          Wort := ord(x) and 1
    end;

  Procedure Shift (x:RegisterNr);

    Function Count:Byte;
      begin if (a2='') or (a2='1') then Count := Wort(Art)
            else if a2='CL' then Count := Wort(Art)+2
            else begin Fehler := True; Count := 0 end
      end;

  Begin
  H := hex($D0+Count);
  MakeDisp(x,a1,Res1)
  End;

  Procedure StringBefehl;

    label EXIT;

    Const Max = 5;
          Befehl : Array [1..Max] of
                      Record Name : String[4];
                             Code : Byte
                      End
                 =((Name : 'MOVS'; Code : $A4),
                   (Name : 'CMPS'; Code : $A6),
                   (Name : 'SCAS'; Code : $AE),
                   (Name : 'LODS'; Code : $AC),
                   (Name : 'STDS'; Code : $AA));

    Var k : Integer;

    begin
    if a2<>'' then Fehler := True;
    if length(o)>4 then begin a1:=copy(o,5,length(o)-4);
                              o :=copy(o,1,4)
                        end;
    If (a1='B') or (a1='BYTE') then Art := Oder(Art,ByteFormat)
    else if (a1='W') or (a1='WORD') then Art := Oder(Art,WortFormat);
    For k:=1 to Max do
      with Befehl[k] do
        if o=Name then
           Begin H := H+hex(Code+Wort(Art));
                 goto EXIT
           End;
    Fehler := True
    ; EXIT :
    end;

  Procedure JmpCall(x:integer);
  { x=1 ==> JMP,  x=0 ==> CALL  }
  begin
  if a2='' then
  if (copy(a1,1,2)='F ') or (copy(a1,1,4)='FAR ')
  then begin Skip;
       Scan(a1,Res1);
       if Res1.Adressierung=Immediat then
            begin if not (pos(':',a1) in [0,1,length(a1)]) then
                  H := hex($9A+$50*x)+'/'+copy(a1,pos(':',a1)+1,length(a1)-pos(':',a1))
                                     +'/'+copy(a1,1,pos(':',a1)-1)
            end
       else if (Res1.Format <> Byteformat) and (Res1.Adressierung <> Register)
            then begin H := '$FF';
                       MakeDISP(2*x+3,a1,res1)
                 end
       end
  else begin
       Scan(a1,Res1);
       if Res1.Adressierung=Immediat then H := hex($E8+x)+'/'+LongDISP+a1
       else if Res1.Format <> ByteFormat then
            begin H := '$FF';
                  MakeDISP(2*x+2,a1,Res1)
            end
       end
  end;

  Procedure IncDec(x:integer);
  { x=0 ==> INC, x=1 ==> DEC  }
  Begin With Res1 do
  if (Adressierung=Register) and (Art=WortFormat)
  Then H := hex($40+8*x+Reg)
  else begin H := hex($FE+Wort(Art));
             MakeDISP(x,a1,Res1)
       end
  end;
