                  { Berechnet den 8052-Code }

       (*   (c) 1986  by  Paul Kostal & Peter Ullrich    *)

overlay
procedure HexLine5(var o : LabelString; a1 , a2 : zeile; var H : zeile);


  var on          : byte;
      R1,R2,R3,b  : integer;
      a3          : zeile;

  function OpCodeNummer(var z : LabelString):integer;
    const OpcodeName : array[1..41] of string[5] =
        ('ADD','ADDC','ANL','CALL','CJNE','CLR','CPL','DA','DEC','DIV',
         'DJNZ','INC','JB','JBC','JC','JMP','JNB','JNC','JNZ','JR',
         'JZ','MOV','MOVC','MOVX','MUL','NOP','ORL','POP','PUSH','RET',
         'RETI','RL','RLC','RR','RRC','SETB','SUBB','SWAP','XCH','XCHD',
         'XRL');
    var i,j,m : integer;
    begin i:=1; j:=41;
      repeat m:=(i+j) div 2;
       if z<=OpCodeName[m] then j:=m else i:=m+1
      until i=j;
      if OpCodeName[i]=z then OpCodeNummer:=i
                         else OpCodeNummer:=0
    end;

  procedure Regs(var a:zeile; var R:integer);
    const RegName: array[6..15] of string [3] =
                  ('@R0','@R1','R0','R1','R2','R3','R4','R5','R6','R7');
    var i : 6..15;
    begin R:=0;
      for i:=6 to 15 do if RegName[i]=a then R:=i;
      if R=0 then begin
        if a[1]='#' then begin
          R:=4;
          delete(a,1,1);
        end
        else R:=5;
      end;
    end;

  function SFR(a:zeile):zeile;
    const SFRName: array[1..26] of string[6] =
         ('ACC','B','PSW','SP','DPH','DPL','P0','P1','P2','P3',
          'IP','IE','TMOD','TCON','T2CON','TH0','TL0','TH1','TL1','TH2',
          'TL2','RCAP2H','RCAP2L','SCON','SBUF','PCON');
    const SFRAdr: array[1..26] of string[3] =
                ('0E0','0F0','0D0','81','83','82','80','90','0A0','0B0',
                 '0B8','0A8','89','88','0C8','8C','8A','8D','8B','0CD',
                 '0CC','0CB','0CA','98','99','97');
    var i, s: integer;
    begin SFR:=a;
      for i:=1 to 26 do if a=SFRName[i] then SFR:=SFRAdr[i]+'H';
    end;

  procedure Hbit(Hex, a:zeile; var HN:zeile);
    const BSFRName: array[1..15] of string[5] =
                ('P0','TCON','P1','SCON','P2','IE','P3','IP','','T2CON',
                 'PSW','','ACC','','B');
    const BitSFRName: array[1..44] of string[6] =
(* TCON *)    ('IT0','IE0','IT1','IE1','TR0','TF0','TR1','TF1',
(* SCON *)     'RI','TI','RB8','TB8','REN','SM2','SM1','SM0',
(* IE *)       'EX0','ET0','EX1','ET1','ES','ET2','EA',
(* IP *)       'PX0','PT0','PX1','PT1','PS','PT2',
(* T2CON *)    'CP/RL2','C/T2','TR2','EXEN2','TCLK','RCLK','EXF2','TF2',
(* PSW *)      'P','OV','RS0','RS1','F0','AC','CY');
    const BitSFRAdr: array[1..44] of string[2] =
                   ('88','89','8A','8B','8C','8D','8E','8F',
                    '98','99','9A','9B','9C','9D','9E','9F',
                    'A8','A9','AA','AB','AC','AD','AF',
                    'B8','B9','BA','BB','BC','BD',
                    'C8','C9','CA','CB','CC','CD','CE','CF',
                    'D0','D2','D3','D4','D5','D6','D7');
    var I,S,bit,Error : integer;
                    b : zeile;
    begin S:=pos('.',a);
      if S>0 then begin
        b:=copy(a,1,S-1);
        delete(a,1,S);
        val(a,bit,Error);
        if (Error=0) and (bit>=0) and (bit<8) then begin
          S:=0;
          for I:=1 to 15 do if b=BSFRName[I] then S:=I;
          if S<>0 then HN:=Hex+'/$'+HexByte($80+(S-1)*$08+bit);
        end;
      end else
      begin
        for I:=1 to 44 do
          if a=BitSFRName[I] then HN:=Hex+'/$'+BitSFRAdr[I];
        if HN='' then HN:=Hex+'/<'+a;
      end;
    end;

  procedure AOP(Hex:integer; var HN:zeile);
    begin
      if a1='A' then begin
        HN:='$'+HexByte(Hex or R2);
        if R2<6 then HN:=HN+'/<'+a2;
      end;
    end;

  procedure HLogik(Hex:integer; var HN:zeile);
    begin
      AOP(Hex,HN);
      if (HN='') and (R1=5) then
        if a2='A' then HN:='$'+HexByte(Hex or 2)+'/<'+a1 else
        if R2=4 then HN:='$'+HexByte(Hex or 3)+'/<'+a1+'/<'+a2;
    end;

  procedure Cbit(Hex:integer; var HN:zeile);
    begin
      if a1='C' then
        if a2[1]='!' then begin
          delete(a2,1,1);
          Hbit('$'+HexByte(Hex+$60),a2,HN);
        end
        else Hbit('$'+HexByte(Hex+$32),a2,HN)
      else HLogik(Hex,HN);
    end;

  begin H:='';
    Regs(a1,R1); Regs(a2,R2);
    a1:=SFR(a1); a2:=SFR(a2);
    on:=OpCodeNummer(o);
    case on of
      1: (* ADD *)
         AOP($20,H);
      2: (* ADDC *)
         AOP($30,H);
      3: (* ANL *)
         Cbit($50,H);
      4: (* CALL *)
         if R1=5 then H:='$12/'+a1;
      5: (* CJNE *)
         begin
           b:=pos(',',a2);
           a3:=copy(a2,b+1,80);
           delete(a2,b,80);
           Regs(a3,R3);
           if R3=5 then begin
             if (R1>5) and (R1<16) and (R2=4) then
               H:='$'+HexByte($B0 or R1)+'/<'+a2+'/~'+a3 else
             if (a1='A') and ((R2=4) or (R2=5)) then begin
               a2:=SFR(a2);
               H:='$'+HexByte($B0 or R2)+'/<'+a2+'/~'+a3;
             end;
           end;
         end;
      6: (* CLR *)
         if a1='A' then H:='$E4' else
         if a1='C' then H:='$C3' else
         Hbit('$C2',a1,H);
      7: (* CPL *)
         if a1='A' then H:='$F4' else
         if a1='C' then H:='$B3' else
         Hbit('$B2',a1,H);
      8: (* DA *)
         if a1='A' then H:='$D4';
      9: (* DEC *)
         if a1='A' then H:='$14' else  begin
           if R1>4 then H:='$'+HexByte($10 or R1);
           if R1=5 then H:=H+'/<'+a1;
         end;
     10: (* DIV *)
         if a1='AB' then H:='$84';
     11: (* DJNZ *)
         if R2=5 then
           if R1>7 then H:='$'+HexByte($D0 or R1)+'/~'+a2 else
           if R1=5 then H:='$D5/<'+a1+'/~'+a2;
     12: (* INC *)
         if a1='A' then H:='$04' else
         if a1='DPTR' then H:='$A3' else begin
           if R1>4 then H:='$'+HexByte(R1);
           if R1=5 then H:=H+'/<'+a1;
         end;
     13: (* JB *)
         if R2=5 then begin
           Hbit('$20',a1,H);
           if H<>'' then H:=H+'/~'+a2;
         end;
     14: (* JBC *)
         if R2=5 then begin
           Hbit('$10',a1,H);
           if H<>'' then H:=H+'/~'+a2;
         end;
     15: (* JC *)
         if R1=5 then H:='$40/~'+a1;
     16: (* JMP *)
         if a1='@A+DPTR' then H:='$73' else
         if R1=5 then H:='$02/'+a1;
     17: (* JNB *)
         if R2=5 then begin
           Hbit('$30',a1,H);
           if H<>'' then H:=H+'/~'+a2;
         end;
     18: (* JNC *)
         if R1=5 then H:='$50/~'+a1;
     19: (* JNZ *)
         if R1=5 then H:='$70/~'+a1;
     20: (* JR *)
         if R1=5 then H:='$80/~'+a1;
     21: (* JZ *)
         if R1=5 then H:='$60/~'+a1;
     22: (* MOV *)
         if a1='A' then if R2=4 then AOP($70,H) else AOP($E0,H) else
         if R1>5 then
           if a2='A' then H:='$'+Hexbyte($F0 or R1) else
           if R2=5 then H:='$'+Hexbyte($A0 or R1)+'/<'+a2 else
           if R2=4 then H:='$'+Hexbyte($70 or R1)+'/<'+a2 else
         else
           if a1='C' then Hbit('$A2',a2,H) else
           if a2='C' then Hbit('$92',a1,H) else
           if a1='DPTR' then if R2=4 then H:='$90/'+a2 else else
           if R1=5 then
             if a2='A' then H:='$F5/<'+a1 else
             if R2=4 then H:='$75/<'+a1+'/<'+a2 else
             if R2=5 then H:='$85/<'+a2+'/<'+a1 else
             H:='$'+HexByte($80 or R2)+'/<'+a1;
     23: (* MOVC *)
         if a1='A' then
           if a2='@A+DPTR' then H:='$93' else
           if a2='@A+PC' then H:='$83';
     24: (* MOVX *)
         if a1='A' then
           if a2='@DPTR' then H:='$E0' else
           if (R2<8) and (R2>5) then H:='$'+HexByte($E0 or (R2-4)) else
         else
         if a2='A' then
           if a1='@DPTR' then H:='$F0' else
           if (R1<8) and (R1>5) then H:='$'+HexByte($F0 or (R1-4));
     25: (* MUL *)
         if a1='AB' then H:='$A4';
     26: (* NOP *)
         H:='$00';
     27: (* ORL *)
         Cbit($40,H);
     28: (* POP *)
         if R2=5 then H:='$D0/<'+a1;
     29: (* PUSH *)
         if R2=5 then H:='$C0/<'+a1;
     30: (* RET *)
         H:='$22';
     31: (* RETI *)
         H:='$32';
     32: (* RL *)
         if a1='A' then H:='$23';
     33: (* RLC *)
         if a1='A' then H:='$33';
     34: (* RR *)
         if a1='A' then H:='$03';
     35: (* RRC *)
         if a1='A' then H:='$13';
     36: (* SETB *)
         if a1='C' then H:='$D3' else
         Hbit('$D2',a1,H);
     37: (* SUBB *)
         AOP($90,H);
     38: (* SWAP *)
         if a1='A' then H:='$C4';
     39: (* XCH *)
         if R2<>4 then AOP($C0,H);
     40: (* XCHD *)
         if (a1='A') and ((R2=6) or (R2=7)) then
           H:='$'+HexByte($D0 or R2);
     41: (* XRL *)
         HLogik($60,H);
    end;
  end;