{****************************************************************************}
{*                Konvertierung in das INLINE-Format                        *}
{*                                                                          *}
{* f ByteZahl zaehlt die Anzahl der Bytes einer Zeile                       *}
{* p VariablenListe erstellt eine Liste mit allen Labels und Variablen      *}
{* p Konvertiere stellt endgueltiges INLINE-Statement her                   *}
{****************************************************************************}

function ByteZahl(l : zeile):byte; var t : byte;
  begin  t:=0;
    while l<>'' do  begin
      if l[1] in ['<','~'] then t:=t+1 else
      if (l[1]='$') and (length(l)>1) and (l[2] in ['0'..'9','A'..'F'])
        then t:=t+1 else t:=t+2;
      if pos('/',l)=0 then l:='' else delete(l,1,pos('/',l))
    end;
    ByteZahl:=t
  end;

{$A-}
procedure VariablenListe(SB : SuchBaum); var p : TextListe;
  begin
    if SB<>NIL then
      with SB^ do begin
        VariablenListe(links);
        with Eintrag do begin write(PRNFile,copy(VarName+'       ',1,8));
          case Art of
           relativ : writeln(PRNFile,' * ',HexWord(VarRef));
           absolut : writeln(PRNFile,' = ',HexWord(VarRef));
           extern  : writeln(PRNFile,' : EXTERN');
           macro   : begin
                       writeln(PRNFile,' : MACRO ',MPtr^.ParamListe);
                       p:=MPtr^.M_Liste;
                       while p<>NIL do
                         begin
                           writeln(PRNFile,'':14,p^.M_Zeile); p:=p^.naechst
                         end
                     end
          end
        end;
        VariablenListe(rechts)
      end
  end;
{$A+}

procedure Konvertiere(C : integer; var z : zeile);
  var t,l : zeile; p : byte; e,fc : integer; h:boolean; Hilf:integer;
  begin Hilf:=PC; PC:=C;
    l:=z+'/'; if not First then z:='/' else begin z:=''; First:=false end;
    repeat
      p:=pos('/',l); t:=copy(l,1,p-1); delete(l,1,p);
      if (length(t)=3) and (t[1]='$') and (t[2] in ['0'..'9','A'..'F'] )
      then begin z:=z+t; C:=C+1 end
      else case t[1] of
        '~' : begin delete(t,1,1); berechne(t,e,fc); C:=C+1;
                e:=e-C; h:=error(fc,t);
                if (e<-128) or (e>127) or (fc and $8020 <> $8000)
                                       then h:=error(8,t)
                                       else z:=z+'$'+HexByte(e)
              end;
        '`' : begin delete(t,1,1); berechne(t,e,fc); C:=C+2;
                h := error(fc,t);
                if fc and 32 = 32 then z:=z+t+'-*-2'
                else if fc and $8000 = $8000
                     then begin e:=e-C;
                                z:=z+'$'+HexByte(lo(e))+'/'+'$'+HexByte(hi(e))
                          end
                     else { Absolute Adressierung }
                          z:=z+'$'+HexWord(e-2)+'-*'
              end;
        '<' : begin delete(t,1,1); berechne(t,e,fc); C:=C+1;
                if not error(fc,t) then z:=z+'$'+HexByte(e) else z:=z+'<'+t
              end
      else
         begin
           Berechne(t,e,fc); if (fc and 32)=0 then h:=error(fc,t);
           if fc=$8000 then z:=z+'*+$'+HexWord(e-C) else

           if fc= 0 then if Prozessor=MPC_8052 then
             z:=z+'$'+HexByte(Hi(e))+'/$'+HexByte(Lo(e)) else
             z:=z+'$'+HexByte(Lo(e))+'/$'+HexByte(Hi(e)) else
           if (fc and 32)=32 then z:=z+t else z:=z+'????';
           C:=C+2
         end
      end; (*case*)
      if l<>'' then z:=z+'/'
    until l='';
    PC:=Hilf;
    if C<>PC then h:=error(9,l)
  end;
