program INLASS_80; {INLINE-Assembler fuer Turbo-Pascal}

{$V-}

const   KommentarAnfang   = ';';
        ArgumentTrennung  = ',';
        LabelEnde         = ':';

type    Zeile             = string[80];
        string14          = string[14];
        LabelString       = string[8];

var     Source,
        Objekt,
        PRNfile           : text;
        PC                : integer;
        FileName          : string14;
        FehlerZahl        : integer;
        First,
        KommentarFlag     : boolean;
        SOU_Device,
        PRN_Device,
        OBJ_Device        : string[2];
        Ext               : string[3];
        PunktPos          : byte;
        Antwort           : char;
        KommStr           : string[1];
        Prozessor         : (MPC_Z80,MPC_6502,MPC_8080,MPC_8086,MPC_8052);

{$I PARAMSTR.BIB}   (*Kann ab Turbo-Pascal 3.0 weggelassen werden*)
{$I SCANLINE.INC}
{$I ERROR.INC}
{$I SUCHBAUM.INC}
{$I BERECHNE.INC}
{$I HL1-Z80.INC}
{$I HL2-6502.INC}
{$I HL3-8080.INC}
{$I HL4A8086.INC}
{$I HL4B8086.INC}
{$I HL5-8052.INC}
{$I INL.INC}
{$I DOPASS.INC}

begin
  ClrScr; writeln('INLINE-Assembler fuer Turbo-Pascal':55);
  writeln('----------------------------------':55);
  writeln; writeln('Version Jan.1986 U.K.':70); writeln;
  fehlerzahl:=0; KommentarFlag:=true;
  SOU_Device:=''; OBJ_Device:=''; PRN_Device:='';
  if ParamCount=0
    then
      begin
        write('*'); readln(FileName);
        write('Source als Kommentar (J/N) ? ');
        repeat
          read(kbd,Antwort); Antwort:=upcase(Antwort)
        until Antwort in ['J','N']; writeln(Antwort);
        KommentarFlag:=Antwort='J'
      end
    else
      begin
        FileName:=ParamStr(1);
        if ParamCount>1 then
           begin
             KommStr:=ParamStr(2);
             KommentarFlag:=not(KommStr[1] in ['N','n'])
           end
      end;

  PunktPos:=posalt('.',FileName);
  if PunktPos>0
     then
       begin
         Ext:=copy(FileName,PunktPos+1,length(FileName)-PunktPos);
         if Ext<>'' then while length(Ext)<3 do Ext:=Ext+Ext[1];
         delete(FileName,PunktPos,length(FileName)-PunktPos+1)
       end
     else Ext:='';
  if Ext<>'' then
         begin
           SOU_Device:=Ext[1]+':';
           OBJ_Device:=Ext[2]+':';
           PRN_Device:=Ext[3]+':'
         end;
  assign(Source,SOU_Device+FileName+'.SOU');
  assign(Objekt,OBJ_Device+FileName+'.INL');  rewrite(Objekt);
  assign(PRNFile,PRN_Device+FileName+'.PRN'); rewrite(PRNFile);
  VarListe:=NIL;
  writeln(SOU_Device+FileName+'.SOU');
  writeln('-> ',OBJ_Device+FileName+'.INL');
  writeln('-> ',PRN_Device+FileName+'.PRN');
  writeln(PRNFile,'PASS 1'); DoPass(1);
  writeln(PRNFile,'PASS 2'); DoPass(2);
  writeln(PRNFile);
  VariablenListe(VarListe); close(PRNFile); close(Objekt);
  writeln(FehlerZahl,' Fehler.')
end.
