{****************************************************************************}
{*      Hilfsprozeduren des Assemblers                                      *}
{*                                                                          *}
{* f HexByte(x) ergibt zweistellige Hexzahl                                 *}
{* f HexWord(x) ergibt vierstellige Hexzahl                                 *}
{* p SkipLeftBlanks schneidet linke,                                        *}
{* p SkipRightBlanks schneidet rechte Lerrzeichen ab                        *}
{* p SkipPar schneidet links auf- und rechts zugehenden Klammer ab          *}
{* f geklammert wird wahr, wenn Ausdruck links und rechts geklammert ist    *}
{* p ScanLine zerlegt eine Zeile in LABEL, OPCODE, ARG1, ARG2 und KOMMENTAR *}
{*                                                                          *}
{****************************************************************************}

const HexZiffer : array[0..15] of char = '0123456789ABCDEF';
      MaxLabel  = 8;

type  HexZahl = string[4];

function  HexByte(x:integer) : HexZahl;
  begin
    HexByte:=HexZiffer[(lo(x) shr 4)]+HexZiffer[(lo(x) and 15)]
  end;

function HexWord(x:integer) : HexZahl;
  begin
    HexWord:=HexByte(Hi(x))+HexByte(lo(x))
  end;

procedure SkipLeftBlanks(var z : Zeile);
  begin
    while pos(' ',z)=1 do delete(z,1,1)
  end;

procedure SkipRightBlanks(var z : Zeile);
  begin
    while (length(z)>1) and (z[length(z)]=' ') do delete(z,length(z),1);
    if z=' ' then z:=''
  end;

procedure SkipPar(var z : Zeile);
  begin
    if pos('(',z)=1 then delete(z,1,1);
    if z<>'' then if z[length(z)]=')' then delete(z,length(z),1)
  end;

function geklammert(var z : Zeile):boolean;
  begin
   if z<>''
      then geklammert:=(z[1]='(') and (z[length(z)]=')')
      else geklammert:=false
  end;

(*.PA*)
{$V-}

function posalt(t : labelstring; var s : zeile) : integer;
  begin posalt := pos (t,s) end;

function pos(target : labelstring; search : zeile) : integer;

  var x,y : integer; diag : char;

  begin x:=posalt('''',search); y:=posalt(target,search);
  if x=0 then pos := y
  else if posalt('''',target)<>0 then pos := y
  else begin diag:=chr(0);
             while posalt(diag,target)+posalt(diag,search)<>0 do diag:=succ(diag);
             while (x<y) and (x<>0)
             do begin search[x]:=diag;
                      x:=posalt('''',search);
                      while (y<x) and (y<>0)
                      do begin search[y]:=diag;
                               y:=posalt(target,search)
                         end;
                      if x<>0 then begin search[x]:=diag;
                                         x:=posalt('''',search)
                                   end
                              else y:=0
                end;
             pos := y
       end
  end;

procedure ScanLine(var SZ : zeile; var Lab, OPCODE : LabelString;
                   var Arg1,Arg2,Kommentar : zeile; local : char);

  Function upcase(c : char) : char;
    begin
    if c='/' then upcase:='\'
    else if (c>='a') and (c<='z') then upcase:=chr(ord(c)-32)
    else upcase:=c
    end;

  var i,KA,LE,OE,AE : byte; PFlag, KFlag, XFlag : boolean;
  begin

    {Tabs in Spaces umwandeln}
    while pos(^I,SZ)>0 do
      begin insert(' ',SZ,pos(^I,SZ)); delete(SZ,pos(^I,SZ),1) end;

    {Alle Zeichen, ausser wenn sie in Strings stehen, in Grossbuchstaben
     umwandeln. Labelende und Kommentaranfang finden}
    PFlag:=false; KFlag:=false; XFlag:=false; KA:=0; LE:=0;
    for i:=1 to length(SZ) do
      begin
       if not (PFlag or KFlag) then
         begin
           SZ[i]:=upcase(SZ[i]); if SZ[i]='&' then SZ[i]:=local;
           if i>1 then if SZ[i]=' ' then if SZ[i-1]<>' ' then XFlag := True;
           if (SZ[i]=LabelEnde) and (LE=0) and not XFlag then LE:=i;
           if (SZ[i]=KommentarAnfang) and (KA=0)
              then begin KA:=i; KFlag:=true end
         end;
       if SZ[i]='''' then if PFlag or (pos('AF''',SZ)<>i-2) then PFlag:=not PFlag
      end;
    if PFlag then SZ:=SZ+'''';

    {Kommentar entfernen}
    Kommentar:='';
    if KA>0 then
      begin Kommentar:=copy(SZ,KA+1,length(SZ)-KA); delete(SZ,KA,length(SZ)-KA+1) end;

    {Label entfernen}
    Lab:='';
    if LE>0
       then begin SkipLeftBlanks(SZ); LE:=pos(LabelEnde,SZ) end
       else if SZ<>'' then if SZ[1] in ['A'..'Z','&'] then LE:=pos(' ',SZ+' ');
    if LE>0 then begin Lab:=copy(SZ,1,LE-1); delete(SZ,1,LE) end;

    {Opcode und Argumente entfernen}
    SkipLeftBlanks(SZ); Arg1:=''; Arg2:=''; OE:=pos(' ',SZ);
    if OE=0
      then OPCODE:=SZ
      else
        begin
          OPCODE:=copy(SZ,1,OE); delete(SZ,1,OE); SkipLeftBlanks(SZ);
          AE:=pos(ArgumentTrennung,SZ);
          if AE=0
            then Arg1:=SZ
            else
               begin
                  Arg1:=copy(SZ,1,AE-1);
                  delete(SZ,1,AE); SkipLeftBlanks(SZ); Arg2:=SZ
               end
        end;
    SkipRightBlanks(OPCODE); SkipRightBlanks(Arg1); SkipRightBlanks(Arg2);
  end;
