{****************************************************************************}
{*                Verwaltung der dynamischen Variablen                      *}
{*                                                                          *}
{*  p Suche sucht einen Eintrag, gibt NIL zurueck, falls nicht erfolgreich  *}
{*  p FuegeEin fuegt einen Eintrag ein                                      *}
{*  p SkipMacro ueberlist eine Macro-Definition                             *}
{*  p MachMacro legt ein Macro an                                           *}
{*  p PushMacro bringt ein Macro in den TextStack & ersetzt die Parameter   *}
{*  p PopZeile  holt die oberste Macrozeile                                 *}
{****************************************************************************}

type TextListe        = ^TextEintrag;
     TextEintrag      = record
                          M_Zeile : string[60];
                          naechst : TextListe
                        end;

     MacroListe       = record
                          ParamListe : Zeile;
                          local      : char;
                          M_Liste    : TextListe
                        end;

     tEintrag         = record
                          VarName : LabelString;
                          case Art:(extern,relativ,absolut,macro) of
                            absolut,
                            relativ : (VarRef : integer);
                            macro   : (MPtr   : ^MacroListe)
                        end;

      SuchBaum         = ^SuchBaumEintrag;
      SuchBaumEintrag  = record
                           Eintrag : tEintrag;
                           links,
                           rechts  : SuchBaum
                         end;

var VarListe, SuchListe  : SuchBaum;
    VarEintrag : tEintrag;
    TextStack  : TextListe;

function  LinksVon(tE1,tE2 : tEintrag) : boolean; {Anwendungsabhaengig}
  begin LinksVon:=tE1.VarName<tE2.VarName end;

{$A-}
procedure Suche(SB : SuchBaum; Ref : tEintrag; var Gef : SuchBaum); {Unabhaenging}
  begin
    Gef:=SB;
    if SB<>NIL then
      if LinksVon(Ref,SB^.Eintrag) then Suche(SB^.links,Ref,Gef) else
      if LinksVon(SB^.Eintrag,Ref) then Suche(SB^.rechts,Ref,Gef)
  end;

procedure FuegeEin(var SB : SuchBaum; Ref : tEintrag); {Unabhaengig}
  begin
    if SB=NIL then
      begin
        new(SB); with SB^ do begin Eintrag:=Ref; links:=NIL; rechts:=NIL end
      end else
    if LinksVon(Ref,SB^.Eintrag) then FuegeEin(SB^.links,Ref) else
    if LinksVon(SB^.Eintrag,Ref) then FuegeEin(SB^.rechts,Ref)
    else SB^.Eintrag:=Ref
  end;
{$A+}

procedure SkipMacro(name : LabelString);
  var z,k,a1,a2 : zeile; L,o : LabelString; b : byte; s : SuchBaum;
    e : tEintrag;
  begin
    b:=1; e.VarName:=name; Suche(VarListe,e,s);
    with s^,Eintrag do MPtr^.local:='A';
    while (not EOF(Source)) and (b>0) do begin
      readln(Source,z); ScanLine(z,L,o,a1,a2,k,'&');
      if o='MACRO' then b:=succ(b);
      if o='ENDM' then b:=pred(b);
    end
  end;

procedure MachMacro(L : LabelString; p : Zeile);
  var T  : tEintrag;  count : byte;
      q,r: TextListe;
      h  : boolean;
      o  : LabelString;
      a1, a2, c : zeile;
  begin
    count:=1;
    if L='' then begin h:=error(12,L); exit end;
    with T do
      begin
        VarName:=L; Art:=macro;
        new(MPtr);
        with Mptr^ do
          begin
            ParamListe:=p; M_Liste:=NIL; local:='A';
            if not EOF(Source) then
              repeat
                readln(Source,p); ScanLine(p,L,o,a1,a2,c,'&');
                if a2<>'' then a1:=a1+','+a2;
                if o='MACRO' then begin count:=succ(count); h:=error(15,L) end;
                if o='ENDM'  then count:=pred(count);
                if count=1 then
                  begin
                    new(r); r^.M_Zeile:=L+' '+o+' '+a1; r^.naechst:=NIL;
                    q:=M_Liste;
                    if q=NIL
                      then M_Liste:=r
                      else
                        begin
                          while q^.naechst<>NIL do q:=q^.naechst;
                          q^.naechst:=r
                        end
                  end
              until (count=0) or EOF(Source);
            if count>0 then h:=error(19,'');
          end
      end;
    FuegeEin(VarListe,T)
  end;

procedure PushMacro(M : MacroListe; Pr : Zeile);
  var t,p,q,a : TextListe;
      Alt, Neu: string[80];
      Pt      : Zeile;

  procedure Ersetze(var Z,alt,neu : zeile);
    begin
      while pos(alt,Z)>0 do
        begin insert(#1,Z,pos(alt,Z)); delete(Z,pos(alt,Z),length(alt)) end;
      while pos(#1,Z)>0 do
        begin insert(neu,Z,pos(#1,Z)); delete(Z,pos(#1,Z),1) end;
    end;

  procedure HolParameter(var von,par : zeile);
    var i : byte;
    begin
      if von<>''
        then
          begin
             von:=von+','; i:=pos(',',von); par:=copy(von,1,i-1);
             delete(von,1,i); SkipLeftBlanks(par); SkipRightBlanks(par)
          end
        else par:=''
    end;

  begin  {Anhaengen}
    t:=NIL; a:=NIL;
    with M do
      begin
        p:=M_Liste; Pt:=ParamListe;
        while p<>NIL do
          begin
            new(q); q^.naechst:=NIL; q^.M_Zeile:=p^.M_Zeile;
            if t=NIL then t:=q else a^.naechst:=q;
            a:=q; p:=p^.naechst
          end;
        HolParameter(Pt,Alt); HolParameter(Pr,Neu);
        while Neu<>'' do
          begin
            a:=t;
            while a<>NIL do
               begin Ersetze(a^.M_Zeile,Alt,Neu); a:=a^.naechst end;
            HolParameter(Pt,Alt); HolParameter(Pr,Neu)
          end;
        a:=t; if t<>NIL then while a^.naechst<>NIL do a:=a^.naechst;
        a^.naechst:=TextStack; TextStack:=t
      end
  end; {PushMacro}

procedure PopZeile(var z : Zeile);
  var p : TextListe;
  begin
    z:=TextStack^.M_Zeile; p:=TextStack;
    TextStack:=TextStack^.naechst; dispose(p)
  end;
                                                                   