
// FIG.CPP

#include "FIG.HPP"
#include <graphics.h>
#include <conio.h>
#include <string.h>

PUNKT::PUNKT(INT Xinit, INT Yinit) : ORT (Xinit, Yinit)
{
  // Voreinstellung ist unsichtbar
  sichtbar = FALSE;
}

VOID PUNKT::zeig()
{
  sichtbar = TRUE;

  // voreingestellte Farben verwenden
  putpixel(X, Y, getcolor());
}

VOID PUNKT::tarn()
{
  sichtbar = FALSE;

  // mit der Hintergrundfarbe lschen
  putpixel(X, Y, getbkcolor());
}

VOID PUNKT::schieb_nach(INT Xneu, INT Yneu)
{
  tarn();   // den aktuellen Punkt unsichtbar
	    // machen
  X = Xneu; // den X- und Y-Koordinaten den
  Y = Yneu; // neuen Ort zuweisen
  zeig();   // den Punkt am neuen Ort zeigen
}

VOID PUNKT::schieb(INT schieb_um)
{
  INT Xd, Yd;
  INT Xfig, Yfig;

  // die Figur zeigen, die verschoben werden soll
  zeig();

  // die erste Position der Figur lesen
  Xfig = Xhol();
  Yfig = Yhol();

  // Die Schleife zum Verschieben
  while (GetDelta(Xd, Yd))
  {
    Xfig += (Xd * schieb_um);
    Yfig += (Yd * schieb_um);

    // die Figur soll bewegt werden
    schieb_nach(Xfig, Yfig);
  };
}

KREIS::KREIS(INT Xinit, INT Yinit, INT InitRadius) : PUNKT (Xinit, Yinit)
{
  Radius = InitRadius;
}

VOID KREIS::zeig()
{
  sichtbar = TRUE;

  // Kreis zeichnen
  circle(X, Y, Radius);
}

VOID KREIS::tarn()
{
  // aktuelle Farben speichern
  unsigned INT TempColor;

  // die aktuelle Farbe initialisieren
  TempColor = getcolor();

  // Zeichenfarbe ist die Hintergrundfarbe
  setcolor(getbkcolor());
  sichtbar = FALSE;

  // in der Hintergrundfarbe zeichnen
  circle(X, Y, Radius);

  // Farbe auf die aktuelle Farbe zurcksetzen
  setcolor(TempColor);
}

VOID KREIS::expand(INT expand_um)
{
  // alten Kreis lschen
  tarn();

  // den Radius erweitern
  Radius += expand_um;

  // negativen Radius vermeiden
  if (Radius < 0) Radius = 0;

  // neuen Kreis zeichnen
  zeig();
}

VOID KREIS::kontra(INT kontra_um)
{
  // neu zeichnen mit (kontra_um)
  expand(-kontra_um);
}

VOID BOGEN::zeig()
{
  sichtbar = TRUE;
  arc(X, Y, StartWinkel, EndWinkel, Radius);
}

VOID BOGEN::tarn()
{
  INT TempColor;
  TempColor = getcolor();
  setcolor (getbkcolor());
  sichtbar = FALSE;

  // den Bogen in der Hintergrundfarbe
  // zeichnen, um ihn zu verbergen
  arc(X, Y, StartWinkel, EndWinkel, Radius);
  setcolor(TempColor);
}

TEXT::TEXT(INT Xtxt, INT Ytxt, INT TxtFont,
	   INT FeldGroesse, char *Text) : PUNKT(Xtxt, Ytxt)
{
  // Standardfonts, in graph.h definiert
  Font = TxtFont;

  // Breite des Bereichs fr den Text
  Feld = FeldGroesse;

  // zeigt auf die Nachricht
  Txt = Text;
};

VOID TEXT::zeig(VOID)
{
  // 8 Pixels pro Zeichen
  INT size = Feld / (8 * strlen(Txt));

  // zentriert im Kreis
  settextjustify(CENTER_TEXT, CENTER_TEXT);

  // Gre > 1: vergrern
  settextstyle(Font, HORIZ_DIR, size);

  // den Text zeigen
  outtextxy(X, Y, Txt);
}

// Elementfunktionen der Klasse KREIS_TEXT

KREIS_TEXT::KREIS_TEXT(INT Xkreis, INT Ykreis,
		 INT Radius, INT Font,
	   char *Txt) :
	   KREIS (Xkreis, Ykreis, Radius),
	   TEXT(Xkreis, Ykreis, Font, 2*Radius, Txt)
{
}

VOID KREIS_TEXT::zeig(VOID)
{
  KREIS::zeig();
  TEXT::zeig();
}

// eine allgemeine Funktion, um die Cursortasten
// ber die Tastatur einzulesen (keine
// Elementfunktion)

BOOL GetDelta(INT& Xd, INT& Yd)
{
  CHAR Taste;
  BOOL Ende;
  Xd = 0;
  Yd = 0;

  do
  {
    // Tastendruck lesen
    Taste = getch();

    // Carriage Return
    if (Taste == 13) return(FALSE);

    // ein erweiterter Tastencode
    if (Taste == 0)
    {
      // Annahme: der Tastendruck ist brauchbar
      Ende = TRUE;

      // den Rest des Codes lesen
      Taste = getch();
      switch (Taste)
      {
	case 72: Yd = -1; // unten
		 break;
	case 80: Yd =  1; // oben
		 break;
	case 75: Xd = -1; // links
		 break;
	case 77: Xd =  1; // rechts
		 break;

	// keine Pfeiltaste
	default: Ende = FALSE;
      };
    };
  } while (!Ende);
  return(TRUE);
}

