
// FIG.HPP

#ifndef FIG_HPP
#define FIG_HPP

#define VOID void
#define CHAR char
#define INT  int
enum BOOL {FALSE, TRUE};

//  Die Klasse ORT bescheibt Orte auf
//  dem Bildschirm mit X-Y-Koordinaten.

class ORT
{
protected:
   INT X;
   INT Y;
public:
   ORT(INT Xinit, INT Yinit)
   { X = Xinit;
     Y = Yinit;
   }
   INT Xhol() {return X;}
   INT Yhol() {return Y;}
};

//  Die Klasse PUNKT beschreibt, ob ein Punkt
//  sichtbar ist oder nicht.

class PUNKT : public ORT
{
protected:
   BOOL sichtbar;
public:
   PUNKT(INT Xinit, INT Yinit);

   // zeig und Hide sind virtuell
   virtual VOID zeig();
   virtual VOID tarn();

   virtual VOID schieb(INT schieb_um);
   BOOL ist_sichtbar() { return sichtbar; }
   VOID schieb_nach(INT Xneu, INT Yneu);
};

//  Die Klasse KREIS beschreibt den Radius
//  eines Kreises.

class KREIS : public PUNKT
{  // abgeleitet von der Klasse PUNKT und
   // der Klasse ORT
protected:
   INT Radius;
public:
   KREIS(INT Xinit, INT Yinit, INT InitRadius);
   VOID zeig();
   VOID tarn();
   VOID expand(INT expand_um);
   VOID kontra(INT kontra_um);
};

class BOGEN : public KREIS
{
   INT StartWinkel;
   INT EndWinkel;

public:
   // Konstruktor
   BOGEN(INT Xinit, INT Yinit, INT InitRadius,
       INT InitStartWinkel, INT InitEndWinkel)
   : KREIS (Xinit, Yinit, InitRadius)
   {
     StartWinkel = InitStartWinkel;
     EndWinkel = InitEndWinkel;
   }
   VOID zeig();  // dies sind virtuelle
   VOID tarn();  // Funktionen in PUNKT
};

class TEXT : public PUNKT
{  // zeigt eine Nachricht auf dem
   //  Grafik-Bildschirm

   char *Txt; // Nachricht, die gezeigt werden soll
   INT Font;  // der BGI-Font, der verwendet wird
   INT Feld; // Feldgre fr die Texteinteilung

public:

   // Nachricht initialisieren
   TEXT(INT Xtxt, INT Ytxt, INT TxtFont, INT FeldGroesse, char *Text);

   // Nachricht zeigen
   VOID zeig(VOID);
};


class KREIS_TEXT : KREIS, TEXT
{  // erbt alle Merkmale von KREIS und TEXT

public:
   KREIS_TEXT(INT Xkreis, INT Ykreis, INT Radius, INT Font, char *Txt);

   // einen Kreis mit einer Nachricht zeigen
   VOID zeig(VOID);
};

// Prototyp einer allgemeinen Nicht-Elementfunktion

BOOL GetDelta(INT& Xd, INT& Yd);


#endif

