
// PKT.CPP

#include "pkt.hpp"
#include <graphics.h>
#include <conio.h>

PUNKT::PUNKT(INT Xinit, INT Yinit) : ORT (Xinit, Yinit)
{
  // Voreinstellung ist unsichtbar
  sichtbar = FALSE;
}

VOID PUNKT::zeig()
{
  sichtbar = TRUE;

  // voreingestellte Farben verwenden
  putpixel(X, Y, getcolor());
}

VOID PUNKT::tarn()
{
  sichtbar = FALSE;

  // mit der Hintergrundfarbe lschen
  putpixel(X, Y, getbkcolor());
}

VOID PUNKT::schieb_nach(INT Xneu, INT Yneu)
{
  tarn();   // den aktuellen Punkt unsichtbar
	    // machen
  X = Xneu; // den X- und Y-Koordinaten den
  Y = Yneu; // neuen Ort zuweisen
  zeig();   // den Punkt am neuen Ort zeigen
}

VOID PUNKT::schieb(INT schieb_um)
{
  INT Xd, Yd;
  INT Xfig, Yfig;

  // die Figur zeigen, die verschoben werden soll
  zeig();

  // die erste Position der Figur lesen
  Xfig = Xhol();
  Yfig = Yhol();

  // Die Schleife zum Verschieben
  while (GetDelta(Xd, Yd))
  {
    Xfig += (Xd * schieb_um);
    Yfig += (Yd * schieb_um);

    // die Figur soll bewegt werden
    schieb_nach(Xfig, Yfig);
  };
}

// eine allgemeine Funktion, um die Cursortasten
// ber die Tastatur einzulesen (keine
// Elementfunktion)

BOOL GetDelta(INT& Xd, INT& Yd)
{
  CHAR Taste;
  BOOL Ende;
  Xd = 0;
  Yd = 0;

  do
  {
    // Tastendruck lesen
    Taste = getch();

    // Carriage Return
    if (Taste == 13) return(FALSE);

    // ein erweiterter Tastencode
    if (Taste == 0)
    {
      // Annahme: der Tastendruck ist brauchbar
      Ende = TRUE;

      // den Rest des Codes lesen
      Taste = getch();
      switch (Taste)
      {
	case 72: Yd = -1; // unten
		 break;
	case 80: Yd =  1; // oben
		 break;
	case 75: Xd = -1; // links
		 break;
	case 77: Xd =  1; // rechts
		 break;

	// keine Pfeiltaste
	default: Ende = FALSE;
      };
    };
  } while (!Ende);
  return(TRUE);
}

