{***************************************************************
*                                                              *
* Aus: "Diagramme a la carte" c't 1990 Heft 2 Seite 132 - 146  *
* Untertitel: Universelle Diagrammzeichenroutine in C"         *
*                                                              *
* Umgeschrieben auf Turbo-Pascal (ab Version 4.0)              *
* von Johann Walzer am 30.Dez.1991                             *
*                                                              *
***************************************************************}

program DiagTest;

uses crt,dos,graph,diagramm;

const
  n=256;

var
  treiber, mode        : integer; { Parameter der }
  maxcolor, maxx, maxy : integer; { Graphik-Karte }
  alt_exit             : pointer; { Error-Routine }
  DrawCode             : integer; { Ergebnis der DrawDiag-Routine }

  i    : longint;
  yh   : real;
  wahl : malflags;
  art  : byte;
  xw,yw,hw,ww: integer;

  x : array [0..256] of real;
  y : array [0..256] of real;


{$F+}
procedure error_exit;
{ Umgeleitete Error-Routine }
begin
  closegraph;
  if erroraddr<>nil then begin sound(440); delay(100); nosound; end;
end;
{$F-}


procedure graphein;
{ Graphik-Modus einschalten }
var
  bgipfad   : string[80];
  errorcode : integer;
begin
  directvideo := false;
  alt_exit    := exitproc;
  exitproc    := @error_exit;
  bgipfad     := '';     { BGI-Pfad: aktuelles Verzeichnis }
  treiber     := 0;
  initgraph(treiber,mode,bgipfad);
  errorcode   := graphresult;
  if errorcode<>grok then begin
    writeln('Falscher BGI-Pfad');
    halt(1);
  end;
  maxcolor := getmaxcolor;
  maxx     := getmaxx;
  maxy     := getmaxy;
end;




begin   { Haupt-Programm }
  clrscr;
  repeat
    gotoxy(5,3); write('Art des Diagramms (0 bis 8)   : '); clreol;
    read(art);
  until (art in [0..8]);

  repeat
    gotoxy(5,4); write('X,Y der oberen linken Bildecke: '); clreol;
    read(xw,yw);
  until ((xw<639) and (yw<480));

  repeat
    gotoxy(5,5); write('Weite und Hhe des Diagramms : '); clreol;
    read(ww,hw);
  until ((ww+xw<640) and (hw+yw<480));

  for i:=0 to n do
  begin
    x[i]:=(i+1)/n*6;
    yh:=i/n*6-3;
    y[i]:=exp(-yh*yh)*0.995;
  end;

  graphein;
  setgraphmode(mode);

  with wahl do
  begin
    raster:=true;
    transp:=true;
    extrem:=false;
    nullin:=true;
    achsen:=true;
    verlin:=true;
    normen:=false;
    zahlen:=false;
    marker:=0;
  end;

  DrawCode:=DrawDiag(art,wahl,addr(x),addr(y),n,rel,xw,yw,ww,hw);
  if (DrawCode<>0) then Write('Fehler in DrawDiag: ',DrawCode)
  else repeat until keypressed;
  closegraph;
end.
