{******************************************************************
*                                                                 *
*   Aus: "Diagramme a la carte" c't 1990 Heft 2 Seite 132 - 146   *
*   Untertitel: Universelle Diagrammzeichenroutine in C"          *
*                                                                 *
*   Umgeschrieben auf Turbo-Pascal (ab Version 4.0)               *
*   von Johann Walzer am 30.Dez.1991                              *
*                                                                 *
*******************************************************************
*                                                                 *
*   Universelle Diagrammroutine fr beliebige Bildschirmmae      *
*                                                                 *
*   Version 1.2 vom 16.11.1989 geschrieben von DITTELSOFT         *
*                                                                 *
*   Autor: Georg Ditti, Aachen                                   *
*                                                                 *
*   art:=0 : lineare Darstellung                   (byte)         *
*   art:=1 : y-logarithmische Darstellung                         *
*   art:=2 : x-logarithmische Dartsellung                         *
*   art:=3 : doppelt logarithmische Darstellung                   *
*   art:=4 : Polardiagramm                                        *
*   art:=5 : diabatische Darstellung                              *
*   art:=6 : diabatisch-logarithmische Darstellung                *
*   art:=7 : komplexe Ebene                                       *
*   art:=8 : Darstellung komplexer Zahlen im Polardiagramm        *
*                                                                 *
*   malen.raster : Raster(selbstskalierend)        (malflags)     *
*   malen.transp : neues Diagramm ber altes zeichnen             *
*   malen.extrem : Extrema markieren                              *
*   malen.nullin : Nullinien erzwingen                            *
*   malen.achsen : keine Achsenmarkierungen                       *
*   malen.verlin : keine Verbindungslinien                        *
*   malen.normen : Maximum auf 1 normieren                        *
*   malen.zahlen : Y-Werte werden numeriert (ohne X-Werte)        *
*                                                                 *
*   malen.marker : 0 => keine Punktmarkierung                     *
*                  1 => gerade Kreuzchen                          *
*                  2 => schrge Kreuzchen                         *
*                  3 => Quadrate                                  *
*                  4 => Rauten                                    *
*                  5 => Dreiecke nach oben                        *
*                  6 => Dreiecke nach unten                       *
*                  7 => Kreise                                    *
*                                                                 *
*   xwerte ist Zeiger auf Feld mit X-Werten        (Pointer)      *
*                     oder Anfang des complex-Arrays              *
*   ywerte ist Zeiger auf Feld mit Y-Werten        (Pointer)      *
*                                                                 *
*   ACHTUNG: Das Feld mit den X-Werten bzw. das Feld mit den      *
*            Y-Werten mu jeweils innerhalb eines Segments liegen *
*                                                                 *
*   n ist die Anzahl darzustellender Werte         (LongInt)      *
*                                                                 *
*   typ gibt Datentyp an                           (WertTyp)      *
*               byt => byte                                       *
*               int => integer                                    *
*               lng => longint                                    *
*               rel => real                                       *
*               dbl => double                                     *
*               cpx => complex                                    *
*                                                                 *
*   x,y,w,h sind die Mae des auszumalenden Fensters   (integer)  *
*                                                                 *
*   (x,y:=Position der oberen, linken Ecke in Pixeln              *
*    w,h:=Breite und Hhe des Zeichenbereichs in Pixel)           *
*                                                                 *
******************************************************************}


unit diagramm;

{$N+}  { 287-Emulation einschalten fr "double"-Typ }

interface

{ ******* Typendefinitionen, Funktionsprototypen ************* }

type
  complex = record
              re: double;
              im: double;
            end;

  malflags = record
               raster: boolean;
               transp: boolean;
               extrem: boolean;
               nullin: boolean;
               achsen: boolean;
               verlin: boolean;
               normen: boolean;
               zahlen: boolean;
               marker: byte;
             end;

   werttyp = (byt,int,lng,rel,dbl,cpx);    { Typ der X,Y-Werte }


  {  Statische Fenster- und Mastabsparameter fr mehrere Kurven  }
var
  xskamin,xskamax,xpixfak,ypixfak,yskamin,yskamax: double;
  xstepsum,ystepsum,xstep,ystep,xstepmk,ystepmk: double;
  xpixoff,ypixoff,ix0,iy0,ixmin,iymin,ixmax,iymax: integer;

  {  Erklrung der einzelnen Variablen :
     xskamin,xskamax:=Skalenextrema > Extrema !      (double)
     xpixfak,ypixfak:=Pixel pro Skaleneinheit        (double)
     yskamin,yskamax:=siehe oben                     (double)
     xstepsum,ystepsum:=aktueller Skalenmarker       (double)
     xstep,ystep      :=aktuelle Schrittweite        (double)
     xstepmk,ystepmk  :=aktuelle Schriftweite        (double)
     xpixoff,ypixoff  :=Zeichenoffset in Pixeln      (integer)
     ix0,iy0,ixmin,iymin,ixmax,iymax:=Hilfsvariablen (integer)  }


function drawdiag(art: byte; malen: malflags; xwerte, ywerte: pointer;
                  n: longint; typ: werttyp; x, y, w, h: integer): integer;

{----------------------------------------------------------------------------}

implementation

uses graph;

function log10(arg: double): double;
const ln10: double=2.30258509299405;
begin
  log10:=ln(arg)/ln10;
end;

function diabat(arg: double): double;
{  Diabatische Funktion, Quelle: SCHOTT-Glasfilterkatalog  }
begin
  if (arg>=1-1e-10) then arg:=1-1e-10;
  if (arg<=1e-10)   then arg:=1e-10;
  diabat:=1-log10(log10(1/arg));
end;


{  marker_malen zeichnet und beschriftet die Skalenachsen,
   wird fr jeden einzelnen Schritt neu aufgerufen,
   schaltet bei nichtlinearen Diagrammen Schrittweite um
 }

procedure marker_malen(b, xmin, xmax, ymin, ymax, pixoff: integer;
                       pixfak: double; var step, stepsum, stepmk: double;
                       dir: char; malen: malflags; flag: integer);

var
  x1line,y1line,x2line,y2line, toff: integer;
  absstepsum: double;
  mark: string[10];

begin

  absstepsum:=abs(stepsum);

  if (dir='x')       {  X-Achse markieren  }
  then begin
    case flag of
      2, -2: x1line:=pixoff+round(pixfak*log10(stepsum));
      else   x1line:=pixoff+round(pixfak*stepsum);
    end;

    x2line:=x1line;

    if (0.1>frac(absstepsum/stepmk+0.001)) then
    begin
      y1line:=b; y2line:=b+8;
      if ((absstepsum=0) or (absstepsum<100000) and (absstepsum>=0.00099))
      then begin
             Str(absstepsum:10:3,mark); toff:=23;
             while (mark[1]=' ') do delete(mark,1,1);
             if (stepsum<0) then mark:='-'+copy(mark,1,5)
                            else mark:=' '+copy(mark,1,5);
           end
      else begin Str(stepsum:10,  mark); toff:=35; delete(mark,7,1); end;
      if malen.achsen then OutTextXY(x2line-toff,y2line+7,mark);
      setlinestyle(SolidLn,0,ThickWidth);
    end
    else begin y1line:=b; y2line:=b+4 end;

    if ((x1line>xmin) and (xmax>x1line))
    then begin
      if malen.achsen then line(x1line,y1line,x2line,y2line);
      if malen.raster
      then begin
        setlinestyle(UserBitLn,$1111,NormWidth);
        y1line:=ymin; y2line:=ymax;
        line(x1line,y1line,x2line,y2line);
      end;
      setlinestyle(SolidLn,0,NormWidth);
    end
  end
  else
  if (dir='y')          {  Y-Achse markieren  }
  then begin
    case flag of
      2, -2: y1line:=pixoff-round(pixfak*log10(stepsum));
      3, -3: y1line:=pixoff-round(pixfak*diabat(stepsum));
      else   y1line:=pixoff-round(pixfak*stepsum);
    end;

    y2line:=y1line;

    if (0.1>frac(absstepsum/stepmk+0.001))
    then begin
      x1line:=b; x2line:=b-8;
      if ((absstepsum=0) or (absstepsum<100000) and (absstepsum>=0.00099))
      then begin
             Str(absstepsum:10:3,mark); toff:=49;
             while (mark[1]=' ') do delete(mark,1,1);
             if (stepsum<0) then mark:='-'+copy(mark,1,5)
                            else mark:=' '+copy(mark,1,5);
           end
      else begin Str(stepsum:10,   mark); toff:=73; delete(mark,7,1); end;
      if malen.achsen then OutTextXY(x2line-toff,y2line+1,mark);
      setlinestyle(SolidLn,0,ThickWidth);
    end
    else begin x1line:=b; x2line:=b-4 end;

    if ((y1line>ymin) and (ymax>y1line))
    then begin
      if malen.achsen then line(x1line,y1line,x2line,y2line);
      if malen.raster
      then begin
        setlinestyle(UserBitLn,$1111,Normwidth);
        x1line:=xmin; x2line:=xmax;
        line(x1line,y1line,x2line,y2line);
      end;
      setlinestyle(SolidLn,0,NormWidth);
    end
  end;

  case flag of                             {  Schrittweite neu einstellen  }
    1: stepsum:=stepsum+step;              {  linear ab 0 aufwrts  }
   -1: stepsum:=stepsum-step;              {  linear ab 0 abwrts  }
    2: begin                               {  logarithmisch ab 1 aufwrts  }
         if (0.01>=abs(frac(log10(stepsum)+0.001)))
         then begin step:=step*10; stepmk:=stepmk*10 end;
         stepsum:=stepsum+step;
       end;
   -2: begin                               {  logarithmisch ab 1 abwrts  }
         stepsum:=stepsum-step;
         if (0.01>=abs(frac(log10(stepsum)-0.001)))
         then begin step:=step/10; stepmk:=stepmk/10 end;
       end;
    3: begin                               {  diabatisch ab 0.5 aufwrts  }
         stepsum:=stepsum+step;
         if (0.01>=frac(abs(log10(1-stepsum))+0.001))
         then begin step:=step/10; stepmk:=stepmk/10 end;
       end;
   -3: begin                               {  diabatisch ab 0.5 abwrts  }
        stepsum:=stepsum-step;
        if ((stepsum<0.1999) and (stepsum>0.9e-3))
        then begin stepmk:=stepmk/10; step:=stepsum*0.9 end;
        if (stepsum<0.9e-3)
        then begin stepmk:=stepmk/100; step:=stepsum*0.99 end;
      end;
  end
end;


{  polmarker_malen zeichnet und beschriftet die
   Skalenmarkierungen fr das Polardiagramm,
   wird fr jeden einzelnen Schritt neu aufgerufen
 }

procedure polmarker_malen(xpixoff, ypixoff: integer; pixfak: double;
                          var step, stepsum, stepmk: double;
                          malen: malflags);

var
  x1line,y1line,x2line,y2line,i,h1,h2: integer;
  w: double;
  mark: string[10];

begin
  stepsum:=stepsum+step;
  x1line:=xpixoff+round(stepsum*pixfak); x2line:=x1line;

  if (0.1>frac(stepsum/stepmk+0.001))
  then begin
    y1line:=ypixoff-6; y2line:=ypixoff+6;
    h1:=xpixoff-6; h2:=xpixoff+6;
    SetLineStyle(SolidLn,0,ThickWidth);
    if ((stepsum=0) or (stepsum<10000) and (stepsum>=0.00099))
    then begin
           Str(stepsum:10:3,mark);
           while (mark[1]=' ') do delete(mark,1,1);
           mark:=copy(mark,1,5);
           if (mark[5]='0') then delete(mark,5,1);
         end
    else begin Str(stepsum:10,  mark); delete(mark,7,1); end;

    if malen.achsen then OutTextXY(x2line-15,y2line+9,mark);
  end
  else begin
    y1line:=ypixoff-3; y2line:=ypixoff+3;
    h1:=xpixoff-3; h2:=xpixoff+3;
    SetLineStyle(SolidLn,0,NormWidth);
  end;

  if malen.achsen          { Markierungs-Striche auf den Achsen }
  then begin
    line(x1line,y1line,x2line,y2line);
    x1line:=xpixoff-round(stepsum*pixfak); x2line:=x1line;
    line(x1line,y1line,x2line,y2line);
    x1line:=h1; x2line:=h2;
    y1line:=ypixoff-round(stepsum*pixfak); y2line:=y1line;
    line(x1line,y1line,x2line,y2line);
    y1line:=ypixoff+round(stepsum*pixfak); y2line:=y1line;
    line(x1line,y1line,x2line,y2line);
  end;

  if malen.raster
  then begin
    setlinestyle(UserBitLn,$1111,Normwidth);

    for i:=0 to 36 do
    begin
      w:=i*PI/18;
      x2line:=xpixoff+round(pixfak*stepsum*cos(w));
      y2line:=ypixoff+round(pixfak*stepsum*sin(w));
      if (i<>0) then line(x1line,y1line,x2line,y2line);
      if (((i mod 3)=0) and (stepsum>step))
      then begin
        x1line:=xpixoff+round(pixfak*(stepsum-step)*cos(w));
        y1line:=ypixoff+round(pixfak*(stepsum-step)*sin(w));
        line(x1line,y1line,x2line,y2line);
      end;
      x1line:=x2line; y1line:=y2line;
    end;
    setlinestyle(SolidLn,0,NormWidth);
  end;
end;


function DrawDiag(art: byte; malen: malflags; xwerte, ywerte: pointer;
                  n: longint; typ: werttyp; x, y, w, h: integer): integer;

  {  Allgemeine Betriebsvariablen  }
var
  i,s: longint;
  XSeg,XOfs,YSeg,YOfs: integer;
  size: integer;
  BytPtr:^byte; IntPtr:^integer; LngPtr:^longint; RelPtr:^real;
  DblPtr: ^double; CpxPtr:^complex;
  x1line,y1line,x2line,y2line: integer;
  xmin,xmax,ymin,ymax,maxpos,minpos,xw,yw,xh,yh,nymax: double;
  initxstepsum,initystepsum,initxstep,initystep,initxstepmk,initystepmk: double;

  {  Erklrung der einzelnen Variablen :

    i,s := Zhlvariablen                                            (longint)
    XSeg...YOfs := Segment und Offset der Zeiger auf Tabellen-Werte (integer)
    size := Gre der Tabellen-Werte je nach eingestelltem Typ      (integer)
    BytPtr...CpxPtr := Zeiger fr jeden Wert-Typ
    x1line...y2line :=Start- und End-Punkte fr "LINE"-proc.        (integer)
    flag:=Allgemeine Flagvariable, fters gebraucht                 (integer)
    xmin,xmax    :=Minimum und Maximum der X-Werte                  (double)
    ymin,ymax    :=Minimum und Maximum der Y-Werte                  (double)
    maxpos,minpos:=Position der Extrema auf der X-Achse             (double)
    xw,yw,xh,yh  :=Zwischenergebnisse                               (double)
    nymax        :=Maximum der Funktionswerte                       (double)
    initxstepsum,initystepsum:=Anfang der Skalierung                (double)
    initxstep,initystep:=anfngliche Skalierungsweite              (double)
    initxstepmk,initystepmk:=anfngliche Markierungsweite          (double)}


begin

   {   Pointer initialisieren   }

   XSeg:=Seg(xwerte^); YSeg:=Seg(ywerte^);
   XOfs:=Ofs(xwerte^); YOfs:=Ofs(ywerte^);


   if malen.zahlen then begin XSeg:=YSeg; XOfs:=YOfs end;

   {  Maximal 1000 Punkte sonst sieht man nix mehr  }

   s:=1; while ((n div s)>1000) do s:=s+1;

   case typ of
     byt: begin
            BytPtr:=Ptr(XSeg,XOfs); xmin:=BytPtr^;
            BytPtr:=Ptr(YSeg,YOfs); ymin:=BytPtr^;
            size:=sizeof(BytPtr^);
          end;
     int: begin
            IntPtr:=Ptr(XSeg,XOfs); xmin:=IntPtr^;
            IntPtr:=Ptr(YSeg,YOfs); ymin:=IntPtr^;
            size:=sizeof(IntPtr^);
          end;
     lng: begin
            LngPtr:=Ptr(XSeg,XOfs); xmin:=LngPtr^;
            LngPtr:=Ptr(YSeg,YOfs); ymin:=LngPtr^;
            size:=sizeof(LngPtr^);
          end;
     rel: begin
            RelPtr:=Ptr(XSeg,XOfs); xmin:=RelPtr^;
            RelPtr:=Ptr(YSeg,YOfs); ymin:=RelPtr^;
            size:=sizeof(RelPtr^);
          end;
     dbl: begin
            DblPtr:=Ptr(XSeg,XOfs); xmin:=DblPtr^;
            DblPtr:=Ptr(YSeg,YOfs); ymin:=DblPtr^;
            size:=sizeof(DblPtr^);
          end;
     cpx: begin
            CpxPtr:=Ptr(XSeg,XOfs); xmin:=CpxPtr^.re;
                                    ymin:=CpxPtr^.im;
            size:=sizeof(CpxPtr^);
          end;
   end;

   if malen.zahlen then xmin:=0;
   xmax:=xmin; ymax:=ymin;
   maxpos:=xmin; minpos:=xmin;


   {  Extrema finden  }

   i:=1;
   repeat
     case typ of
       byt: begin
              BytPtr:=Ptr(XSeg,XOfs+i*size); xw:=BytPtr^;
              BytPtr:=Ptr(YSeg,YOfs+i*size); yw:=BytPtr^;
            end;
       int: begin
              IntPtr:=Ptr(XSeg,XOfs+i*size); xw:=IntPtr^;
              IntPtr:=Ptr(YSeg,YOfs+i*size); yw:=IntPtr^;
            end;
       lng: begin
              LngPtr:=Ptr(XSeg,XOfs+i*size); xw:=LngPtr^;
              LngPtr:=Ptr(YSeg,YOfs+i*size); yw:=LngPtr^;
            end;
       rel: begin
              RelPtr:=Ptr(XSeg,XOfs+i*size); xw:=RelPtr^;
              RelPtr:=Ptr(YSeg,YOfs+i*size); yw:=RelPtr^;
            end;
       dbl: begin
              DblPtr:=Ptr(XSeg,XOfs+i*size); xw:=DblPtr^;
              DblPtr:=Ptr(YSeg,YOfs+i*size); yw:=DblPtr^;
            end;
       cpx: begin
              CpxPtr:=Ptr(XSeg,XOfs+i*size); xw:=CpxPtr^.re;
                                             yw:=CpxPtr^.im;
            end;
     end;

     if malen.zahlen then xw:=i;
     if (art=8) then
     begin
       xh:=arctan(yw/xw);
       yh:=sqrt(xw*xw+yw*yw);
       xw:=xh; yw:=yh;
     end;

     if (xmin>=xw) then xmin:=xw;
     if (xw>=xmax) then xmax:=xw;
     if (ymin>=yw) then begin ymin:=yw; minpos:=xw; end;
     if (yw>=ymax) then begin ymax:=yw; maxpos:=xw; end;

     i:=i+s;
   until (i>n);

   if malen.normen then
   begin nymax:=ymax; ymin:=ymin/nymax; ymax:=1.; end;

   {   Diagrammparameter nur erstes Mal bestimmen   }

   if malen.transp then
   begin
     {  Wertbereichsprfung, Skalierungsfaktor,
        Fensternullpunkt zum Zeichnen  }

     {  Zuerst in X-Richtung  }

     xpixfak:=w-60;
     ypixfak:=h-25;

     case art of
     2,3,6: begin
              if (malen.nullin and (xmin>=1)) then xmin:=1;
              if (malen.nullin and (xmax<=1)) then xmax:=1;
              if (0>=xmin) then DrawDiag:=1;                  { Fehler !!! }
              xskamin:=xmin*0.8; xskamax:=xmax*1.1;
              xpixfak:=xpixfak/(log10(xskamax)-log10(xskamin));
              xpixoff:=x+60-round(log10(xskamin)*xpixfak);
              initxstepsum:=1; initxstep:=0.1; initxstepmk:=0.5;
              if (xpixfak*initxstep>=100)
              then begin initxstep:=0.02; initxstepmk:=0.1 end
              else if (xpixfak*initxstep<2)
                   then begin initxstep:=0.9; initxstepmk:=1; end
                   else if(xpixfak*initxstep<10)
                        then begin initxstep:=0.3; initxstepmk:=1; end
            end;

     4,8: ;
     else
     begin
       if (malen.nullin and (xmin>=0)) then xskamin:=0;
       if (malen.nullin and (xmax<=0)) then xskamax:=0;
       xskamin:=xmin-0.05*abs(xmax-xmin);
       xskamax:=xmax+0.05*abs(xmax-xmin);
       xpixfak:=xpixfak/(xskamax-xskamin);
       xpixoff:=x+60-round(xskamin*xpixfak);
       initxstepsum:=0; initxstep:=1; initxstepmk:=5;
       while (xpixfak*initxstep>=100) do
         begin initxstep:=initxstep/10; initxstepmk:=initxstepmk/10; end;
       while (xpixfak*initxstep<10) do
         begin initxstep:=initxstep*10; initxstepmk:=initxstepmk*10; end;
       if (xpixfak*initxstep>=50)
       then begin initxstep:=initxstep/5; initxstepmk:=initxstepmk/5; end
       else if (xpixfak*initxstep>=20)
            then begin initxstep:=initxstep/2; initxstepmk:=initxstepmk/2 end;
     end;
     end;

     {  Dann in Y-Richtung  }

     case art of
     1, 3: begin
             if (malen.nullin and (ymin>=1)) then ymin:=1;
             if (malen.nullin and (ymax<=1)) then ymax:=1;
             if (0>=ymin) then DrawDiag:=2;                    { Fehler !!! }
             yskamin:=ymin*0.9; yskamax:=ymax*1.1;
             ypixfak:=ypixfak/(log10(yskamax)-log10(yskamin));
             ypixoff:=y+h-25+round(log10(yskamin)*ypixfak);
             initystepsum:=1; initystep:=0.1; initystepmk:=0.5;
             if (ypixfak*initystep>=100)
             then begin initystep:=0.02; initystepmk:=0.1; end
             else if (ypixfak*initystep<2)
                  then begin initystep:=0.9; initystepmk:=1; end
                  else if (ypixfak*initystep<10)
                       then begin initystep:=0.3; initystepmk:=1; end
           end;
     5, 6: begin
             if ((0>ymin) or (0>ymax) or (ymin>1) or (ymax>1))
             then DrawDiag:=3;                                 { Fehler !!! }
             yskamin:=1e-9; yskamax:=1-(1-ymax)/2;
             if (yskamax>=1-1e-10) then yskamax:=1-1e-10;
             ypixfak:=ypixfak/(diabat(yskamax)-diabat(yskamin));
             ypixoff:=y+h-25+round(diabat(1e-9)*ypixfak);
             initystepsum:=0.5; initystep:=0.1; initystepmk:=0.5;
           end;
     4, 8: begin
             yskamax:=abs(ymax)*1.05; yskamin:=-yskamax;
             xskamax:=yskamax;   xskamin:=-xskamax;
             ypixfak:=ypixfak/(yskamax*2); xpixfak:=xpixfak/(xskamax*2);
             if (w<h) then ypixfak:=xpixfak else xpixfak:=ypixfak;
             ypixoff:=y+(h div 2); xpixoff:=x+(w div 2);
             initystepsum:=0; initystep:=0.2; initystepmk:=1;
             while (ypixfak*initystep>=100) do
               begin initystep:=initystep/10; initystepmk:=initystepmk/10 end;
             while (ypixfak*initystep<10) do
               begin initystep:=initystep*10; initystepmk:=initystepmk*10 end;
             if (ypixfak*initystep>=50)
             then begin initystep:=initystep/5; initystepmk:=initystepmk/5 end;
             if (ypixfak*initystep>=20)
             then begin initystep:=initystep/2; initystepmk:=initystepmk/2 end;
           end;
     else
     begin
       if (malen.nullin and (ymin>=0)) then ymin:=0;
       if (malen.nullin and (ymax<=0)) then ymax:=0;
       yskamin:=ymin-0.05*abs(ymax-ymin);
       yskamax:=ymax+0.05*abs(ymax-ymin);
       ypixfak:=ypixfak/(yskamax-yskamin);
       ypixoff:=y+h-25+round(yskamin*ypixfak);
       initystepsum:=0; initystep:=1; initystepmk:=5;
       while (ypixfak*initystep>=100) do
         begin initystep:=initystep/10; initystepmk:=initystepmk/10 end;
       while (ypixfak*initystep<10) do
         begin initystep:=initystep*10; initystepmk:=initystepmk*10 end;
       if (ypixfak*initystep>=50)
       then begin initystep:=initystep/5; initystepmk:=initystepmk/5 end
       else if (ypixfak*initystep>=20)
            then begin initystep:=initystep/2; initystepmk:=initystepmk/2 end;
     end
     end;

     {   Diverse Einstellungen der GRAPH-Unit von Borland   }

     SetColor(getmaxcolor);
     SetLineStyle(SolidLn,0,NormWidth);
     SetTextJustify(LeftText,CenterText);
     SetTextStyle(DefaultFont,0,1);

     Rectangle(x,y,x+w,y+h);       { Box um das Diagramm zeichnen }

     {   Zeichnen der X-Achse   }

     x1line:=x;
     y1line:=ypixoff;
     if ((y+12>ypixoff) or (ypixoff>y+h-25))
     then case art of
            1, 3: y1line:=ypixoff-round(log10(yskamin)*ypixfak);
            else  y1line:=ypixoff-round(yskamin*ypixfak);
          end;
     x2line:=x+w;
     y2line:=y1line;
     ix0:=y1line; ixmin:=x; ixmax:=x+w;
     line(x1line,y1line,x2line,y2line);

     {   Zeichnen der Y-Achse   }

     x1line:=xpixoff;
     if ((x>xpixoff+60) or (xpixoff>x+w-5))
     then case art of
            2,3,6: x1line:=xpixoff+round(log10(xskamin)*xpixfak);
            else   x1line:=xpixoff+round(xskamin*xpixfak);
          end;
     y1line:=y;
     x2line:=x1line;
     y2line:=y+h;
     iy0:=x1line; iymin:=y; iymax:=y+h;
     line(x1line,y1line,x2line,y2line);

     {  Zeichnen der X-Achsenmarkierer
        von einem 'runden' Startpunkt aus  }

     case art of
     2,3,6: begin                          {  Logarithmische Skalierung  }
              xstepsum:=initxstepsum;
              xstep:=initxstep;
              xstepmk:=initxstepmk;
              while (xskamax>=xstepsum) do
                marker_malen(ix0,ixmin,ixmax,iymin,iymax,xpixoff,xpixfak,
                             xstep,xstepsum,xstepmk,'x',malen,2);
              xstepsum:=initxstepsum;
              xstep:=initxstep;
              xstepmk:=initxstepmk;
              while (xstepsum>=xskamin) do
                marker_malen(ix0,ixmin,ixmax,iymin,iymax,xpixoff,xpixfak,
                             xstep,xstepsum,xstepmk,'x',malen,-2);
            end;
     4,8: ;
     else begin                            {  Lineare Skalierung  }
            xstepsum:=initxstepsum;
            xstep:=initxstep;
            xstepmk:=initxstepmk;
            while (xskamax>=xstepsum) do
              marker_malen(ix0,ixmin,ixmax,iymin,iymax,xpixoff,xpixfak,
                           xstep,xstepsum,xstepmk,'x',malen,1);
            xstepsum:=initxstepsum;
            xstep:=initxstep;
            xstepmk:=initxstepmk;
            while (xstepsum>=xskamin) do
              marker_malen(ix0,ixmin,ixmax,iymin,iymax,xpixoff,xpixfak,
                           xstep,xstepsum,xstepmk,'x',malen,-1);
          end
     end; {  end of switch  }

     {  Zeichnen der Y-Achsenmarkierer von
        einem definierten Startpunkt aus  }

     case art of
     1,3: begin                            {  Logarithmische Skalierung  }
            ystepsum:=initystepsum;
            ystep:=initystep;
            ystepmk:=initystepmk;
            while (yskamax>=ystepsum) do
              marker_malen(iy0,ixmin,ixmax,iymin,iymax,ypixoff,ypixfak,
                           ystep,ystepsum,ystepmk,'y',malen,2);
            ystepsum:=initystepsum;
            ystep:=initystep;
            ystepmk:=initystepmk;
            while (ystepsum>=yskamin) do
              marker_malen(iy0,ixmin,ixmax,iymin,iymax,ypixoff,ypixfak,
                           ystep,ystepsum,ystepmk,'y',malen,-2);
          end;
     4,8: begin                            {   Polare Skalierung   }
            ystepsum:=initystepsum;
            ystep:=initystep;
            ystepmk:=initystepmk;
            while (yskamax>=ystepsum+ystep) do
              polmarker_malen(xpixoff,ypixoff,ypixfak,ystep,ystepsum,
                              ystepmk,malen);
          end;
     5,6: begin                             {   Diabatische Skalierung   }
            ystepsum:=initystepsum;
            ystep:=initystep;
            ystepmk:=initystepmk;
            while (yskamax>=ystepsum) do
              marker_malen(iy0,ixmin,ixmax,iymin,iymax,ypixoff,ypixfak,
                           ystep,ystepsum,ystepmk,'y',malen,3);
            ystepsum:=initystepsum;
            ystep:=initystep;
            ystepmk:=initystepmk;
            while (ystepsum>=yskamin) do
              marker_malen(iy0,ixmin,ixmax,iymin,iymax,ypixoff,ypixfak,
                           ystep,ystepsum,ystepmk,'y',malen,-3);
          end;
     else begin                            {   Lineare Skalierung   }
            ystepsum:=initystepsum;
            ystep:=initystep;
            ystepmk:=initystepmk;
            while (yskamax>=ystepsum) do
              marker_malen(iy0,ixmin,ixmax,iymin,iymax,ypixoff,ypixfak,
                           ystep,ystepsum,ystepmk,'y',malen,1);
            ystepsum:=initystepsum;
            ystep:=initystep;
            ystepmk:=initystepmk;
            while (ystepsum>=yskamin) do
              marker_malen(iy0,ixmin,ixmax,iymin,iymax,ypixoff,ypixfak,
                           ystep,ystepsum,ystepmk,'y',malen,-1);
          end;
     end; {  end of switch  }
   end; {  end of 'neumalen'-if  }

   {  Ab hier wird das Wertefeld in das Diagramm eingezeichnet  }

   i:=0;
   repeat
     case typ of
       byt: begin
              BytPtr:=Ptr(XSeg,XOfs+i*size); xw:=BytPtr^;
              BytPtr:=Ptr(YSeg,YOfs+i*size); yw:=BytPtr^;
            end;
       int: begin
              IntPtr:=Ptr(XSeg,XOfs+i*size); xw:=IntPtr^;
              IntPtr:=Ptr(YSeg,YOfs+i*size); yw:=IntPtr^;
            end;
       lng: begin
              LngPtr:=Ptr(XSeg,XOfs+i*size); xw:=LngPtr^;
              LngPtr:=Ptr(YSeg,YOfs+i*size); yw:=LngPtr^;
            end;
       rel: begin
              RelPtr:=Ptr(XSeg,XOfs+i*size); xw:=RelPtr^;
              RelPtr:=Ptr(YSeg,YOfs+i*size); yw:=RelPtr^;
            end;
       dbl: begin
              DblPtr:=Ptr(XSeg,XOfs+i*size); xw:=DblPtr^;
              DblPtr:=Ptr(YSeg,YOfs+i*size); yw:=DblPtr^;
            end;
       cpx: begin
              CpxPtr:=Ptr(XSeg,XOfs+i*size); xw:=CpxPtr^.re;
                                             yw:=CpxPtr^.im;
            end;
     end;

     if malen.zahlen then xw:=i;
     if (art=8) then
     begin
       xh:=arctan(yw/xw);
       yh:=sqrt(xw*xw+yw*yw);
       xw:=xh; yw:=yh;
     end;

     if malen.normen then yw:=yw/nymax;

     case art of
       2,3,6: x2line:=xpixoff+round(xpixfak*log10(xw));
       4,8:   x2line:=xpixoff+round(xpixfak*cos(xw)*yw);
       else   x2line:=xpixoff+round(xpixfak*xw);
     end;

     case art of
       1,3:   y2line:=ypixoff-round(ypixfak*log10(yw));
       4,8:   y2line:=ypixoff-round(ypixfak*sin(xw)*yw);
       5,6:   y2line:=ypixoff-round(ypixfak*diabat(yw));
       else   y2line:=ypixoff-round(ypixfak*yw);
     end;

     {  Verbindungslinien ziehen  }

     if ((i>0) and malen.verlin) then line(x1line,y1line,x2line,y2line);

     {  groes Kreuz bei den Extrema  }

     if (malen.extrem and ((xw=minpos) or (xw=maxpos)))
     then begin
            line(x2line-20,y2line,x2line+20,y2line);
            line(x2line,y2line-20,x2line,y2line+20);
          end;

     case malen.marker of
     1: begin                          {  gerade Kreuzchen  }
          line(x2line-3,y2line,x2line+3,y2line);
          line(x2line,y2line-3,x2line,y2line+3);
        end;
     2: begin                          {  schrge Kreuzchen  }
          line(x2line-3,y2line-3,x2line+3,y2line+3);
          line(x2line+3,y2line-3,x2line-3,y2line+3);
        end;
     3: begin                          {  Kstchen  }
          rectangle(x2line-3,y2line-3,x2line+3,y2line+3);
        end;
     4: begin                          {  Rauten  }
          line(x2line-3,y2line,x2line,y2line-3);
          line(x2line,y2line-3,x2line+3,y2line);
          line(x2line+3,y2line,x2line,y2line+3);
          line(x2line,y2line+3,x2line-3,y2line);
        end;
     5: begin                          {  Dreieck nach oben  }
          line(x2line-3,y2line+2,x2line,y2line-3);
          line(x2line,y2line-3,x2line+3,y2line+2);
          line(x2line+3,y2line+2,x2line-3,y2line+2);
        end;
     6: begin                          {  Dreieck nach unten  }
          line(x2line-3,y2line-2,x2line,y2line+3);
          line(x2line,y2line+3,x2line+3,y2line-2);
          line(x2line+3,y2line-2,x2line-3,y2line-2);
        end;
     7: begin                          {  Kreise  }
          circle(x2line,y2line,3);
        end;
     end;

     x1line:=x2line; y1line:=y2line;

     i:=i+s;
   until (i>n);
   DrawDiag:=0;        { Erfolg !!! }
end;

end.
