         TITLE    'SKStart.ASM: SideKick so laden, da HELP funktioniert'
; Aufruf mit SKStart param . param = Verzeichnis, in dem SK steht
CodeSeg  SEGMENT  PARA PUBLIC 'Code'
         ASSUME   CS:CodeSeg,SS:CodeSeg
         ASSUME   DS:CodeSeg,ES:CodeSeg
         ORG      100h
Begin:   JMP      Start
ComSpec  DB       "COMSPEC="
EnvStrg  DB       "APATH="
AktPfad  DB       " :\"
         DB       64 DUP (0) ; Feld fr aktuellen Pfad
SKPfad   DB       64 DUP (0) ; Feld fr SideKick-Pfad
;
Start:   XOR      CH,CH
         MOV      CL,CS:80h  ; Kdo-Zeilenlnge steht auf PSP+80h
         CMP      CL,0       ; Kdo-Zeile vorhanden ?
         JE       ZweitAuf   ; nein: zweiter Aufruf
         DEC      CL         ; Anzahl zu kopierender Bytes
         MOV      SI,82h     ; Adresse erstes Byte des Kommandozeilen-Textes
         LEA      DI,SKPfad
         REP MOVSB           ; SK-Pfad ins Feld SKPfad kopieren,
                             ; abschlieendes 00h steht schon drinnen
         CALL     AktVerz    ; Aktuelles Verzeichnis samt Laufwerk feststellen
         CALL     PutEnv     ; abspeichern im Environment
         LEA      SI,SKPfad
         CALL     ChDir      ; SK-Verzeichnis einstellen
         JMP      Exit
ZweitAuf:
         CALL     GetEnv     ; Verzeichnis aus Environment lesen
                             ; Achtung: jetzt zeigt DS auf Environment !
         CALL     ChDir      ; frher aktuelles Verzeichnis einstellen
;
Exit:    MOV      AH,4Ch
         INT      21h

;
AktVerz: MOV      AH,19h     ; aktuelles Laufwerk erfragen
         INT      21h        ; jetzt Laufwerksnummer in AL (0 ... A, usw.)
         ADD      AL,65      ; in laufwerksbuchstaben umsetzen
         MOV      AktPfad,AL     ; Laufwerksbuchstaben mit Doppelpunkt
         MOV      AH,47h     ; aktuelles Verzeichnis erfragen
         XOR      DL,DL      ; (DL)=0 ... aktuelles Laufwerk
         LEA      SI,AktPfad+3
         INT      21h
         RET
;
PutEnv:  CALL     SuchEnv    ; Segmentadresse des Master-Environments
         XOR      DI,DI      ; Beginn des Environments
         XOR      AX,AX      ; 0000h suchen
         CLD                 ; Verarbeitung von links nach rechts
         XOR      CX,0FFFFh  ; langes Suchen ermglichen
PESuch:  REPNE SCASB         ;
         CMP      BYTE PTR [DI],0 ; 00h gefunden; nchstes Byte auch 00h ?
         JNE      PESuch     ; nein
         LEA      SI,EnvStrg ; ja
PE1:     MOV      AL,[SI]
         CMP      AL,0       ; Ende des Pfads ?
         JE       PE2        ; ja
         MOV      ES:[DI],AL ; nein: abspeichern
         INC      SI
         INC      DI
         JMP      PE1
PE2:     XOR      AX,AX
         MOV      ES:[DI],AX ; 0000h anhngen
         RET
;
GetEnv:  CALL     SuchEnv    ; Segmentadresse des Environments
         XOR      DI,DI      ; Beginn des Environments
         CLD                 ; Verarbeitung von links nach rechts
         MOV      CX,1000    ; Suchen ber 1000 Bytes ermglichen
         PUSH     CX
GESuch:  POP      CX
         LEA      BX,EnvStrg
         MOV      AL,[BX]    ; "A" suchen
         REPNE SCASB         ;
         CMP      CX,0       ; 1000 Bytes schon abgesucht ?
         JZ       Exit       ; erfolglose Suche
         PUSH     CX         ; "A" gefunden
         MOV      CX,5       ; noch 5 weitere Zeichen prfen
GESCont: INC      BX         ; nchstes Zeichen
         MOV      AL,BYTE PTR [BX]
         CMP      BYTE PTR ES:[DI],AL  ; nchstes Zeichen aus EnvStrg ?
         JNE      GESuch     ; nein: nach Anfang des EnvStrg weitersuchen
         INC      DI         ; nchstes Zeichen im EnvStrg
         LOOP     GESCont    ; ja: EnvStrg indentifizieren
         POP      CX         ; identifiziert: Stack wieder richtigstellen
         MOV      SI,DI
         PUSH     ES         ; ES:SI zeigt auf Pfad
         POP      DS
         RET                 ; jetzt zeigt DS:SI auf Pfad (fr ChDir-Routine)
;
SuchEnv: MOV      BX,-1
SE0:     INC      BX
         XOR      DI,DI
         LEA      SI,ComSpec ; diese Zeichenkette soll gesucht werden
         MOV      AX,[SI]    ; Vergleichsoperand
SE1:     MOV      ES,BX
         CMP      AX,ES:[DI]
         JE       SE2        ; gleich: SE2
         INC      BX         ; ungleich: nchster Paragraph
         JMP      SE1
SE2:     MOV      CX,3       ; noch 3 Vergleiche
SE3:     INC      SI
         INC      SI         ; nchstes Wort in ComSpec
         MOV      AX,[SI]    ; Vergleichsoperand
         INC      DI
         INC      DI         ; nchstes Wort im Speicher
         CMP      AX,ES:[DI]
         LOOPE    SE3        ; gleich: nchster Vergleich
         JNE      SE0        ; ungleich: weitersuchen nach erstem Wort
         RET                 ; gleich: Suche beendet, Adresse in ES
;
ChDir:   MOV      AH,0Eh     ; Funktion Laufwerk whlen
         MOV      DL,[SI]    ; Laufwerksbuchstabe
         AND      DL,11011111b ; in Grobuchstaben umsetzen
         SUB      DL,65      ; umwandeln in Laufwerkszahl
         INT      21h
         MOV      AH,3BH     ; CHDIR-Funktion
         MOV      DX,SI
         ADD      DX,2       ; Pfad
         INT      21h
         RET
;
CodeSeg  ENDS
         END      Begin
