         TITLE    'SA.ASM: Proze, der SUBST.EXE fr aktuellen Pfad einleitet'
CodeSeg  SEGMENT  PARA PUBLIC 'Code'
         ASSUME   CS:CodeSeg,SS:CodeSeg
         ASSUME   DS:CodeSeg,ES:CodeSeg
KdoZeile EQU      80h         ; Offset der Kommandozeile im PSP
         ORG      100h
Begin:   JMP      Start
Subst    DB       'C:\DOS\SUBST.EXE',0 ; nachzuladendes Programm
         DB       12 DUP (0)  ; Patch-Space fr Subst-Pfad
StackOfs DW       0
StackSeg DW       0           ; zum Sichern des Stacks
ParBlock DW       0           ; Environment vom Parent-Proze bernehmen
ParKdoO  DW       KdoZeile    ; Befehlszeile im PSP, Offset
ParKdoS  DW       0           ;       Segmentadresse, wird spter eingesetzt
         DW       4 DUP (-1)  ; Zeiger auf Standard-FCBs (hier unntig)
AktPfad  DB       " :\"
         DB       64 DUP (0)  ; Feld fr aktuellen Pfad
Start:   CLD                  ; Verarbeitung von links nach rechts
         CALL     RamFrei     ; Speicher fr SUBST-Nachladen freimachen
         CALL     AktVerz     ; aktuelles Verzeichnis feststellen
         CALL     AddDel      ; /D in Kommandozeile hinzufgen
         MOV      ParKdoS,DS  ; Segmentadresse von KdoZeile im ParBlock
         CALL     ExeSubst    ; Child-Proze SUBST.EXE einleiten
         CALL     AddAkt      ; aktuelles Verzeichnis hinzufgen
         CALL     ExeSubst    ; Child-Proze SUBST.EXE einleiten
         CALL     ChDrive     ; substituiertes Laufwerk anwhlen
         MOV      AH,4Ch
         INT      21h
;
RamFrei: LEA      BX,Ende     ; Offset Programmende
         MOV      CL,4
         SHR      BX,CL       ; durch 16 dividieren, wird Segmentdifferenz
         INC      BX          ; zur Sicherheit +1
         PUSH     CS
         POP      ES
         MOV      AH,4Ah      ; Funktion Speicherblock ndern
         INT      21h         ; ausfhren
         RET
;
AktVerz: MOV      AH,19h     ; aktuelles Laufwerk erfragen
         INT      21h        ; jetzt Laufwerksnummer in AL (0 ... A, usw.)
         ADD      AL,65      ; in Laufwerksbuchstaben umsetzen
         MOV      AktPfad,AL ; Laufwerksbuchstaben mit Doppelpunkt
         MOV      AH,47h     ; aktuelles Verzeichnis erfragen
         XOR      DL,DL      ; (DL)=0 ... aktuelles Laufwerk
         LEA      SI,AktPfad+3
         INT      21h
         RET
;
AddDel:  MOV      BL,DS:KdoZeile ; Lnge der Kommandozeile
         XOR      BH,BH
         MOV      DI,KdoZeile
         MOV      BYTE PTR [BX+DI+1]," "
         MOV      WORD PTR [BX+DI+2],"D/" ; Operanden /D abspeichern
         MOV      BYTE PTR [BX+DI+4],13   ; CR anhngen
         ADD      BL,3        ; Lnge der KdoZeile anpassen
         MOV      BYTE PTR [DI],BL ; und abspeichern
         RET
;
AddAkt:  MOV      BL,DS:KdoZeile
         XOR      BH,BH
         DEC      BL          ; Offset in Kommandozeile, ab dem Pfad beginnt
         MOV      DI,KdoZeile
         ADD      DI,BX
         LEA      SI,AktPfad
AA0:     MOV      AL,[SI]
         MOV      [DI],AL
         INC      SI
         INC      DI
         CMP      BYTE PTR [SI],0  ; Zeichenkette zu Ende ?
         JNE      AA0              ; nein
         MOV      BYTE PTR [DI],13 ; ja: CR anhngen
         DEC      DI
         MOV      AX,DI
         MOV      DX,KdoZeile
         SUB      AX,DX
         MOV      DS:KdoZeile,AL ; Lngenbyte richtigstellen
         RET
;
ExeSubst: MOV     CS:StackOfs,SP
         MOV      CS:StackSeg,SS ; Stack gesichert
         MOV      AX,4B00h    ; Funktion EXEC, Laden und Ausfhren
         LEA      DX,Subst    ; Lademodulname
         PUSH     CS
         POP      ES
         LEA      BX,ParBlock ; Parameterblock adressiert ber ES:BX
         INT      21h         ; Child-Proze einleiten
         MOV      SP,CS:StackOfs
         MOV      SS,CS:StackSeg ; Stack wiederhergestellt
         RET
;
ChDrive: MOV      SI,KdoZeile+2 ; Zeichen nache erstem Blank in KdoZeile
CD0:     CMP      BYTE PTR [SI]," " ; Blank ?
         JNE      CD1        ; nein: Laufwerksbuchstabe gefunden
         INC      SI         ; ja
         JMP      CD0
CD1:     MOV      AH,0Eh     ; Funktion Laufwerk whlen
         MOV      DL,[SI]    ; Laufwerksbuchstabe
         AND      DL,11011111b ; in Grobuchstaben umsetzen
         SUB      DL,65      ; umwandeln in Laufwerkszahl
         INT      21h
         RET
;
Ende     EQU      $
CodeSeg  ENDS
         END      Begin
