
/*
 * CONV.EXE
 * converts strings
 * CONV -ifrom -oto < inputname > outputname
 */

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>

#include "mylib.c"

VOID main(INT argc, CHAR * argv[])
{
  INT key;
  CHAR i[80];
  CHAR o[80];
  CHAR temp[80];

  INT search=0;

  if (argc==1)
  {
    cprintf("Convert strings within textfiles\n");
    goto error;
  }
  if (!((argv[1][0]=='-') && (argv[2][0]=='-')))
  {
    cprintf("leading '-' missing\n");
    goto error;
  }
  if (!((toupper(argv[1][1])=='I') && (toupper(argv[2][1])=='O')))
  {
    cprintf("flag-signs 'I' or 'O' missing\n");
    goto error;
  }
  if (convert_string(i,&argv[1][2])==0)
  {
    cprintf("Error converting input-String\n");
    exit(1);
  }
  if (convert_string(o,&argv[2][2])==0)
  {
    cprintf("Error converting output-String\n");
    exit(1);
  }
  cprintf("Converting string: %s to %s",i,o); //argv[1],argv[2]);

  do
  {
    key=getchar();
    if ((key&0xff)==i[search])
    {
      if (i[search+1]==0)
      { // found completely
	search=0;
	putstr(o);
      }
      else
      { // next match
	temp[search]=key;
	temp[search+1]=0;
	search++;
      }
    }
    else
    {
      if (search)
      { // first error
	putstr(temp);
	putchar(key);
	search=0;
      }
      else // no match
	putchar(key);
    }
  }
  while (key!=EOF);
  return;
error:
  printf("CONV -ifrom -oto < inputname > outputname\n");
}

/* CONV.C END */
